package jp.sourceforge.acerola3d.a3editor;

import java.awt.*;
import java.awt.event.*;
import java.io.IOException;
import javax.swing.*;
import java.util.*;
import jp.sourceforge.acerola3d.a3panels.*;

class A3eFileManagerGUI extends JPanel implements ActionListener {
    private static final long serialVersionUID = 1L;
    A3eFileManager fileManager;
    A3eFile currentDir;
    ArrayList<A3eFileGUI> fileGUIs = new ArrayList<A3eFileGUI>();
    MyVBox viewerBox;
    CardLayout cardLayout;
    JLabel filePathL;
    JPanel viewerPanel;
    VrmlPanel vrmlPanel;
    BVHPanel bvhPanel;
    ImagePanel imagePanel;
    SoundPanel soundPanel;
    HtmlPanel htmlPanel;
    MyVBox dirBox;
    JButton refreshButton;
    JPanel mainPanel;

    A3eFileManagerGUI(A3eFileManager fm) {
        fileManager = fm;
        currentDir = fileManager.a3eRootDir;

        setLayout(new BorderLayout());
        JSplitPane basePane = new JSplitPane();
        basePane.setDividerLocation(600);
        add(basePane,BorderLayout.CENTER);
        viewerBox = new MyVBox();
        viewerBox.setMinimumSize(new Dimension(100,100));//これないとだめだね
        basePane.setLeftComponent(viewerBox);
        viewerBox.myAdd(new JLabel("Viewer"),0.0);
        filePathL = new JLabel();
        viewerBox.myAdd(filePathL,0.0);
        cardLayout = new CardLayout();
        viewerPanel = new JPanel();
        viewerPanel.setLayout(cardLayout);
        viewerBox.myAdd(viewerPanel,1.0);
        viewerPanel.add(new DummyPanel(),"none");
        vrmlPanel = new VrmlPanel(null);
        viewerPanel.add(vrmlPanel,"VRML");
        bvhPanel = new BVHPanel(null);
        viewerPanel.add(bvhPanel,"BVH");
        imagePanel = new ImagePanel(null);
        viewerPanel.add(imagePanel,"IMAGE");
        soundPanel = new SoundPanel(null);
        viewerPanel.add(soundPanel,"SOUND");
        htmlPanel = new HtmlPanel(null);
        viewerPanel.add(htmlPanel,"HTML");

        dirBox = new MyVBox();
        basePane.setRightComponent(dirBox);

        refresh();
    }
    void refresh() {
        dirBox.removeAll();

        refreshButton = new JButton("refresh");
        refreshButton.addActionListener(this);
        dirBox.myAdd(refreshButton,0);
        MyHBox pathBox = new MyHBox();
        dirBox.myAdd(pathBox,0);
        pathBox.myAdd(new JLabel("Path:"),0);
        Deque<A3eDirButton> stack = new ArrayDeque<A3eDirButton>();
        A3eFile p = currentDir;
        while (p!=null) {
            stack.addFirst(new A3eDirButton(p,this));
            p = p.parent;
        }
        while (!stack.isEmpty()) {
            pathBox.myAdd(stack.removeFirst(),0);
        }
        pathBox.myAdd(Box.createGlue(),1);

        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setPreferredSize(new Dimension(500,300));
        dirBox.myAdd(scrollPane,1);
        mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel,BoxLayout.Y_AXIS));
        scrollPane.getViewport().setView(mainPanel);

        fileGUIs.clear();
        for (A3eFile f : currentDir.children) {
            A3eFileGUI fGUI = new A3eFileGUI(f,this);
            mainPanel.add(fGUI);
            fileGUIs.add(fGUI);
        }
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                validate();
            }
        });
        cardLayout.show(viewerPanel,"none");
        filePathL.setText("");
    }
    void init() {
        try {
            fileManager.refresh();
            currentDir = fileManager.getRefreshedFile(currentDir);
            if (currentDir==null)
                currentDir = fileManager.a3eRootDir;
            this.refresh();
        } catch(IOException ee) {
            ee.printStackTrace();
        }
    }
    public void actionPerformed(ActionEvent e) {
        if (e.getSource()==refreshButton) {
            try {
                fileManager.refresh();
                currentDir = fileManager.getRefreshedFile(currentDir);
                if (currentDir==null)
                    currentDir = fileManager.a3eRootDir;
                this.refresh();
            } catch(IOException ee) {
                ee.printStackTrace();
            }
        }
    }
    void openViewer(A3eFile f,A3eFileGUI fGUI) {
        soundPanel.clear();
        for (A3eFileGUI fg : fileGUIs) {
            fg.setSelected(false);
        }
        fGUI.setSelected(true);
        if (f.type==A3eFileType.DIR) {
            cardLayout.show(viewerPanel,"none");
            filePathL.setText("DIR:"+f.getPath());
        } else if (f.type==A3eFileType.CATALOG) {
            cardLayout.show(viewerPanel,"none");
            filePathL.setText("CATALOG:"+f.getPath());
        } else if (f.type==A3eFileType.BVH) {
            bvhPanel.loadBVH(f.toFile());
            cardLayout.show(viewerPanel,"BVH");
            filePathL.setText("BVH:"+f.getPath());
        } else if (f.type==A3eFileType.VRML) {
            vrmlPanel.loadVRML(f.toFile());
            cardLayout.show(viewerPanel,"VRML");
            filePathL.setText("VRML:"+f.getPath());
        } else if (f.type==A3eFileType.IMAGE) {
            imagePanel.loadImage(f.toFile());
            cardLayout.show(viewerPanel,"IMAGE");
            filePathL.setText("IMAGE:"+f.getPath());
        } else if (f.type==A3eFileType.SOUND) {
            soundPanel.loadSound(f.toFile());
            cardLayout.show(viewerPanel,"SOUND");
            filePathL.setText("SOUND:"+f.getPath());
        } else if (f.type==A3eFileType.HTML) {
            htmlPanel.open(f.toFile());
            cardLayout.show(viewerPanel,"HTML");
            filePathL.setText("HTML:"+f.getPath());
        } else if (f.type==A3eFileType.UNKNOWN) {
            cardLayout.show(viewerPanel,"none");
            filePathL.setText("UNKNOWN:"+f.getPath());
        }
    }
    class DummyPanel extends JPanel {
        private static final long serialVersionUID = 1L;
        DummyPanel() {
            setLayout(new BorderLayout());
            MyVBox b = new MyVBox();
            add(b,BorderLayout.CENTER);
            b.myAdd(new JLabel("右のアイコンをクリックするとここに内容が表示されます。",JLabel.CENTER),0.0);
            b.myAdd(new JLabel("(対応ファイルのみ。)",JLabel.CENTER),0.0);
            b.myAdd(new JLabel("フォルダを開くにはダブルクリックして下さい。",JLabel.CENTER),0.0);
        }
    }
    void clear() {
        soundPanel.clear();
    }
}
