/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.media.j3d.BoundingSphere;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.A3Adapter;
import jp.sourceforge.acerola3d.a3.A3Canvas;
import jp.sourceforge.acerola3d.a3.A3CanvasInterface;
import jp.sourceforge.acerola3d.a3.A3Controller;
import jp.sourceforge.acerola3d.a3.A3Event;
import jp.sourceforge.acerola3d.a3.A3Listener;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.Action3D;
import jp.sourceforge.acerola3d.a3.ProjectionMode;
import jp.sourceforge.acerola3d.a3.Skeleton;
import jp.sourceforge.acerola3d.a3.Util;
import jp.sourceforge.acerola3d.a3editor.A3Editor;
import jp.sourceforge.acerola3d.a3editor.A3eActionEditor;
import jp.sourceforge.acerola3d.a3editor.A3eFile;
import jp.sourceforge.acerola3d.a3editor.A3eFileType;
import jp.sourceforge.acerola3d.a3editor.CenteredVRML;
import jp.sourceforge.acerola3d.a3editor.T;
import jp.sourceforge.acerola3d.a3panels.MyExamController;
import jp.sourceforge.acerola3d.a3panels.MyHBox;
import jp.sourceforge.acerola3d.a3panels.MyVBox;

class A3eActionEditorGUI
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    A3Editor a3editor;
    A3eActionEditor actionEditor;
    JToggleButton viewMode;
    double canvasWidthInPWorld = 1.0;
    MyExamController myExamController;
    Skeleton skeleton;
    HashMap<String, CenteredVRML> vrmls = new HashMap();
    ArrayList<Edit> editSequence = new ArrayList();
    int editSequenceIndex = -1;
    JComboBox actionCB;
    JButton deleteActionB;
    JButton renameActionB;
    JButton newActionB;
    NewActionInputPanel newActionInputPanel;
    JComboBox bvhCB;
    JCheckBox loopCB;
    JButton segnoB;
    JLabel segnoL;
    JButton dalsegnoB;
    JLabel dalsegnoL;
    JComboBox soundFileCB;
    JComboBox soundTypeCB;
    JCheckBox soundLoopCB;
    JButton soundGainB;
    JLabel soundGainL;
    JCheckBox soundContinueCB;
    JToggleButton camB;
    JToggleButton topB;
    JToggleButton frontB;
    JToggleButton sideB;
    JButton adjustB;
    JButton bigB;
    JButton smallB;
    JButton upB;
    JButton downB;
    JButton rightB;
    JButton leftB;
    A3Canvas canvas;
    JComboBox editModeCB;
    JCheckBox measureCB;
    JComboBox boneCB;
    JLabel vrmlL;
    JComboBox vrmlCB;
    JButton undoB;
    JButton redoB;
    Action3D measure;
    Action3D empty;
    Action3D speaker;

    A3eActionEditorGUI(A3eActionEditor ae, A3Editor editor) {
        this.a3editor = editor;
        this.actionEditor = ae;
        this.setLayout(new BorderLayout());
        MyHBox baseBox = new MyHBox();
        this.add((Component)baseBox, "Center");
        MyVBox leftBox = new MyVBox();
        baseBox.myAdd(leftBox, 0.0);
        MyVBox centerBox = new MyVBox();
        baseBox.myAdd(centerBox, 1.0);
        MyVBox rightBox = new MyVBox();
        baseBox.myAdd(rightBox, 0.0);
        MyVBox vBox = null;
        MyHBox hBox = null;
        vBox = new MyVBox();
        LineBorder lb = new LineBorder(Color.BLUE, 2);
        TitledBorder tb = new TitledBorder(lb, "\u30a2\u30af\u30b7\u30e7\u30f3");
        vBox.setBorder(tb);
        leftBox.myAdd(vBox, 0.0);
        vBox.myAdd(new JLabel("\u30a2\u30af\u30b7\u30e7\u30f3\u540d:"), 0.0);
        this.actionCB = new JComboBox();
        this.actionCB.addActionListener(this);
        this.actionCB.setMaximumSize(new Dimension(10000, this.actionCB.getPreferredSize().height));
        vBox.myAdd(this.actionCB, 0.0);
        this.deleteActionB = new JButton("\u3053\u306e\u30a2\u30af\u30b7\u30e7\u30f3\u3092\u524a\u9664");
        this.deleteActionB.addActionListener(this);
        vBox.myAdd(this.deleteActionB, 0.0);
        this.renameActionB = new JButton("\u30a2\u30af\u30b7\u30e7\u30f3\u540d\u306e\u5909\u66f4");
        this.renameActionB.addActionListener(this);
        vBox.myAdd(this.renameActionB, 0.0);
        this.newActionB = new JButton("\u65b0\u3057\u3044\u30a2\u30af\u30b7\u30e7\u30f3\u3092\u8ffd\u52a0");
        this.newActionB.addActionListener(this);
        vBox.myAdd(this.newActionB, 0.0);
        this.newActionInputPanel = new NewActionInputPanel();
        vBox = new MyVBox();
        lb = new LineBorder(Color.BLUE, 2);
        tb = new TitledBorder(lb, "\u30e2\u30fc\u30b7\u30e7\u30f3");
        vBox.setBorder(tb);
        leftBox.myAdd(vBox, 0.0);
        vBox.myAdd(new JLabel("BVH File"), 0.0);
        this.bvhCB = new JComboBox();
        this.bvhCB.addActionListener(this);
        vBox.myAdd(this.bvhCB, 1.0);
        this.loopCB = new JCheckBox("\u30eb\u30fc\u30d7\u3059\u308b");
        this.loopCB.addActionListener(this);
        vBox.myAdd(this.loopCB, 0.0);
        vBox.myAdd(new JLabel("segno:"), 0.0);
        hBox = new MyHBox();
        vBox.myAdd(hBox, 0.0);
        this.segnoB = new JButton("\u5909\u66f4");
        this.segnoB.addActionListener(this);
        hBox.myAdd(this.segnoB, 0.0);
        this.segnoL = new JLabel("0.0");
        hBox.myAdd(this.segnoL, 1.0);
        vBox.myAdd(new JLabel("dalsegno:"), 0.0);
        hBox = new MyHBox();
        vBox.myAdd(hBox, 0.0);
        this.dalsegnoB = new JButton("\u5909\u66f4");
        this.dalsegnoB.addActionListener(this);
        hBox.myAdd(this.dalsegnoB, 0.0);
        this.dalsegnoL = new JLabel("-1.0");
        hBox.myAdd(this.dalsegnoL, 1.0);
        vBox = new MyVBox();
        lb = new LineBorder(Color.BLUE, 2);
        tb = new TitledBorder(lb, "\u30b5\u30a6\u30f3\u30c9");
        vBox.setBorder(tb);
        leftBox.myAdd(vBox, 0.0);
        vBox.myAdd(new JLabel("\u30d5\u30a1\u30a4\u30eb:"), 0.0);
        this.soundFileCB = new JComboBox();
        this.soundFileCB.addActionListener(this);
        vBox.myAdd(this.soundFileCB, 0.0);
        vBox.myAdd(new JLabel("\u30bf\u30a4\u30d7:"), 0.0);
        this.soundTypeCB = new JComboBox();
        this.soundTypeCB.addItem("PointSound");
        this.soundTypeCB.addItem("Background");
        this.soundTypeCB.addItem("ConeSound");
        this.soundTypeCB.addActionListener(this);
        vBox.myAdd(this.soundTypeCB, 0.0);
        this.soundLoopCB = new JCheckBox("\u30eb\u30fc\u30d7");
        this.soundLoopCB.addActionListener(this);
        vBox.myAdd(this.soundLoopCB, 0.0);
        vBox.myAdd(new JLabel("\u30b2\u30a4\u30f3"), 0.0);
        hBox = new MyHBox();
        vBox.myAdd(hBox, 0.0);
        this.soundGainB = new JButton("\u5909\u66f4");
        this.soundGainB.addActionListener(this);
        hBox.myAdd(this.soundGainB, 0.0);
        this.soundGainL = new JLabel("1.0");
        hBox.myAdd(this.soundGainL, 1.0);
        this.soundContinueCB = new JCheckBox("\u7d99\u7d9a");
        this.soundContinueCB.addActionListener(this);
        this.soundContinueCB.setSelected(true);
        vBox.myAdd(this.soundContinueCB, 0.0);
        leftBox.myAdd(Box.createVerticalGlue(), 1.0);
        MyHBox topBox = new MyHBox();
        centerBox.myAdd(topBox, 0.0);
        MyVBox topLBox = new MyVBox();
        topBox.myAdd(topLBox, 1.0);
        MyVBox topCBox = new MyVBox();
        topBox.myAdd(topCBox, 1.0);
        MyVBox topRBox = new MyVBox();
        topBox.myAdd(topRBox, 1.0);
        this.canvas = A3Canvas.createA3Canvas((int)300, (int)300);
        MyMouseListener ml = new MyMouseListener(this);
        this.canvas.addA3Listener((A3Listener)ml);
        this.canvas.addMouseMotionListener((MouseMotionListener)ml);
        centerBox.myAdd((Component)this.canvas, 1.0);
        MyHBox topLUBox = new MyHBox();
        topLBox.myAdd(topLUBox, 0.0);
        this.topB = new JToggleButton("top");
        this.topB.addActionListener(this);
        topLUBox.myAdd(this.topB, 1.0);
        this.camB = new JToggleButton("cam");
        this.camB.addActionListener(this);
        topLUBox.myAdd(this.camB, 1.0);
        MyHBox topLDBox = new MyHBox();
        topLBox.myAdd(topLDBox, 0.0);
        this.frontB = new JToggleButton("front");
        this.frontB.addActionListener(this);
        topLDBox.myAdd(this.frontB, 1.0);
        this.sideB = new JToggleButton("side");
        this.sideB.addActionListener(this);
        topLDBox.myAdd(this.sideB, 1.0);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.topB);
        bg.add(this.camB);
        bg.add(this.frontB);
        bg.add(this.sideB);
        this.frontB.setSelected(true);
        this.adjustB = new JButton("adjust");
        this.adjustB.addActionListener(this);
        topCBox.myAdd(this.adjustB, 0.0);
        MyHBox topCCBox = new MyHBox();
        topCBox.myAdd(topCCBox, 0.0);
        this.bigB = new JButton("+");
        this.bigB.addActionListener(this);
        topCCBox.myAdd(this.bigB, 1.0);
        this.smallB = new JButton("-");
        this.smallB.addActionListener(this);
        topCCBox.myAdd(this.smallB, 1.0);
        this.upB = new JButton("^");
        this.upB.addActionListener(this);
        topRBox.myAdd(this.upB, 0.0);
        MyHBox topRCBox = new MyHBox();
        topRBox.myAdd(topRCBox, 1.0);
        this.leftB = new JButton("<");
        this.leftB.addActionListener(this);
        topRCBox.myAdd(this.leftB, 0.0);
        topRCBox.myAdd(Box.createGlue(), 1.0);
        this.rightB = new JButton(">");
        this.rightB.addActionListener(this);
        topRCBox.myAdd(this.rightB, 0.0);
        this.downB = new JButton("v");
        this.downB.addActionListener(this);
        topRBox.myAdd(this.downB, 0.0);
        MyVBox editModeBox = new MyVBox();
        lb = new LineBorder(Color.BLUE, 2);
        tb = new TitledBorder(lb, "\u7de8\u96c6\u30e2\u30fc\u30c9");
        editModeBox.setBorder(tb);
        rightBox.myAdd(editModeBox, 0.0);
        this.editModeCB = new JComboBox();
        this.editModeCB.addItem("\u5168\u90e8");
        this.editModeCB.addItem("\u9aa8\u3060\u3051");
        this.editModeCB.addItem("\u5f62\u3059\u3079\u3066");
        this.editModeCB.addItem("\u4e00\u3064\u306e\u5f62");
        this.editModeCB.addItem("\u4e0a\u5439\u304d\u51fa\u3057");
        this.editModeCB.addItem("\u4e0b\u5439\u304d\u51fa\u3057");
        this.editModeCB.addItem("\u53f3\u5439\u304d\u51fa\u3057");
        this.editModeCB.addItem("\u5de6\u5439\u304d\u51fa\u3057");
        this.editModeCB.addItem("\u30e9\u30d9\u30eb");
        this.editModeCB.addItem("\u30b5\u30a6\u30f3\u30c9");
        this.editModeCB.addActionListener(this);
        editModeBox.myAdd(this.editModeCB, 0.0);
        editModeBox.myAdd(new JSeparator(), 0.0);
        this.measureCB = new JCheckBox("\u30e1\u30b8\u30e3\u30fc");
        this.measureCB.addActionListener(this);
        editModeBox.myAdd(this.measureCB, 0.0);
        MyVBox relationBox = new MyVBox();
        lb = new LineBorder(Color.BLUE, 2);
        tb = new TitledBorder(lb, "\u5bfe\u5fdc\u4ed8\u3051");
        relationBox.setBorder(tb);
        rightBox.myAdd(relationBox, 0.0);
        relationBox.myAdd(new JLabel("bone:"), 0.0);
        this.boneCB = new JComboBox();
        this.boneCB.addActionListener(this);
        relationBox.myAdd(this.boneCB, 0.0);
        this.vrmlL = new JLabel("[????]\u306evrml:");
        relationBox.myAdd(this.vrmlL, 0.0);
        this.vrmlCB = new JComboBox();
        this.vrmlCB.addActionListener(this);
        relationBox.myAdd(this.vrmlCB, 0.0);
        rightBox.myAdd(Box.createVerticalGlue(), 1.0);
        MyHBox undoRedoBox = new MyHBox();
        rightBox.myAdd(undoRedoBox, 0.0);
        this.undoB = new JButton("undo");
        this.undoB.addActionListener(this);
        undoRedoBox.myAdd(this.undoB, 1.0);
        this.redoB = new JButton("redo");
        this.redoB.addActionListener(this);
        undoRedoBox.myAdd(this.redoB, 1.0);
        try {
            Action3D.clearCash((String)"x-res:///jp/sourceforge/acerola3d/a3panels/resources/measure.a3");
            this.measure = new Action3D("x-res:///jp/sourceforge/acerola3d/a3panels/resources/measure.a3");
            this.measure.setPickable(false);
            this.empty = new Action3D("x-res:///jp/sourceforge/acerola3d/a3editor/resources/empty.a3");
            this.empty.setPickable(false);
            this.speaker = new Action3D("x-res:///jp/sourceforge/acerola3d/a3editor/resources/speaker2.a3");
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.myExamController = new MyExamController();
        this.keyboardShotcutInit();
    }

    void keyboardShotcutInit() {
        ActionMap am = this.getActionMap();
        InputMap im = this.getInputMap(1);
        AbstractAction topViewAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                A3eActionEditorGUI.this.canvas.setProjectionMode(ProjectionMode.PARALLEL);
                A3eActionEditorGUI.this.canvas.setNavigationMode(A3CanvasInterface.NaviMode.EDIT);
                A3eActionEditorGUI.this.adjustTop();
                A3eActionEditorGUI.this.viewMode = A3eActionEditorGUI.this.topB;
            }
        };
        am.put("topViewAction", topViewAction);
        im.put(KeyStroke.getKeyStroke('7'), "topViewAction");
        AbstractAction camViewAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                A3eActionEditorGUI.this.canvas.setProjectionMode(ProjectionMode.PERSPECTIVE);
                A3eActionEditorGUI.this.canvas.setA3Controller((A3Controller)A3eActionEditorGUI.this.myExamController);
                A3eActionEditorGUI.this.adjustCam();
                A3eActionEditorGUI.this.viewMode = A3eActionEditorGUI.this.camB;
            }
        };
        am.put("camViewAction", camViewAction);
        im.put(KeyStroke.getKeyStroke('9'), "camViewAction");
        AbstractAction frontViewAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                A3eActionEditorGUI.this.canvas.setProjectionMode(ProjectionMode.PARALLEL);
                A3eActionEditorGUI.this.canvas.setNavigationMode(A3CanvasInterface.NaviMode.EDIT);
                A3eActionEditorGUI.this.adjustFront();
                A3eActionEditorGUI.this.viewMode = A3eActionEditorGUI.this.frontB;
            }
        };
        am.put("frontViewAction", frontViewAction);
        im.put(KeyStroke.getKeyStroke('1'), "frontViewAction");
        AbstractAction sideViewAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                A3eActionEditorGUI.this.canvas.setProjectionMode(ProjectionMode.PARALLEL);
                A3eActionEditorGUI.this.canvas.setNavigationMode(A3CanvasInterface.NaviMode.EDIT);
                A3eActionEditorGUI.this.adjustSide();
                A3eActionEditorGUI.this.viewMode = A3eActionEditorGUI.this.sideB;
            }
        };
        am.put("sideViewAction", sideViewAction);
        im.put(KeyStroke.getKeyStroke('3'), "sideViewAction");
        AbstractAction undoAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                if (A3eActionEditorGUI.this.editSequenceIndex < 0) {
                    return;
                }
                Edit e = A3eActionEditorGUI.this.editSequence.get(A3eActionEditorGUI.this.editSequenceIndex);
                e.undo();
                --A3eActionEditorGUI.this.editSequenceIndex;
            }
        };
        am.put("undoAction", undoAction);
        im.put(KeyStroke.getKeyStroke("ctrl Z"), "undoAction");
        AbstractAction redoAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                if (A3eActionEditorGUI.this.editSequenceIndex >= A3eActionEditorGUI.this.editSequence.size() - 1) {
                    return;
                }
                ++A3eActionEditorGUI.this.editSequenceIndex;
                Edit e = A3eActionEditorGUI.this.editSequence.get(A3eActionEditorGUI.this.editSequenceIndex);
                e.redo();
            }
        };
        am.put("redoAction", redoAction);
        im.put(KeyStroke.getKeyStroke("ctrl Y"), "redoAction");
    }

    void doEdit(Edit e) {
        e.edit();
        while (this.editSequence.size() - 1 > this.editSequenceIndex) {
            this.editSequence.remove(this.editSequence.size() - 1);
        }
        this.editSequence.add(e);
        ++this.editSequenceIndex;
    }

    void init() {
        this.editSequence.clear();
        this.editSequenceIndex = -1;
        try {
            String bvhPath = this.actionEditor.getBVHPath();
            String bvhUrl = this.actionEditor.getBVHURL();
            this.skeleton = bvhUrl != null && !bvhPath.equals("none") ? new Skeleton(bvhUrl) : null;
            Vector3d actionOffset = this.actionEditor.getOffset();
            Quat4d actionQuat = this.actionEditor.getQuat();
            double actionScale = this.actionEditor.getScale();
            if (this.skeleton != null) {
                this.skeleton.setScale(actionScale);
                this.skeleton.setQuat(actionQuat);
                this.skeleton.setLoc(actionOffset);
            }
            this.vrmls.clear();
            for (String bn : this.actionEditor.getUsedBones()) {
                String vrmlURL = this.actionEditor.getVRMLFile(bn).getURLString();
                CenteredVRML vrml = new CenteredVRML(vrmlURL);
                T t = this.actionEditor.getPartData(bn);
                t = this.catalog2CenteredVRML(bn, t);
                vrml.setScale(t.scale);
                vrml.setRot(t.rot);
                vrml.setLoc2(t.offset);
                this.vrmls.put(bn, vrml);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.actionCB.removeActionListener(this);
        this.actionCB.removeAllItems();
        for (String an : this.actionEditor.getActionNames()) {
            this.actionCB.addItem(an);
        }
        this.actionCB.setSelectedItem(this.actionEditor.getCurrentActionName());
        this.actionCB.addActionListener(this);
        this.newActionInputPanel.init();
        this.bvhCB.removeActionListener(this);
        this.bvhCB.removeAllItems();
        this.bvhCB.addItem(A3eFile.noneFile);
        for (A3eFile bvh : this.a3editor.fileManager.listA3eFile(A3eFileType.BVH)) {
            this.bvhCB.addItem(bvh);
        }
        A3eFile bvh = this.actionEditor.getBVHFile();
        if (bvh == null) {
            this.bvhCB.setSelectedItem(A3eFile.noneFile);
        } else {
            this.bvhCB.setSelectedItem(bvh);
        }
        this.bvhCB.addActionListener(this);
        this.loopCB.setSelected(this.actionEditor.getLoop());
        this.segnoL.setText("" + this.actionEditor.getSegno());
        this.dalsegnoL.setText("" + this.actionEditor.getDalsegno());
        this.soundFileCB.removeActionListener(this);
        this.soundTypeCB.removeActionListener(this);
        this.soundFileCB.removeAllItems();
        this.soundFileCB.addItem(A3eFile.noneFile);
        for (A3eFile sf : this.a3editor.fileManager.listA3eFile(A3eFileType.SOUND)) {
            this.soundFileCB.addItem(sf);
        }
        A3eFile soundFile = this.actionEditor.getSoundFile();
        if (!soundFile.equals(A3eFile.noneFile)) {
            this.soundFileCB.setSelectedItem(soundFile);
            this.soundTypeCB.setEnabled(true);
            this.soundLoopCB.setEnabled(true);
            this.soundGainB.setEnabled(true);
            this.soundContinueCB.setEnabled(true);
            this.soundTypeCB.setSelectedItem(this.actionEditor.getSoundType());
            this.soundLoopCB.setSelected(this.actionEditor.getSoundLoop());
            this.soundGainL.setText("" + this.actionEditor.getSoundGain());
            this.soundContinueCB.setSelected(this.actionEditor.getSoundContinue());
            Vector3d v = this.actionEditor.getSoundOffset();
            this.speaker.setLoc(v);
            v = this.actionEditor.getSoundDirection();
            Quat4d q = Util.a2bQuat((Vector3d)new Vector3d(0.0, 0.0, 1.0), (Vector3d)v);
            this.speaker.setQuat(q);
        } else {
            this.soundFileCB.setSelectedItem(A3eFile.noneFile);
            this.soundTypeCB.setEnabled(false);
            this.soundLoopCB.setEnabled(false);
            this.soundGainB.setEnabled(false);
            this.soundContinueCB.setEnabled(false);
            this.soundTypeCB.setSelectedItem("PointSound");
            this.soundLoopCB.setSelected(false);
            this.soundGainL.setText("1.0");
            this.soundContinueCB.setSelected(true);
            this.speaker.setLoc(0.0, 0.0, 0.0);
            this.speaker.setRot(0.0, 0.0, 0.0);
        }
        this.soundFileCB.addActionListener(this);
        this.soundTypeCB.addActionListener(this);
        this.editModeCB.setSelectedItem("\u5168\u90e8");
        this.measureCB.setSelected(false);
        this.boneCB.removeAllItems();
        this.boneCB.addItem("[none]");
        String[] allBones = new String[]{};
        if (this.skeleton != null) {
            String[] arr$ = this.skeleton.getBones();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String bn = arr$[i$];
                this.boneCB.addItem(bn);
            }
        }
        this.vrmlL.setText("[none]\u306evrml:");
        this.vrmlCB.removeActionListener(this);
        this.vrmlCB.removeAllItems();
        this.vrmlCB.addItem(A3eFile.noneFile);
        for (A3eFile vrml : this.a3editor.fileManager.listA3eFile(A3eFileType.VRML)) {
            this.vrmlCB.addItem(vrml);
        }
        this.vrmlCB.setSelectedItem(this.actionEditor.getVRMLFile("[none]"));
        this.vrmlCB.addActionListener(this);
        this.canvas.delAll();
        this.viewMode = this.frontB;
        this.frontB.setSelected(true);
        this.canvas.setProjectionMode(ProjectionMode.PARALLEL);
        this.canvas.setNavigationMode(A3CanvasInterface.NaviMode.EDIT);
        if (this.skeleton != null) {
            this.canvas.add((A3Object)this.skeleton);
        }
        for (CenteredVRML vrml : this.vrmls.values()) {
            this.canvas.add((A3Object)vrml);
        }
        double[] xy = this.actionEditor.getRightBalloonOffset();
        this.empty.setBalloonLoc(A3Object.BalloonDir.RIGHT, xy[0], xy[1]);
        xy = this.actionEditor.getLeftBalloonOffset();
        this.empty.setBalloonLoc(A3Object.BalloonDir.LEFT, xy[0], xy[1]);
        xy = this.actionEditor.getTopBalloonOffset();
        this.empty.setBalloonLoc(A3Object.BalloonDir.TOP, xy[0], xy[1]);
        xy = this.actionEditor.getBottomBalloonOffset();
        this.empty.setBalloonLoc(A3Object.BalloonDir.BOTTOM, xy[0], xy[1]);
        xy = this.actionEditor.getLabelOffset();
        this.empty.setLabelLoc(xy[0], xy[1]);
        this.adjustFront();
        this.requestFocus();
    }

    BoundingSphere getAllBound() {
        BoundingSphere ret = null;
        for (CenteredVRML v : this.vrmls.values()) {
            if (ret == null) {
                ret = new BoundingSphere(v.getNode().getBounds());
                continue;
            }
            ret.combine(v.getNode().getBounds());
        }
        if (this.skeleton != null) {
            if (ret == null) {
                ret = new BoundingSphere(this.skeleton.getNode().getBounds());
            } else {
                ret.combine(this.skeleton.getNode().getBounds());
            }
        }
        if (ret == null) {
            ret = new BoundingSphere();
        }
        return ret;
    }

    void adjustCam() {
        BoundingSphere bs = this.getAllBound();
        this.myExamController.adjust(bs);
        this.speaker.setScale(0.1 * bs.getRadius());
        this.canvas.del((A3Object)this.measure);
        this.camB.setSelected(true);
    }

    void adjustTop() {
        BoundingSphere bs = this.getAllBound();
        double radius = bs.getRadius();
        Point3d center = new Point3d();
        bs.getCenter(center);
        this.canvasWidthInPWorld = 3.0 * radius;
        this.canvas.setCanvasWidthInPWorld(this.canvasWidthInPWorld);
        this.canvas.setCameraLocImmediately(center.x, center.y + 1.5 * radius, center.z);
        this.canvas.setCameraRotImmediately(-1.5707963267948966, 0.0, 0.0);
        this.canvas.setCameraScaleImmediately(1.0);
        this.speaker.setScale(0.1 * bs.getRadius());
        if (this.measureCB.isSelected()) {
            this.measure.setRot(-1.5707963267948966, 0.0, 0.0);
            this.canvas.add((A3Object)this.measure);
        }
        this.topB.setSelected(true);
    }

    void adjustFront() {
        BoundingSphere bs = this.getAllBound();
        double radius = bs.getRadius();
        Point3d center = new Point3d();
        bs.getCenter(center);
        this.canvasWidthInPWorld = 3.0 * radius;
        this.canvas.setCanvasWidthInPWorld(this.canvasWidthInPWorld);
        this.canvas.setCameraLocImmediately(center.x, center.y, center.z + 1.5 * radius);
        this.canvas.setCameraRotImmediately(0.0, 0.0, 0.0);
        this.canvas.setCameraScaleImmediately(1.0);
        this.speaker.setScale(0.1 * bs.getRadius());
        if (this.measureCB.isSelected()) {
            this.measure.setRot(0.0, 0.0, 0.0);
            this.canvas.add((A3Object)this.measure);
        }
        this.frontB.setSelected(true);
    }

    void adjustSide() {
        BoundingSphere bs = this.getAllBound();
        double radius = bs.getRadius();
        Point3d center = new Point3d();
        bs.getCenter(center);
        this.canvasWidthInPWorld = 3.0 * radius;
        this.canvas.setCanvasWidthInPWorld(this.canvasWidthInPWorld);
        this.canvas.setCameraLocImmediately(center.x + 1.5 * radius, center.y, center.z);
        this.canvas.setCameraRotImmediately(0.0, 1.5707963267948966, 0.0);
        this.canvas.setCameraScaleImmediately(1.0);
        this.speaker.setScale(0.1 * bs.getRadius());
        if (this.measureCB.isSelected()) {
            this.measure.setRot(0.0, 1.5707963267948966, 0.0);
            this.canvas.add((A3Object)this.measure);
        }
        this.sideB.setSelected(true);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object s = ae.getSource();
        if (s == this.actionCB) {
            if (ae.getActionCommand().equals("comboBoxChanged")) {
                this.actionEditor.changeCurrentAction((String)this.actionCB.getSelectedItem());
                this.init();
            } else if (ae.getActionCommand().equals("comboBoxEdited")) {
                System.out.println("gaha2");
            } else {
                System.out.println("gaha3");
            }
        } else if (s == this.deleteActionB) {
            if (this.actionCB.getItemCount() == 1) {
                JOptionPane.showMessageDialog(this, "\u6700\u5f8c\u306e\u30a2\u30af\u30b7\u30e7\u30f3\u306f\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3002");
                return;
            }
            String an = (String)this.actionCB.getSelectedItem();
            int ret = JOptionPane.showConfirmDialog(this, "\u30a2\u30af\u30b7\u30e7\u30f3[" + an + "]\u306e\u60c5\u5831\u304c\u5168\u3066\u524a\u9664\u3055\u308c\u307e\u3059\u3002\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f", "\u524a\u9664\u78ba\u8a8d", 0);
            if (ret == 1) {
                return;
            }
            this.actionEditor.deleteAction(an);
            this.init();
        } else if (s == this.renameActionB) {
            String an = (String)this.actionCB.getSelectedItem();
            String newName = JOptionPane.showInputDialog(this, "Input new ActionName", an);
            if (!newName.equals("")) {
                if (this.actionEditor.checkActionNameDuplication(newName)) {
                    JOptionPane.showMessageDialog(this, "\u30a2\u30af\u30b7\u30e7\u30f3\u540d\u304c\u91cd\u8907\u3057\u3066\u3044\u307e\u3059\u3002");
                } else {
                    this.actionEditor.setActionName(newName);
                    int i = this.actionCB.getSelectedIndex();
                    this.actionCB.removeActionListener(this);
                    this.actionCB.removeItemAt(i);
                    this.actionCB.insertItemAt(newName, i);
                    this.actionCB.setSelectedItem(newName);
                    this.actionCB.addActionListener(this);
                }
            }
        } else if (s == this.newActionB) {
            String newName;
            this.newActionInputPanel.clear();
            int ret = JOptionPane.showConfirmDialog(this, this.newActionInputPanel, "New Action", 2);
            if (ret == 0 && !(newName = this.newActionInputPanel.actionNameTF.getText()).equals("")) {
                if (this.actionEditor.checkActionNameDuplication(newName)) {
                    JOptionPane.showMessageDialog(this, "\u30a2\u30af\u30b7\u30e7\u30f3\u540d\u304c\u91cd\u8907\u3057\u3066\u3044\u307e\u3059\u3002");
                } else {
                    A3eFile bvh;
                    String baseActionName = (String)this.newActionInputPanel.baseActionCB.getSelectedItem();
                    if (!this.actionEditor.checkCompatibility(baseActionName, bvh = (A3eFile)this.newActionInputPanel.bvhCB.getSelectedItem())) {
                        JOptionPane.showMessageDialog(this, "\u30d9\u30fc\u30b9\u3068\u306a\u308b\u30a2\u30af\u30b7\u30e7\u30f3\u3068BVH\u30d5\u30a1\u30a4\u30eb\u306b\u4e92\u63db\u6027\u304c\u3042\u308a\u307e\u305b\u3093");
                    } else {
                        this.actionEditor.createNewAction2(newName, baseActionName, bvh);
                        this.init();
                    }
                }
            }
        } else if (s == this.bvhCB) {
            int ret = JOptionPane.showConfirmDialog(this, "BVH\u3092\u5909\u66f4\u3059\u308b\u3068\u30a2\u30af\u30b7\u30e7\u30f3\u306e\u5168\u3066\u306e\u60c5\u5831\u304c\u30af\u30ea\u30a2\u3055\u308c\u307e\u3059\u3002\u3088\u308d\u3057\u3044\u3067\u3059\u304b?", "\u5909\u66f4\u78ba\u8a8d", 0);
            if (ret == 1) {
                String bvh = this.actionEditor.getBVH();
                this.bvhCB.setSelectedItem(bvh);
            } else {
                this.actionEditor.setBVH((A3eFile)this.bvhCB.getSelectedItem());
                this.init();
            }
        } else if (s == this.loopCB) {
            this.actionEditor.setLoop(this.loopCB.isSelected());
        } else if (s == this.segnoB) {
            try {
                String input = JOptionPane.showInputDialog(this, "Input segno value", this.segnoL.getText());
                double d = Double.parseDouble(input);
                this.actionEditor.setSegno(d);
                this.segnoL.setText("" + d);
            }
            catch (NumberFormatException e) {}
        } else if (s == this.dalsegnoB) {
            try {
                String input = JOptionPane.showInputDialog(this, "Input dalsegno value", this.dalsegnoL.getText());
                double d = Double.parseDouble(input);
                this.actionEditor.setDalsegno(d);
                this.dalsegnoL.setText("" + d);
            }
            catch (NumberFormatException e) {}
        } else if (s == this.soundFileCB) {
            if (this.soundFileCB.getSelectedItem().equals("[none]")) {
                this.actionEditor.removeSoundDate();
                this.soundTypeCB.setEnabled(false);
                this.soundLoopCB.setEnabled(false);
                this.soundGainB.setEnabled(false);
                this.soundContinueCB.setEnabled(false);
                this.soundTypeCB.removeActionListener(this);
                this.soundTypeCB.setSelectedItem("PointSound");
                this.soundTypeCB.addActionListener(this);
                this.soundLoopCB.setSelected(false);
                this.soundGainL.setText("1.0");
                this.soundContinueCB.setSelected(true);
            } else {
                this.actionEditor.setSoundFile((A3eFile)this.soundFileCB.getSelectedItem());
                this.soundTypeCB.setEnabled(true);
                this.soundLoopCB.setEnabled(true);
                this.soundGainB.setEnabled(true);
                this.soundContinueCB.setEnabled(true);
                this.soundTypeCB.setSelectedItem(this.actionEditor.getSoundType());
                this.soundLoopCB.setSelected(this.actionEditor.getSoundLoop());
                this.soundGainL.setText("" + this.actionEditor.getSoundGain());
                this.soundContinueCB.setSelected(this.actionEditor.getSoundContinue());
            }
        } else if (s == this.soundTypeCB) {
            this.actionEditor.setSoundType((String)this.soundTypeCB.getSelectedItem());
        } else if (s == this.soundLoopCB) {
            this.actionEditor.setSoundLoop(this.soundLoopCB.isSelected());
        } else if (s == this.soundGainB) {
            try {
                String input = JOptionPane.showInputDialog(this, "Input Sound Gain", this.soundGainL.getText());
                double d = Double.parseDouble(input);
                this.actionEditor.setSoundGain(d);
                this.soundGainL.setText("" + d);
            }
            catch (NumberFormatException e) {}
        } else if (s == this.soundContinueCB) {
            this.actionEditor.setSoundContinue(this.soundContinueCB.isSelected());
        } else if (s == this.camB) {
            this.canvas.setProjectionMode(ProjectionMode.PERSPECTIVE);
            this.canvas.setA3Controller((A3Controller)this.myExamController);
            this.adjustCam();
            this.viewMode = this.camB;
        } else if (s == this.topB) {
            this.canvas.setProjectionMode(ProjectionMode.PARALLEL);
            this.canvas.setNavigationMode(A3CanvasInterface.NaviMode.EDIT);
            this.adjustTop();
            this.viewMode = this.topB;
        } else if (s == this.frontB) {
            this.canvas.setProjectionMode(ProjectionMode.PARALLEL);
            this.canvas.setNavigationMode(A3CanvasInterface.NaviMode.EDIT);
            this.adjustFront();
            this.viewMode = this.frontB;
        } else if (s == this.sideB) {
            this.canvas.setProjectionMode(ProjectionMode.PARALLEL);
            this.canvas.setNavigationMode(A3CanvasInterface.NaviMode.EDIT);
            this.adjustSide();
            this.viewMode = this.sideB;
        } else if (s == this.adjustB) {
            if (this.viewMode == this.camB) {
                this.adjustCam();
            } else if (this.viewMode == this.topB) {
                this.adjustTop();
            } else if (this.viewMode == this.frontB) {
                this.adjustFront();
            } else if (this.viewMode == this.sideB) {
                this.adjustSide();
            }
        } else if (s == this.bigB) {
            if (this.viewMode == this.camB) {
                this.myExamController.big();
            } else {
                this.canvasWidthInPWorld = 0.75 * this.canvasWidthInPWorld;
                this.canvas.setCanvasWidthInPWorld(this.canvasWidthInPWorld);
                this.canvas.setCameraScaleImmediately(1.0);
            }
        } else if (s == this.smallB) {
            if (this.viewMode == this.camB) {
                this.myExamController.small();
            } else {
                this.canvasWidthInPWorld = 1.3333333333333333 * this.canvasWidthInPWorld;
                this.canvas.setCanvasWidthInPWorld(this.canvasWidthInPWorld);
                this.canvas.setCameraScaleImmediately(1.0);
            }
        } else if (s == this.upB) {
            if (this.viewMode == this.camB) {
                this.myExamController.up();
            } else {
                Vector3d v = this.canvas.getCameraLoc();
                double d = 0.1 * this.canvasWidthInPWorld;
                if (this.viewMode == this.topB) {
                    v.z += d;
                } else if (this.viewMode == this.frontB) {
                    v.y -= d;
                } else if (this.viewMode == this.sideB) {
                    v.y -= d;
                }
                this.canvas.setCameraLocImmediately(v);
            }
        } else if (s == this.downB) {
            if (this.viewMode == this.camB) {
                this.myExamController.down();
            } else {
                Vector3d v = this.canvas.getCameraLoc();
                double d = 0.1 * this.canvasWidthInPWorld;
                if (this.viewMode == this.topB) {
                    v.z -= d;
                } else if (this.viewMode == this.frontB) {
                    v.y += d;
                } else if (this.viewMode == this.sideB) {
                    v.y += d;
                }
                this.canvas.setCameraLocImmediately(v);
            }
        } else if (s == this.rightB) {
            if (this.viewMode == this.camB) {
                this.myExamController.right();
            } else {
                Vector3d v = this.canvas.getCameraLoc();
                double d = 0.1 * this.canvasWidthInPWorld;
                if (this.viewMode == this.topB) {
                    v.x -= d;
                } else if (this.viewMode == this.frontB) {
                    v.x -= d;
                } else if (this.viewMode == this.sideB) {
                    v.z += d;
                }
                this.canvas.setCameraLocImmediately(v);
            }
        } else if (s == this.leftB) {
            if (this.viewMode == this.camB) {
                this.myExamController.left();
            } else {
                Vector3d v = this.canvas.getCameraLoc();
                double d = 0.1 * this.canvasWidthInPWorld;
                if (this.viewMode == this.topB) {
                    v.x += d;
                } else if (this.viewMode == this.frontB) {
                    v.x += d;
                } else if (this.viewMode == this.sideB) {
                    v.z -= d;
                }
                this.canvas.setCameraLocImmediately(v);
            }
        } else if (s == this.editModeCB) {
            String m = (String)this.editModeCB.getSelectedItem();
            if (m.equals("\u5168\u90e8")) {
                this.canvas.delAll();
                if (this.skeleton != null) {
                    this.canvas.add((A3Object)this.skeleton);
                    this.skeleton.setPickable(true);
                }
                for (CenteredVRML vrml : this.vrmls.values()) {
                    this.canvas.add((A3Object)vrml);
                    vrml.setPickable(true);
                }
            } else if (m.equals("\u9aa8\u3060\u3051")) {
                this.canvas.delAll();
                if (this.skeleton != null) {
                    this.canvas.add((A3Object)this.skeleton);
                    this.skeleton.setPickable(true);
                }
            } else if (m.equals("\u5f62\u3059\u3079\u3066")) {
                this.canvas.delAll();
                if (this.skeleton != null) {
                    this.canvas.add((A3Object)this.skeleton);
                    this.skeleton.setPickable(false);
                }
                for (CenteredVRML vrml : this.vrmls.values()) {
                    this.canvas.add((A3Object)vrml);
                    vrml.setPickable(true);
                }
            } else if (m.equals("\u4e00\u3064\u306e\u5f62")) {
                String bn;
                CenteredVRML vrml;
                this.canvas.delAll();
                if (this.skeleton != null) {
                    this.canvas.add((A3Object)this.skeleton);
                    this.skeleton.setPickable(false);
                }
                if ((vrml = this.vrmls.get(bn = (String)this.boneCB.getSelectedItem())) != null) {
                    this.canvas.add((A3Object)vrml);
                    vrml.setPickable(true);
                }
            } else if (m.equals("\u4e0a\u5439\u304d\u51fa\u3057")) {
                this.canvas.delAll();
                if (this.skeleton != null) {
                    this.canvas.add((A3Object)this.skeleton);
                    this.skeleton.setPickable(false);
                }
                for (CenteredVRML vrml : this.vrmls.values()) {
                    this.canvas.add((A3Object)vrml);
                    vrml.setPickable(false);
                }
                this.canvas.add((A3Object)this.empty);
                this.empty.setBalloonDir(A3Object.BalloonDir.TOP);
                this.empty.setBalloon("\u5439\u304d\u51fa\u3057");
                this.empty.setLabel(null);
            } else if (m.equals("\u4e0b\u5439\u304d\u51fa\u3057")) {
                this.canvas.delAll();
                if (this.skeleton != null) {
                    this.canvas.add((A3Object)this.skeleton);
                    this.skeleton.setPickable(false);
                }
                for (CenteredVRML vrml : this.vrmls.values()) {
                    this.canvas.add((A3Object)vrml);
                    vrml.setPickable(false);
                }
                this.canvas.add((A3Object)this.empty);
                this.empty.setBalloonDir(A3Object.BalloonDir.BOTTOM);
                this.empty.setBalloon("\u5439\u304d\u51fa\u3057");
                this.empty.setLabel(null);
            } else if (m.equals("\u53f3\u5439\u304d\u51fa\u3057")) {
                this.canvas.delAll();
                if (this.skeleton != null) {
                    this.canvas.add((A3Object)this.skeleton);
                    this.skeleton.setPickable(false);
                }
                for (CenteredVRML vrml : this.vrmls.values()) {
                    this.canvas.add((A3Object)vrml);
                    vrml.setPickable(false);
                }
                this.canvas.add((A3Object)this.empty);
                this.empty.setBalloonDir(A3Object.BalloonDir.RIGHT);
                this.empty.setBalloon("\u5439\u304d\u51fa\u3057");
                this.empty.setLabel(null);
            } else if (m.equals("\u5de6\u5439\u304d\u51fa\u3057")) {
                this.canvas.delAll();
                if (this.skeleton != null) {
                    this.canvas.add((A3Object)this.skeleton);
                    this.skeleton.setPickable(false);
                }
                for (CenteredVRML vrml : this.vrmls.values()) {
                    this.canvas.add((A3Object)vrml);
                    vrml.setPickable(false);
                }
                this.canvas.add((A3Object)this.empty);
                this.empty.setBalloonDir(A3Object.BalloonDir.LEFT);
                this.empty.setBalloon("\u5439\u304d\u51fa\u3057");
                this.empty.setLabel(null);
            } else if (m.equals("\u30e9\u30d9\u30eb")) {
                this.canvas.delAll();
                if (this.skeleton != null) {
                    this.canvas.add((A3Object)this.skeleton);
                    this.skeleton.setPickable(false);
                }
                for (CenteredVRML vrml : this.vrmls.values()) {
                    this.canvas.add((A3Object)vrml);
                    vrml.setPickable(false);
                }
                this.canvas.add((A3Object)this.empty);
                this.empty.setBalloon(null);
                this.empty.setLabel("\u30e9\u30d9\u30eb");
            } else if (m.equals("\u30b5\u30a6\u30f3\u30c9")) {
                this.canvas.delAll();
                if (this.skeleton != null) {
                    this.canvas.add((A3Object)this.skeleton);
                    this.skeleton.setPickable(false);
                }
                this.canvas.add((A3Object)this.speaker);
            }
        } else if (s == this.measureCB) {
            if (this.measureCB.isSelected()) {
                if (this.viewMode != this.camB) {
                    if (this.viewMode == this.topB) {
                        this.measure.setRot(-1.5707963267948966, 0.0, 0.0);
                    } else if (this.viewMode == this.frontB) {
                        this.measure.setRot(0.0, 0.0, 0.0);
                    } else if (this.viewMode == this.sideB) {
                        this.measure.setRot(0.0, 1.5707963267948966, 0.0);
                    }
                    this.canvas.add((A3Object)this.measure);
                }
            } else {
                this.canvas.del((A3Object)this.measure);
            }
        } else if (s == this.boneCB) {
            String bn = (String)this.boneCB.getSelectedItem();
            this.vrmlL.setText(bn + "\u306evrml:");
            this.vrmlCB.removeActionListener(this);
            this.vrmlCB.setSelectedItem(this.actionEditor.getVRMLFile(bn));
            this.vrmlCB.addActionListener(this);
            if (this.skeleton != null) {
                this.skeleton.resetSelected();
                this.skeleton.setBoneSelected(bn, true);
            }
            if (this.editModeCB.getSelectedItem().equals("\u4e00\u3064\u306e\u5f62")) {
                CenteredVRML vrml;
                this.canvas.delAll();
                if (this.skeleton != null) {
                    this.canvas.add((A3Object)this.skeleton);
                    this.skeleton.setPickable(false);
                }
                if ((vrml = this.vrmls.get(bn)) != null) {
                    this.canvas.add((A3Object)vrml);
                    vrml.setPickable(true);
                }
            }
        } else if (s == this.vrmlCB) {
            this.doEdit(new VrmlChangeEdit());
        } else if (s == this.undoB) {
            if (this.editSequenceIndex >= 0) {
                Edit e = this.editSequence.get(this.editSequenceIndex);
                e.undo();
                --this.editSequenceIndex;
            }
        } else if (s == this.redoB) {
            if (this.editSequenceIndex < this.editSequence.size() - 1) {
                ++this.editSequenceIndex;
                Edit e = this.editSequence.get(this.editSequenceIndex);
                e.redo();
            }
        } else {
            System.out.println("gaha?????");
        }
    }

    T centeredVRML2CATALOG(String bn, T t) {
        Vector3d bvhOffset;
        Vector3d actionOffset = this.actionEditor.getOffset();
        Quat4d actionQuatRev = this.actionEditor.getQuat();
        actionQuatRev.conjugate();
        double actionScale = this.actionEditor.getScale();
        if (this.skeleton != null) {
            bvhOffset = this.skeleton.getOffset(bn);
            if (bvhOffset == null) {
                bvhOffset = new Vector3d();
            }
        } else {
            bvhOffset = new Vector3d();
        }
        T tt = new T();
        tt.offset = new Vector3d(t.offset);
        tt.offset.sub((Tuple3d)actionOffset);
        tt.offset.scale(1.0 / actionScale);
        tt.offset = Util.trans((Quat4d)actionQuatRev, (Vector3d)tt.offset);
        tt.offset.sub((Tuple3d)bvhOffset);
        Quat4d boneQuat = Util.euler2quat((Vector3d)t.rot);
        boneQuat.mul(actionQuatRev, boneQuat);
        tt.rot = Util.quat2euler((Quat4d)boneQuat);
        tt.rot.scale(57.29577951308232);
        tt.scale = t.scale / actionScale;
        return tt;
    }

    T catalog2CenteredVRML(String bn, T t) {
        Vector3d bvhOffset;
        Vector3d actionOffset = this.actionEditor.getOffset();
        Quat4d actionQuat = this.actionEditor.getQuat();
        double actionScale = this.actionEditor.getScale();
        if (this.skeleton != null) {
            bvhOffset = this.skeleton.getOffset(bn);
            if (bvhOffset == null) {
                bvhOffset = new Vector3d();
            }
        } else {
            bvhOffset = new Vector3d();
        }
        Vector3d boneOffset = new Vector3d(t.offset);
        Vector3d v = new Vector3d(t.rot);
        v.scale(Math.PI / 180);
        Quat4d boneQuat = Util.euler2quat((Vector3d)v);
        double boneScale = t.scale;
        T tt = new T();
        tt.offset = new Vector3d(boneOffset);
        tt.offset.add((Tuple3d)bvhOffset);
        tt.offset.scale(actionScale);
        tt.offset = Util.trans((Quat4d)actionQuat, (Vector3d)tt.offset);
        tt.offset.add((Tuple3d)actionOffset);
        Quat4d quat = new Quat4d();
        quat.mul(actionQuat, boneQuat);
        tt.rot = Util.quat2euler((Quat4d)quat);
        tt.scale = boneScale * actionScale;
        return tt;
    }

    String getBoneName(CenteredVRML vrml) {
        String boneName = null;
        for (String bn : this.vrmls.keySet()) {
            CenteredVRML v = this.vrmls.get(bn);
            if (v != vrml) continue;
            boneName = bn;
            break;
        }
        return boneName;
    }

    void clear() {
        this.actionEditor.saveCatalog();
    }

    class VrmlChangeEdit
    extends Edit {
        String boneName;
        A3eFile oldFile;
        Vector3d offset;
        Vector3d rot;
        double scale;
        A3eFile newFile;

        VrmlChangeEdit() {
            this.boneName = (String)A3eActionEditorGUI.this.boneCB.getSelectedItem();
            this.oldFile = A3eActionEditorGUI.this.actionEditor.getVRMLFile(this.boneName);
            this.newFile = (A3eFile)A3eActionEditorGUI.this.vrmlCB.getSelectedItem();
            CenteredVRML oldVRML = A3eActionEditorGUI.this.vrmls.get(this.boneName);
            if (oldVRML != null) {
                this.offset = oldVRML.getLoc2();
                this.rot = oldVRML.getRot();
                this.scale = oldVRML.getScale();
            }
        }

        @Override
        void edit() {
            A3eActionEditorGUI.this.actionEditor.setVRML(this.boneName, this.newFile);
            CenteredVRML oldVRML = A3eActionEditorGUI.this.vrmls.get(this.boneName);
            CenteredVRML newVRML = null;
            if (this.newFile == A3eFile.noneFile) {
                newVRML = null;
                A3eActionEditorGUI.this.vrmls.remove(this.boneName);
            } else {
                try {
                    newVRML = new CenteredVRML(this.newFile.getURLString());
                    A3eActionEditorGUI.this.vrmls.put(this.boneName, newVRML);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
            if (oldVRML != null) {
                A3eActionEditorGUI.this.canvas.del((A3Object)oldVRML);
            }
            if (newVRML != null) {
                newVRML.setScale(this.scale);
                newVRML.setRot(this.rot);
                newVRML.setLoc2(this.offset);
                A3eActionEditorGUI.this.canvas.add((A3Object)newVRML);
            }
            A3eActionEditorGUI.this.boneCB.removeActionListener(A3eActionEditorGUI.this);
            A3eActionEditorGUI.this.vrmlCB.removeActionListener(A3eActionEditorGUI.this);
            A3eActionEditorGUI.this.boneCB.setSelectedItem(this.boneName);
            A3eActionEditorGUI.this.vrmlCB.setSelectedItem(this.newFile);
            A3eActionEditorGUI.this.boneCB.addActionListener(A3eActionEditorGUI.this);
            A3eActionEditorGUI.this.vrmlCB.addActionListener(A3eActionEditorGUI.this);
        }

        @Override
        void undo() {
            A3eActionEditorGUI.this.actionEditor.setVRML(this.boneName, this.oldFile);
            CenteredVRML newVRML = A3eActionEditorGUI.this.vrmls.get(this.boneName);
            CenteredVRML oldVRML = null;
            if (this.oldFile == A3eFile.noneFile) {
                oldVRML = null;
                A3eActionEditorGUI.this.vrmls.remove(this.boneName);
            } else {
                try {
                    oldVRML = new CenteredVRML(this.oldFile.getURLString());
                    A3eActionEditorGUI.this.vrmls.put(this.boneName, oldVRML);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
            if (newVRML != null) {
                A3eActionEditorGUI.this.canvas.del((A3Object)newVRML);
            }
            if (oldVRML != null) {
                oldVRML.setScale(this.scale);
                oldVRML.setRot(this.rot);
                oldVRML.setLoc2(this.offset);
                A3eActionEditorGUI.this.canvas.add((A3Object)oldVRML);
            }
            A3eActionEditorGUI.this.boneCB.removeActionListener(A3eActionEditorGUI.this);
            A3eActionEditorGUI.this.vrmlCB.removeActionListener(A3eActionEditorGUI.this);
            A3eActionEditorGUI.this.boneCB.setSelectedItem(this.boneName);
            A3eActionEditorGUI.this.vrmlCB.setSelectedItem(this.oldFile);
            A3eActionEditorGUI.this.boneCB.addActionListener(A3eActionEditorGUI.this);
            A3eActionEditorGUI.this.vrmlCB.addActionListener(A3eActionEditorGUI.this);
        }
    }

    class PartEdit
    extends Edit {
        String boneName;
        Vector3d oldOffset;
        Vector3d oldRot;
        double oldScale;
        Vector3d newOffset;
        Vector3d newRot;
        double newScale;

        PartEdit(CenteredVRML target) {
            this.oldOffset = new Vector3d();
            this.oldRot = new Vector3d();
            this.boneName = A3eActionEditorGUI.this.getBoneName(target);
            T t = A3eActionEditorGUI.this.actionEditor.getPartData(this.boneName);
            t = A3eActionEditorGUI.this.catalog2CenteredVRML(this.boneName, t);
            this.oldOffset = t.offset;
            this.oldRot = t.rot;
            this.oldScale = t.scale;
            this.newOffset = target.getLoc2();
            this.newRot = target.getRot();
            this.newScale = target.getScale();
        }

        @Override
        void edit() {
            T t = new T();
            t.offset = this.newOffset;
            t.rot = this.newRot;
            t.scale = this.newScale;
            t = A3eActionEditorGUI.this.centeredVRML2CATALOG(this.boneName, t);
            A3eActionEditorGUI.this.actionEditor.setPartData(this.boneName, t);
            CenteredVRML target = A3eActionEditorGUI.this.vrmls.get(this.boneName);
            target.setRot(this.newRot);
            target.setScale(this.newScale);
            target.setLoc2(this.newOffset);
        }

        @Override
        void undo() {
            T t = new T();
            t.offset = this.oldOffset;
            t.rot = this.oldRot;
            t.scale = this.oldScale;
            t = A3eActionEditorGUI.this.centeredVRML2CATALOG(this.boneName, t);
            A3eActionEditorGUI.this.actionEditor.setPartData(this.boneName, t);
            CenteredVRML target = A3eActionEditorGUI.this.vrmls.get(this.boneName);
            target.setScale(this.oldScale);
            target.setRot(this.oldRot);
            target.setLoc2(this.oldOffset);
        }
    }

    class SkeletonEdit
    extends Edit {
        Vector3d oldOffset;
        Vector3d oldRot;
        double oldScale;
        Vector3d newOffset;
        Vector3d newRot;
        double newScale;

        SkeletonEdit() {
            this.oldOffset = A3eActionEditorGUI.this.actionEditor.getOffset();
            this.oldRot = A3eActionEditorGUI.this.actionEditor.getRot();
            this.oldRot.scale(Math.PI / 180);
            this.oldScale = A3eActionEditorGUI.this.actionEditor.getScale();
            this.newOffset = A3eActionEditorGUI.this.skeleton.getLoc();
            this.newRot = A3eActionEditorGUI.this.skeleton.getRot();
            this.newScale = A3eActionEditorGUI.this.skeleton.getScale();
        }

        @Override
        void edit() {
            A3eActionEditorGUI.this.actionEditor.setScale(this.newScale);
            Vector3d v = new Vector3d(this.newRot);
            v.scale(57.29577951308232);
            A3eActionEditorGUI.this.actionEditor.setOffset(this.newOffset);
            A3eActionEditorGUI.this.actionEditor.setRot(v);
            A3eActionEditorGUI.this.skeleton.setScale(this.newScale);
            A3eActionEditorGUI.this.skeleton.setRot(this.newRot);
            A3eActionEditorGUI.this.skeleton.setLoc(this.newOffset);
        }

        @Override
        void undo() {
            A3eActionEditorGUI.this.actionEditor.setScale(this.oldScale);
            Vector3d v = new Vector3d(this.oldRot);
            v.scale(57.29577951308232);
            A3eActionEditorGUI.this.actionEditor.setRot(v);
            A3eActionEditorGUI.this.actionEditor.setOffset(this.oldOffset);
            A3eActionEditorGUI.this.skeleton.setScale(this.oldScale);
            A3eActionEditorGUI.this.skeleton.setRot(this.oldRot);
            A3eActionEditorGUI.this.skeleton.setLoc(this.oldOffset);
        }
    }

    abstract class Edit {
        Edit() {
        }

        abstract void edit();

        abstract void undo();

        void redo() {
            this.edit();
        }
    }

    class NewActionInputPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        JTextField actionNameTF;
        JComboBox baseActionCB;
        JComboBox bvhCB;

        NewActionInputPanel() {
            MyVBox baseBox = new MyVBox();
            this.add(baseBox);
            MyHBox actionNameBox = new MyHBox();
            baseBox.myAdd(actionNameBox, 0.0);
            actionNameBox.myAdd(new JLabel("ActionName:"), 0.0);
            this.actionNameTF = new JTextField();
            actionNameBox.myAdd(this.actionNameTF, 1.0);
            MyHBox baseActionBox = new MyHBox();
            baseBox.myAdd(baseActionBox, 0.0);
            baseActionBox.myAdd(new JLabel("\u30d9\u30fc\u30b9\u3068\u306a\u308b\u30a2\u30af\u30b7\u30e7\u30f3"), 0.0);
            this.baseActionCB = new JComboBox();
            baseActionBox.myAdd(this.baseActionCB, 1.0);
            MyHBox bvhBox = new MyHBox();
            baseBox.myAdd(bvhBox, 0.0);
            bvhBox.myAdd(new JLabel("BVH:"), 0.0);
            this.bvhCB = new JComboBox();
            bvhBox.myAdd(this.bvhCB, 1.0);
        }

        void init() {
            this.actionNameTF.setText("");
            this.baseActionCB.removeAllItems();
            this.baseActionCB.addItem("[none]");
            for (String an : A3eActionEditorGUI.this.actionEditor.getActionNames()) {
                this.baseActionCB.addItem(an);
            }
            this.baseActionCB.setSelectedItem("[none]");
            this.bvhCB.removeAllItems();
            this.bvhCB.addItem(A3eFile.noneFile);
            for (A3eFile bvh : A3eActionEditorGUI.this.a3editor.fileManager.listA3eFile(A3eFileType.BVH)) {
                this.bvhCB.addItem(bvh);
            }
            this.bvhCB.setSelectedItem(A3eFile.noneFile);
        }

        void clear() {
            this.actionNameTF.setText("");
            this.baseActionCB.setSelectedItem("[none]");
            this.bvhCB.setSelectedItem(A3eFile.noneFile);
        }
    }

    class MyMouseListener
    extends A3Adapter
    implements MouseMotionListener {
        A3eActionEditorGUI actionEditorGUI;
        double preX;
        double preY;
        A3Object targetA3;

        MyMouseListener(A3eActionEditorGUI aeGUI) {
            this.actionEditorGUI = aeGUI;
        }

        public void mousePressed(A3Event e) {
            int x = e.getMouseEvent().getX();
            int y = e.getMouseEvent().getY();
            Point3d p = A3eActionEditorGUI.this.canvas.canvasToPhysicalCS(x, y, 1.0);
            this.preX = p.x;
            this.preY = p.y;
            this.targetA3 = e.getA3Object();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (A3eActionEditorGUI.this.viewMode == A3eActionEditorGUI.this.camB) {
                return;
            }
            double[] xy = new double[2];
            String m = (String)A3eActionEditorGUI.this.editModeCB.getSelectedItem();
            if (m.equals("\u4e0a\u5439\u304d\u51fa\u3057")) {
                A3eActionEditorGUI.this.empty.getBalloonLoc(A3Object.BalloonDir.TOP, xy);
            } else if (m.equals("\u4e0b\u5439\u304d\u51fa\u3057")) {
                A3eActionEditorGUI.this.empty.getBalloonLoc(A3Object.BalloonDir.BOTTOM, xy);
            } else if (m.equals("\u53f3\u5439\u304d\u51fa\u3057")) {
                A3eActionEditorGUI.this.empty.getBalloonLoc(A3Object.BalloonDir.RIGHT, xy);
            } else if (m.equals("\u5de6\u5439\u304d\u51fa\u3057")) {
                A3eActionEditorGUI.this.empty.getBalloonLoc(A3Object.BalloonDir.LEFT, xy);
            } else if (m.equals("\u30e9\u30d9\u30eb")) {
                A3eActionEditorGUI.this.empty.getLabelLoc(xy);
            } else {
                return;
            }
            int x = e.getX();
            int y = e.getY();
            Point3d p = A3eActionEditorGUI.this.canvas.canvasToPhysicalCS(x, y, 1.0);
            double nowX = p.x;
            double nowY = p.y;
            xy[0] = xy[0] + (nowX - this.preX);
            xy[1] = xy[1] + (nowY - this.preY);
            if (m.equals("\u4e0a\u5439\u304d\u51fa\u3057")) {
                A3eActionEditorGUI.this.empty.setBalloonLoc(A3Object.BalloonDir.TOP, xy[0], xy[1]);
            } else if (m.equals("\u4e0b\u5439\u304d\u51fa\u3057")) {
                A3eActionEditorGUI.this.empty.setBalloonLoc(A3Object.BalloonDir.BOTTOM, xy[0], xy[1]);
            } else if (m.equals("\u53f3\u5439\u304d\u51fa\u3057")) {
                A3eActionEditorGUI.this.empty.setBalloonLoc(A3Object.BalloonDir.RIGHT, xy[0], xy[1]);
            } else if (m.equals("\u5de6\u5439\u304d\u51fa\u3057")) {
                A3eActionEditorGUI.this.empty.setBalloonLoc(A3Object.BalloonDir.LEFT, xy[0], xy[1]);
            } else if (m.equals("\u30e9\u30d9\u30eb")) {
                A3eActionEditorGUI.this.empty.setLabelLoc(xy[0], xy[1]);
            }
            this.preX = nowX;
            this.preY = nowY;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        public void mouseReleased(A3Event e) {
            this.mouseDragged(e.getMouseEvent());
            String m = (String)A3eActionEditorGUI.this.editModeCB.getSelectedItem();
            double[] xy = new double[2];
            if (m.equals("\u5168\u90e8")) {
                if (this.targetA3 instanceof Skeleton) {
                    this.updateActionOffsetRotScale();
                } else if (this.targetA3 instanceof CenteredVRML) {
                    this.updatePartsOffsetRotScale((CenteredVRML)this.targetA3);
                }
            } else if (m.equals("\u9aa8\u3060\u3051")) {
                if (this.targetA3 instanceof Skeleton) {
                    this.updateActionOffsetRotScale();
                }
            } else if (m.equals("\u5f62\u3059\u3079\u3066")) {
                if (this.targetA3 instanceof CenteredVRML) {
                    this.updatePartsOffsetRotScale((CenteredVRML)this.targetA3);
                }
            } else if (m.equals("\u4e00\u3064\u306e\u5f62")) {
                if (this.targetA3 instanceof CenteredVRML) {
                    this.updatePartsOffsetRotScale((CenteredVRML)this.targetA3);
                }
            } else if (m.equals("\u4e0a\u5439\u304d\u51fa\u3057")) {
                A3eActionEditorGUI.this.empty.getBalloonLoc(A3Object.BalloonDir.TOP, xy);
                A3eActionEditorGUI.this.actionEditor.setTopBalloonOffset(xy);
            } else if (m.equals("\u4e0b\u5439\u304d\u51fa\u3057")) {
                A3eActionEditorGUI.this.empty.getBalloonLoc(A3Object.BalloonDir.BOTTOM, xy);
                A3eActionEditorGUI.this.actionEditor.setBottomBalloonOffset(xy);
            } else if (m.equals("\u53f3\u5439\u304d\u51fa\u3057")) {
                A3eActionEditorGUI.this.empty.getBalloonLoc(A3Object.BalloonDir.RIGHT, xy);
                A3eActionEditorGUI.this.actionEditor.setRightBalloonOffset(xy);
            } else if (m.equals("\u5de6\u5439\u304d\u51fa\u3057")) {
                A3eActionEditorGUI.this.empty.getBalloonLoc(A3Object.BalloonDir.LEFT, xy);
                A3eActionEditorGUI.this.actionEditor.setLeftBalloonOffset(xy);
            } else if (m.equals("\u30e9\u30d9\u30eb")) {
                A3eActionEditorGUI.this.empty.getLabelLoc(xy);
                A3eActionEditorGUI.this.actionEditor.setLabelOffset(xy);
            } else if (m.equals("\u30b5\u30a6\u30f3\u30c9")) {
                Vector3d v = A3eActionEditorGUI.this.speaker.getLoc();
                A3eActionEditorGUI.this.actionEditor.setSoundOffset(v.x, v.y, v.z);
                Quat4d q = A3eActionEditorGUI.this.speaker.getQuat();
                v = Util.trans((Quat4d)q, (Vector3d)new Vector3d(0.0, 0.0, 1.0));
                A3eActionEditorGUI.this.actionEditor.setSoundDirection(v.x, v.y, v.z);
            } else {
                System.out.println("???????" + m);
            }
        }

        void updateActionOffsetRotScale() {
            if (A3eActionEditorGUI.this.skeleton != null) {
                A3eActionEditorGUI.this.doEdit(new SkeletonEdit());
            }
        }

        void updatePartsOffsetRotScale(CenteredVRML vrml) {
            A3eActionEditorGUI.this.doEdit(new PartEdit(vrml));
        }
    }
}

