/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3editor;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import jp.sourceforge.acerola3d.a3editor.A3eDirButton;
import jp.sourceforge.acerola3d.a3editor.A3eFile;
import jp.sourceforge.acerola3d.a3editor.A3eFileGUI;
import jp.sourceforge.acerola3d.a3editor.A3eFileManager;
import jp.sourceforge.acerola3d.a3editor.A3eFileType;
import jp.sourceforge.acerola3d.a3panels.BVHPanel;
import jp.sourceforge.acerola3d.a3panels.HtmlPanel;
import jp.sourceforge.acerola3d.a3panels.ImagePanel;
import jp.sourceforge.acerola3d.a3panels.MyHBox;
import jp.sourceforge.acerola3d.a3panels.MyVBox;
import jp.sourceforge.acerola3d.a3panels.SoundPanel;
import jp.sourceforge.acerola3d.a3panels.VrmlPanel;

class A3eFileManagerGUI
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    A3eFileManager fileManager;
    A3eFile currentDir;
    ArrayList<A3eFileGUI> fileGUIs = new ArrayList();
    MyVBox viewerBox;
    CardLayout cardLayout;
    JLabel filePathL;
    JPanel viewerPanel;
    VrmlPanel vrmlPanel;
    BVHPanel bvhPanel;
    ImagePanel imagePanel;
    SoundPanel soundPanel;
    HtmlPanel htmlPanel;
    MyVBox dirBox;
    JButton refreshButton;
    JPanel mainPanel;

    A3eFileManagerGUI(A3eFileManager fm) {
        this.fileManager = fm;
        this.currentDir = this.fileManager.a3eRootDir;
        this.setLayout(new BorderLayout());
        JSplitPane basePane = new JSplitPane();
        basePane.setDividerLocation(600);
        this.add((Component)basePane, "Center");
        this.viewerBox = new MyVBox();
        this.viewerBox.setMinimumSize(new Dimension(100, 100));
        basePane.setLeftComponent(this.viewerBox);
        this.viewerBox.myAdd(new JLabel("Viewer"), 0.0);
        this.filePathL = new JLabel();
        this.viewerBox.myAdd(this.filePathL, 0.0);
        this.cardLayout = new CardLayout();
        this.viewerPanel = new JPanel();
        this.viewerPanel.setLayout(this.cardLayout);
        this.viewerBox.myAdd(this.viewerPanel, 1.0);
        this.viewerPanel.add((Component)new DummyPanel(), "none");
        this.vrmlPanel = new VrmlPanel(null);
        this.viewerPanel.add((Component)this.vrmlPanel, "VRML");
        this.bvhPanel = new BVHPanel(null);
        this.viewerPanel.add((Component)this.bvhPanel, "BVH");
        this.imagePanel = new ImagePanel(null);
        this.viewerPanel.add((Component)this.imagePanel, "IMAGE");
        this.soundPanel = new SoundPanel(null);
        this.viewerPanel.add((Component)this.soundPanel, "SOUND");
        this.htmlPanel = new HtmlPanel(null);
        this.viewerPanel.add((Component)this.htmlPanel, "HTML");
        this.dirBox = new MyVBox();
        basePane.setRightComponent(this.dirBox);
        this.refresh();
    }

    void refresh() {
        this.dirBox.removeAll();
        this.refreshButton = new JButton("refresh");
        this.refreshButton.addActionListener(this);
        this.dirBox.myAdd(this.refreshButton, 0.0);
        MyHBox pathBox = new MyHBox();
        this.dirBox.myAdd(pathBox, 0.0);
        pathBox.myAdd(new JLabel("Path:"), 0.0);
        ArrayDeque<A3eDirButton> stack = new ArrayDeque<A3eDirButton>();
        A3eFile p = this.currentDir;
        while (p != null) {
            stack.addFirst(new A3eDirButton(p, this));
            p = p.parent;
        }
        while (!stack.isEmpty()) {
            pathBox.myAdd((Component)stack.removeFirst(), 0.0);
        }
        pathBox.myAdd(Box.createGlue(), 1.0);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setPreferredSize(new Dimension(500, 300));
        this.dirBox.myAdd(scrollPane, 1.0);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        scrollPane.getViewport().setView(this.mainPanel);
        this.fileGUIs.clear();
        for (A3eFile f : this.currentDir.children) {
            A3eFileGUI fGUI = new A3eFileGUI(f, this);
            this.mainPanel.add(fGUI);
            this.fileGUIs.add(fGUI);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                A3eFileManagerGUI.this.validate();
            }
        });
        this.cardLayout.show(this.viewerPanel, "none");
        this.filePathL.setText("");
    }

    void init() {
        try {
            this.fileManager.refresh();
            this.currentDir = this.fileManager.getRefreshedFile(this.currentDir);
            if (this.currentDir == null) {
                this.currentDir = this.fileManager.a3eRootDir;
            }
            this.refresh();
        }
        catch (IOException ee) {
            ee.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.refreshButton) {
            try {
                this.fileManager.refresh();
                this.currentDir = this.fileManager.getRefreshedFile(this.currentDir);
                if (this.currentDir == null) {
                    this.currentDir = this.fileManager.a3eRootDir;
                }
                this.refresh();
            }
            catch (IOException ee) {
                ee.printStackTrace();
            }
        }
    }

    void openViewer(A3eFile f, A3eFileGUI fGUI) {
        this.soundPanel.clear();
        for (A3eFileGUI fg : this.fileGUIs) {
            fg.setSelected(false);
        }
        fGUI.setSelected(true);
        if (f.type == A3eFileType.DIR) {
            this.cardLayout.show(this.viewerPanel, "none");
            this.filePathL.setText("DIR:" + f.getPath());
        } else if (f.type == A3eFileType.CATALOG) {
            this.cardLayout.show(this.viewerPanel, "none");
            this.filePathL.setText("CATALOG:" + f.getPath());
        } else if (f.type == A3eFileType.BVH) {
            this.bvhPanel.loadBVH(f.toFile());
            this.cardLayout.show(this.viewerPanel, "BVH");
            this.filePathL.setText("BVH:" + f.getPath());
        } else if (f.type == A3eFileType.VRML) {
            this.vrmlPanel.loadVRML(f.toFile());
            this.cardLayout.show(this.viewerPanel, "VRML");
            this.filePathL.setText("VRML:" + f.getPath());
        } else if (f.type == A3eFileType.IMAGE) {
            this.imagePanel.loadImage(f.toFile());
            this.cardLayout.show(this.viewerPanel, "IMAGE");
            this.filePathL.setText("IMAGE:" + f.getPath());
        } else if (f.type == A3eFileType.SOUND) {
            this.soundPanel.loadSound(f.toFile());
            this.cardLayout.show(this.viewerPanel, "SOUND");
            this.filePathL.setText("SOUND:" + f.getPath());
        } else if (f.type == A3eFileType.HTML) {
            this.htmlPanel.open(f.toFile());
            this.cardLayout.show(this.viewerPanel, "HTML");
            this.filePathL.setText("HTML:" + f.getPath());
        } else if (f.type == A3eFileType.UNKNOWN) {
            this.cardLayout.show(this.viewerPanel, "none");
            this.filePathL.setText("UNKNOWN:" + f.getPath());
        }
    }

    void clear() {
        this.soundPanel.clear();
    }

    class DummyPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        DummyPanel() {
            this.setLayout(new BorderLayout());
            MyVBox b = new MyVBox();
            this.add((Component)b, "Center");
            b.myAdd(new JLabel("\u53f3\u306e\u30a2\u30a4\u30b3\u30f3\u3092\u30af\u30ea\u30c3\u30af\u3059\u308b\u3068\u3053\u3053\u306b\u5185\u5bb9\u304c\u8868\u793a\u3055\u308c\u307e\u3059\u3002", 0), 0.0);
            b.myAdd(new JLabel("(\u5bfe\u5fdc\u30d5\u30a1\u30a4\u30eb\u306e\u307f\u3002)", 0), 0.0);
            b.myAdd(new JLabel("\u30d5\u30a9\u30eb\u30c0\u3092\u958b\u304f\u306b\u306f\u30c0\u30d6\u30eb\u30af\u30ea\u30c3\u30af\u3057\u3066\u4e0b\u3055\u3044\u3002", 0), 0.0);
        }
    }
}

