/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3editor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileNameExtensionFilter;
import jp.sourceforge.acerola3d.a3editor.A3eFile;
import jp.sourceforge.acerola3d.a3editor.A3eFileManager;

public class CreateA3GUI
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    A3eFileManager fileManager;
    JButton createB;

    public CreateA3GUI(A3eFileManager fm) {
        this.fileManager = fm;
        this.createB = new JButton("Acerola3D\u30d5\u30a1\u30a4\u30eb\u3092\u4f5c\u6210");
        this.createB.addActionListener(this);
        this.add(this.createB);
    }

    void init() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            File rootDir = this.fileManager.rootDir;
            File defaultFile = new File(rootDir, rootDir.getName() + ".a3");
            JFileChooser chooser = new JFileChooser(rootDir);
            chooser.setSelectedFile(defaultFile);
            FileNameExtensionFilter filter = new FileNameExtensionFilter("Acerola3D Files", "a3");
            chooser.setFileFilter(filter);
            int returnVal = chooser.showSaveDialog(this);
            if (returnVal != 0) {
                return;
            }
            File f = chooser.getSelectedFile();
            A3eFile[] files = this.fileManager.listA3eFile();
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(f));
            byte[] buf = new byte[1024];
            for (A3eFile ff : files) {
                if (ff.isIgnored() || ff.isDirectory()) continue;
                FileInputStream fis = new FileInputStream(ff.toFile());
                ZipEntry ze = new ZipEntry(ff.getPath());
                zos.putNextEntry(ze);
                int len = 0;
                while ((len = fis.read(buf)) != -1) {
                    zos.write(buf, 0, len);
                }
                fis.close();
                zos.closeEntry();
            }
            zos.close();
            this.fileManager.refresh();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    void clear() {
    }
}

