/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3panels;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.Node;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.A3Controller;
import jp.sourceforge.acerola3d.a3.A3Event;
import jp.sourceforge.acerola3d.a3.A3Object;

public class MyExamController
extends A3Controller {
    Vector3d fixationPoint = new Vector3d(0.0, 1.0, 0.0);
    double distance = 3.0;
    Quat4d cameraQuat = new Quat4d(0.0, 0.0, 0.0, 1.0);
    int lastMouseX;
    int lastMouseY;

    public void init() {
        this.fixationPoint.set(0.0, 1.0, 0.0);
        this.distance = 3.0;
        this.cameraQuat.set(0.0, 0.0, 0.0, 1.0);
        this.setCamera();
    }

    public void adjust(A3Object a3) {
        Node n = a3.getNode();
        Bounds b = n.getBounds();
        if (b instanceof BoundingSphere) {
            BoundingSphere bs = (BoundingSphere)b;
            Point3d p = new Point3d();
            bs.getCenter(p);
            double r = bs.getRadius();
            if (r > 0.0) {
                this.fixationPoint.set((Tuple3d)p);
                this.distance = r * 2.5;
            } else {
                this.fixationPoint.set(0.0, 1.0, 0.0);
                this.distance = 3.0;
            }
        } else {
            this.fixationPoint.set(0.0, 1.0, 0.0);
            this.distance = 3.0;
        }
        this.cameraQuat.set(0.0, 0.0, 0.0, 1.0);
        this.setCamera();
    }

    public void adjust(BoundingSphere bs) {
        Point3d p = new Point3d();
        bs.getCenter(p);
        double r = bs.getRadius();
        if (r > 0.0) {
            this.fixationPoint.set((Tuple3d)p);
            this.distance = r * 2.5;
        } else {
            this.fixationPoint.set(0.0, 1.0, 0.0);
            this.distance = 3.0;
        }
        this.cameraQuat.set(0.0, 0.0, 0.0, 1.0);
        this.setCamera();
    }

    public void mousePressed(A3Event ae) {
        MouseEvent me = ae.getMouseEvent();
        this.lastMouseX = me.getX();
        this.lastMouseY = me.getY();
    }

    public void mouseDragged(A3Event ae) {
        MouseEvent me = ae.getMouseEvent();
        int shiftX = me.getX() - this.lastMouseX;
        int shiftY = me.getY() - this.lastMouseY;
        if ((me.getModifiersEx() & 0x400) != 0) {
            Quat4d q0 = new Quat4d(0.0, 0.0, 0.0, 1.0);
            double t = (double)(-shiftX) * 0.01;
            Quat4d q1 = new Quat4d(0.0, Math.sin(t), 0.0, Math.cos(t));
            t = (double)(-shiftY) * 0.01;
            Quat4d q2 = new Quat4d(Math.sin(t), 0.0, 0.0, Math.cos(t));
            q0.mul(q1);
            q0.mul(q2);
            this.cameraQuat.mul(q0);
        } else if ((me.getModifiersEx() & 0x800) != 0) {
            Vector3d v = this.a3canvas.virtualCSToPhysicalCS(this.fixationPoint);
            Point3d shift = this.a3canvas.canvasToPhysicalCS(this.lastMouseX, this.lastMouseY, -v.z);
            shift.sub((Tuple3d)this.a3canvas.canvasToPhysicalCS(me.getX(), me.getY(), -v.z));
            if ((me.getModifiers() & 1) != 0) {
                shift.set(shift.x, 0.0, -shift.y);
            }
            Vector3d vx = this.a3canvas.getCameraUnitVecX();
            Vector3d vy = this.a3canvas.getCameraUnitVecY();
            Vector3d vz = this.a3canvas.getCameraUnitVecZ();
            vx.scale(shift.x);
            vy.scale(shift.y);
            vz.scale(shift.z);
            this.fixationPoint.add((Tuple3d)vx);
            this.fixationPoint.add((Tuple3d)vy);
            this.fixationPoint.add((Tuple3d)vz);
        } else if ((me.getModifiersEx() & 0x1000) != 0) {
            this.distance = this.distance * (double)(100 + shiftY) / 100.0;
        }
        this.setCamera();
        this.lastMouseX = me.getX();
        this.lastMouseY = me.getY();
    }

    public void up() {
        Vector3d v = this.a3canvas.getCameraUnitVecY();
        v.scale(0.1 * this.distance);
        this.fixationPoint.sub((Tuple3d)v);
        this.setCamera();
    }

    public void down() {
        Vector3d v = this.a3canvas.getCameraUnitVecY();
        v.scale(0.1 * this.distance);
        this.fixationPoint.add((Tuple3d)v);
        this.setCamera();
    }

    public void right() {
        Vector3d v = this.a3canvas.getCameraUnitVecX();
        v.scale(0.1 * this.distance);
        this.fixationPoint.sub((Tuple3d)v);
        this.setCamera();
    }

    public void left() {
        Vector3d v = this.a3canvas.getCameraUnitVecX();
        v.scale(0.1 * this.distance);
        this.fixationPoint.add((Tuple3d)v);
        this.setCamera();
    }

    public void big() {
        this.distance *= 0.75;
        this.setCamera();
    }

    public void small() {
        this.distance *= 1.3333333333333333;
        this.setCamera();
    }

    void setCamera() {
        Quat4d tmpQ = new Quat4d(0.0, 0.0, 1.0, 0.0);
        Quat4d cameraQuatC = new Quat4d();
        cameraQuatC.conjugate(this.cameraQuat);
        tmpQ.mul(this.cameraQuat, tmpQ);
        tmpQ.mul(cameraQuatC);
        tmpQ.scale(this.distance);
        Vector3d tmpV = new Vector3d(this.fixationPoint);
        tmpV.set(tmpV.x + tmpQ.x, tmpV.y + tmpQ.y, tmpV.z + tmpQ.z);
        this.a3canvas.setCameraLocImmediately(tmpV);
        this.a3canvas.setCameraQuatImmediately(this.cameraQuat);
        this.a3canvas.setCameraScaleImmediately(this.distance / 2.0);
    }

    public void mouseReleased(A3Event e) {
    }

    public void mouseClicked(A3Event ae) {
    }

    public void mouseDoubleClicked(A3Event ae) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }
}

