/*
 * Decompiled with CFR 0.152.
 */
package com.microcrowd.loader.java3d.max3ds;

import com.microcrowd.loader.java3d.max3ds.CannotChopException;
import com.microcrowd.loader.java3d.max3ds.ChunkMap;
import com.microcrowd.loader.java3d.max3ds.ChunkTester;
import com.microcrowd.loader.java3d.max3ds.Loader3DS;
import com.microcrowd.loader.java3d.max3ds.chunks.Chunk;
import com.microcrowd.loader.java3d.max3ds.data.KeyFramer;
import com.sun.j3d.loaders.SceneBase;
import com.sun.j3d.utils.image.TextureLoader;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.j3d.Behavior;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Light;
import javax.media.j3d.Node;
import javax.media.j3d.Texture;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class ChunkChopper {
    private Logger logger = Logger.getLogger((class$com$microcrowd$loader$java3d$max3ds$ChunkChopper == null ? (class$com$microcrowd$loader$java3d$max3ds$ChunkChopper = ChunkChopper.class$("com.microcrowd.loader.java3d.max3ds.ChunkChopper")) : class$com$microcrowd$loader$java3d$max3ds$ChunkChopper).getName());
    private Loader3DS loader;
    private BranchGroup sceneGroup;
    private SceneBase base;
    private HashMap dataMap;
    private ByteBuffer chunkBuffer;
    private Integer chunkID;
    private TransformGroup currentGroup;
    private String currentObjectName;
    private ChunkTester chunkTester = new ChunkTester();
    private Chunk mainChunk = new Chunk("MainChunk");
    private ChunkMap chunkMap = new ChunkMap(this.mainChunk);
    private KeyFramer keyFramer = new KeyFramer();
    public static boolean debug;
    public static Chunk debugChunk;
    static /* synthetic */ Class class$com$microcrowd$loader$java3d$max3ds$ChunkChopper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized SceneBase loadSceneBase(InputStream inputStream, Loader3DS loader, int modelSize) {
        block13: {
            this.loader = loader;
            this.sceneGroup = new BranchGroup();
            this.base = new SceneBase();
            this.dataMap = new HashMap();
            this.base.setSceneGroup(this.sceneGroup);
            ReadableByteChannel channel = null;
            channel = Channels.newChannel(inputStream);
            this.chunkBuffer = this.getByteBuffer(channel, modelSize);
            short mainChunkID = this.chunkBuffer.getShort();
            long mainChunkLength = this.chunkBuffer.getInt();
            long begin = System.currentTimeMillis();
            this.logger.finest("\n\n\n STARTING SUBCUNKS " + (mainChunkLength - 61L));
            try {
                this.loadSubChunks(this.mainChunk, 0);
            }
            catch (CannotChopException e) {
                // empty catch block
            }
            this.logger.finest("FINISHED WITH THE SUBCHUNKS");
            Object var12_10 = null;
            try {
                if (channel != null) {
                    channel.close();
                }
                break block13;
            }
            catch (Exception e2) {}
            break block13;
            {
                catch (Exception e) {
                    e.printStackTrace();
                    Object var12_11 = null;
                    try {
                        if (channel != null) {
                            channel.close();
                        }
                        break block13;
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                try {
                    if (channel != null) {
                        channel.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return this.base;
    }

    public ByteBuffer getByteBuffer(ReadableByteChannel channel, int channelSize) throws IOException {
        ByteBuffer chunkBuffer = ByteBuffer.allocate(channelSize);
        chunkBuffer.order(ByteOrder.LITTLE_ENDIAN);
        channel.read(chunkBuffer);
        chunkBuffer.position(0);
        return chunkBuffer;
    }

    protected void loadSubChunks(Chunk parentChunk, int level) throws CannotChopException {
        ++level;
        while (this.chunkBuffer.hasRemaining()) {
            this.chunkID = new Integer(this.chunkBuffer.getShort());
            Chunk chunk = parentChunk.getSubChunk(this.chunkID);
            int currentChunkLength = this.chunkBuffer.getInt() - 6;
            int finishedPosition = this.chunkBuffer.position() + currentChunkLength;
            int previousLimit = this.chunkBuffer.limit();
            this.chunkBuffer.limit(this.chunkBuffer.position() + currentChunkLength);
            if (debug) {
                this.debug(parentChunk, level, this.chunkID, currentChunkLength, this.chunkBuffer.position(), this.chunkBuffer.limit());
            }
            if (chunk != null && currentChunkLength != 0) {
                try {
                    chunk.loadData(this);
                }
                catch (BufferUnderflowException e) {
                    this.chunkBuffer.position(finishedPosition);
                    this.chunkBuffer.limit(previousLimit);
                    throw new CannotChopException(" tried to read too much data from the buffer. Trying to recover.", e);
                }
                try {
                    if (this.chunkBuffer.hasRemaining()) {
                        this.loadSubChunks(chunk, level);
                    }
                    chunk.initialize(this);
                }
                catch (CannotChopException e) {
                    this.logger.log(Level.SEVERE, chunk.toString() + "Trying to continue");
                }
            }
            this.chunkBuffer.position(finishedPosition);
            this.chunkBuffer.limit(previousLimit);
        }
    }

    public KeyFramer getKeyFramer() {
        return this.keyFramer;
    }

    public void addObject(String name, TransformGroup group) {
        this.sceneGroup.addChild((Node)group);
        this.currentGroup = group;
        this.currentObjectName = name;
        this.base.addNamedObject(name, (Object)group);
    }

    public String getObjectName() {
        return this.currentObjectName;
    }

    public void setObjectName(String name) {
        this.currentObjectName = name;
    }

    public TransformGroup getGroup() {
        return this.currentGroup;
    }

    public void pushData(Object key, Object data) {
        this.dataMap.put(key, data);
    }

    public Object popData(Object key) {
        Object retVal = this.dataMap.remove(key);
        return retVal;
    }

    public void setNamedObject(String key, Object value) {
        this.base.addNamedObject(key, value);
    }

    public boolean hasLights() {
        return this.base.getLightNodes() != null && this.base.getLightNodes().length > 0;
    }

    public void addBehaviorNode(Behavior behavior) {
        this.base.addBehaviorNode(behavior);
    }

    public void addLightNode(Light light) {
        this.base.addLightNode(light);
    }

    public void addViewGroup(TransformGroup viewGroup) {
        this.base.addViewGroup(viewGroup);
    }

    public Object getNamedObject(String key) {
        if (key == null) {
            return null;
        }
        return this.base.getNamedObjects().get(key);
    }

    public TransformGroup getNamedTransformGroup(String key) {
        Object object = this.getNamedObject(key);
        if (object instanceof TransformGroup) {
            return (TransformGroup)object;
        }
        if (object != null) {
            this.logger.log(Level.INFO, "Retrieving " + key + " which is a named object but not useable because " + " its not a transform group. Its a " + object.getClass().getName());
        }
        return null;
    }

    public long getLong() {
        return this.chunkBuffer.getLong();
    }

    public int getShort() {
        return this.chunkBuffer.getShort();
    }

    public int getUnsignedShort() {
        return this.chunkBuffer.getShort() & 0xFFFF;
    }

    public float getFloat() {
        return this.chunkBuffer.getFloat();
    }

    public Vector3f getVector() {
        return new Vector3f((Tuple3f)this.getPoint());
    }

    public Point3f getPoint() {
        float x = this.chunkBuffer.getFloat();
        float z = -this.chunkBuffer.getFloat();
        float y = this.chunkBuffer.getFloat();
        return new Point3f(x, y, z);
    }

    public int getInt() {
        return this.chunkBuffer.getInt();
    }

    public int getUnsignedInt() {
        return this.chunkBuffer.getInt() & 0xFFFFFFFF;
    }

    public int getUnsignedByte() {
        return this.chunkBuffer.get() & 0xFF;
    }

    public byte[] getChunkBytes() {
        byte[] retVal = new byte[this.chunkBuffer.limit() - this.chunkBuffer.position()];
        this.get(retVal);
        return retVal;
    }

    public void get(byte[] bytes) {
        this.chunkBuffer.get(bytes);
    }

    public void setDataMap(HashMap dataMap) {
        this.dataMap = dataMap;
    }

    public String getString() {
        StringBuffer stringBuffer = new StringBuffer();
        char charIn = (char)this.chunkBuffer.get();
        while (charIn != '\u0000') {
            stringBuffer.append(charIn);
            charIn = (char)this.chunkBuffer.get();
        }
        return stringBuffer.toString();
    }

    public Integer getID() {
        return this.chunkID;
    }

    public Texture createTexture(String textureImageName) {
        Image image = this.loader.getTextureImage(textureImageName);
        if (image == null) {
            System.err.println("Cannot load texture image " + textureImageName + ". Make sure it is in the directory with the model file. " + "If its a bmp make sure JAI is installed.");
            return null;
        }
        try {
            TextureLoader textureLoader = new TextureLoader(image, null);
            return textureLoader.getTexture();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void debug(Chunk parentChunk, int level, Integer chunkID, long chunkLength, int position, long limit) {
        try {
            for (int i = 0; i < level; ++i) {
                System.out.print("  ");
            }
            Chunk child = parentChunk.getSubChunk(chunkID);
            int id = (short)chunkID.intValue() & 0xFFFF;
            System.out.println(parentChunk + " is " + (child == null ? "skipping" : "LOADING") + ": [id=" + Integer.toHexString(id) + ", object= <" + parentChunk.getSubChunk(chunkID) + ">, chunkLength=" + chunkLength + ", position=" + position + " limit=" + limit + "]");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void exceptAndExit(Throwable exception) {
        this.logger.log(Level.SEVERE, "\nThe chunk for loadData method read too much or not enough data from the stream. It needs be skipped or adjusted to read more or less data.");
        exception.printStackTrace();
        System.exit(3);
    }

    private static String byteString(int i) {
        char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] buf = new char[2];
        buf[1] = digits[i & 0xF];
        buf[0] = digits[(i >>>= 4) & 0xF];
        return "0x" + new String(buf).toUpperCase();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

