/*
 * Decompiled with CFR 0.152.
 */
package com.microcrowd.loader.java3d.max3ds;

import com.microcrowd.loader.java3d.max3ds.ChunkChopper;
import com.microcrowd.loader.java3d.max3ds.DefaultTextureImageLoader;
import com.microcrowd.loader.java3d.max3ds.TextureImageLoader;
import com.sun.j3d.loaders.LoaderBase;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.SceneBase;
import java.awt.Image;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.PointLight;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;

public class Loader3DS
extends LoaderBase {
    private boolean dataMapInitialized;
    private TextureImageLoader textureImageLoader;
    private boolean fromUrl;
    private boolean debugMode;

    public Scene load(Reader reader) throws FileNotFoundException {
        throw new UnsupportedOperationException("Not supported for 3DS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scene load(String modelPath) throws FileNotFoundException {
        InputStream fileIn = null;
        this.setBasePathFromFilename(modelPath);
        try {
            File modelFile = this.getFile(modelPath);
            fileIn = new FileInputStream(modelFile);
            Scene scene = this.parseChunks(fileIn, (int)modelFile.length());
            return scene;
        }
        finally {
            try {
                fileIn.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void setBaseUrlFromUrl(URL url) throws FileNotFoundException {
        String u = url.toString();
        String s = u.lastIndexOf(47) == -1 ? url.getProtocol() + ":" : u.substring(0, u.lastIndexOf(47) + 1);
        try {
            this.setBaseUrl(new URL(s));
        }
        catch (MalformedURLException e) {
            throw new FileNotFoundException(e.getMessage());
        }
    }

    private void setBasePathFromFilename(String fileName) {
        if (fileName.lastIndexOf(File.separator) == -1) {
            this.setBasePath("." + File.separator);
        } else {
            this.setBasePath(fileName.substring(0, fileName.lastIndexOf(File.separator)));
        }
    }

    public void setBasePath(String pathName) {
        String basePath = pathName;
        if (basePath == null || basePath == "") {
            basePath = "." + File.separator;
        }
        basePath = basePath.replace('/', File.separatorChar);
        if (!(basePath = basePath.replace('\\', File.separatorChar)).endsWith(File.separator)) {
            basePath = basePath + File.separator;
        }
        super.setBasePath(basePath);
    }

    public boolean fromUrl() {
        return this.fromUrl;
    }

    public Image getTextureImage(String imageName) {
        try {
            if (this.textureImageLoader == null) {
                this.textureImageLoader = new DefaultTextureImageLoader(this);
            }
            return this.textureImageLoader.getTextureImage(imageName);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void setTextureImageLoader(TextureImageLoader loader) {
        this.textureImageLoader = loader;
    }

    protected Scene parseChunks(InputStream inputStream, int modelSize) {
        ChunkChopper chopper = new ChunkChopper();
        SceneBase base = chopper.loadSceneBase(inputStream, this, modelSize);
        if (!chopper.hasLights()) {
            Loader3DS.addDefaultLights((Group)base.getSceneGroup());
            Loader3DS.addDefaultLights((Group)chopper.getGroup());
        }
        return base;
    }

    public static void addDefaultLights(Group group) {
        PointLight light1 = new PointLight();
        PointLight light2 = new PointLight();
        light1.setInfluencingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 3000.0));
        light2.setInfluencingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 3000.0));
        Transform3D t1 = new Transform3D(new float[]{1.0f, 0.0f, 0.0f, -900.0f, 0.0f, 1.0f, 0.0f, 1500.0f, 0.0f, 0.0f, 1.0f, 1000.0f, 0.0f, 0.0f, 0.0f, 1.0f});
        Transform3D t2 = new Transform3D(new float[]{1.0f, 0.0f, 0.0f, 900.0f, 0.0f, 1.0f, 0.0f, -1500.0f, 0.0f, 0.0f, 1.0f, -1000.0f, 0.0f, 0.0f, 0.0f, 1.0f});
        TransformGroup group1 = new TransformGroup(t1);
        TransformGroup group2 = new TransformGroup(t2);
        group1.addChild((Node)light1);
        group2.addChild((Node)light2);
        group.addChild((Node)group1);
        group.addChild((Node)group2);
    }

    private File getFile(String fileName) {
        File file = null;
        try {
            file = new File(fileName);
            if (!file.exists()) {
                throw new IOException(fileName + " doesn't exist");
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return file;
    }

    public Scene load(URL url) throws FileNotFoundException {
        this.fromUrl = true;
        try {
            URLConnection connection = url.openConnection();
            if (this.baseUrl == null) {
                this.setBaseUrlFromUrl(url);
            }
            return this.parseChunks(connection.getInputStream(), connection.getContentLength());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Url " + url + " cannot be loaded");
        }
    }

    public void turnOnDebug() {
        if (!this.debugMode) {
            ChunkChopper.debug = true;
            this.debugMode = true;
        }
    }
}

