/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.vrml97.impl;

import org.jdesktop.j3d.loaders.vrml97.impl.ConstField;
import org.jdesktop.j3d.loaders.vrml97.impl.ConstSFRotation;
import org.jdesktop.j3d.loaders.vrml97.impl.Field;

public class SFRotation
extends Field {
    float[] rot = new float[4];

    public SFRotation() {
        this.rot[0] = 0.0f;
        this.rot[1] = 0.0f;
        this.rot[2] = 1.0f;
        this.rot[3] = 0.0f;
    }

    public SFRotation(float x, float y, float z, float axisAngle) {
        this.rot[0] = x;
        this.rot[1] = y;
        this.rot[2] = z;
        this.rot[3] = axisAngle;
    }

    public SFRotation(float[] axisAngle) {
        this.rot[0] = axisAngle[0];
        this.rot[1] = axisAngle[1];
        this.rot[2] = axisAngle[2];
        this.rot[3] = axisAngle[3];
    }

    public void getValue(float[] rotation) {
        System.arraycopy(this.rot, 0, rotation, 0, 4);
    }

    public float[] getValue() {
        return this.rot;
    }

    public void setValue(float[] r) {
        System.arraycopy(r, 0, this.rot, 0, 4);
        this.route();
    }

    public void setValue(float xAxis, float yAxis, float zAxis, float angle) {
        this.rot[0] = xAxis;
        this.rot[1] = yAxis;
        this.rot[2] = zAxis;
        this.rot[3] = angle;
        this.route();
    }

    public void setValue(ConstSFRotation rotation) {
        this.setValue((SFRotation)rotation.ownerField);
    }

    public void setValue(SFRotation rotation) {
        this.setValue(rotation.rot);
    }

    public Object clone() {
        return new SFRotation(this.rot);
    }

    public void update(Field field) {
        this.setValue((SFRotation)field);
    }

    public synchronized ConstField constify() {
        if (this.constField == null) {
            this.constField = new ConstSFRotation(this);
        }
        return this.constField;
    }

    public a3vrml.Field wrap() {
        return new a3vrml.field.SFRotation(this);
    }

    void route() {
        double normalizer = Math.sqrt(this.rot[0] * this.rot[0] + this.rot[1] * this.rot[1] + this.rot[2] * this.rot[2]);
        if (normalizer < (double)0.001f) {
            this.rot[0] = 0.0f;
            this.rot[1] = 1.0f;
            this.rot[2] = 0.0f;
        } else {
            this.rot[0] = (float)((double)this.rot[0] / normalizer);
            this.rot[1] = (float)((double)this.rot[1] / normalizer);
            this.rot[2] = (float)((double)this.rot[2] / normalizer);
        }
        super.route();
    }

    public String toString() {
        return this.rot[0] + " " + this.rot[1] + " " + this.rot[2] + " " + this.rot[3] + "\n";
    }
}

