/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.j3d.loaders.md2;

import java.io.DataInputStream;
import java.io.IOException;
import org.newdawn.j3d.loaders.cio.LittleEndianDataInputStream;
import org.newdawn.j3d.loaders.md2.MD2Header;
import org.newdawn.j3d.loaders.md2.MD2Vertex;

public class MD2Frame {
    private float[] scale = new float[3];
    private float[] translate = new float[3];
    private String name;
    private MD2Vertex[] verts;

    public MD2Frame(DataInputStream tin, MD2Header header) throws IOException {
        LittleEndianDataInputStream in = new LittleEndianDataInputStream(tin);
        this.verts = new MD2Vertex[header.getVertexCount()];
        this.scale[0] = in.readFloat() / 25.0f;
        this.scale[1] = in.readFloat() / 25.0f;
        this.scale[2] = in.readFloat() / 25.0f;
        this.translate[0] = in.readFloat() / 25.0f;
        this.translate[1] = in.readFloat() / 25.0f;
        this.translate[2] = in.readFloat() / 25.0f;
        byte[] temp = new byte[16];
        in.read(temp, 0, 16);
        int len = 16;
        int i = 0;
        while (i < 16) {
            if (temp[i] == 0) {
                len = i;
                break;
            }
            ++i;
        }
        this.name = new String(temp, 0, len);
        int i2 = 0;
        while (i2 < header.getVertexCount()) {
            this.verts[i2] = new MD2Vertex(tin, this.scale, this.translate);
            ++i2;
        }
    }

    public String getName() {
        return this.name;
    }

    public MD2Vertex getVertex(int i) {
        return this.verts[i];
    }
}

