/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.j3d.loaders.ac3d;

import java.util.ArrayList;
import java.util.Iterator;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import org.newdawn.j3d.loaders.ac3d.AC3DMaterial;
import org.newdawn.j3d.loaders.ac3d.AC3DObject;
import org.newdawn.j3d.loaders.ac3d.DefaultNodeFactory;
import org.newdawn.j3d.loaders.ac3d.NodeFactory;
import org.newdawn.j3d.loaders.ac3d.tree.ShapeTree;
import org.newdawn.loaders.InvalidDataException;
import org.newdawn.loaders.resourcepools.ResourceLoadFailedException;

public class AC3DModel {
    private String texturePath;
    private org.newdawn.loaders.ac3d.AC3DModel model;
    private AC3DMaterial[] materials;
    private ArrayList objects = new ArrayList();

    public AC3DModel(org.newdawn.loaders.ac3d.AC3DModel theModel, String texturePath) throws InvalidDataException, ResourceLoadFailedException {
        this.texturePath = texturePath;
        this.model = theModel;
        long startTime = System.currentTimeMillis();
        org.newdawn.loaders.ac3d.AC3DMaterial[] realMaterials = new org.newdawn.loaders.ac3d.AC3DMaterial[]{};
        realMaterials = this.model.getMaterials().toArray(realMaterials);
        this.materials = new AC3DMaterial[realMaterials.length];
        for (int i = 0; i < realMaterials.length; ++i) {
            org.newdawn.loaders.ac3d.AC3DMaterial realMaterial = realMaterials[i];
            this.materials[realMaterial.getIndex()] = new AC3DMaterial(realMaterial);
        }
        Iterator objIt = this.model.getObjects().iterator();
        int objCount = 0;
        while (objIt.hasNext()) {
            this.objects.add(new AC3DObject((org.newdawn.loaders.ac3d.AC3DObject)objIt.next(), this));
            ++objCount;
        }
    }

    public String getTexturePath() {
        return this.texturePath;
    }

    public BranchGroup createInstance() throws ResourceLoadFailedException {
        return this.createInstance(null, false);
    }

    public BranchGroup createInstance(boolean optimise) throws ResourceLoadFailedException {
        return this.createInstance(null, optimise);
    }

    public BranchGroup createInstance(NodeFactory factory) throws ResourceLoadFailedException {
        return this.createInstance(factory, false);
    }

    public BranchGroup createInstance(NodeFactory nodeFactory, boolean optimise) throws ResourceLoadFailedException {
        BranchGroup modelGroup = new BranchGroup();
        ShapeTree tree = new ShapeTree();
        Iterator objIt = this.objects.iterator();
        long startTime = System.currentTimeMillis();
        if (nodeFactory == null) {
            nodeFactory = new DefaultNodeFactory();
        }
        if (optimise) {
            while (objIt.hasNext()) {
                ((AC3DObject)objIt.next()).addSurfacesToTree(tree, true);
            }
        } else {
            while (objIt.hasNext()) {
                ((AC3DObject)objIt.next()).addShapeTreeToTree(tree);
            }
        }
        long shapeReadStartTime = System.currentTimeMillis();
        Iterator shapeIt = tree.getShapes(this.materials, nodeFactory).iterator();
        int shapeCount = 0;
        while (shapeIt.hasNext()) {
            modelGroup.addChild((Node)((Shape3D)shapeIt.next()));
            ++shapeCount;
        }
        return modelGroup;
    }
}

