/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import java.util.HashMap;
import javax.media.j3d.Transform3D;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.Motion;
import jp.sourceforge.acerola3d.a3.bvh.BVH;

public class Marionette
implements Motion {
    String rootBone;
    HashMap<String, BoneData> boneHash = new HashMap();
    HashMap<String, Transform3D> transHash = new HashMap();

    public Marionette() {
    }

    public Marionette(Motion m, double t) {
        String rootBone = m.getRootBone();
        this.setRootBone(rootBone);
        this.copyData(m, t, rootBone);
    }

    void copyData(Motion m, double t, String bone) {
        this.setTransform3D(bone, m.getTransform3D(bone, t));
        String[] children = m.getChildBones(bone);
        this.setChildBones(bone, children);
        for (String b : children) {
            this.copyData(m, t, b);
        }
    }

    public void setBVHDefaultPose(BVH bvh) {
        this.boneHash.clear();
        this.transHash.clear();
        String rootBone = bvh.getRootBone();
        this.setRootBone(rootBone);
        this.copyBVHDefaultPoseData(bvh, rootBone);
    }

    void copyBVHDefaultPoseData(BVH bvh, String bone) {
        Vector3d v = bvh.getOffset(bone);
        Transform3D t = new Transform3D();
        t.set(v);
        this.setTransform3D(bone, t);
        String[] children = bvh.getChildBones(bone);
        this.setChildBones(bone, children);
        for (String b : children) {
            this.copyBVHDefaultPoseData(bvh, b);
        }
    }

    @Override
    public double getMotionLength() {
        return -1.0;
    }

    @Override
    public double getDefaultFrameTime() {
        return 0.0333;
    }

    @Override
    public String getRootBone() {
        return this.rootBone;
    }

    @Override
    public String getParentBone(String b) {
        return this.boneHash.get((Object)b).parent;
    }

    @Override
    public String[] getChildBones(String boneName) {
        return (String[])this.boneHash.get((Object)boneName).children.clone();
    }

    @Override
    public String[] getAllBones() {
        return this.boneHash.keySet().toArray(new String[0]);
    }

    @Override
    public Transform3D getTransform3D(String bone, double time) {
        return new Transform3D(this.transHash.get(bone));
    }

    public void setRootBone(String rootBone) {
        this.rootBone = rootBone;
    }

    public void setChildBones(String parent, String[] children) {
        BoneData bd = new BoneData(parent, children);
        this.boneHash.put(parent, bd);
    }

    public void setTransform3D(String bone, Transform3D trans) {
        this.transHash.put(bone, trans);
    }

    class BoneData {
        String parent = null;
        String[] children = null;

        BoneData(String p, String[] c) {
            this.parent = p;
            this.children = (String[])c.clone();
        }
    }
}

