/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nwn.viewer;

import com.sun.j3d.utils.behaviors.vp.OrbitBehavior;
import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.universe.PlatformGeometry;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.Font;
import javax.media.j3d.Alpha;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Text3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class Display
extends Canvas3D {
    private SimpleUniverse simpleUniverse;
    private float distance = 5.0f;
    private DirectionalLight directionalLight1;
    private DirectionalLight directionalLight2;
    private AmbientLight ambientLight;
    private BranchGroup scene;
    private BranchGroup loadingText;
    private BranchGroup modelGroup;
    private long start = System.currentTimeMillis();
    private int frames = 0;
    private int lastFrame = -1;
    private long fpsThreshold = 256L;

    public Display() {
        super(SimpleUniverse.getPreferredConfiguration());
        this.simpleUniverse = new SimpleUniverse((Canvas3D)this);
        ViewingPlatform viewingPlatform = this.simpleUniverse.getViewingPlatform();
        PlatformGeometry platformGeometry = new PlatformGeometry();
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        Color3f color3f = new Color3f(0.1f, 0.1f, 0.1f);
        Color3f color3f2 = new Color3f(0.3f, 0.3f, 0.3f);
        Background background = new Background(color3f2);
        background.setApplicationBounds((Bounds)boundingSphere);
        this.ambientLight = new AmbientLight(color3f);
        this.ambientLight.setInfluencingBounds((Bounds)boundingSphere);
        this.ambientLight.setCapability(14);
        this.ambientLight.setCapability(15);
        platformGeometry.addChild((Node)this.ambientLight);
        Color3f color3f3 = new Color3f(1.0f, 1.0f, 1.0f);
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, -1.0f);
        Color3f color3f4 = new Color3f(0.1f, 0.1f, 0.1f);
        Vector3f vector3f2 = new Vector3f(-1.0f, -1.0f, -1.0f);
        this.directionalLight1 = new DirectionalLight(color3f3, vector3f);
        this.directionalLight1.setInfluencingBounds((Bounds)boundingSphere);
        this.directionalLight1.setCapability(14);
        this.directionalLight1.setCapability(15);
        this.directionalLight1.setCapability(18);
        this.directionalLight1.setCapability(19);
        platformGeometry.addChild((Node)this.directionalLight1);
        this.directionalLight2 = new DirectionalLight(color3f4, vector3f2);
        this.directionalLight2.setInfluencingBounds((Bounds)boundingSphere);
        this.directionalLight2.setCapability(14);
        this.directionalLight2.setCapability(15);
        this.directionalLight2.setCapability(18);
        this.directionalLight2.setCapability(19);
        platformGeometry.addChild((Node)this.directionalLight2);
        viewingPlatform.setPlatformGeometry(platformGeometry);
        Transform3D transform3D = new Transform3D();
        transform3D.rotX(1.8849555921538759);
        Transform3D transform3D2 = new Transform3D();
        transform3D2.rotY(2.5132741228718345);
        transform3D.mul(transform3D2);
        transform3D.setTranslation(new Vector3f(4.0f, this.distance, 3.0f));
        viewingPlatform.getViewPlatformTransform().setTransform(transform3D);
        OrbitBehavior orbitBehavior = new OrbitBehavior((Canvas3D)this, 112);
        orbitBehavior.setRotationCenter(new Point3d(0.0, 0.0, 0.0));
        orbitBehavior.setSchedulingBounds((Bounds)boundingSphere);
        viewingPlatform.setViewPlatformBehavior((ViewPlatformBehavior)orbitBehavior);
        this.scene = new BranchGroup();
        this.scene.setCapability(14);
        this.scene.setCapability(13);
        this.scene.setCapability(12);
        this.modelGroup = new BranchGroup();
        this.modelGroup.setCapability(14);
        this.modelGroup.setCapability(13);
        this.modelGroup.setCapability(12);
        this.scene.addChild((Node)this.modelGroup);
        this.scene.addChild((Node)background);
        this.simpleUniverse.addBranchGraph(this.scene);
        this.loadingText = this.createLoadingMessage();
    }

    public void postRender() {
        ++this.frames;
        if ((long)this.frames > this.fpsThreshold) {
            long l = System.currentTimeMillis();
            this.lastFrame = (int)((long)this.frames * 1000L / (l - this.start));
            this.start = l;
            System.out.println("Display FPS:" + this.lastFrame);
            this.frames = 0;
        }
    }

    public DirectionalLight getDirectionalLight1() {
        return this.directionalLight1;
    }

    public void setDirectionalLight1(DirectionalLight directionalLight) {
        this.directionalLight1 = directionalLight;
    }

    public DirectionalLight getDirectionalLight2() {
        return this.directionalLight2;
    }

    public void setDirectionalLight2(DirectionalLight directionalLight) {
        this.directionalLight2 = directionalLight;
    }

    public AmbientLight getAmbientLight() {
        return this.ambientLight;
    }

    public void setAmbientLight(AmbientLight ambientLight) {
        this.ambientLight = ambientLight;
    }

    public BranchGroup getScene() {
        return this.scene;
    }

    public void setScene(BranchGroup branchGroup) {
        this.scene = branchGroup;
    }

    public void addLoadingMessage() {
        this.scene.addChild((Node)this.loadingText);
    }

    public void removeLoadingMessage() {
        this.scene.removeChild((Node)this.loadingText);
    }

    public BranchGroup getModelGroup() {
        return this.modelGroup;
    }

    public void destoryEverything() {
        this.simpleUniverse.removeAllLocales();
    }

    private BranchGroup createLoadingMessage() {
        String string = "Loading Model";
        String string2 = "serif";
        float f = 0.1f;
        float f2 = string.length();
        BranchGroup branchGroup = new BranchGroup();
        TransformGroup transformGroup = new TransformGroup();
        Transform3D transform3D = new Transform3D();
        transform3D.rotX(1.5707963267948966);
        transform3D.setScale((double)(2.0f / f2));
        transformGroup.setTransform(transform3D);
        branchGroup.addChild((Node)transformGroup);
        TransformGroup transformGroup2 = new TransformGroup();
        transformGroup2.setCapability(18);
        transformGroup2.setCapability(17);
        transformGroup.addChild((Node)transformGroup2);
        Font3D font3D = new Font3D(new Font(string2, 0, 2), (double)f, new FontExtrusion());
        Text3D text3D = new Text3D(font3D, string, new Point3f(-f2 / 2.0f, -1.0f, -1.0f));
        Shape3D shape3D = new Shape3D();
        Appearance appearance = new Appearance();
        Material material = new Material();
        material.setLightingEnable(true);
        appearance.setMaterial(material);
        shape3D.setGeometry((Geometry)text3D);
        shape3D.setAppearance(appearance);
        transformGroup2.addChild((Node)shape3D);
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        Transform3D transform3D2 = new Transform3D();
        Alpha alpha = new Alpha(-1, 1, 0L, 0L, 4000L, 0L, 0L, 0L, 0L, 0L);
        RotationInterpolator rotationInterpolator = new RotationInterpolator(alpha, transformGroup2, transform3D2, 0.0f, (float)Math.PI * -2);
        rotationInterpolator.setSchedulingBounds((Bounds)boundingSphere);
        transformGroup2.addChild((Node)rotationInterpolator);
        branchGroup.setCapability(17);
        branchGroup.compile();
        return branchGroup;
    }
}

