/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.util.Vector;
import org.sablecc.sablecc.IntSet;
import org.sablecc.sablecc.Symbol;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
final class SymbolSet
implements Cloneable {
    private final IntSet terminals;
    private final IntSet nonterminals;
    private boolean empty;
    private boolean modified;
    private Symbol[] symbols;

    private final void computeArray() {
        Vector<Symbol> vector = new Vector<Symbol>(0);
        int[] nArray = this.terminals.elements();
        int n = 0;
        while (n < nArray.length) {
            vector.addElement(Symbol.symbol(nArray[n], true));
            ++n;
        }
        nArray = this.nonterminals.elements();
        n = 0;
        while (n < nArray.length) {
            vector.addElement(Symbol.symbol(nArray[n], false));
            ++n;
        }
        this.symbols = new Symbol[vector.size()];
        vector.copyInto(this.symbols);
        this.modified = false;
    }

    final void setTerminal(int n) {
        this.terminals.set(n);
        this.modified = true;
    }

    final void clearTerminal(int n) {
        this.terminals.clear(n);
        this.modified = true;
    }

    final boolean getTerminal(int n) {
        return this.terminals.get(n);
    }

    final void setNonterminal(int n) {
        this.nonterminals.set(n);
        this.modified = true;
    }

    final void clearNonterminal(int n) {
        this.nonterminals.clear(n);
        this.modified = true;
    }

    final boolean getNonterminal(int n) {
        return this.nonterminals.get(n);
    }

    final void setEmpty() {
        this.empty = true;
        this.modified = true;
    }

    final void clearEmpty() {
        this.empty = false;
        this.modified = true;
    }

    final boolean getEmpty() {
        return this.empty;
    }

    final void and(SymbolSet symbolSet) {
        this.terminals.and(symbolSet.terminals);
        this.nonterminals.and(symbolSet.nonterminals);
        this.empty &= symbolSet.empty;
        this.modified = true;
    }

    final void or(SymbolSet symbolSet) {
        this.terminals.or(symbolSet.terminals);
        this.nonterminals.or(symbolSet.nonterminals);
        this.empty |= symbolSet.empty;
        this.modified = true;
    }

    final void xor(SymbolSet symbolSet) {
        this.terminals.xor(symbolSet.terminals);
        this.nonterminals.xor(symbolSet.nonterminals);
        this.empty ^= symbolSet.empty;
        this.modified = true;
    }

    public final int hashCode() {
        return this.terminals.hashCode() + this.nonterminals.hashCode() + new Boolean(this.empty).hashCode();
    }

    public final boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        SymbolSet symbolSet = (SymbolSet)object;
        boolean bl = false;
        if (this.terminals.equals(symbolSet.terminals) && this.nonterminals.equals(symbolSet.nonterminals) && this.empty == symbolSet.empty) {
            bl = true;
        }
        return bl;
    }

    final Symbol[] getSymbols() {
        if (this.modified) {
            this.computeArray();
        }
        return this.symbols;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        Symbol[] symbolArray = this.getSymbols();
        boolean bl = false;
        int n = 0;
        while (n < symbolArray.length) {
            if (bl) {
                stringBuffer.append(",");
            } else {
                bl = true;
            }
            stringBuffer.append(symbolArray[n]);
            ++n;
        }
        if (this.empty) {
            if (bl) {
                stringBuffer.append(",");
            } else {
                bl = true;
            }
            stringBuffer.append("*empty*");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public final Object clone() {
        return new SymbolSet(this);
    }

    private final /* synthetic */ void this() {
        this.modified = true;
    }

    SymbolSet() {
        this.this();
        this.terminals = new IntSet();
        this.nonterminals = new IntSet();
    }

    private SymbolSet(SymbolSet symbolSet) {
        this.this();
        this.terminals = (IntSet)symbolSet.terminals.clone();
        this.nonterminals = (IntSet)symbolSet.nonterminals.clone();
        this.empty = symbolSet.empty;
    }
}

