/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.media.j3d.BadTransformException;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.media.j3d.WakeupOnElapsedTime;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.A3BranchGroup;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.A3Sounds;
import jp.sourceforge.acerola3d.a3.A3VirtualUniverse;
import jp.sourceforge.acerola3d.a3.Action3D;
import jp.sourceforge.acerola3d.a3.Selected3D;
import jp.sourceforge.acerola3d.a3.Util;

class A3Behavior
extends Behavior {
    static long elapsedTime = 33L;
    static Node selected3d_egg = new Selected3D();
    A3Object a3 = null;
    A3BranchGroup topGroup;
    TransformGroup transGroup;
    Transform3D t;
    Transform3D tt;
    A3VirtualUniverse universe = null;
    boolean isInterpolate = false;
    boolean autoDirectionControl = false;
    boolean billboardControl = false;
    Vector3d nowS = new Vector3d(1.0, 1.0, 1.0);
    Vector3d nextS = new Vector3d(1.0, 1.0, 1.0);
    Quat4d nowQ = new Quat4d(0.0, 0.0, 0.0, 1.0);
    Quat4d nextQ = new Quat4d(0.0, 0.0, 0.0, 1.0);
    Vector3d nowV = new Vector3d();
    Vector3d nextV = new Vector3d();
    boolean needRecalc = true;
    Vector3d nowTrans = new Vector3d();
    BranchGroup selected3d_bg = null;
    TransformGroup selected3d_tg = null;
    double interpolateRatio = 0.1;
    boolean isVisible = true;
    ArrayList<Runnable> runnableQueue = null;
    Vector3d tmpV = new Vector3d();
    Quat4d actualQ = new Quat4d();
    static Quat4d fixQ = new Quat4d(1.0 * Math.sin(0.7853981633974483), 0.0, 0.0, Math.cos(0.7853981633974483));

    A3Behavior(A3Object a) {
        this.a3 = a;
        this.topGroup = new A3BranchGroup();
        this.topGroup.setCapability(13);
        this.topGroup.setCapability(14);
        this.topGroup.setA3(this.a3);
        this.t = new Transform3D();
        this.tt = new Transform3D();
        this.transGroup = new TransformGroup(this.t);
        this.transGroup.setCapability(18);
        this.transGroup.addChild((Node)this);
        this.topGroup.addChild((Node)this.transGroup);
        this.runnableQueue = new ArrayList();
    }

    void setA3VirtualUniverse(A3VirtualUniverse u) {
        this.universe = u;
    }

    void setNode(Node n) {
        this.transGroup.addChild(n);
    }

    boolean isZ() {
        if (this.universe != null) {
            return this.universe.scene.upperDirection == A3Object.UpperDirection.Z;
        }
        return false;
    }

    void setNow() {
        if (this.isZ()) {
            this.actualQ.mul(this.nowQ, fixQ);
        } else {
            this.actualQ.set((Tuple4d)this.nowQ);
        }
        if (this.isVisible) {
            this.tt.setScale(this.nowS);
        } else {
            this.tt.setScale(0.0);
        }
        this.t.set(this.actualQ, this.nowV, 1.0);
        this.t.mul(this.tt);
        try {
            this.transGroup.setTransform(this.t);
        }
        catch (BadTransformException e) {
            System.out.println("BadTransformException in A3Behavior.setNow().");
        }
        if (this.a3 instanceof Action3D) {
            ((Action3D)this.a3).setSoundLocQuat(this.nowV, this.actualQ);
        } else if (this.a3 instanceof A3Sounds) {
            ((A3Sounds)this.a3).setSoundLocQuat(this.nowV, this.actualQ);
        }
    }

    void init() {
        this.setNow();
    }

    public void initialize() {
        WakeupOnElapsedTime w = new WakeupOnElapsedTime(elapsedTime);
        this.wakeupOn((WakeupCondition)w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStimulus(Enumeration criteria) {
        WakeupOnElapsedTime w;
        long et;
        if (this.universe == null) {
            et = elapsedTime;
            w = new WakeupOnElapsedTime(elapsedTime);
            this.wakeupOn((WakeupCondition)w);
        } else {
            et = this.universe.elapsedTime;
            w = null;
            w = new WakeupOnBehaviorPost((Behavior)this.universe.getTimerBehavior(), 1);
            this.wakeupOn((WakeupCondition)w);
        }
        ArrayList runnableCopy = null;
        ArrayList<Runnable> arrayList = this.runnableQueue;
        synchronized (arrayList) {
            runnableCopy = (ArrayList)this.runnableQueue.clone();
            this.runnableQueue.clear();
        }
        for (Runnable r : runnableCopy) {
            r.run();
        }
        if (!this.needRecalc) {
            return;
        }
        double ratio = 1.0 - Math.pow(this.interpolateRatio, (double)et / 1000.0);
        this.nowTrans.sub((Tuple3d)this.nextV, (Tuple3d)this.nowV);
        this.nowTrans.scale(ratio);
        this.nowV.add((Tuple3d)this.nowTrans);
        if (this.autoDirectionControl) {
            this.autoQuatControl();
        } else if (this.billboardControl) {
            this.billboardControl();
        } else {
            this.nowQ.normalize();
            this.nowQ.interpolate(this.nextQ, ratio);
            this.nowQ.normalize();
        }
        this.tmpV.sub((Tuple3d)this.nextS, (Tuple3d)this.nowS);
        this.tmpV.scale(ratio);
        this.nowS.add((Tuple3d)this.tmpV);
        this.setNow();
        if (!this.isInterpolate) {
            this.needRecalc = false;
        }
    }

    void autoQuatControl() {
        Vector3d front = new Vector3d();
        front.sub((Tuple3d)this.nextV, (Tuple3d)this.nowV);
        if (front.length() > this.universe.scene.cameraNowS / 1000.0) {
            Vector3d up = new Vector3d(this.a3.upperVector);
            if (this.isZ()) {
                this.nowQ.set((Tuple4d)Util.frontFacingQuat_A3Z(front, up));
            } else {
                this.nowQ.set((Tuple4d)Util.frontFacingQuat_A3Y(front, up));
            }
        }
    }

    void billboardControl() {
        Vector3d front = new Vector3d();
        front.sub((Tuple3d)this.universe.scene.cameraNowV, (Tuple3d)this.nowV);
        if (front.length() > this.universe.scene.cameraNowS / 1000.0) {
            Vector3d up = new Vector3d(this.a3.upperVector);
            if (this.isZ()) {
                this.nowQ.set((Tuple4d)Util.frontFacingQuat_A3Z(front, up));
            } else {
                this.nowQ.set((Tuple4d)Util.frontFacingQuat_A3Y(front, up));
            }
        }
    }

    void setEnableBehavior(boolean b) {
        this.isInterpolate = b;
    }

    void setInterpolateRatio(double ir) {
        this.interpolateRatio = ir;
    }

    void setAutoDirectionControl(boolean b) {
        this.autoDirectionControl = b;
        if (this.autoDirectionControl && this.billboardControl) {
            this.billboardControl = false;
        }
    }

    void setBillboardControl(boolean b) {
        this.billboardControl = b;
        if (this.billboardControl && this.autoDirectionControl) {
            this.autoDirectionControl = false;
        }
    }

    void setTransformImmediately(Transform3D t) {
        t.getScale(this.nowS);
        t.get(this.nowV);
        t.get(this.nowQ);
        this.nextS.set((Tuple3d)this.nowS);
        this.nextV.set((Tuple3d)this.nowV);
        this.nextQ.set((Tuple4d)this.nowQ);
        this.needRecalc = true;
    }

    void move(Vector3d v, Quat4d q, double s) {
        if (this.isInterpolate) {
            this.nextS.set(s, s, s);
            this.nextV.set((Tuple3d)v);
            this.nextQ.set((Tuple4d)q);
            this.nextQ.normalize();
        } else {
            this.nowS.set(s, s, s);
            this.nowV.set((Tuple3d)v);
            this.nowQ.set((Tuple4d)q);
            this.nextS.set(s, s, s);
            this.nextV.set((Tuple3d)v);
            this.nextQ.set((Tuple4d)q);
        }
        this.needRecalc = true;
    }

    void moveImmediately(Vector3d v, Quat4d q, double s) {
        this.nowS.set(s, s, s);
        this.nowV.set((Tuple3d)v);
        this.nowQ.set((Tuple4d)q);
        this.nextS.set(s, s, s);
        this.nextV.set((Tuple3d)v);
        this.nextQ.set((Tuple4d)q);
        this.needRecalc = true;
    }

    void setLoc(Vector3d v) {
        if (this.isInterpolate) {
            this.nextV.set((Tuple3d)v);
        } else {
            this.nowV.set((Tuple3d)v);
            this.nextV.set((Tuple3d)v);
        }
        this.needRecalc = true;
    }

    void setLocImmediately(Vector3d v) {
        this.nowV.set((Tuple3d)v);
        this.nextV.set((Tuple3d)v);
        this.needRecalc = true;
    }

    void addLoc(Vector3d v) {
        if (this.isInterpolate) {
            this.nextV.add((Tuple3d)v);
        } else {
            this.nextV.add((Tuple3d)v);
            this.nowV.set((Tuple3d)this.nextV);
        }
        this.needRecalc = true;
    }

    void addLocImmediately(Vector3d v) {
        this.nextV.add((Tuple3d)v);
        this.nowV.set((Tuple3d)this.nextV);
        this.needRecalc = true;
    }

    Vector3d getLoc() {
        return new Vector3d(this.nowV);
    }

    Vector3d getTargetLoc() {
        return new Vector3d(this.nextV);
    }

    void setQuat(Quat4d q) {
        if (this.isInterpolate) {
            this.nextQ.set((Tuple4d)q);
        } else {
            this.nowQ.set((Tuple4d)q);
            this.nextQ.set((Tuple4d)q);
        }
        this.needRecalc = true;
    }

    void setQuatImmediately(Quat4d q) {
        this.nowQ.set((Tuple4d)q);
        this.nextQ.set((Tuple4d)q);
        this.needRecalc = true;
    }

    void mulQuat(Quat4d q) {
        if (this.isInterpolate) {
            this.nextQ.mul(q);
        } else {
            this.nextQ.mul(q);
            this.nowQ.set((Tuple4d)this.nextQ);
        }
        this.needRecalc = true;
    }

    void mulQuatImmediately(Quat4d q) {
        this.nextQ.mul(q);
        this.nowQ.set((Tuple4d)this.nextQ);
        this.needRecalc = true;
    }

    Quat4d getQuat() {
        return new Quat4d(this.nowQ);
    }

    Quat4d getTargetQuat() {
        return new Quat4d(this.nextQ);
    }

    void setLookAtPoint(Vector3d lookAt) {
        Vector3d front = new Vector3d();
        front.sub((Tuple3d)lookAt, (Tuple3d)this.nowV);
        Vector3d up = new Vector3d(this.a3.upperVector);
        Quat4d q = null;
        q = this.isZ() ? Util.frontFacingQuat_A3Z(front, up) : Util.frontFacingQuat_A3Y(front, up);
        this.nextQ.set((Tuple4d)q);
        if (!this.isInterpolate) {
            this.nowQ.set((Tuple4d)q);
        }
        this.needRecalc = true;
    }

    void setLookAtPointImmediately(Vector3d lookAt) {
        Vector3d front = new Vector3d();
        front.sub((Tuple3d)lookAt, (Tuple3d)this.nowV);
        Vector3d up = new Vector3d(this.a3.upperVector);
        Quat4d q = null;
        q = this.isZ() ? Util.frontFacingQuat_A3Z(front, up) : Util.frontFacingQuat_A3Y(front, up);
        this.nextQ.set((Tuple4d)q);
        this.nowQ.set((Tuple4d)q);
        this.needRecalc = true;
    }

    void setScale(double s) {
        if (this.isInterpolate) {
            this.nextS.set(s, s, s);
        } else {
            this.nowS.set(s, s, s);
            this.nextS.set(s, s, s);
        }
        this.needRecalc = true;
    }

    void setScaleX(double sx) {
        if (this.isInterpolate) {
            this.nextS.x = sx;
        } else {
            this.nowS.x = sx;
            this.nextS.x = sx;
        }
        this.needRecalc = true;
    }

    void setScaleY(double sy) {
        if (this.isInterpolate) {
            this.nextS.y = sy;
        } else {
            this.nowS.y = sy;
            this.nextS.y = sy;
        }
        this.needRecalc = true;
    }

    void setScaleZ(double sz) {
        if (this.isInterpolate) {
            this.nextS.z = sz;
        } else {
            this.nowS.z = sz;
            this.nextS.z = sz;
        }
        this.needRecalc = true;
    }

    void setScale(Vector3d sv) {
        if (this.isInterpolate) {
            this.nextS.set((Tuple3d)sv);
        } else {
            this.nowS.set((Tuple3d)sv);
            this.nextS.set((Tuple3d)sv);
        }
        this.needRecalc = true;
    }

    void setScaleImmediately(double s) {
        this.nowS.set(s, s, s);
        this.nextS.set(s, s, s);
        this.needRecalc = true;
    }

    void setScaleXImmediately(double sx) {
        this.nowS.x = sx;
        this.nextS.x = sx;
        this.needRecalc = true;
    }

    void setScaleYImmediately(double sy) {
        this.nowS.y = sy;
        this.nextS.y = sy;
        this.needRecalc = true;
    }

    void setScaleZImmediately(double sz) {
        this.nowS.z = sz;
        this.nextS.z = sz;
        this.needRecalc = true;
    }

    void setScaleImmediately(Vector3d sv) {
        this.nowS.set((Tuple3d)sv);
        this.nextS.set((Tuple3d)sv);
        this.needRecalc = true;
    }

    void mulScale(double s) {
        if (this.isInterpolate) {
            this.nextS.scale(s);
        } else {
            this.nextS.scale(s);
            this.nowS.set((Tuple3d)this.nextS);
        }
        this.needRecalc = true;
    }

    void mulScaleX(double sx) {
        if (this.isInterpolate) {
            this.nextS.x *= sx;
        } else {
            this.nextS.x *= sx;
            this.nowS.set((Tuple3d)this.nextS);
        }
        this.needRecalc = true;
    }

    void mulScaleY(double sy) {
        if (this.isInterpolate) {
            this.nextS.y *= sy;
        } else {
            this.nextS.y *= sy;
            this.nowS.set((Tuple3d)this.nextS);
        }
        this.needRecalc = true;
    }

    void mulScaleZ(double sz) {
        if (this.isInterpolate) {
            this.nextS.z *= sz;
        } else {
            this.nextS.z *= sz;
            this.nowS.set((Tuple3d)this.nextS);
        }
        this.needRecalc = true;
    }

    void mulScale(Vector3d sv) {
        if (this.isInterpolate) {
            this.nextS.x *= sv.x;
            this.nextS.y *= sv.y;
            this.nextS.z *= sv.z;
        } else {
            this.nextS.x *= sv.x;
            this.nextS.y *= sv.y;
            this.nextS.z *= sv.z;
            this.nowS.set((Tuple3d)this.nextS);
        }
        this.needRecalc = true;
    }

    void mulScaleImmediately(double s) {
        this.nextS.scale(s);
        this.nowS.set((Tuple3d)this.nextS);
        this.needRecalc = true;
    }

    void mulScaleXImmediately(double sx) {
        this.nextS.x *= sx;
        this.nowS.set((Tuple3d)this.nextS);
        this.needRecalc = true;
    }

    void mulScaleYImmediately(double sy) {
        this.nextS.y *= sy;
        this.nowS.set((Tuple3d)this.nextS);
        this.needRecalc = true;
    }

    void mulScaleZImmediately(double sz) {
        this.nextS.z *= sz;
        this.nowS.set((Tuple3d)this.nextS);
        this.needRecalc = true;
    }

    void mulScaleImmediately(Vector3d sv) {
        this.nextS.x *= sv.x;
        this.nextS.y *= sv.y;
        this.nextS.z *= sv.z;
        this.nowS.set((Tuple3d)this.nextS);
        this.needRecalc = true;
    }

    double getScale() {
        return (this.nowS.x + this.nowS.y + this.nowS.z) / 3.0;
    }

    double getScaleX() {
        return this.nowS.x;
    }

    double getScaleY() {
        return this.nowS.y;
    }

    double getScaleZ() {
        return this.nowS.z;
    }

    Vector3d getScaleV() {
        return new Vector3d(this.nowS);
    }

    double getTargetScale() {
        return (this.nextS.x + this.nextS.y + this.nextS.z) / 3.0;
    }

    double getTargetScaleX() {
        return this.nextS.x;
    }

    double getTargetScaleY() {
        return this.nextS.y;
    }

    double getTargetScaleZ() {
        return this.nextS.z;
    }

    Vector3d getTargetScaleV() {
        return new Vector3d(this.nextS);
    }

    public final void moveForward(double l) {
        Vector3d v = this.getUnitVecZ();
        v.scale(l);
        this.addLoc(v);
    }

    public final void moveForwardImmediately(double l) {
        Vector3d v = this.getUnitVecZ();
        v.scale(l);
        this.addLocImmediately(v);
    }

    public final void moveBackward(double l) {
        Vector3d v = this.getUnitVecZ();
        v.scale(-l);
        this.addLoc(v);
    }

    public final void moveBackwardImmediately(double l) {
        Vector3d v = this.getUnitVecZ();
        v.scale(-l);
        this.addLocImmediately(v);
    }

    public final void moveRight(double l) {
        Vector3d v = this.getUnitVecX();
        v.scale(-l);
        this.addLoc(v);
    }

    public final void moveRightImmediately(double l) {
        Vector3d v = this.getUnitVecX();
        v.scale(-l);
        this.addLocImmediately(v);
    }

    public final void moveLeft(double l) {
        Vector3d v = this.getUnitVecX();
        v.scale(l);
        this.addLoc(v);
    }

    public final void moveLeftImmediately(double l) {
        Vector3d v = this.getUnitVecX();
        v.scale(l);
        this.addLocImmediately(v);
    }

    public final void moveUp(double l) {
        Vector3d v = this.getUnitVecY();
        v.scale(l);
        this.addLoc(v);
    }

    public final void moveUpImmediately(double l) {
        Vector3d v = this.getUnitVecY();
        v.scale(l);
        this.addLocImmediately(v);
    }

    public final void moveDown(double l) {
        Vector3d v = this.getUnitVecY();
        v.scale(-l);
        this.addLoc(v);
    }

    public final void moveDownImmediately(double l) {
        Vector3d v = this.getUnitVecY();
        v.scale(-l);
        this.addLocImmediately(v);
    }

    public final void moveTo(Vector3d v, double l) {
        Vector3d vv = new Vector3d();
        vv.sub((Tuple3d)v, (Tuple3d)this.nowV);
        if (vv.length() != 0.0) {
            vv.normalize();
        }
        vv.scale(l);
        this.addLoc(vv);
    }

    public final void moveTo(double x, double y, double z, double l) {
        Vector3d vv = new Vector3d(x, y, z);
        vv.sub((Tuple3d)this.nowV);
        if (vv.length() != 0.0) {
            vv.normalize();
        }
        vv.scale(l);
        this.addLoc(vv);
    }

    public final void moveToImmediately(Vector3d v, double l) {
        Vector3d vv = new Vector3d();
        vv.sub((Tuple3d)v, (Tuple3d)this.nowV);
        if (vv.length() != 0.0) {
            vv.normalize();
        }
        vv.scale(l);
        this.addLocImmediately(vv);
    }

    public final void moveToImmediately(double x, double y, double z, double l) {
        Vector3d vv = new Vector3d(x, y, z);
        vv.sub((Tuple3d)this.nowV);
        if (vv.length() != 0.0) {
            vv.normalize();
        }
        vv.scale(l);
        this.addLocImmediately(vv);
    }

    Vector3d getUnitVecX() {
        return Util.trans(this.nowQ, new Vector3d(1.0, 0.0, 0.0));
    }

    Vector3d getUnitVecY() {
        return Util.trans(this.nowQ, new Vector3d(0.0, 1.0, 0.0));
    }

    Vector3d getUnitVecZ() {
        return Util.trans(this.nowQ, new Vector3d(0.0, 0.0, 1.0));
    }

    double getSpeed() {
        if (this.isInterpolate) {
            if (this.universe != null) {
                return this.nowTrans.length() / ((double)this.universe.elapsedTime / 1000.0);
            }
            return this.nowTrans.length() / ((double)elapsedTime / 1000.0);
        }
        return 0.0;
    }

    static void setSelected3DMarker(Node n) {
        selected3d_egg = n;
    }

    void setSelected3D(boolean b) {
        if (b && this.selected3d_bg == null) {
            Node n = selected3d_egg.cloneTree();
            n.setPickable(false);
            this.selected3d_tg = new TransformGroup();
            this.selected3d_tg.setCapability(18);
            this.selected3d_tg.addChild(n);
            this.selected3d_bg = new BranchGroup();
            this.selected3d_bg.setCapability(17);
            this.selected3d_bg.addChild((Node)this.selected3d_tg);
            this.adjustSelected3D();
            this.topGroup.addChild((Node)this.selected3d_bg);
        } else if (!b && this.selected3d_bg != null) {
            this.topGroup.removeChild((Node)this.selected3d_bg);
            this.selected3d_bg = null;
            this.selected3d_tg = null;
        }
    }

    void adjustSelected3D() {
        Bounds b = this.transGroup.getBounds();
        if (b instanceof BoundingSphere) {
            BoundingSphere bs = (BoundingSphere)b;
            Point3d p = new Point3d();
            bs.getCenter(p);
            double r = bs.getRadius();
            Transform3D t = new Transform3D();
            this.tmpV.set((Tuple3d)this.nowS);
            this.tmpV.scale(r);
            t.setScale(this.tmpV);
            p.scale(this.getScale());
            Vector3d v = new Vector3d();
            v.add((Tuple3d)this.nowV, (Tuple3d)p);
            t.setTranslation(v);
            this.selected3d_tg.setTransform(t);
        }
    }

    boolean isSelected3D() {
        return this.selected3d_bg != null;
    }

    void setVisible(boolean b) {
        this.isVisible = b;
        this.needRecalc = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRunnable(Runnable r) {
        ArrayList<Runnable> arrayList = this.runnableQueue;
        synchronized (arrayList) {
            this.runnableQueue.add(r);
        }
    }
}

