/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.A3CanvasInterface;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.Component2D;

class A3Label
extends Component2D {
    A3Object a3;
    String label = "none";
    double offsetX;
    double offsetY;
    int width = 0;
    int height = 0;

    A3Label(String s, A3Object a3) {
        this.label = s;
        this.a3 = a3;
    }

    @Override
    public void paint(Graphics2D g, A3CanvasInterface canvas) {
        Vector3d v = this.a3.getLoc();
        if (!this.a3.lockedA3) {
            v = canvas.virtualCSToPhysicalCS(v);
        }
        Vector3d vv = new Vector3d(this.offsetX, this.offsetY, 0.0);
        vv.scale(this.a3.getScale());
        if (!this.a3.lockedA3) {
            vv.scale(1.0 / canvas.getCameraScale());
        }
        Vector3d p3d = new Vector3d(v.x + vv.x, v.y + vv.y, v.z + vv.z);
        Point p = canvas.physicalCSToCanvas(new Point3d((Tuple3d)p3d));
        if (this.width == 0 || this.height == 0) {
            FontMetrics fm = g.getFontMetrics();
            this.width = fm.stringWidth(this.label) + 4;
            this.height = fm.getHeight() + 2;
        }
        g.setColor(Color.WHITE);
        g.drawString(this.label, p.x - this.width / 2, p.y + this.height / 2);
    }

    public void setString(String s) {
        this.label = s;
    }

    public void setOffset(double x, double y) {
        this.offsetX = x;
        this.offsetY = y;
    }

    public void getOffset(double[] ret) {
        ret[0] = this.offsetX;
        ret[1] = this.offsetY;
    }

    @Override
    public void calPhysicalZ(A3CanvasInterface canvas) {
        Vector3d v = canvas.virtualCSToPhysicalCS(this.a3.getLoc());
        this.z = v.z;
    }
}

