/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import java.util.HashMap;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.A3InitData;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.A3UpdateData;
import jp.sourceforge.acerola3d.a3.Action3DData;
import jp.sourceforge.acerola3d.sound.A3Sound;
import jp.sourceforge.acerola3d.sound.A3SoundType;

public class A3Sounds
extends A3Object {
    HashMap<String, A3Sound> a3sounds = new HashMap();

    public A3Sounds() {
        super(new A3InitData("jp.sourceforge.acerola3d.a3.Sounds"));
        this.setNode((Node)new BranchGroup());
    }

    public A3Sounds(A3InitData d) {
        super(d);
        this.setNode((Node)new BranchGroup());
    }

    public void load(String soundName, String soundUrl, String soundType, double gain, boolean loop, Vector3d offset, Vector3d dir) throws Exception {
        A3SoundType type = A3SoundType.PointSound;
        if (soundType.equals("Point")) {
            type = A3SoundType.PointSound;
        } else if (soundType.equals("Background")) {
            type = A3SoundType.BackgroundSound;
        } else if (soundType.equals("Cone")) {
            type = A3SoundType.ConeSound;
        }
        A3Sound s = Action3DData.soundSystem.load(soundUrl, 0.0f, type, (float)gain, loop, offset, dir);
        this.a3sounds.put(soundName, s);
    }

    public void start(String soundName) {
        A3Sound s = this.a3sounds.get(soundName);
        if (s != null) {
            s.start();
        }
    }

    public void stop(String soundName) {
        A3Sound s = this.a3sounds.get(soundName);
        if (s != null) {
            s.stop();
        }
    }

    public void pause(String soundName) {
        A3Sound s = this.a3sounds.get(soundName);
        if (s != null) {
            s.pause();
        }
    }

    public void setSoundDirection(String soundName, Vector3d d) {
        A3Sound s = this.a3sounds.get(soundName);
        if (s != null) {
            s.setDirection(d);
        }
    }

    public void setSoundDirection(String soundName, double x, double y, double z) {
        A3Sound s = this.a3sounds.get(soundName);
        if (s != null) {
            s.setDirection((float)x, (float)y, (float)z);
        }
    }

    public void setSoundOffset(String soundName, Vector3d o) {
        A3Sound s = this.a3sounds.get(soundName);
        if (s != null) {
            s.setOffset(o);
        }
    }

    public void setSoundOffset(String soundName, double x, double y, double z) {
        A3Sound s = this.a3sounds.get(soundName);
        if (s != null) {
            s.setOffset((float)x, (float)y, (float)z);
        }
    }

    @Override
    public void update(A3UpdateData d) {
        super.update(d);
        System.out.println("Sounds.update(). not implemented yet!");
    }

    void setSoundLocQuat(Vector3d v, Quat4d q) {
        for (A3Sound s : this.a3sounds.values()) {
            s.setLoc(v);
            s.setQuat(q);
        }
    }

    void setSoundTypeLocked() {
        for (A3Sound s : this.a3sounds.values()) {
            s.setType(A3SoundType.BackgroundSound);
        }
    }
}

