/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MQResourceBundle
extends ResourceBundle {
    public static final String NL = System.getProperty("line.separator", "\n");
    private ResourceBundle rb = null;
    private boolean convertEOL = false;
    private static String UnixEOL = "\n";
    private HashMap cache = null;
    private static boolean DEBUG = false;

    public MQResourceBundle(ResourceBundle resourceBundle) {
        this.rb = resourceBundle;
        String string = System.getProperty("line.separator");
        if (!string.equals(UnixEOL)) {
            this.convertEOL = true;
            this.cache = new HashMap();
            if (DEBUG) {
                System.out.println(this.getClass().getName() + ": Will convert messages to use native EOL.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handleGetObject(String string) {
        if (this.convertEOL) {
            Object object = null;
            HashMap hashMap = this.cache;
            synchronized (hashMap) {
                object = this.cache.get(string);
                if (object == null && (object = this.rb.getObject(string)) instanceof String) {
                    object = MQResourceBundle.unix2native((String)object);
                    this.cache.put(string, object);
                }
            }
            return object;
        }
        return this.rb.getObject(string);
    }

    public String getString(String string, Object object) throws MissingResourceException {
        if (object instanceof Object[]) {
            return MessageFormat.format(this.getString(string), (Object[])object);
        }
        Object[] objectArray = new Object[]{object};
        return MessageFormat.format(this.getString(string), objectArray);
    }

    public String getString(String string, Object object, Object object2) throws MissingResourceException {
        Object[] objectArray = new Object[]{object, object2};
        return MessageFormat.format(this.getString(string), objectArray);
    }

    public String getString(String string, Object[] objectArray) throws MissingResourceException {
        return MessageFormat.format(this.getString(string), objectArray);
    }

    public String getKString(String string) throws MissingResourceException {
        return "[" + string + "]: " + this.getString(string);
    }

    public String getKString(String string, Object object) throws MissingResourceException {
        return "[" + string + "]: " + this.getString(string, object);
    }

    public String getKString(String string, Object object, Object object2) throws MissingResourceException {
        return "[" + string + "]: " + this.getString(string, object, object2);
    }

    public String getKString(String string, Object[] objectArray) throws MissingResourceException {
        return "[" + string + "]: " + this.getString(string, objectArray);
    }

    public char getChar(String string) throws MissingResourceException {
        char c;
        String string2 = this.getString(string);
        try {
            c = string2.charAt(0);
        }
        catch (Exception exception) {
            c = '\u0000';
        }
        return c;
    }

    public String getCString(String string) throws MissingResourceException {
        return this.getString(string) + ":";
    }

    public static String unix2native(String string) {
        boolean bl = false;
        StringBuffer stringBuffer = null;
        String string2 = System.getProperty("line.separator");
        int n = 0;
        if (string == null) {
            return "<null>";
        }
        if (string2.equals("\n")) {
            return string;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\n') continue;
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(2 * string.length());
            }
            stringBuffer.append(string.substring(n, i));
            stringBuffer.append(string2);
            n = i + 1;
        }
        if (stringBuffer != null) {
            if (n < string.length()) {
                stringBuffer.append(string.substring(n, string.length()));
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName() + ": convertEOL=" + this.convertEOL);
        if (this.convertEOL && this.cache != null) {
            stringBuffer.append(" cache=" + this.cache.toString());
            stringBuffer.append("\n");
        }
        stringBuffer.append(" resourceBundle=" + this.rb.toString());
        return stringBuffer.toString();
    }

    public Enumeration getKeys() {
        return this.rb.getKeys();
    }

    public Locale getLocale() {
        return this.rb.getLocale();
    }
}

