/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import com.sun.messaging.jmq.io.Packet;
import java.util.ArrayList;

public class PacketPool {
    ArrayList pool = null;
    static final int INITIALSIZE = 128;
    int capacity = 128;
    int size = 0;
    int hits = 0;
    int misses = 0;
    int drops = 0;
    int adds = 0;
    boolean resetPacket = false;
    boolean dontTimestampPacket = false;

    public PacketPool() {
        this.pool = new ArrayList(128);
    }

    public PacketPool(int n) {
        this.capacity = n;
        this.pool = new ArrayList(128);
    }

    public PacketPool(int n, boolean bl, boolean bl2) {
        this.capacity = n;
        this.pool = new ArrayList(128);
        this.dontTimestampPacket = bl2;
        this.resetPacket = bl;
    }

    public void setCapacity(int n) {
        this.capacity = n;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public synchronized Packet get() {
        if (this.size > 0) {
            --this.size;
            ++this.hits;
            return (Packet)this.pool.remove(this.pool.size() - 1);
        }
        ++this.misses;
        Packet packet = new Packet();
        if (this.dontTimestampPacket) {
            packet.generateSequenceNumber(false);
            packet.generateTimestamp(false);
        }
        return packet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Packet packet) {
        if (packet == null) {
            return;
        }
        if (this.resetPacket) {
            packet.reset();
        }
        PacketPool packetPool = this;
        synchronized (packetPool) {
            if (this.size < this.capacity) {
                ++this.size;
                this.pool.add(packet);
                ++this.adds;
            } else {
                ++this.drops;
            }
        }
    }

    public synchronized void clear() {
        this.pool = null;
        this.size = 0;
        this.pool = new ArrayList(128);
    }

    public String toString() {
        return super.toString() + ": capacity=" + this.capacity + ", size=" + this.size;
    }

    public String toDiagString() {
        return this.toString() + ", hits=" + this.hits + ", misses=" + this.misses + ", adds=" + this.adds + ", drops=" + this.drops;
    }
}

