/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import com.sun.messaging.jmq.io.VRFile;
import com.sun.messaging.jmq.io.VRFileWarning;
import com.sun.messaging.jmq.io.VRecord;
import com.sun.messaging.jmq.io.VRecordMap;
import com.sun.messaging.jmq.resources.SharedResources;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.StreamCorruptedException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;

public class VRFileMap
extends VRFile {
    static final int EIGHT_K = 8192;
    private static boolean DEBUG = Boolean.getBoolean("vrfile.debug");
    protected ArrayList mappedBuffers = new ArrayList(1);
    protected MappedByteBuffer mbuffer = null;
    protected ArrayList startsAt = new ArrayList(1);

    public VRFileMap(File file) {
        this(file, 0xA00000L);
    }

    public VRFileMap(String string) {
        this(new File(string), 0xA00000L);
    }

    public VRFileMap(String string, long l) {
        this(new File(string), l);
    }

    public VRFileMap(File file, long l) {
        super(file, l);
    }

    public synchronized void open() throws IOException, VRFileWarning {
        this.open(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void open(boolean bl) throws IOException, VRFileWarning {
        if (this.opened) {
            return;
        }
        RandomAccessFile randomAccessFile = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        try {
            randomAccessFile = new RandomAccessFile(this.backingFile, "rw");
            abstractInterruptibleChannel = randomAccessFile.getChannel();
            long l = randomAccessFile.length();
            if (l == 0L) {
                if (!bl) return;
                this.initNewFile(randomAccessFile, (FileChannel)abstractInterruptibleChannel);
            } else {
                this.loadFile(randomAccessFile, (FileChannel)abstractInterruptibleChannel);
            }
            this.opened = true;
            this.doForce();
            if (DEBUG) {
                System.out.println("file version=" + this.fileversion);
                System.out.println("number of allocated buffer loaded " + this.allocated.size());
                System.out.println("number of free buffer loaded " + this.numFree);
                System.out.println("safe=" + this.safe);
                this.printMappedBuffers();
            }
            if (this.warning == null) return;
            throw this.warning;
        }
        finally {
            if (abstractInterruptibleChannel != null) {
                abstractInterruptibleChannel.close();
            }
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
    }

    public synchronized void close() {
        if (!this.opened) {
            return;
        }
        if (DEBUG) {
            System.out.println(this.backingFile + ": closing...");
            System.out.println("filePointer = " + this.filePointer);
            System.out.println("number of allocated buffers =" + this.allocated.size());
            System.out.println("number of free buffers = " + this.numFree);
            this.printMappedBuffers();
        }
        this.force();
        this.mappedBuffers.clear();
        this.startsAt.clear();
        this.mbuffer = null;
        this.reset();
    }

    public synchronized int[] getMap() throws IOException {
        if (!this.opened) {
            try {
                this.open(false);
            }
            catch (VRFileWarning vRFileWarning) {
                // empty catch block
            }
        }
        if (this.mappedBuffers.size() == 0) {
            return new int[0];
        }
        int[] nArray = new int[this.allocated.size() + this.numFree];
        boolean bl = false;
        for (int i = 0; i < this.mappedBuffers.size(); ++i) {
            MappedByteBuffer mappedByteBuffer = (MappedByteBuffer)this.mappedBuffers.get(i);
            int n = mappedByteBuffer.position();
            int n2 = 0;
            n2 = (Integer)this.startsAt.get(i);
            mappedByteBuffer.position(n2);
            int n3 = 0;
            while (!bl && mappedByteBuffer.hasRemaining()) {
                try {
                    int n4 = mappedByteBuffer.getInt();
                    int n5 = mappedByteBuffer.getInt();
                    int n6 = this.adjustRecordState(this.fileversion, mappedByteBuffer.getShort());
                    if (n2 + n5 > mappedByteBuffer.remaining()) {
                        n6 = -1;
                    }
                    switch (n6) {
                        case -1: {
                            bl = true;
                            break;
                        }
                        case 2: 
                        case 4: {
                            nArray[n3++] = n5;
                            mappedByteBuffer.position(n2 + n5);
                            break;
                        }
                        case 1: {
                            nArray[n3++] = 0 - n5;
                            mappedByteBuffer.position(n2 + n5);
                            break;
                        }
                        case 1001: {
                            bl = true;
                            break;
                        }
                    }
                    n2 += n5;
                }
                catch (BufferUnderflowException bufferUnderflowException) {
                    bufferUnderflowException.printStackTrace();
                }
            }
            mappedByteBuffer.position(n);
        }
        return nArray;
    }

    public synchronized VRecord allocate(int n) throws IOException {
        VRecord vRecord;
        this.checkOpenAndWrite();
        int n2 = (n + 12 + this.blockSize - 1) / this.blockSize * this.blockSize;
        if (DEBUG) {
            System.out.println("allocating " + n2);
        }
        if ((vRecord = this.findFreeRecord(n2)) != null) {
            vRecord.allocate((short)2);
            if (this.safe) {
                vRecord.force();
            }
            --this.numFree;
            ++this.hits;
            if (DEBUG) {
                System.out.println("allocate(): hit, requested " + n + ", allocated " + vRecord.getCapacity());
            }
        } else {
            if (this.numFree > 0) {
                ++this.misses;
            }
            if (this.mbuffer.remaining() < n2) {
                this.growfile(n2 + 12);
            }
            vRecord = this.getNewSlice(n2);
        }
        this.allocated.add(vRecord);
        this.bytesAllocated += (long)vRecord.getCapacity();
        return vRecord;
    }

    public synchronized void force() {
        this.checkOpen();
        int n = this.mappedBuffers.size();
        for (int i = 0; i < n; ++i) {
            MappedByteBuffer mappedByteBuffer = (MappedByteBuffer)this.mappedBuffers.get(i);
            mappedByteBuffer.force();
        }
    }

    public synchronized void clear(boolean bl) throws IOException {
        if (this.opened) {
            MappedByteBuffer mappedByteBuffer = (MappedByteBuffer)this.mappedBuffers.get(0);
            mappedByteBuffer.position(0);
            this.writeFileHeader(mappedByteBuffer);
            mappedByteBuffer.put(this.lastRecordHeader);
            mappedByteBuffer.force();
            this.mappedBuffers.clear();
            this.allocated.clear();
            this.freeMap.clear();
            mappedByteBuffer.clear();
            if (this.fileSize > (long)mappedByteBuffer.capacity()) {
                this.fileSize = mappedByteBuffer.capacity();
                RandomAccessFile randomAccessFile = new RandomAccessFile(this.backingFile, "rw");
                randomAccessFile.setLength(this.fileSize);
            }
            mappedByteBuffer.position(24);
            mappedByteBuffer.limit(mappedByteBuffer.capacity());
            this.filePointer = 24L;
            this.mappedBuffers.add(mappedByteBuffer);
            this.mbuffer = mappedByteBuffer;
            this.force();
        } else if (this.backingFile.exists()) {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.backingFile, "rw");
            randomAccessFile.setLength(0L);
            randomAccessFile.getChannel().force(false);
            randomAccessFile.close();
        }
    }

    public String toString() {
        return "VRFileMap:" + this.backingFile + ":# of buffers=" + this.allocated.size() + ":# of free buffers=" + this.numFree + ":# of MappedByteBuffer=" + this.mappedBuffers.size();
    }

    private void initNewFile(RandomAccessFile randomAccessFile, FileChannel fileChannel) throws IOException {
        if (DEBUG) {
            System.out.println("Creating new backing file with initial size " + this.initialFileSize);
        }
        this.fileSize = this.initialFileSize;
        randomAccessFile.setLength(this.fileSize);
        this.mbuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, this.fileSize);
        this.mappedBuffers.add(this.mbuffer);
        this.writeFileHeader(this.mbuffer);
        this.mbuffer.put(this.lastRecordHeader);
        this.mbuffer.position(24);
        this.startsAt.add(new Integer(24));
        this.filePointer = 24L;
    }

    private void loadFile(RandomAccessFile randomAccessFile, FileChannel fileChannel) throws IOException {
        byte[] byArray;
        int n;
        if (DEBUG) {
            System.out.println("Loading backing file with size " + randomAccessFile.length());
        }
        if ((n = randomAccessFile.read(byArray = new byte[16])) != 16) {
            throw new IOException(SharedResources.getResources().getString("S3017", this.backingFile));
        }
        short s = this.checkFileHeader(ByteBuffer.wrap(byArray));
        if (s == 2) {
            long l = randomAccessFile.readLong();
        }
        boolean bl = false;
        long l = 0L;
        long l2 = randomAccessFile.length();
        long l3 = l2 <= Integer.MAX_VALUE ? l2 : Integer.MAX_VALUE;
        boolean bl2 = true;
        while (!bl) {
            int n2;
            long l4 = l / 8192L * 8192L;
            int n3 = 0;
            if (l2 > l3) {
                this.mbuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, l4, l3);
                if (bl2) {
                    n2 = this.fileversion == 2 ? 24 : 16;
                    this.mbuffer.position(n2);
                    bl2 = false;
                } else if (l4 < l) {
                    n2 = (int)(l - l4);
                    this.mbuffer.position(n2);
                }
                this.startsAt.add(new Integer(this.mbuffer.position()));
                n3 = this.load(this.mbuffer, false);
                this.mbuffer.limit(n3);
                n2 = n3 - (int)(l - l4);
                l += (long)n2;
                l2 -= (long)n2;
            } else {
                if (!bl2 && l2 < this.initialFileSize) {
                    long l5 = l + this.initialFileSize;
                    randomAccessFile.setLength(l5);
                    l2 = this.initialFileSize;
                }
                this.mbuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, l4, l2);
                if (bl2) {
                    int n4 = this.fileversion == 2 ? 24 : 16;
                    this.mbuffer.position(n4);
                    bl2 = false;
                } else if (l4 < l) {
                    int n5 = (int)(l - l4);
                    this.mbuffer.position(n5);
                }
                this.startsAt.add(new Integer(this.mbuffer.position()));
                n3 = this.load(this.mbuffer, true);
                n2 = n3 - (int)(l - l4);
                this.filePointer = l + (long)n2;
                bl = true;
            }
            this.mappedBuffers.add(this.mbuffer);
        }
        this.fileSize = randomAccessFile.length();
    }

    private int load(MappedByteBuffer mappedByteBuffer, boolean bl) throws StreamCorruptedException, IOException {
        boolean bl2 = false;
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[12]);
        int n = mappedByteBuffer.position();
        while (!bl2 && mappedByteBuffer.hasRemaining()) {
            short s = 1;
            ByteBuffer byteBuffer2 = null;
            VRecordMap vRecordMap = null;
            if (mappedByteBuffer.remaining() < 12) {
                if (!bl) break;
                s = -7;
            } else {
                s = this.checkRecord(mappedByteBuffer, byteBuffer);
            }
            switch (s) {
                case 1: 
                case 2: {
                    mappedByteBuffer.position(n);
                    byteBuffer2 = mappedByteBuffer.slice();
                    vRecordMap = new VRecordMap(this, mappedByteBuffer, byteBuffer2);
                    int n2 = vRecordMap.getCapacity();
                    if (s == 2) {
                        this.allocated.add(vRecordMap);
                        this.bytesAllocated += (long)n2;
                    } else {
                        this.putFreeList(vRecordMap, true);
                    }
                    mappedByteBuffer.position(n += n2);
                    break;
                }
                case 1001: {
                    mappedByteBuffer.position(n);
                    bl2 = true;
                    break;
                }
                case -1: {
                    mappedByteBuffer.position(n);
                    if (!bl && n != 0) {
                        bl2 = true;
                        break;
                    }
                    n = this.handleBadRecord((short)-6, byteBuffer, mappedByteBuffer, bl);
                    mappedByteBuffer.position(n);
                    break;
                }
                case -7: 
                case -6: 
                case -5: 
                case -4: 
                case -3: 
                case -2: {
                    mappedByteBuffer.position(n);
                    n = this.handleBadRecord(s, byteBuffer, mappedByteBuffer, bl);
                    mappedByteBuffer.position(n);
                    break;
                }
            }
        }
        return n;
    }

    private short checkRecord(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        int n = byteBuffer.position();
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        short s = byteBuffer.getShort();
        byteBuffer2.rewind();
        byteBuffer2.putInt(n2);
        byteBuffer2.putInt(n3);
        byteBuffer2.putShort(s);
        short s2 = this.adjustRecordState(this.fileversion, s);
        if (n2 != -1431677611) {
            return -2;
        }
        if (s2 == -3) {
            return s2;
        }
        if (s2 == 1001) {
            if (n3 != 0) {
                return -6;
            }
            return s2;
        }
        if (n3 <= 12) {
            return -4;
        }
        if (n + n3 == byteBuffer.limit()) {
            return s2;
        }
        if ((long)n + (long)n3 > (long)byteBuffer.limit()) {
            return -1;
        }
        if (byteBuffer.limit() - n - n3 > 4) {
            n2 = byteBuffer.getInt(n + n3);
            if (n2 != -1431677611) {
                return -5;
            }
            return s2;
        }
        return s2;
    }

    private int handleBadRecord(short s, ByteBuffer byteBuffer, MappedByteBuffer mappedByteBuffer, boolean bl) throws IOException {
        if (DEBUG) {
            System.out.println("bad record found at " + mappedByteBuffer.position() + " in " + mappedByteBuffer);
        }
        int n = mappedByteBuffer.position();
        int n2 = this.findGoodRecord(mappedByteBuffer);
        mappedByteBuffer.position(n);
        if (n2 == mappedByteBuffer.limit() && bl) {
            if (mappedByteBuffer.remaining() >= 12) {
                mappedByteBuffer.put(this.lastRecordHeader);
            } else {
                mappedByteBuffer.limit(n);
            }
            VRFileMap.addWarning(this.getNewWarning(), s, n, byteBuffer, null);
            return n;
        }
        ByteBuffer byteBuffer2 = mappedByteBuffer.slice();
        VRecordMap vRecordMap = new VRecordMap(this, mappedByteBuffer, byteBuffer2, n2 - n);
        ((VRecord)vRecordMap).free();
        this.putFreeList(vRecordMap, true);
        VRFileMap.addWarning(this.getNewWarning(), s, n, byteBuffer, vRecordMap);
        return n2;
    }

    private VRecord getNewSlice(int n) throws IOException {
        int n2 = this.mbuffer.remaining() - n;
        int n3 = this.mbuffer.position() + n;
        ByteBuffer byteBuffer = this.mbuffer.slice();
        byteBuffer.limit(n);
        VRecordMap vRecordMap = new VRecordMap(this, this.mbuffer, byteBuffer, n);
        this.mbuffer.position(n3);
        this.filePointer += (long)n;
        if (DEBUG) {
            System.out.println("getNewSlice(" + n + "):");
            System.out.println("Slice at " + (n3 - n) + " on " + this.mbuffer);
            System.out.println("filePointer advanced to " + this.filePointer);
        }
        this.mbuffer.put(this.lastRecordHeader);
        this.mbuffer.position(n3);
        if (this.safe) {
            ((VRecord)vRecordMap).force();
        }
        return vRecordMap;
    }

    private void growfile(int n) throws IOException {
        if (DEBUG) {
            System.out.println("growfile(): need to grow file; remaining = " + this.mbuffer.remaining() + "; need = " + n);
        }
        long l = 0L;
        l = this.isThresholdReached() ? (long)((float)this.fileSize + (float)this.getThreshold() * this.getThresholdFactor()) : (long)((float)this.fileSize + (float)this.fileSize * this.getGrowthFactor());
        int n2 = this.mbuffer.remaining() + (int)(l - this.fileSize);
        while (n2 < n) {
            l = this.isThresholdReached() ? (long)((float)l + (float)this.getThreshold() * this.getThresholdFactor()) : (long)((float)l + (float)l * this.getGrowthFactor());
            n2 = this.mbuffer.remaining() + (int)(l - this.fileSize);
        }
        long l2 = this.filePointer / 8192L * 8192L;
        if (l - l2 > Integer.MAX_VALUE) {
            l = l2 + Integer.MAX_VALUE;
        }
        RandomAccessFile randomAccessFile = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        long l3 = 0L;
        try {
            randomAccessFile = new RandomAccessFile(this.backingFile, "rw");
            randomAccessFile.setLength(l);
            abstractInterruptibleChannel = randomAccessFile.getChannel();
            l3 = l - l2;
            MappedByteBuffer mappedByteBuffer = ((FileChannel)abstractInterruptibleChannel).map(FileChannel.MapMode.READ_WRITE, l2, l3);
            this.mappedBuffers.add(mappedByteBuffer);
            if (l2 < this.filePointer) {
                int n3 = (int)(this.filePointer - l2);
                mappedByteBuffer.position(n3);
                this.startsAt.add(new Integer(n3));
            }
            this.mbuffer.limit(this.mbuffer.position());
            if (DEBUG) {
                System.out.println("number of records allocated=" + this.allocated.size());
                System.out.println("growing file from " + this.fileSize + " to " + l);
                System.out.println("old buffer =" + this.mbuffer);
                System.out.println("new mapped buffer =" + mappedByteBuffer);
                System.out.println("new mapped buffer starts at " + l2);
                System.out.println("filePointer = " + this.filePointer);
            }
            this.mbuffer = mappedByteBuffer;
            this.fileSize = l;
        }
        catch (IOException iOException) {
            if (DEBUG) {
                System.out.println(iOException);
                iOException.printStackTrace();
                System.out.println("file position= " + this.filePointer);
                System.out.println("current file size= " + this.fileSize);
                System.out.println("new file size= " + l);
                System.out.println("tried to map from " + l2 + " for " + l3);
                this.printMappedBuffers();
            }
            if (randomAccessFile != null) {
                randomAccessFile.setLength(this.fileSize);
            }
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            if (DEBUG) {
                System.out.println(runtimeException);
                runtimeException.printStackTrace();
                System.out.println("file position= " + this.filePointer);
                System.out.println("current file size= " + this.fileSize);
                System.out.println("new file size= " + l);
                System.out.println("tried to map from " + l2 + " for " + l3);
                this.printMappedBuffers();
            }
            throw new IOException(runtimeException.getMessage());
        }
        finally {
            if (abstractInterruptibleChannel != null) {
                abstractInterruptibleChannel.close();
            }
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
    }

    private int findGoodRecord(MappedByteBuffer mappedByteBuffer) {
        int n;
        int n2 = n = mappedByteBuffer.position();
        while (mappedByteBuffer.hasRemaining()) {
            try {
                int n3 = mappedByteBuffer.getInt();
                if (n3 == -1431677611) {
                    int n4 = mappedByteBuffer.getInt();
                    short s = this.adjustRecordState(this.fileversion, mappedByteBuffer.getShort());
                    int n5 = n + n4;
                    if (s != -3 && (s == 1001 || n4 > 12)) {
                        if (s == 1001) {
                            if (n4 == 0) {
                                return n;
                            }
                        } else {
                            if (n5 == mappedByteBuffer.limit()) {
                                return n;
                            }
                            if (n5 > mappedByteBuffer.limit() ? n - n2 > 12 : (n3 = mappedByteBuffer.getInt(n5)) == -1431677611) {
                                return n;
                            }
                        }
                    }
                }
                mappedByteBuffer.position(n += 4);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                mappedByteBuffer.position(mappedByteBuffer.limit());
                n = mappedByteBuffer.limit();
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                mappedByteBuffer.position(mappedByteBuffer.limit());
                n = mappedByteBuffer.limit();
            }
        }
        return n;
    }

    private void printMappedBuffers() {
        System.out.println("mapped buffers:");
        for (int i = 0; i < this.mappedBuffers.size(); ++i) {
            System.out.println((MappedByteBuffer)this.mappedBuffers.get(i));
        }
    }
}

