/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.io.Serializable;
import java.util.Random;

public class RedeliveryPolicy
implements Cloneable,
Serializable {
    public static final int NO_MAXIMUM_REDELIVERIES = -1;
    private static Random randomNumberGenerator;
    private double collisionAvoidanceFactor = 0.15;
    private int maximumRedeliveries = 6;
    private long initialRedeliveryDelay = 1000L;
    private boolean useCollisionAvoidance;
    private boolean useExponentialBackOff;
    private short backOffMultiplier = (short)5;

    public RedeliveryPolicy copy() {
        try {
            return (RedeliveryPolicy)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Could not clone: " + e, e);
        }
    }

    public short getBackOffMultiplier() {
        return this.backOffMultiplier;
    }

    public void setBackOffMultiplier(short backOffMultiplier) {
        this.backOffMultiplier = backOffMultiplier;
    }

    public short getCollisionAvoidancePercent() {
        return (short)Math.round(this.collisionAvoidanceFactor * 100.0);
    }

    public void setCollisionAvoidancePercent(short collisionAvoidancePercent) {
        this.collisionAvoidanceFactor = (double)collisionAvoidancePercent * 0.01;
    }

    public long getInitialRedeliveryDelay() {
        return this.initialRedeliveryDelay;
    }

    public void setInitialRedeliveryDelay(long initialRedeliveryDelay) {
        this.initialRedeliveryDelay = initialRedeliveryDelay;
    }

    public int getMaximumRedeliveries() {
        return this.maximumRedeliveries;
    }

    public void setMaximumRedeliveries(int maximumRedeliveries) {
        this.maximumRedeliveries = maximumRedeliveries;
    }

    public long getRedeliveryDelay(long previousDelay) {
        long redeliveryDelay = previousDelay == 0L ? this.initialRedeliveryDelay : (this.useExponentialBackOff && this.backOffMultiplier > 1 ? previousDelay * (long)this.backOffMultiplier : previousDelay);
        if (this.useCollisionAvoidance) {
            Random random = RedeliveryPolicy.getRandomNumberGenerator();
            double variance = (random.nextBoolean() ? this.collisionAvoidanceFactor : -this.collisionAvoidanceFactor) * random.nextDouble();
            redeliveryDelay = (long)((double)redeliveryDelay + (double)redeliveryDelay * variance);
        }
        return redeliveryDelay;
    }

    public boolean isUseCollisionAvoidance() {
        return this.useCollisionAvoidance;
    }

    public void setUseCollisionAvoidance(boolean useCollisionAvoidance) {
        this.useCollisionAvoidance = useCollisionAvoidance;
    }

    public boolean isUseExponentialBackOff() {
        return this.useExponentialBackOff;
    }

    public void setUseExponentialBackOff(boolean useExponentialBackOff) {
        this.useExponentialBackOff = useExponentialBackOff;
    }

    protected static synchronized Random getRandomNumberGenerator() {
        if (randomNumberGenerator == null) {
            randomNumberGenerator = new Random();
        }
        return randomNumberGenerator;
    }
}

