/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.spring;

import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.spring.ActiveMQConnectionFactory;
import org.springframework.beans.factory.FactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveMQConnectionFactoryFactoryBean
implements FactoryBean {
    private List<String> tcpHostAndPorts = new ArrayList<String>();
    private Long maxInactivityDuration;
    private String tcpProperties;
    private Long maxReconnectDelay;
    private String failoverProperties;

    public Object getObject() throws Exception {
        ActiveMQConnectionFactory answer = new ActiveMQConnectionFactory();
        String brokerURL = this.getBrokerURL();
        answer.setBrokerURL(brokerURL);
        return answer;
    }

    public String getBrokerURL() {
        StringBuffer buffer = new StringBuffer("failover:(");
        int counter = 0;
        for (String tcpHostAndPort : this.tcpHostAndPorts) {
            if (counter++ > 0) {
                buffer.append(",");
            }
            buffer.append(this.createTcpHostAndPortUrl(tcpHostAndPort));
        }
        buffer.append(")");
        ArrayList<String> parameters = new ArrayList<String>();
        if (this.maxReconnectDelay != null) {
            parameters.add("maxReconnectDelay=" + this.maxReconnectDelay);
        }
        if (this.notEmpty(this.failoverProperties)) {
            parameters.add(this.failoverProperties);
        }
        buffer.append(this.asQueryString(parameters));
        return buffer.toString();
    }

    public Class getObjectType() {
        return ActiveMQConnectionFactory.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public List<String> getTcpHostAndPorts() {
        return this.tcpHostAndPorts;
    }

    public void setTcpHostAndPorts(List<String> tcpHostAndPorts) {
        this.tcpHostAndPorts = tcpHostAndPorts;
    }

    public void setTcpHostAndPort(String tcpHostAndPort) {
        this.tcpHostAndPorts = new ArrayList<String>();
        this.tcpHostAndPorts.add(tcpHostAndPort);
    }

    public Long getMaxInactivityDuration() {
        return this.maxInactivityDuration;
    }

    public void setMaxInactivityDuration(Long maxInactivityDuration) {
        this.maxInactivityDuration = maxInactivityDuration;
    }

    public String getTcpProperties() {
        return this.tcpProperties;
    }

    public void setTcpProperties(String tcpProperties) {
        this.tcpProperties = tcpProperties;
    }

    public Long getMaxReconnectDelay() {
        return this.maxReconnectDelay;
    }

    public void setMaxReconnectDelay(Long maxReconnectDelay) {
        this.maxReconnectDelay = maxReconnectDelay;
    }

    public String getFailoverProperties() {
        return this.failoverProperties;
    }

    public void setFailoverProperties(String failoverProperties) {
        this.failoverProperties = failoverProperties;
    }

    protected String asQueryString(List<String> parameters) {
        int size = parameters.size();
        if (size < 1) {
            return "";
        }
        StringBuffer buffer = new StringBuffer("?");
        buffer.append(parameters.get(0));
        for (int i = 1; i < size; ++i) {
            buffer.append("&");
            buffer.append(parameters.get(i));
        }
        return buffer.toString();
    }

    protected String createTcpHostAndPortUrl(String tcpHostAndPort) {
        ArrayList<String> parameters = new ArrayList<String>();
        if (this.maxInactivityDuration != null) {
            parameters.add("wireFormat.maxInactivityDuration=" + this.maxInactivityDuration);
        }
        if (this.notEmpty(this.tcpProperties)) {
            parameters.add(this.tcpProperties);
        }
        return tcpHostAndPort + this.asQueryString(parameters);
    }

    protected boolean notEmpty(String text) {
        return text != null && text.length() > 0;
    }
}

