/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.auth.jaas;

import com.sun.messaging.jmq.auth.jaas.MQBasicPermissionCollection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;

public abstract class MQBasicPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = 7965671047666454007L;
    private transient boolean wildcard;

    public MQBasicPermission(String string) {
        super(string);
        this.init(string);
    }

    private void init(String string) {
        if (string == null) {
            throw new NullPointerException("name null");
        }
        int n = string.length();
        if (n == 0) {
            throw new IllegalArgumentException("name empty");
        }
        if (n == 1 && string.equals("*")) {
            this.wildcard = true;
        } else {
            this.validateName(string);
        }
    }

    public abstract void validateName(String var1) throws IllegalArgumentException;

    public boolean implies(Permission permission) {
        if (!(permission instanceof MQBasicPermission)) {
            return false;
        }
        if (permission.getClass() != this.getClass()) {
            return false;
        }
        MQBasicPermission mQBasicPermission = (MQBasicPermission)permission;
        if (this.wildcard) {
            return true;
        }
        if (mQBasicPermission.wildcard) {
            return false;
        }
        return this.getName().equals(mQBasicPermission.getName());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MQBasicPermission)) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        MQBasicPermission mQBasicPermission = (MQBasicPermission)object;
        return this.getName().equals(mQBasicPermission.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String getActions() {
        return "";
    }

    public PermissionCollection newPermissionCollection() {
        return new MQBasicPermissionCollection();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(this.getName());
    }
}

