/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.io.ReadOnlyPacket;
import com.sun.messaging.jmq.jmsclient.ConnectionConsumerImpl;
import com.sun.messaging.jmq.jmsclient.ConsumerReader;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import java.io.IOException;
import java.io.PrintStream;
import javax.jms.JMSException;

public class ConnectionConsumerReader
extends ConsumerReader {
    private ConnectionConsumerImpl connectionConsumer = null;
    private int load = 0;
    private int maxMessages;

    public ConnectionConsumerReader(ConnectionConsumerImpl connectionConsumerImpl) {
        super(connectionConsumerImpl.getConnection(), connectionConsumerImpl.getReadQueue());
        this.connectionConsumer = connectionConsumerImpl;
        this.maxMessages = connectionConsumerImpl.getMaxMessages();
        if (this.maxMessages < 1) {
            this.maxMessages = 1;
        }
        this.load = 0;
    }

    protected void deliver(ReadOnlyPacket readOnlyPacket) throws IOException, JMSException {
        MessageImpl messageImpl = this.protocolHandler.getJMSMessage(readOnlyPacket);
        if (this.maxMessages == 1) {
            this.connectionConsumer.onMessage(messageImpl);
            this.connectionConsumer.startServerSession();
        } else {
            if (this.load == 0) {
                this.load = this.sessionQueue.size() + 1;
                if (this.load > this.maxMessages) {
                    this.load = this.maxMessages;
                }
            }
            this.connectionConsumer.onMessage(messageImpl);
            --this.load;
            if (this.load == 0) {
                this.connectionConsumer.startServerSession();
            }
        }
    }

    protected void deliver() throws IOException, JMSException {
    }

    public void dump(PrintStream printStream) {
        printStream.println("------ ConnectionConsumerReader dump ------");
        printStream.println("maxMessages: " + this.maxMessages);
        printStream.println("current load: " + this.load);
        super.dump(printStream);
    }
}

