/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.comparator;

import com.jidesoft.comparator.ComparatorContext;
import java.io.Serializable;
import java.util.Comparator;

public class CharSequenceComparator
implements Comparator,
Serializable {
    private boolean _caseSensitive;
    public static final ComparatorContext CONTEXT = new ComparatorContext("IgnoreLocale");
    public static final ComparatorContext CONTEXT_IGNORE_CASE = new ComparatorContext("IgnoreLocale_Ignorecase");

    public CharSequenceComparator() {
        this(true);
    }

    public CharSequenceComparator(boolean bl) {
        this._caseSensitive = bl;
    }

    public boolean isCaseSensitive() {
        return this._caseSensitive;
    }

    public void setCaseSensitive(boolean bl) {
        this._caseSensitive = bl;
    }

    public int compare(Object object, Object object2) {
        if (object == null && object2 == null) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (object instanceof CharSequence) {
            if (object2 instanceof CharSequence) {
                CharSequence charSequence = (CharSequence)object;
                CharSequence charSequence2 = (CharSequence)object2;
                return this.isCaseSensitive() ? this.compareCase(charSequence, charSequence2) : this.compareIgnoreCase(charSequence, charSequence2);
            }
            throw new ClassCastException("The second argument of this method was not a CharSequence: " + object2.getClass().getName());
        }
        if (object2 instanceof Comparable) {
            throw new ClassCastException("The first argument of this method was not a CharSequence: " + object.getClass().getName());
        }
        throw new ClassCastException("Both arguments of this method were not CharSequences: " + object.getClass().getName() + " and " + object2.getClass().getName());
    }

    private int compareCase(CharSequence charSequence, CharSequence charSequence2) {
        int n = charSequence.length();
        int n2 = charSequence2.length();
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            char c;
            char c2 = charSequence.charAt(i);
            if (c2 == (c = charSequence2.charAt(i))) continue;
            return c2 - c;
        }
        return n - n2;
    }

    private int compareIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        int n = charSequence.length();
        int n2 = charSequence2.length();
        int n3 = 0;
        for (int i = 0; n3 < n && i < n2; ++n3, ++i) {
            char c;
            char c2 = charSequence.charAt(n3);
            if (c2 == (c = charSequence2.charAt(i)) || (c2 = Character.toUpperCase(c2)) == (c = Character.toUpperCase(c)) || (c2 = Character.toLowerCase(c2)) == (c = Character.toLowerCase(c))) continue;
            return c2 - c;
        }
        return n - n2;
    }
}

