/*
 * Decompiled with CFR 0.152.
 */
package com.qbrowser.container;

import com.qbrowser.QBrowserV2;
import com.qbrowser.property.Property;
import com.qbrowser.util.QBrowserUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageContainer {
    int displaynumber;
    private String dest_name_with_suffix;
    private String vmsgid;
    private String vcorrelationid;
    private int vdeliverymode = 2;
    private int vpriority = 4;
    private long vexpiration = 0L;
    private String vjms_type;
    private boolean vredelivered;
    private long vtimestamp;
    private ArrayList<Property> additionalHeaders = new ArrayList();
    private String message_type;
    Destination vdest;
    Destination vreplyto;
    private Message message;
    private long body_size = -1L;

    public int getDisplaynumber() {
        return this.displaynumber;
    }

    public void setDisplaynumber(int displaynumber) {
        this.displaynumber = displaynumber;
    }

    public Message getMessage() {
        return this.message;
    }

    public void setMessageAfterLazyLoad(Message message) {
        this.message = message;
    }

    public void setMessage(Message message) {
        this.message = message;
        if (message != null) {
            try {
                this.setBody_size(QBrowserUtil.messageBodySizeOfLong(message));
                this.setMessage_type(QBrowserV2.messageType(message));
                this.setVmsgid(message.getJMSMessageID());
                this.setVdest(message.getJMSDestination());
                this.setVreplyto(message.getJMSReplyTo());
                this.setVcorrelationid(message.getJMSCorrelationID());
                this.setVdeliverymode(message.getJMSDeliveryMode());
                this.setVexpiration(message.getJMSExpiration());
                this.setVjms_type(message.getJMSType());
                this.setVpriority(message.getJMSPriority());
                this.setVredelivered(message.getJMSRedelivered());
                this.setVtimestamp(message.getJMSTimestamp());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public long getBody_size() {
        return this.body_size;
    }

    public void setBody_size(long body_size) {
        this.body_size = body_size;
    }

    public void setMessageFromBrokerWithLazyLoad(Message message) {
        try {
            if (message != null) {
                this.setBody_size(QBrowserUtil.messageBodySizeOfLong(message));
                this.setMessage_type(QBrowserV2.messageType(message));
                this.setVmsgid(message.getJMSMessageID());
                this.setVdest(message.getJMSDestination());
                this.setVreplyto(message.getJMSReplyTo());
                this.setVcorrelationid(message.getJMSCorrelationID());
                this.setVdeliverymode(message.getJMSDeliveryMode());
                this.setVexpiration(message.getJMSExpiration());
                this.setVjms_type(message.getJMSType());
                this.setVpriority(message.getJMSPriority());
                this.setVredelivered(message.getJMSRedelivered());
                this.setVtimestamp(message.getJMSTimestamp());
            }
        }
        catch (Exception jmse) {
            jmse.printStackTrace();
        }
    }

    public Destination getVdest() {
        return this.vdest;
    }

    public void setVdest(Destination vdest) {
        this.vdest = vdest;
    }

    public Destination getVreplyto() {
        return this.vreplyto;
    }

    public void setVreplyto(Destination vreplyto) {
        this.vreplyto = vreplyto;
    }

    public String getVcorrelationid() {
        return this.vcorrelationid;
    }

    public void setVcorrelationid(String vcorrelationid) {
        this.vcorrelationid = vcorrelationid;
    }

    public int getVdeliverymode() {
        return this.vdeliverymode;
    }

    public void setVdeliverymode(int vdeliverymode) {
        this.vdeliverymode = vdeliverymode;
    }

    public int getVpriority() {
        return this.vpriority;
    }

    public void setVpriority(int vpriority) {
        this.vpriority = vpriority;
    }

    public long getVexpiration() {
        return this.vexpiration;
    }

    public void setVexpiration(long vexpiration) {
        this.vexpiration = vexpiration;
    }

    public String getVjms_type() {
        return this.vjms_type;
    }

    public void setVjms_type(String vjms_type) {
        this.vjms_type = vjms_type;
    }

    public boolean isVredelivered() {
        return this.vredelivered;
    }

    public void setVredelivered(boolean vredelivered) {
        this.vredelivered = vredelivered;
    }

    public long getVtimestamp() {
        return this.vtimestamp;
    }

    public void setVtimestamp(long vtimestamp) {
        this.vtimestamp = vtimestamp;
    }

    public String getVmsgid() {
        return this.vmsgid;
    }

    public void setVmsgid(String vmsgid) {
        this.vmsgid = vmsgid;
    }

    public String getMessage_type() {
        return this.message_type;
    }

    public void setMessage_type(String message_type) {
        this.message_type = message_type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message getRealMessageFromBroker(Session session, Queue queue) {
        Message imes = this.getMessage();
        if (imes != null) {
            return imes;
        }
        QueueBrowser qb = null;
        Message retval = null;
        try {
            String selector = "JMSMessageID ='" + this.getVmsgid() + "'";
            qb = session.createBrowser(queue, selector);
            Enumeration emt = qb.getEnumeration();
            if (emt.hasMoreElements()) {
                Message imsg = (Message)emt.nextElement();
                this.setMessageAfterLazyLoad(imsg);
                retval = imsg;
            }
        }
        catch (Exception ie) {
            ie.printStackTrace();
        }
        finally {
            if (qb != null) {
                try {
                    qb.close();
                }
                catch (JMSException je) {}
                qb = null;
            }
        }
        return retval;
    }

    public String getDest_name_with_suffix() {
        return this.dest_name_with_suffix;
    }

    public void setDest_name_with_suffix(String dest_name_with_suffix) {
        this.dest_name_with_suffix = dest_name_with_suffix;
    }

    public String getPureDest_name() {
        if (this.dest_name_with_suffix == null) {
            return null;
        }
        return QBrowserUtil.getPureDestName(this.dest_name_with_suffix);
    }

    public String getDest_type() {
        if (QBrowserUtil.isLocalStore(this.dest_name_with_suffix)) {
            return "LOCAL_STORE";
        }
        if (QBrowserUtil.isTopic(this.dest_name_with_suffix)) {
            return "TOPIC";
        }
        return "QUEUE";
    }

    public ArrayList<Property> getAdditionalHeaders() {
        return this.additionalHeaders;
    }

    public void setAdditionalHeaders(ArrayList<Property> additionalHeaders) {
        this.additionalHeaders = additionalHeaders;
    }
}

