/*
 * Decompiled with CFR 0.152.
 */
package com.qbrowser.persist;

import com.qbrowser.QBrowserV2;
import com.qbrowser.localstore.LocalMessageContainer;
import com.qbrowser.persist.PersistedMessageReader;
import com.qbrowser.property.Property;
import com.qbrowser.util.QBrowserUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.Session;

public class MapMessageReader
extends PersistedMessageReader {
    ArrayList map_properties = new ArrayList();

    void readFileAndSetPropertyValue(String filepath, Property prop) {
        String type = prop.getProperty_type();
        try {
            if (type.equals("String")) {
                prop.setProperty_value(this.readFileIntoString(new File(filepath)));
                prop.selfValidate();
            } else if (type.equals("Int")) {
                prop.setProperty_value(Integer.parseInt(this.readFileIntoString(new File(filepath))));
                prop.selfValidate();
            } else if (type.equals("Boolean")) {
                prop.setProperty_value(Boolean.parseBoolean(this.readFileIntoString(new File(filepath))));
                prop.selfValidate();
            } else if (type.equals("Bytes")) {
                prop.setProperty_value(this.readFileIntoBytes(new File(filepath)));
                prop.validated_type = 10;
                prop.selfValidate();
            } else if (type.equals("Byte")) {
                prop.setProperty_value(Byte.parseByte(this.readFileIntoString(new File(filepath))));
                prop.selfValidate();
            } else if (type.equals("Double")) {
                prop.setProperty_value(Double.parseDouble(this.readFileIntoString(new File(filepath))));
                prop.selfValidate();
            } else if (type.equals("Float")) {
                prop.setProperty_value(Float.valueOf(Float.parseFloat(this.readFileIntoString(new File(filepath)))));
                prop.selfValidate();
            } else if (type.equals("Long")) {
                prop.setProperty_value(Long.parseLong(this.readFileIntoString(new File(filepath))));
                prop.selfValidate();
            } else if (type.equals("Short")) {
                prop.setProperty_value(Short.parseShort(this.readFileIntoString(new File(filepath))));
                prop.selfValidate();
            }
        }
        catch (Exception convertEx) {
            convertEx.printStackTrace();
        }
    }

    public File readPersistedMessage(File msgArchive) throws Exception {
        File workdirFile = super.readPersistedMessage(msgArchive);
        File def_file = new File(workdirFile.getAbsolutePath() + File.separator + "MapMessageDef");
        if (def_file == null || !def_file.exists()) {
            throw new IOException(QBrowserV2.resources.getString("qkey.msg.msg334") + def_file.getName() + QBrowserV2.resources.getString("qkey.msg.msg335"));
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(def_file));
            String line = null;
            while ((line = br.readLine()) != null) {
                Property map_prop = new Property();
                ArrayList ar = QBrowserUtil.parseDelimitedString(line, "@@@HzRpWr@@");
                block12: for (int i = 0; i < ar.size(); ++i) {
                    String token = (String)ar.get(i);
                    switch (i) {
                        case 0: {
                            continue block12;
                        }
                        case 1: {
                            map_prop.setKey(token);
                            continue block12;
                        }
                        case 2: {
                            map_prop.setProperty_type(token);
                            continue block12;
                        }
                        case 3: {
                            String fullpath = workdirFile.getAbsolutePath() + File.separator + "MapMessage" + File.separator + token;
                            this.readFileAndSetPropertyValue(fullpath, map_prop);
                        }
                    }
                }
                this.map_properties.add(map_prop);
            }
        }
        catch (Exception e) {
            MapMessageReader.clearDir(workdirFile);
            e.printStackTrace();
            throw new IOException(QBrowserV2.resources.getString("qkey.msg.msg331") + e.getMessage() + "\n\nFile=" + def_file.getName());
        }
        finally {
            if (br != null) {
                br.close();
                br = null;
            }
        }
        return workdirFile;
    }

    public File readPersistedMessageWithLazyLoad(File msgArchive) throws Exception {
        File workdirFile = super.readPersistedMessageWithLazyLoad(msgArchive);
        return workdirFile;
    }

    public LocalMessageContainer recreateMessagefromReadData(Session session) throws Exception {
        MapMessage mapmsg = session.createMapMessage();
        LocalMessageContainer lmc = new LocalMessageContainer();
        if (this.properties != null) {
            QBrowserUtil.copyUserProperties(this.properties, (Message)mapmsg);
        }
        lmc.setMessage((Message)mapmsg);
        lmc.setReal_file_path(this.source_file_path);
        if (this.headers != null) {
            QBrowserUtil.copyMessageHeaders(this.headers, (Message)mapmsg);
            QBrowserUtil.populateHeadersOfLocalMessageContainer(this.headers, lmc);
        }
        try {
            block15: for (int i = 0; i < this.map_properties.size(); ++i) {
                Property mapm_body_data = (Property)this.map_properties.get(i);
                String key = mapm_body_data.getKey();
                if (key == null) continue;
                switch (mapm_body_data.validated_type) {
                    case 0: {
                        continue block15;
                    }
                    case 10: {
                        mapmsg.setBytes(key, mapm_body_data.getProperty_valueASBytes());
                        continue block15;
                    }
                    case 1: {
                        mapmsg.setString(key, mapm_body_data.getProperty_valueASString());
                        continue block15;
                    }
                    case 3: {
                        mapmsg.setBoolean(key, mapm_body_data.getProperty_valueASBoolean());
                        continue block15;
                    }
                    case 2: {
                        mapmsg.setInt(key, mapm_body_data.getProperty_valueASInt());
                        continue block15;
                    }
                    case 4: {
                        mapmsg.setByte(key, mapm_body_data.getProperty_valueASByte());
                        continue block15;
                    }
                    case 9: {
                        byte[] bytesarray = QBrowserUtil.extractBytes(mapm_body_data.getProperty_valueASString());
                        if (bytesarray == null) {
                            throw new Exception("Q0021");
                        }
                        mapmsg.setBytes(key, bytesarray);
                        continue block15;
                    }
                    case 5: {
                        mapmsg.setDouble(key, mapm_body_data.getProperty_valueASDouble());
                        continue block15;
                    }
                    case 6: {
                        mapmsg.setFloat(key, mapm_body_data.getProperty_valueASFloat());
                        continue block15;
                    }
                    case 7: {
                        mapmsg.setLong(key, mapm_body_data.getProperty_valueASLong());
                        continue block15;
                    }
                    case 8: {
                        mapmsg.setShort(key, mapm_body_data.getProperty_valueASShort());
                        continue block15;
                    }
                }
            }
        }
        catch (Throwable thex) {
            throw new IOException("MapMessage " + QBrowserV2.resources.getString("qkey.msg.msg336") + thex.getMessage());
        }
        return lmc;
    }

    public LocalMessageContainer recreateMessagefromReadDataWithLazyLoad() throws Exception {
        LocalMessageContainer lmc = super.recreateMessagefromReadDataWithLazyLoad();
        lmc.setMessage_type("MapMessage");
        return lmc;
    }
}

