#!/usr/local/bin/perl

##=======================================================================##
## AD-EDIT CORE v3.1.1
## (c)2008-2010 NorenzPRO Ltd. TalafumiArai 2010/12/1
##=======================================================================##
use CGI::Carp qw(fatalsToBrowser);

##=======================================================================##
## 設定項目
##=======================================================================##

##★ライブラリ
require './aelib.cgi';
use strict;
use CGI;
use Encode;

##★このスクリプトの名前
our $cginame = 'admenu.cgi';

##★ディレクトリ構成ファイル
our $dirfile = './dir.dat';

##★設定ファイルのパス
our $conffile = './conf.dat';

##★クッキーの名称
our $CookieName = 'AdminPass';

##★パスワードファイル
our $passfile='./pass.cgi';

##=====================================================================================##
##メインルーチン
##=====================================================================================##

our $IncludeTag;
our $CssTag;
our $mz;
our $mi;
our @MenuData;

##ディレクトリファイル読込
open(DIRRD,"$dirfile");
our @DIR = <DIRRD>;
close(DIRRD);

##システム設定ファイル読込
open(CONFRD,"$conffile");
our @CONF = <CONFRD>;
close(CONFRD);
our $DirMode =$CONF[0];
$DirMode =~ s/\r//g; $DirMode =~ s/\n//g;
our $ExecMode =$CONF[1];
$ExecMode =~ s/\r//g; $ExecMode =~ s/\n//g;
our $WRMode =$CONF[2];
$WRMode =~ s/\r//g; $WRMode =~ s/\n//g;
our $Domain =$CONF[3];
$Domain =~ s/\r//g; $Domain =~ s/\n//g;
our $PerlPath =$CONF[4];
$PerlPath =~ s/\r//g; $PerlPath =~ s/\n//g;
our $EditType =$CONF[5];
$EditType =~ s/\r//g; $EditType =~ s/\n//g;
our $EditName =$CONF[6];
$EditName =~ s/\r//g; $EditName =~ s/\n//g;
our $SendmailPath =$CONF[7];
$SendmailPath =~ s/\r//g; $SendmailPath =~ s/\n//g;
our $GmapAPIkey =$CONF[8];
$GmapAPIkey =~ s/\r//g; $GmapAPIkey =~ s/\n//g;
our $SysVersion =$CONF[9];
$SysVersion =~ s/\r//g; $SysVersion =~ s/\n//g;
our $RootPath =$CONF[10];
$RootPath =~ s/\r//g; $RootPath =~ s/\n//g;
our $LogoutTime =$CONF[11];
$LogoutTime =~ s/\r//g; $LogoutTime =~ s/\n//g;
our $PathConvert =$CONF[12];
$PathConvert =~ s/\r//g; $PathConvert =~ s/\n//g;
our $UpdateOut =$CONF[13];
$UpdateOut =~ s/\r//g; $UpdateOut =~ s/\n//g;
our $DefMainURL =$CONF[14];
$DefMainURL =~ s/\r//g; $DefMainURL =~ s/\n//g;
our $SearchSkinURL =$CONF[15];
$SearchSkinURL =~ s/\r//g; $SearchSkinURL =~ s/\n//g;
our $pcoutCode =$CONF[22];
$pcoutCode =~ s/\r//g; $pcoutCode =~ s/\n//g;
our $mboutCode =$CONF[23];
$mboutCode =~ s/\r//g; $mboutCode =~ s/\n//g;

if ($DirMode eq '') { $DirMode ='0755'; }
if ($ExecMode eq '') { $ExecMode ='0755'; }
if ($WRMode eq '') { $WRMode ='0666'; }
if ($PerlPath eq '') { $PerlPath ='#!/usr/local/bin/perl'; }
if ($DefMainURL eq '') { $DefMainURL ='main.html'; }
if ($SearchSkinURL eq '') { $SearchSkinURL ='/skin/skin.html'; }
our $vLogoutTime;
if ($LogoutTime eq '1800') { $vLogoutTime='30分'; }
elsif ($LogoutTime eq '3600') { $vLogoutTime='1時間'; }
elsif ($LogoutTime eq '10800') { $vLogoutTime='3時間'; }
elsif ($LogoutTime eq '21600') { $vLogoutTime='6時間'; }
elsif ($LogoutTime eq '43200') { $vLogoutTime='12時間'; }
elsif ($LogoutTime eq '86400') { $vLogoutTime='1日'; }
elsif ($LogoutTime eq '259200') { $vLogoutTime='3日'; }
elsif ($LogoutTime eq '604800') { $vLogoutTime='7日'; }
else { $LogoutTime='259200'; $vLogoutTime='3日'; }
if ($pcoutCode eq '') { $pcoutCode='sjis'; }
if ($mboutCode eq '') { $mboutCode='sjis'; }

##編集者IDパスワード読込
our $admin_id;
our $admin_pw;
if (open(PASSRD,"$passfile")) {
	my @PASSID = <PASSRD>;
	$admin_id =$PASSID[0];
	$admin_id =~ s/\r//g; $admin_id =~ s/\n//g;
	$admin_pw =$PASSID[1];
	$admin_pw =~ s/\r//g; $admin_pw =~ s/\n//g;
	$admin_pw =crypt($admin_pw,'ae');
	close(PASSRD);
} else { &error('パスワードファイル読込エラー'); }

##フォームの取得
our %in;
our @in;
my $query = CGI->new;
*in = $query->Vars();
foreach (%in) { 
	$_ =~ s/\xEF\xBD\x9E/\xE3\x80\x9C/g; 
	$_ =~ s/\xEF\xBC\x8D/\xE2\x88\x92/g; 
}

##==============メインアクション==============

## 管理者ログイン認証
our $ck_id; our $ck_pw;
our $c_id; our $c_pw;
if ($in{'loging'} eq "new") {
	# フォーム認証
	my $input_id = $in{'admin_id'};
	my $input_pw = $in{'admin_pw'};
	$input_pw =crypt($input_pw,'ae');
	if ($input_id ne "$admin_id") { &error('認証エラー'); }
	if ($input_pw ne "$admin_pw") { &error('認証エラー'); }
	&set_cookie;
	&admin;
} else {
	# クッキー認証
	&get_cookie;
	if (($ck_id eq "$admin_id")&&($ck_pw eq "$admin_pw")) {
		# 処理分岐
		if ($in{'mode'} eq 'admin') { &admin; }
		elsif ($in{'mode'} eq 'add') { &add; }
		elsif ($in{'mode'} eq 'del') { &del; }
		elsif ($in{'mode'} eq 'label') { &label; }
		elsif ($in{'mode'} eq 'remake') { &remake; }
		elsif ($in{'mode'} eq 'defset') { &defset; }
		elsif ($in{'mode'} eq 'sort') { &sort; }
		elsif ($in{'mode'} eq 'mtform') { &mtform; }
		elsif ($in{'mode'} eq 'mtregist') { &mtregist; }
		elsif ($in{'mode'} eq 'MakeIndexFile') { &MakeIndexFile; }
		else { &admin; }
	} else {
		&login;
	}
}

exit;

##=====================================================================================##
##サブルーチン
##=====================================================================================##
sub html_head {

##★HTMLヘッダの変更はここを訂正
my $html_head = <<"HTMLHEAD";
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>PCメニュー設定</title>
<link rel="stylesheet" href="../admin/style.css" type="text/css">
</head>
<body onload="javascript:parent.menu.location.href='menu.cgi'">
<h3 align=center>PCメニュー設定</h3>
<div align=center>ここの設定の前に、
<img src=../icon/conf.gif align=absmiddle><a href="adedit.cgi">[コンテンツ設定]</a> にてコンテンツ登録を行ってください</div>
HTMLHEAD

print "Content-type: text/html\n\n";
print $html_head;

}
##=======================================================================================
sub html_foot {

##★HTMLフッタの変更はここを訂正
my $html_foot = <<"HTMLFOOT";
</body>
</html>
HTMLFOOT

print $html_foot;

}
##=======================================================================================
sub login {

##★ログイン画面の変更はここを訂正
my $html_login = <<"LOGINHTML";
<div align="center">
<form method="post" action="$cginame">
<br>
<h5 align=center style="color:red">セッションタイムアウト</h5>
<h4 align=center>管理画面 再ログイン</h4>
<div align=center>ログインID　<input type="text" name="admin_id" size="25" value="$ck_id" class="Hankaku"></div>
<div align=center>パスワード　<input type="password" name="admin_pw" size="25" value="$ck_pw" class="Hankaku"></div>
<div align="center">
<input type="submit" name="submit" value="ログイン">
<input type="reset" value="リセット">
<input type="hidden" name="mode" value="admin">
<input type="hidden" name="loging" value="new">
</div>
</form>
LOGINHTML

&html_head;
print $html_login;
&html_foot;

exit;
}
##=======================================================================================
sub admin {

&html_head;

##メニュー管理画面
if ($in{'mz'} ne '') { $mz=$in{'mz'}; } else { $mz=1; }

##メニュー定義ファイル読込
my $MenuDataFile='./menu'.$mz.'.dat';
my $MenuIncFile ='./menu'.$mz.'.inc';
my $MenuIncCommons ='../commons/menu'.$mz.'.inc';
@MenuData=();
if (open(MENURD,"$MenuDataFile")) {
	@MenuData = <MENURD>;
	close(MENURD);
}
##コンテンツ文字コード判定→UTF8変換
my $contCC=&checkCharCode($MenuDataFile);
if ($contCC eq 'shiftjis') {
	foreach (@MenuData) { Encode::from_to($_, 'shiftjis', 'utf8'); }
}

##デフォルトバス
my $DefRootPath;
if ($RootPath ne '') { $DefRootPath='/'.$RootPath; } else  { $DefRootPath=''; }

##メニューリスト定義
my $MenuLot=@MenuData-1;my $mi=0;
my $ConfFile;
my $ListTag;
my @MenuLine;
my @MenuLine;
my @DefDir;
my @MenuType;
my @MenuContent;
my @DefTag;
my @DefCss;
my @MenuLabel;
my @vMenuType;
my @vMenuGoto;
my @MenuTarg;
my $vMenuTarg;
for (0..$MenuLot) {
	$MenuData[$mi] =~ s/\r//g;
	$MenuData[$mi] =~ s/\n//g;
	@MenuLine=split(/\t/,$MenuData[$mi]);
	$MenuTarg[$mi]='';$vMenuTarg='';
	if ($mi==0) {
		##メニュー設定
		$DefDir[$mz]=$MenuLine[0];
		$DefTag[$mz]=$MenuLine[1];
		$DefCss[$mz]=$MenuLine[2];
	} else {
		##メニューリスト
		$MenuLabel[$mi]=$MenuLine[0];
		$MenuType[$mi]=$MenuLine[1];
		$MenuContent[$mi]=$MenuLine[2];
		$MenuTarg[$mi]=$MenuLine[3];
		##リンクタイプ取得
		if ($MenuType[$mi] eq 'dir') {
			$vMenuType[$mi]='コンテンツ';
			##コンテンツ調査
			$ConfFile='../'.$MenuLine[2].'/conf.dat';
			my @ConfData;
			if (open(CONFRD,"$ConfFile")) {
				@ConfData = <CONFRD>;
				close(CONFRD);
				##コンテンツ文字コード判定→UTF8変換
				my $contCC=&checkCharCode($ConfFile);
				if ($contCC eq 'shiftjis') {
					foreach (@ConfData) { Encode::from_to($_, 'shiftjis', 'utf8'); }
				}
				$vMenuGoto[$mi]=$ConfData[0]
			} else {
				$vMenuGoto[$mi]=$MenuLine[2];
			}
		} elsif ($MenuType[$mi] eq 'url') {
			$vMenuType[$mi]='URL';
			$vMenuGoto[$mi]=$MenuLine[2];
		} elsif ($MenuType[$mi] eq 'h2') {
			$vMenuType[$mi]='見出し大';
			$vMenuGoto[$mi]='-';
		} elsif ($MenuType[$mi] eq 'h3') {
			$vMenuType[$mi]='見出し中';
			$vMenuGoto[$mi]='-';
		} elsif ($MenuType[$mi] eq 'h4') {
			$vMenuType[$mi]='見出し小';
			$vMenuGoto[$mi]='-';
		}
		if ($MenuTarg[$mi] ne '') {
			$vMenuTarg=' ['.$MenuTarg[$mi].']';
		} else { $vMenuTarg=''; }
		$MenuLabel[$mi] =~ s/\"/&quot;/g;
		$ListTag=$ListTag.'<tr><td><form action='.$cginame.' method=post>'
			.'<input type=submit value=▲><input type=hidden name=mode value=sort><input type=hidden name=key value='.$mi
			.'><input type=hidden name=mz value='.$mz.'></form></td>'
			.'<td><form action='.$cginame.' method=post><input type=text name=newlabel value="'.$MenuLabel[$mi].'" size=40>'
			.'<input type=submit value="変更"><input type=hidden name=mode value=label>'
			.'<input type=hidden name=line value='.$mi.'><input type=hidden name=mz value='.$mz.'></form></td>'
			.'<td>'.$vMenuGoto[$mi].$vMenuTarg.'</td><td>'.$vMenuType[$mi].'</td>'
			.'<td><form action='.$cginame.' method=post>'
			.'<input type=submit value=メニュー削除><input type=hidden name=mode value=del>'
			.'<input type=hidden name=line value='.$mi.'><input type=hidden name=mz value='.$mz.'></form></td></tr>';
	}
	$mi++;
}

##生成タグ形式
my @NameTag;
if ($DefTag[$mz] eq 'a') { $NameTag[$mz] = '&lt;a.classNN&gt形式'; }
elsif ($DefTag[$mz] eq 'ap') { $NameTag[$mz] = '| &lt;a.classNN&gt | 形式(パイプ区切り)'; }
elsif ($DefTag[$mz] eq 'abr') { $NameTag[$mz] = '&lt;a.classNN&gt&lt;br /&gt形式(改行区切)'; }
elsif ($DefTag[$mz] eq 'ul') { $NameTag[$mz] = '&lt;ul.class&gt&lt;li.classNN&gt形式'; }
elsif ($DefTag[$mz] eq 'ol') { $NameTag[$mz] = '&lt;ol.class&gt&lt;li.classNN&gt形式'; }
else { $DefTag[$mz] eq 'ul'; $NameTag[$mz] = '&lt;ul.class&gt&lt;li.classNN&gt形式'; }

##コンテンツリスト
my $DirLot=@DIR-1;my $dd=0;
my $SelectGoto;
my $dSelectGoto;
my $tSelectGoto;
my $vSelectGoto;
my @ConfData;
for (0..$DirLot) {
	($dSelectGoto,$tSelectGoto)=split(/\,/,$DIR[$dd]);
	##コンテンツ調査
	$ConfFile='../'.$dSelectGoto.'/conf.dat';
	if (open(CONFRD,"$ConfFile")) {
		@ConfData = <CONFRD>;
		close(CONFRD);
		##コンテンツ文字コード判定→UTF8変換
		my $contCC=&checkCharCode($ConfFile);
		if ($contCC eq 'shiftjis') {
			foreach (@ConfData) { Encode::from_to($_, 'shiftjis', 'utf8'); }
		}
		$vSelectGoto=$ConfData[0];
	} else {
		$vSelectGoto=$dSelectGoto;
	}
	$vSelectGoto =~ s/\r//g;
	$vSelectGoto =~ s/\n//g;
	$SelectGoto=$SelectGoto.'  <option value="'.$dSelectGoto.'">'.$vSelectGoto.'</option>'."\n";
	$dd++;
}

my $eximage;
my $exTxt;
if ($mz <= 3) {
	$eximage='<img src="img/menu'.$mz.'.gif">';
	$exTxt='';
} else {
	$eximage='';
	$exTxt='<small>(拡張ゾーン)</small>';
}

my $selForm = '<form>ゾーン選択　<select onChange="javascript:location.href=this.options[this.selectedIndex].value">'."\n";
my $seli=1;
my $datfile;
my $Yobi;
my $seld;
for (0..19) {
	$datfile='./menu'.$seli.'.dat';
	if ($seli > 3) { $Yobi='(拡張ゾーン)'; } else { $Yobi=''; }
	if ($mz eq $seli) { $seld=' selected'; } else { $seld=''; }
	if (-e $datfile) {
		$selForm=$selForm.'<option value="'.$cginame.'?mz='.$seli.'"'.$seld.'>メニューゾーン'.$seli.$Yobi.'</option>'."\n";
	} else {
		$selForm=$selForm.'<option value="'.$cginame.'?mz='.$seli.'"'.$seld.'>メニューゾーン'.$seli.$Yobi.' を追加</option>'."\n";
		last;
	}
	$seli++;
}
$selForm = $selForm.'</select></form>'."\n";

##★変更画面の変更はここを訂正
my $htmlForm = <<"htmlForm";
<a name="$mz"></a>
<hr size="1" align="center">
  <h4 align="center">メニューゾーン$mz 設定 $exTxt</h4>
  <div align="center">$selForm</div>
<hr size="1" align="center">
<table width="95%" border="0" cellspacing="0" cellpadding="5" align="center">
<tr>
  <td valign=top>$eximage</td>
  <td valign=top align=left><ul>
  <li>コンテンツで使用するスキンHTML内に、<font color=red> &lt;MenuZone$mz&gt; </font>を記述してください。</li>
  <li>この管理画面で生成されるメニュー定義ファイル( $MenuIncFile ) が変更され、<br>
  この設定画面で編集したメニュー項目に置き換えられます。</li>
  <li>SSIファイル(*.shtml形式)のファイルへ記述する場合は、<br>
  <font color=red>&lt;!--\#include virtual="$DefRootPath/commons/menu$mz.inc" --&gt; </font><br>
  のタグをソ\ースコードに記述して読み込んでください。</li>
  </ul>
</td>
</tr></table>

<table width="95%" border="1" cellspacing="0" cellpadding="3" align="center" bgcolor="#FFFFFF">
<tr> 
  <td align="center" width=5%><b>順</b></td>
  <td align="center" width=30%><b>メニューラベル</b></td>
  <td align="center" width=30%><b>リンク先</b></td>
  <td align="center" width=25%><b>タイプ</b></td>
  <td align="center" width=10%><b>メニュー削除</b></td>
</tr>
$ListTag
</table>

<table width="95%" border="0" cellspacing="0" cellpadding="5" align="center">
<form action=$cginame method=post>
<tr><td>
<div style="margin-bottom:5px"><strong>メニュー項目の追加</strong>
 <a href="javascript:alert(this.help1$mz.title);" name="help1$mz" title="[コンテンツ設定]で登録された項目がリンク先に一覧表\示されます">[?]</a></div>
  　メニュー\表\示\ラベル 
  <input type=text name="MenuLabel" size=30>
  <a href="javascript:alert(this.help2$mz.title);" name="help2$mz" title="サイトメニューに\表\示\する文字列">[?]</a><br>
  　リンク先コンテンツ
  <select name="MenuGoto">
  <option value="admin" selected>URLの場合はこちらに記述→</option>
  $SelectGoto
  <option value="h2">見出し大 - &lt;h2&gt;</option>
  <option value="h3">見出し中 - &lt;h3&gt;</option>
  <option value="h4">見出し小 - &lt;h4&gt;</option>
  </select>
  アドレス <input type=text name="MenuUrl" value="$DefRootPath/" size="25" class="Hankaku">
  ターゲット<input type=text name="MenuTarg" value="" size="10" class="Hankaku">　
  <input type=submit value="メニュー追加">
  <input type=hidden name="mz" value="$mz">
  <input type=hidden name="mode" value="add">
</form>
</td></tr></table>

<table width="95%" border="0" cellspacing="0" cellpadding="5" align="center">
<tr><td>
<div style="margin-bottom:5px"><strong>メニュー設定をサイト全体に反映</strong>(メニュー設定後に操作)
<a href="javascript:alert(this.help5$mz.title);" name="help5$mz" title="各コンテンツフォルダのindex.htmlを更\新します">[?]</a></div>
  <form>　<input type="button" onClick="location.href='$cginame?mode=MakeIndexFile&amp;mz=$mz'" value="上記メニュー項目をサイト全体に反映する(HTMLファイルを更\新)"></form>
</td></tr></table>


<table width="95%" border="0" cellspacing="0" cellpadding="5" align="center">
<tr><td>
  <form action="$cginame" method="POST">
<div style="margin-bottom:5px"><strong>メニュータイプ[CSS設定]</strong> (上級者向け)
  <a href="javascript:alert(this.help4$mz.title);" name="help4$mz" title="\*\.incファイルの書式やCSSクラス名を設定します(上級者向け)">[?]</a></div>
  　生成タグ形式 <select name="DefTag">
  <option value="$DefTag[$mz]" selected>$NameTag[$mz]</option>
  <option value="a">&lt;a.classNN&gt;形式</option>
  <option value="ap">| &lt;a.classNN&gt; | 形式(パイプ区切)</option>
  <option value="abr">&lt;a.classNN&gt;&lt;br /&gt;形式(改行区切)</option>
  <option value="ul">&lt;ul.class&gt;&lt;li.classNN&gt;形式</option>
  <option value="ol">&lt;ol.class&gt;&lt;li.classNN&gt;形式</option></select>　
  CSSクラス名 <input type=text name="DefCss" value="$DefCss[$mz]" class="Hankaku">　
  <input type=hidden name="DefDir" value="/">
  <input type=hidden name="mode" value="defset">
  <input type=hidden name="mz" value="$mz">
  <input type=submit value="設定変更"><br>
  <small>
  　<br>
  　※ <font style="color:#0000CC">メニューゾーン1</font> の標準形式は <font style="color:#0000CC">&lt;a.classNN&gt;形式</font> です<br>
  　※ <font style="color:#0000CC">メニューゾーン2</font> の標準形式は <font style="color:#0000CC">&lt;ul.class&gt;&lt;li.classNN&gt;形式</font> です<br>
  　※ <font style="color:#0000CC">メニューゾーン3</font> の標準形式は <font style="color:#0000CC">| &lt;a.classNN&gt; | 形式(パイプ区切)</font> です<br>
  　<br>
  　※ a.classNN形式：　&lt;a class="classNN"&gt;～&lt;/a&gt; (NNは項目固有の数値)<br>
  　※ ul.class形式：　&lt;ul class="class"&gt;&lt;li class="classNN"&gt;&lt;a&gt;～&lt;/a&gt; (NNは項目固有の数値)<br>
  </small>
  </form>
</td></tr></table>

<table width="95%" border="0" cellspacing="0" cellpadding="5" align="center">
<tr><td>
<div style="margin-bottom:5px"><strong>メニューゾーンファイルの再出力</strong>
  <form action="$cginame"method="POST">
  　<input type="submit" value="メニューゾーンファイルの再出力">
  <input type=hidden name="mode" value="remake">
  </form>
  　<span style="color:red">※リンク切れが発生する場合にこのボタンを押してメニューゾーンファイルを再出力してください</span>
</td></tr></table>
<div align="right"><a href="$cginame?mode=mtform&amp;mz=$mz">[メニューゾーン$mz のメンテナンス]</a></div>
htmlForm
print "$htmlForm\n";

&html_foot;

exit;
}
##=======================================================================================
sub mtform {

##メニューメンテナンス画面
if ($in{'mz'} ne '') { $mz=$in{'mz'}; } else { $mz=1; }

##メニュー定義ファイル読込
my $MenuDataFile='./menu'.$mz.'.dat';
@MenuData=();
if (open(MENURD,"$MenuDataFile")) {
	@MenuData = <MENURD>;
	close(MENURD);
}
##コンテンツ文字コード判定→UTF8変換
my $contCC=&checkCharCode($MenuDataFile);
if ($contCC eq 'shiftjis') {
	foreach (@MenuData) { Encode::from_to($_, 'shiftjis', 'utf8'); }
}
my $menuLot=@MenuData-1;
my $i=0;
my $menutext;
for (0..$menuLot) {
	$menutext=$menutext.$MenuData[$i];
	$i++;
}
$menutext =~ s/\t/\,/g;

##★変更画面の変更はここを訂正
my $CORRECTR = <<"CORRECTR";
<hr size="1" align="center">
<h4 align="center">メニューゾーン$mz のメンテナンスモード</h4>
<div align="center">/admin/menu$mz.dat の編集を行います</div>
<hr size="1" align="center">
<script language=JavaScript><!--
function AddRows(targetObj) {
  var obj = document.getElementsByName(targetObj)[0];
  obj.rows = obj.rows+5;
}
--></script>
        <form method="post" action="$cginame">
        <table border="0" cellspacing="10" cellpadding="1" align="center">
          <tr> 
            <td>順番の入替えなど、手動でメニュー編集を行いたい場合は、こちらを編集してください。<br />
              <textarea name="menutext" cols="60" rows="18" onDblClick="AddRows('menutext')">$menutext</textarea><br />
                【サンプル】ラベル, タイプ[url/dir], エディタタイプ, リンクターゲット, 　(半角カンマ区切り)<br />
                <font style="color:red">
                ※1行目はメニュー形式やCSSクラス名などの設定です<br />
                ※メニュー項目は2行目以降となります</font>
            </td>
          </tr>
          <tr>
            <td>
              <div align="center">
                <input type="submit" name="submit" value="内容\更\新">
                <input type="reset" value="リセット">
                <input type="hidden" name="mode" value="mtregist">
                <input type="hidden" name="mz" value="$mz">
              </div>
            </td>
          </tr>
        </table>
        </form>
<hr size="1" align="center">
<div align="center"><a href="javascript:history.go(-1)">[先程のページへ戻る]</a></div>
<hr size="1" align="center">
CORRECTR

&html_head;
print $CORRECTR;
&html_foot;

exit;
}
##=======================================================================================
sub defset {

##フォーム取得処理
$mz = $in{'mz'};
my $MenuDataFile='./menu'.$mz.'.dat';
my $MenuIncFile ='./menu'.$mz.'.inc';
my $MenuIncCommons ='../commons/menu'.$mz.'.inc';

##メニュー定義ファイル読込
@MenuData=();
if (open(MENURD,"$MenuDataFile")) {
	@MenuData = <MENURD>;
	close(MENURD);
}

if ($in{'DefDir'} eq '') { $in{'DefDir'}='/'; }
$MenuData[0]=$in{'DefDir'}."\t".$in{'DefTag'}."\t".$in{'DefCss'}."\t\n";

##メニュー定義ファイル書込
my $tmpfile = "$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR @MenuData;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuDataFile);

##メニューincファイル書式
&MakeIncTag;

##メニューincファイル書込
$tmpfile = "$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $IncludeTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuIncFile);

$tmpfile = "../commons/$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $IncludeTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuIncCommons);

##処理画面出力
my $jumpurl = "$cginame?mode=admin&amp;mz=$mz";
my $htJump = <<"htJump";
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>メニューゾーン$mz 設定処理</title>
<meta http-equiv="Refresh" content="1;url=$jumpurl">
<link rel="stylesheet" href="style.css" type="text/css">
</head>
<body bgcolor="#FFFFFF" text="#000000">
<h3 align="center">只今、メニューゾーン$mz の設定処理中です。</h3>
</body></html>
htJump

print "Content-type: text/html\n\n";
print $htJump;

exit;
}
##=======================================================================================
sub add {

##★フォーム取得処理
$mz = $in{'mz'};
my $MenuLabel = $in{'MenuLabel'};
my $MenuType;
my $MenuGoto;
if ($in{'MenuGoto'} eq 'admin') {
	$MenuType='url';
	$MenuGoto=$in{'MenuUrl'};
} elsif ($in{'MenuGoto'} eq 'h2') {
	$MenuType='h2';
	$MenuGoto=$in{'MenuGoto'};
} elsif ($in{'MenuGoto'} eq 'h3') {
	$MenuType='h3';
	$MenuGoto=$in{'MenuGoto'};
} elsif ($in{'MenuGoto'} eq 'h4') {
	$MenuType='h4';
	$MenuGoto=$in{'MenuGoto'};
} else {
	$MenuType='dir';
	$MenuGoto=$in{'MenuGoto'};
}
my $MenuTarg = $in{'MenuTarg'};

my $MenuDataFile='./menu'.$mz.'.dat';
my $MenuIncFile ='./menu'.$mz.'.inc';
my $MenuIncCommons ='../commons/menu'.$mz.'.inc';

##メニュー定義ファイル読込
@MenuData=();
if (open(MENURD,"$MenuDataFile")) {
	@MenuData = <MENURD>;
	close(MENURD);
}
##文字コード判定→UTF8変換
my $contCC=&checkCharCode($MenuDataFile);
if ($contCC eq 'shiftjis') {
	foreach (@MenuData) { Encode::from_to($_, 'shiftjis', 'utf8'); }
}

if ($MenuData[0] eq '') { $MenuData[0]="/\tul\t\t\n"; }

##メニュー項目追加
my $format=$MenuLabel."\t".$MenuType."\t".$MenuGoto."\t".$MenuTarg."\t\n";
push(@MenuData,$format);

##メニュー定義ファイル書込
my $tmpfile = "$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR @MenuData;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuDataFile);

##メニューincファイル書式
($in{'DefDir'},$in{'DefTag'},$in{'DefCss'}) = split(/\t/,$MenuData[0]);
&MakeIncTag;

##メニューincファイル書込
$tmpfile = "$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $IncludeTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuIncFile);

$tmpfile = "../commons/$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $IncludeTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuIncCommons);


##★処理画面出力
my $jumpurl = "$cginame?mode=admin&amp;mz=$mz";
my $htJump = <<"htJump";
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>メニューゾーン$mz 追加処理</title>
<meta http-equiv="Refresh" content="1;url=$jumpurl">
<link rel="stylesheet" href="style.css" type="text/css">
</head>
<body bgcolor="#FFFFFF" text="#000000">
<h3 align="center">只今、メニューゾーン$mz の追加処理中です。</h3>
</body></html>
htJump

print "Content-type: text/html\n\n";
print $htJump;

exit;
}
##=======================================================================================
sub del {

##★フォーム取得処理
$mz = $in{'mz'};
my $delLine = $in{'line'};

my $MenuDataFile='./menu'.$mz.'.dat';
my $MenuIncFile ='./menu'.$mz.'.inc';
my $MenuIncCommons ='../commons/menu'.$mz.'.inc';

##メニュー定義ファイル読込
@MenuData=();
if (open(MENURD,"$MenuDataFile")) {
	@MenuData = <MENURD>;
	close(MENURD);
}
##コンテンツ文字コード判定→UTF8変換
my $contCC=&checkCharCode($MenuDataFile);
if ($contCC eq 'shiftjis') {
	foreach (@MenuData) { Encode::from_to($_, 'shiftjis', 'utf8'); }
}

##メニュー項目追加
splice(@MenuData, $delLine, 1);

##メニュー定義ファイル書込
my $tmpfile = "$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR @MenuData;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuDataFile);

##メニューincファイル書式
($in{'DefDir'},$in{'DefTag'},$in{'DefCss'}) = split(/\t/,$MenuData[0]);
&MakeIncTag;

##メニューincファイル書込
$tmpfile = "$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $IncludeTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuIncFile);

$tmpfile = "../commons/$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $IncludeTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuIncCommons);


##★処理画面出力
my $jumpurl = "$cginame?mode=admin&amp;mz=$mz";
my $htJump = <<"htJump";
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>メニューゾーン$mz 削除処理</title>
<meta http-equiv="Refresh" content="1;url=$jumpurl">
<link rel="stylesheet" href="style.css" type="text/css">
</head>
<body bgcolor="#FFFFFF" text="#000000">
<h3 align="center">只今、メニューゾーン$mz の削除処理中です。</h3>
</body></html>
htJump

print "Content-type: text/html\n\n";
print $htJump;

exit;
}
##=======================================================================================
sub mtregist {

##フォーム取得処理
$mz = $in{'mz'};
my $menutext = $in{'menutext'};
$menutext =~ s/\r\n/\n/g;
$menutext =~ s/\r/\n/g;
$menutext =~ s/\,/\t/g;

my $MenuDataFile='./menu'.$mz.'.dat';
my $MenuIncFile ='./menu'.$mz.'.inc';
my $MenuIncCommons ='../commons/menu'.$mz.'.inc';

#メニュー項目追加
@MenuData=split(/\n/,$menutext);
foreach (@MenuData) { $_=$_."\n"; }

##メニュー定義ファイル書込
my $tmpfile = "$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR @MenuData;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuDataFile);

##メニューincファイル書式
($in{'DefDir'},$in{'DefTag'},$in{'DefCss'}) = split(/\t/,$MenuData[0]);
&MakeIncTag;

##メニューincファイル書込
$tmpfile = "$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $IncludeTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuIncFile);

$tmpfile = "../commons/$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $IncludeTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuIncCommons);


##★処理画面出力
my $jumpurl = "$cginame?mode=admin&amp;mz=$mz";
my $htJump = <<"htJump";
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>メニューゾーン$mz 更新処理</title>
<meta http-equiv="Refresh" content="1;url=$jumpurl">
<link rel="stylesheet" href="style.css" type="text/css">
</head>
<body bgcolor="#FFFFFF" text="#000000">
<h3 align="center">只今、メニューゾーン$mz の更新処理中です。</h3>
</body></html>
htJump

print "Content-type: text/html\n\n";
print $htJump;

exit;
}
##=======================================================================================
sub sort {

##★フォーム取得処理
$mz = $in{'mz'};
my $key=$in{'key'};
my $MenuDataFile='./menu'.$mz.'.dat';
my $MenuIncFile ='./menu'.$mz.'.inc';
my $MenuIncCommons ='../commons/menu'.$mz.'.inc';

##メニュー定義ファイル読込
@MenuData=();
if (open(MENURD,"$MenuDataFile")) {
	@MenuData = <MENURD>;
	close(MENURD);
}
##コンテンツ文字コード判定→UTF8変換
my $contCC=&checkCharCode($MenuDataFile);
if ($contCC eq 'shiftjis') {
	foreach (@MenuData) { Encode::from_to($_, 'shiftjis', 'utf8'); }
}

##並び替え処理
my $switch=$key-1;
my $upContent;
my $dnContent;
if ($key > 1) {
	$upContent=$MenuData[$key];
	$dnContent=$MenuData[$switch];
	$MenuData[$key]=$dnContent;
	$MenuData[$switch]=$upContent;
}

##メニュー定義ファイル書込
my $tmpfile = "$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR @MenuData;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuDataFile);

##メニューincファイル書式
($in{'DefDir'},$in{'DefTag'},$in{'DefCss'}) = split(/\t/,$MenuData[0]);
&MakeIncTag;

##メニューincファイル書込
$tmpfile = "$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $IncludeTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuIncFile);

$tmpfile = "../commons/$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $IncludeTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuIncCommons);


##★処理画面出力
my $jumpurl = "$cginame?mode=admin&amp;mz=$mz";
my $htJump = <<"htJump";
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>メニューゾーン$mz 並び替え処理</title>
<meta http-equiv="Refresh" content="1;url=$jumpurl">
<link rel="stylesheet" href="style.css" type="text/css">
</head>
<body bgcolor="#FFFFFF" text="#000000">
<h3 align="center">只今、メニューゾーン$mz の並び替え処理中です。</h3>
</body></html>
htJump

print "Content-type: text/html\n\n";
print $htJump;

exit;
}
##=======================================================================================
sub label {

##★フォーム取得処理
$mz = $in{'mz'};
my $line=$in{'line'};
my $MenuDataFile='./menu'.$mz.'.dat';
my $MenuIncFile ='./menu'.$mz.'.inc';
my $MenuIncCommons ='../commons/menu'.$mz.'.inc';

##メニュー定義ファイル読込
@MenuData=();
if (open(MENURD,"$MenuDataFile")) {
	@MenuData = <MENURD>;
	close(MENURD);
}
##コンテンツ文字コード判定→UTF8変換
my $contCC=&checkCharCode($MenuDataFile);
if ($contCC eq 'shiftjis') {
	foreach (@MenuData) { Encode::from_to($_, 'shiftjis', 'utf8'); }
}

##ラベル名変更処理
my $TargLabel;my $TargDir;my $TargType;my $LinkTarg;
($TargLabel,$TargDir,$TargType,$LinkTarg) = split(/\t/,$MenuData[$line]);
$TargLabel =~ s/\r//g;	$TargLabel =~ s/\n//g;
$TargDir =~ s/\r//g;		$TargDir =~ s/\n//g;
$TargType =~ s/\r//g;		$TargType =~ s/\n//g;
$LinkTarg =~ s/\r//g;		$LinkTarg =~ s/\n//g;
$MenuData[$line]=$in{'newlabel'}."\t".$TargDir."\t".$TargType."\t".$LinkTarg."\t\n";

##メニュー定義ファイル書込
my $tmpfile = "$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR @MenuData;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuDataFile);

##メニューincファイル書式
($in{'DefDir'},$in{'DefTag'},$in{'DefCss'}) = split(/\t/,$MenuData[0]);
&MakeIncTag;

##メニューincファイル書込
$tmpfile = "$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $IncludeTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuIncFile);

$tmpfile = "../commons/$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $IncludeTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuIncCommons);


##★処理画面出力
my $jumpurl = "$cginame?mode=admin&amp;mz=$mz";
my $htJump = <<"htJump";
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>メニューゾーン$mz ラベル名変\更\処理</title>
<meta http-equiv="Refresh" content="1;url=$jumpurl">
<link rel="stylesheet" href="style.css" type="text/css">
</head>
<body bgcolor="#FFFFFF" text="#000000">
<h3 align="center">只今、メニューゾーン$mz ラベル名の変\更\処理中です。</h3>
</body></html>
htJump

print "Content-type: text/html\n\n";
print $htJump;

exit;
}
##=======================================================================================
sub remake {

my $rmz=0;
my $tmpfile;
my $MenuDataFile;
my $MenuIncFile;
my $MenuIncCommons;
for (0..19) {
	$rmz++;
	$mz=$rmz;
	$MenuDataFile='./menu'.$rmz.'.dat';
	$MenuIncFile ='./menu'.$rmz.'.inc';
	$MenuIncCommons ='../commons/menu'.$mz.'.inc';
	
	if (-e $MenuDataFile) {
		##メニュー定義ファイル読込
		@MenuData=();
		if (open(MENURD,"$MenuDataFile")) {
			@MenuData = <MENURD>;
			close(MENURD);
		}
		##コンテンツ文字コード判定→UTF8変換
		my $contCC=&checkCharCode($MenuDataFile);
		if ($contCC eq 'shiftjis') {
			foreach (@MenuData) { Encode::from_to($_, 'shiftjis', 'utf8'); }
		}
		if ($MenuData[0] eq '') { $MenuData[0]="/\tul\t\t\n"; }
		
		##メニューincファイル書式
		($in{'DefDir'},$in{'DefTag'},$in{'DefCss'}) = split(/\t/,$MenuData[0]);
		&MakeIncTag;
		##メニューincファイル書込
		$tmpfile = "$$\.tmp";
		if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
		print MENUWR $IncludeTag;
		close(MENUWR);
		chmod(oct($WRMode),$tmpfile);
		rename($tmpfile,$MenuIncFile);
		
		$tmpfile = "../commons/$$\.tmp";
		if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
		print MENUWR $IncludeTag;
		close(MENUWR);
		chmod(oct($WRMode),$tmpfile);
		rename($tmpfile,$MenuIncCommons);
	} else { last; }
}

##★処理画面出力
my $jumpurl = "$cginame?mode=admin&amp;mz=$mz";
my $htJump = <<"htJump";
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>メニューゾーン再出力</title>
<meta http-equiv="Refresh" content="1;url=$jumpurl">
<link rel="stylesheet" href="style.css" type="text/css">
</head>
<body bgcolor="#FFFFFF" text="#000000">
<h3 align="center">只今、メニューゾーンファイルの再出力処理中です。</h3>
</body></html>
htJump

print "Content-type: text/html\n\n";
print $htJump;

exit;
}
##=======================================================================================
sub MakeIncTag {

my $MenuRootPath;
my $CssNN;

if ($in{'DefCss'} ne '') { $CssTag=' class="'.$in{'DefCss'}.'"'; }
if ($in{'DefTag'} eq 'ol') { $IncludeTag='<ol'.$CssTag.'>'; }
if ($in{'DefTag'} eq 'ul') { $IncludeTag='<ul'.$CssTag.'>'; }
if ($in{'DefTag'} eq 'ap') { $IncludeTag=' | '; }

if ($RootPath ne '') { $MenuRootPath=$RootPath.'/'; } else  { $MenuRootPath=''; }

my $MenuLot=@MenuData-1;$mi=1;
my @MenuLine;
for (1..$MenuLot) {
	$MenuLine[0]='';
	if ($in{'DefCss'} ne '') { $CssNN=' class="'.$in{'DefCss'}.$mz.$mi.'"'; }
	$MenuData[$mi] =~ s/\r//g; $MenuData[$mi] =~ s/\n//g;
	@MenuLine=split(/\t/,$MenuData[$mi]);
	if ($MenuLine[3] ne '') { $MenuLine[3]=' target="'.$MenuLine[3].'"'; }
	if ($MenuLine[1] eq 'h2') {
		if ($in{'DefTag'} eq 'ol') { $IncludeTag=$IncludeTag.'</ol>'; }
		if ($in{'DefTag'} eq 'ul') { $IncludeTag=$IncludeTag.'</ul>'; }
		$IncludeTag=$IncludeTag.'<h2>'.$MenuLine[0].'</h2>';
		if ($in{'DefTag'} eq 'ol') { $IncludeTag=$IncludeTag.'<ol'.$CssTag.'>'; }
		if ($in{'DefTag'} eq 'ul') { $IncludeTag=$IncludeTag.'<ul'.$CssTag.'>'; }
	}
	if ($MenuLine[1] eq 'h3') {
		if ($in{'DefTag'} eq 'ol') { $IncludeTag=$IncludeTag.'</ol>'; }
		if ($in{'DefTag'} eq 'ul') { $IncludeTag=$IncludeTag.'</ul>'; }
		$IncludeTag=$IncludeTag.'<h3>'.$MenuLine[0].'</h3>';
		if ($in{'DefTag'} eq 'ol') { $IncludeTag=$IncludeTag.'<ol'.$CssTag.'>'; }
		if ($in{'DefTag'} eq 'ul') { $IncludeTag=$IncludeTag.'<ul'.$CssTag.'>'; }
	}
	if ($MenuLine[1] eq 'h4') {
		if ($in{'DefTag'} eq 'ol') { $IncludeTag=$IncludeTag.'</ol>'; }
		if ($in{'DefTag'} eq 'ul') { $IncludeTag=$IncludeTag.'</ul>'; }
		$IncludeTag=$IncludeTag.'<h4>'.$MenuLine[0].'</h4>';
		if ($in{'DefTag'} eq 'ol') { $IncludeTag=$IncludeTag.'<ol'.$CssTag.'>'; }
		if ($in{'DefTag'} eq 'ul') { $IncludeTag=$IncludeTag.'<ul'.$CssTag.'>'; }
	}
	if (($in{'DefTag'} eq 'a')&&($MenuLine[1] eq 'url')) {
		$IncludeTag=$IncludeTag.'<a href="'.$MenuLine[2].'"'.$CssNN.$MenuLine[3].'>'.$MenuLine[0].'</a>'."\n";
	}
	if (($in{'DefTag'} eq 'a')&&($MenuLine[1] eq 'dir')) {
		if (-e '../'.$MenuLine[2].'/index.html') {
			$IncludeTag=$IncludeTag.'<a href="'.$in{'DefDir'}.$MenuRootPath.$MenuLine[2].'/index.html"'.$CssNN.$MenuLine[3].'>'.$MenuLine[0].'</a>'."\n";
		} elsif (-e '../'.$MenuLine[2].'/index.cgi') {
			$IncludeTag=$IncludeTag.'<a href="'.$in{'DefDir'}.$MenuRootPath.$MenuLine[2].'/index.cgi"'.$CssNN.$MenuLine[3].'>'.$MenuLine[0].'</a>'."\n";
		}
	}
	if (($in{'DefTag'} eq 'ap')&&($MenuLine[1] eq 'url')) {
		$IncludeTag=$IncludeTag.'<a href="'.$MenuLine[2].'"'.$CssNN.$MenuLine[3].'>'.$MenuLine[0].'</a> | ';
	}
	if (($in{'DefTag'} eq 'ap')&&($MenuLine[1] eq 'dir')) {
		if (-e '../'.$MenuLine[2].'/index.html') {
			$IncludeTag=$IncludeTag.'<a href="'.$in{'DefDir'}.$MenuRootPath.$MenuLine[2].'/index.html"'.$CssNN.$MenuLine[3].'>'.$MenuLine[0].'</a> | ';
		} elsif (-e '../'.$MenuLine[2].'/index.cgi') {
			$IncludeTag=$IncludeTag.'<a href="'.$in{'DefDir'}.$MenuRootPath.$MenuLine[2].'/index.cgi"'.$CssNN.$MenuLine[3].'>'.$MenuLine[0].'</a> | ';
		}
	}
	if (($in{'DefTag'} eq 'abr')&&($MenuLine[1] eq 'url')) {
		$IncludeTag=$IncludeTag.'<a href="'.$MenuLine[2].'"'.$CssNN.$MenuLine[3].'>'.$MenuLine[0].'</a><br>';
	}
	if (($in{'DefTag'} eq 'abr')&&($MenuLine[1] eq 'dir')) {
		if (-e '../'.$MenuLine[2].'/index.html') {
			$IncludeTag=$IncludeTag.'<a href="'.$in{'DefDir'}.$MenuRootPath.$MenuLine[2].'/index.html"'.$CssNN.$MenuLine[3].'>'.$MenuLine[0].'</a><br>';
		} elsif (-e '../'.$MenuLine[2].'/index.cgi') {
			$IncludeTag=$IncludeTag.'<a href="'.$in{'DefDir'}.$MenuRootPath.$MenuLine[2].'/index.cgi"'.$CssNN.$MenuLine[3].'>'.$MenuLine[0].'</a><br>';
		}
	}
	if (($in{'DefTag'} eq 'ol')&&($MenuLine[1] eq 'url')) {
		$IncludeTag=$IncludeTag.'<li'.$CssNN.'><a href="'.$MenuLine[2].'"'.$MenuLine[3].'>'.$MenuLine[0].'</a></li>';
	}
	if (($in{'DefTag'} eq 'ol')&&($MenuLine[1] eq 'dir')) {
		if (-e '../'.$MenuLine[2].'/index.html') {
			$IncludeTag=$IncludeTag.'<li'.$CssNN.'><a href="'.$in{'DefDir'}.$MenuRootPath.$MenuLine[2].'/index.html"'.$MenuLine[3].'>'.$MenuLine[0].'</a></li>';
		} elsif (-e '../'.$MenuLine[2].'/index.cgi') {
			$IncludeTag=$IncludeTag.'<li'.$CssNN.'><a href="'.$in{'DefDir'}.$MenuRootPath.$MenuLine[2].'/index.cgi"'.$MenuLine[3].'>'.$MenuLine[0].'</a></li>';
		}
	}
	if (($in{'DefTag'} eq 'ul')&&($MenuLine[1] eq 'url')) {
		$IncludeTag=$IncludeTag.'<li'.$CssNN.'><a href="'.$MenuLine[2].'"'.$MenuLine[3].'>'.$MenuLine[0].'</a></li>';
	}
	if (($in{'DefTag'} eq 'ul')&&($MenuLine[1] eq 'dir')) {
		if (-e '../'.$MenuLine[2].'/index.html') {
			$IncludeTag=$IncludeTag.'<li'.$CssNN.'><a href="'.$in{'DefDir'}.$MenuRootPath.$MenuLine[2].'/index.html"'.$MenuLine[3].'>'.$MenuLine[0].'</a></li>';
		} elsif (-e '../'.$MenuLine[2].'/index.cgi') {
			$IncludeTag=$IncludeTag.'<li'.$CssNN.'><a href="'.$in{'DefDir'}.$MenuRootPath.$MenuLine[2].'/index.cgi"'.$MenuLine[3].'>'.$MenuLine[0].'</a></li>';
		}
	}
	$mi++;
}
if ($in{'DefTag'} eq 'ol') { $IncludeTag=$IncludeTag.'</ol>'; }
if ($in{'DefTag'} eq 'ul') { $IncludeTag=$IncludeTag.'</ul>'; }

$IncludeTag =~ s/<ul><\/ul>//g;
$IncludeTag =~ s/<ol><\/ol>//g;

if ($pcoutCode eq 'sjis') { Encode::from_to($IncludeTag, 'utf8', 'shiftjis'); }

}
##=======================================================================================
sub MakeIndexFile {

our $di;
our @DIRLIST=();
our @DIRLINE=();
our @DIRNAME=();
our @DirCONF=();
our $TargDir;
our $geturl;
our $checkurl;
our $delindex;
our $setindex;
our $veiwindex;
our $SkipOutIndex;
our $checkConf;
our $status;

##コンテンツ設定ファイル読込
if (open(DIRRD,"dir.dat")) {
	@DIRLIST = <DIRRD>;
	close(DIRRD);
}

##★処理画面出力
my $jumpurl = "$cginame?mode=admin&amp;mz=$mz";
my $htJump = <<"htJump";
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>コンテンツページ更\新\処理</title>
<meta http-equiv="Refresh" content="2;url=$jumpurl">
<link rel="stylesheet" href="style.css" type="text/css">
</head>
<body bgcolor="#FFFFFF" text="#000000">
<h3 align="center">只今、コンテンツページの更\新\処理中です。</h3>
<div align="center">
htJump

print "Content-type: text/html\n\n";
print $htJump;

$di=0;
foreach(@DIRLIST) {
	$SkipOutIndex=2;
	@DIRLINE=split(/\,/,$DIRLIST[$di]);
	$TargDir = $DIRLINE[0];
	$DIRLINE[1] =~ s/\r//g; $DIRLINE[1] =~ s/\n//g;
	if ($DIRLINE[1] ne 'other') {
		#URL取得
		if ($RootPath eq '') {
			$geturl = 'http://'.$Domain.'/'.$TargDir.'/index.cgi';
			$checkurl= '../'.$TargDir.'/index.cgi';
		} else {
			$geturl = 'http://'.$Domain.'/'.$RootPath.'/'.$TargDir.'/index.cgi';
			$checkurl= '../'.$TargDir.'/index.cgi';
		}
		
		#古いindex.htmlを削除
		$delindex='../'.$TargDir.'/index.html';
		unlink($delindex);
		
		#pgedit処理
		if ($DIRLINE[1] eq 'pgedit') {
			$checkConf='../'.$TargDir.'/conf.dat';
			if (open(chkCFRD,"$checkConf")) {
				our @DirCONF = <chkCFRD>;
				close(chkCFRD);
				##文字コード判定→UTF8変換
				my $contCC=&checkCharCode($checkConf);
				if ($contCC eq 'shiftjis') {
					foreach (@DirCONF) { Encode::from_to($_, 'shiftjis', 'utf8'); }
				}
			}
			$DirCONF[56] =~ s/\r//g; $DirCONF[56] =~ s/\n//g;
			if ($DirCONF[56] eq '') { $SkipOutIndex=1; }
		}
		#pgedit2処理
		if ($DIRLINE[1] eq 'pgedit2') {
			$checkConf='../'.$TargDir.'/conf.dat';
			if (open(chkCFRD,"$checkConf")) {
				our @DirCONF = <chkCFRD>;
				close(chkCFRD);
				##文字コード判定→UTF8変換
				my $contCC=&checkCharCode($checkConf);
				if ($contCC eq 'shiftjis') {
					foreach (@DirCONF) { Encode::from_to($_, 'shiftjis', 'utf8'); }
				}
			}
			$DirCONF[63] =~ s/\r//g; $DirCONF[63] =~ s/\n//g;
			if ($DirCONF[63] eq '') { $SkipOutIndex=1; }
		}
		#calender処理
		if ($DIRLINE[1] eq 'calender') {
			$checkConf='../'.$TargDir.'/conf.dat';
			if (open(chkCFRD,"$checkConf")) {
				our @DirCONF = <chkCFRD>;
				close(chkCFRD);
				##文字コード判定→UTF8変換
				my $contCC=&checkCharCode($checkConf);
				if ($contCC eq 'shiftjis') {
					foreach (@DirCONF) { Encode::from_to($_, 'shiftjis', 'utf8'); }
				}
			}
			$DirCONF[37] =~ s/\r//g; $DirCONF[37] =~ s/\n//g;
			if ($DirCONF[37] eq '') { $SkipOutIndex=1; }
		}
		#index.htmlを書き出し
		if ($SkipOutIndex == 2) {
			if (-e $checkurl) {
				$setindex='../'.$TargDir.'/index.html';
				$veiwindex = '/'.$TargDir.'/index.html';
				$status = &GetStore($geturl,$setindex);
				if ($status eq 'ok') {
					print $veiwindex.' を再出力しました<br>';
				} else {
					print '<font style="color:red">'.$veiwindex.' を再出力失敗</font><br>';
				}
			}
		}
	}
	$di++;
}


##★処理画面出力
$htJump = <<"htJump";
</div>
</body></html>
htJump
print $htJump;

exit;

}
##=======================================================================================
sub GetStore {
	use LWP::UserAgent;
	our $ua = LWP::UserAgent->new;
	my $re = $ua->simple_request(HTTP::Request->new(GET => $_[0]));
	if($re->code() == 200){
		open(my $IMG,">$_[1]");
		binmode($IMG);
		print $IMG $re->content();
		close($IMG);
		chmod(oct($WRMode),$_[1]);
		return 'ok';
	} else { 	return 'false'; }
}
##=======================================================================================
