#!/usr/local/bin/perl

##=======================================================================##
## AD-EDIT CORE v3.1.5
## (c)2008-2011 NorenzPRO Ltd. TalafumiArai 2011/1/20
##=======================================================================##
use CGI::Carp qw(fatalsToBrowser);

##=======================================================================##
## 設定項目
##=======================================================================##

##★ライブラリ
require './aelib.cgi';
use strict;
use CGI;
use Encode;

##★このスクリプトの名前
our $cginame = 'admobi.cgi';

##★ディレクトリ構成ファイル
our $dirfile = './dir.dat';

##★クッキーの名称
our $CookieName = 'AdminPass';

##★設定ファイルのパス
our $conffile = './conf.dat';

##★パスワードファイル
our $passfile='./pass.cgi';

##★データファイル
our $MenuDataFile='./mobi.dat';

##★携帯トップHTMLファイル
our $MenuHtmlFile ='../mobi/index.html';

##★携帯トップ用SSIファイル
our $MenuIncludeFile ='../mobi/menu.inc';

##★携帯スキンHTMLファイル
our $SkinHtmlFile ='../skin/mobi.html';

##=====================================================================================##
##メインルーチン
##=====================================================================================##

our $SourceTag;
our $MenuTag;
our $SkinTag;

##ディレクトリファイル読込
open(DIRRD,"$dirfile");
our @DIR = <DIRRD>;
close(DIRRD);

##システム設定ファイル読込
open(CONFRD,"$conffile");
our @CONF = <CONFRD>;
close(CONFRD);
our $DirMode =$CONF[0];
$DirMode =~ s/\r//g; $DirMode =~ s/\n//g;
our $ExecMode =$CONF[1];
$ExecMode =~ s/\r//g; $ExecMode =~ s/\n//g;
our $WRMode =$CONF[2];
$WRMode =~ s/\r//g; $WRMode =~ s/\n//g;
our $Domain =$CONF[3];
$Domain =~ s/\r//g; $Domain =~ s/\n//g;
our $PerlPath =$CONF[4];
$PerlPath =~ s/\r//g; $PerlPath =~ s/\n//g;
our $EditType =$CONF[5];
$EditType =~ s/\r//g; $EditType =~ s/\n//g;
our $EditName =$CONF[6];
$EditName =~ s/\r//g; $EditName =~ s/\n//g;
our $SendmailPath =$CONF[7];
$SendmailPath =~ s/\r//g; $SendmailPath =~ s/\n//g;
our $GmapAPIkey =$CONF[8];
$GmapAPIkey =~ s/\r//g; $GmapAPIkey =~ s/\n//g;
our $SysVersion =$CONF[9];
$SysVersion =~ s/\r//g; $SysVersion =~ s/\n//g;
our $RootPath =$CONF[10];
$RootPath =~ s/\r//g; $RootPath =~ s/\n//g;
our $LogoutTime =$CONF[11];
$LogoutTime =~ s/\r//g; $LogoutTime =~ s/\n//g;
our $PathConvert =$CONF[12];
$PathConvert =~ s/\r//g; $PathConvert =~ s/\n//g;
our $UpdateOut =$CONF[13];
$UpdateOut =~ s/\r//g; $UpdateOut =~ s/\n//g;
our $DefMainURL =$CONF[14];
$DefMainURL =~ s/\r//g; $DefMainURL =~ s/\n//g;
our $SearchSkinURL =$CONF[15];
$SearchSkinURL =~ s/\r//g; $SearchSkinURL =~ s/\n//g;
our $pcoutCode =$CONF[22];
$pcoutCode =~ s/\r//g; $pcoutCode =~ s/\n//g;
our $mboutCode =$CONF[23];
$mboutCode =~ s/\r//g; $mboutCode =~ s/\n//g;

if ($DirMode eq '') { $DirMode ='0755'; }
if ($ExecMode eq '') { $ExecMode ='0755'; }
if ($WRMode eq '') { $WRMode ='0666'; }
if ($PerlPath eq '') { $PerlPath ='#!/usr/local/bin/perl'; }
if ($DefMainURL eq '') { $DefMainURL ='main.html'; }
if ($SearchSkinURL eq '') { $SearchSkinURL ='/skin/skin.html'; }
our $vLogoutTime;
if ($LogoutTime eq '1800') { $vLogoutTime='30分'; }
elsif ($LogoutTime eq '3600') { $vLogoutTime='1時間'; }
elsif ($LogoutTime eq '10800') { $vLogoutTime='3時間'; }
elsif ($LogoutTime eq '21600') { $vLogoutTime='6時間'; }
elsif ($LogoutTime eq '43200') { $vLogoutTime='12時間'; }
elsif ($LogoutTime eq '86400') { $vLogoutTime='1日'; }
elsif ($LogoutTime eq '259200') { $vLogoutTime='3日'; }
elsif ($LogoutTime eq '604800') { $vLogoutTime='7日'; }
else { $LogoutTime='259200'; $vLogoutTime='3日'; }
if ($pcoutCode eq '') { $pcoutCode='sjis'; }
if ($mboutCode eq '') { $mboutCode='sjis'; }

##編集者IDパスワード読込
our $admin_id;
our $admin_pw;
if (open(PASSRD,"$passfile")) {
	my @PASSID = <PASSRD>;
	$admin_id =$PASSID[0];
	$admin_id =~ s/\r//g; $admin_id =~ s/\n//g;
	$admin_pw =$PASSID[1];
	$admin_pw =~ s/\r//g; $admin_pw =~ s/\n//g;
	$admin_pw =crypt($admin_pw,'ae');
	close(PASSRD);
} else { &error('パスワードファイル読込エラー'); }

##フォームの取得
our %in;
our @in;
my $query = CGI->new;
*in = $query->Vars();
foreach (%in) { 
	$_ =~ s/\xEF\xBD\x9E/\xE3\x80\x9C/g; 
	$_ =~ s/\xEF\xBC\x8D/\xE2\x88\x92/g; 
}

##メニュー定義ファイル読込
our @MenuData=();
if (open(MENURD,"$MenuDataFile")) {
	@MenuData = <MENURD>;
	close(MENURD);
}
##文字コード判定→UTF8変換
my $contCC=&checkCharCode($MenuDataFile);
if ($contCC eq 'shiftjis') {
	foreach (@MenuData) { Encode::from_to($_, 'shiftjis', 'utf8'); }
}

##==============メインアクション==============

## 管理者ログイン認証
our $ck_id; our $ck_pw;
our $c_id; our $c_pw;
if ($in{'loging'} eq "new") {
	# フォーム認証
	my $input_id = $in{'admin_id'};
	my $input_pw = $in{'admin_pw'};
	$input_pw =crypt($input_pw,'ae');
	if ($input_id ne "$admin_id") { &error('認証エラー'); }
	if ($input_pw ne "$admin_pw") { &error('認証エラー'); }
	&set_cookie;
	&admin;
} else {
	# クッキー認証
	&get_cookie;
	if (($ck_id eq "$admin_id")&&($ck_pw eq "$admin_pw")) {
		# 処理分岐
		if ($in{'mode'} eq 'admin') { &admin; }
		elsif ($in{'mode'} eq 'add') { &add; }
		elsif ($in{'mode'} eq 'del') { &del; }
		elsif ($in{'mode'} eq 'label') { &label; }
		elsif ($in{'mode'} eq 'defset') { &defset; }
		elsif ($in{'mode'} eq 'sort') { &sort; }
		else { &admin; }
	} else {
		&login;
	}
}

exit;

##=====================================================================================##
##サブルーチン
##=====================================================================================##
sub html_head {

##★HTMLヘッダの変更はここを訂正
my $html_head = <<"HTMLHEAD";
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>携帯メニュー設定</title>
<link rel="stylesheet" href="../admin/style.css" type="text/css">
<script language="JavaScript"><!--
function AddRows(targetObj) {
  var obj = document.getElementsByName(targetObj)[0];
  obj.rows = obj.rows+5;
}
--></script>
</head>
<body onload="javascript:parent.menu.location.href='menu.cgi'">
<h3 align=center>携帯メニュー設定</h3>
<div align=center>ここの設定の前に、
<img src=../icon/conf.gif align=absmiddle><a href="adedit.cgi">[コンテンツ設定]</a> にてコンテンツ登録を行ってください</div>
HTMLHEAD

print "Content-type: text/html\n\n";
print $html_head;

}
##=======================================================================================
sub html_foot {

##★HTMLフッタの変更はここを訂正
my $html_foot = <<"HTMLFOOT";
</body>
</html>
HTMLFOOT

print $html_foot;

}
##=======================================================================================
sub login {

##★ログイン画面の変更はここを訂正
my $html_login = <<"LOGINHTML";
<div align="center">
<form method="post" action="$cginame">
<br>
<h5 align=center style="color:red">セッションタイムアウト</h5>
<h4 align=center>管理画面 再ログイン</h4>
<div align=center>ログインID　<input type="text" name="admin_id" size="25" value="$ck_id" class="Hankaku"></div>
<div align=center>パスワード　<input type="password" name="admin_pw" size="25" value="$ck_pw" class="Hankaku"></div>
<div align="center">
<input type="submit" name="submit" value="ログイン">
<input type="reset" value="リセット">
<input type="hidden" name="mode" value="admin">
<input type="hidden" name="loging" value="new">
</div>
</form>
LOGINHTML

&html_head;
print $html_login;
&html_foot;

exit;
}
##=======================================================================================
sub admin {

&html_head;

##デフォルトバス
my $DefRootPath;
if ($RootPath ne '') { $DefRootPath='/'.$RootPath; } else  { $DefRootPath=''; }

##メニューリスト定義
my $MenuLot=@MenuData-1;my $mi=0;
my $TitleHtml;
my $BodyTag;
my $HeadHtml;
my $FootHtml;
my $ListTag;
my @MenuLine;
my @MenuLabel;
my @MenuType;
my @MenuContent;
my @vMenuType;
my @vMenuGoto;
my @ConfData;
for (0..$MenuLot) {
	@MenuLine=split(/\t/,$MenuData[$mi]);
	if ($mi==0) {
		##メニュー設定
		$TitleHtml=$MenuLine[0];
		$BodyTag=$MenuLine[1];
		$HeadHtml=$MenuLine[2];
		$FootHtml=$MenuLine[3];
		$TitleHtml =~ s/<br>/\n/g;
		$HeadHtml =~ s/<br>/\n/g;
		$FootHtml =~ s/<br>/\n/g;
	} else {
		##メニューリスト
		$MenuLabel[$mi]=$MenuLine[0];
		$MenuType[$mi]=$MenuLine[1];
		$MenuContent[$mi]=$MenuLine[2];
		##リンクタイプ取得
		if ($MenuType[$mi] eq 'dir') {
			$vMenuType[$mi]='コンテンツ';
			##コンテンツ調査
			my $ConfFile='../'.$MenuLine[2].'/conf.dat';
			if (open(CONFRD,"$ConfFile")) {
				@ConfData = <CONFRD>;
				close(CONFRD);
				##コンテンツ文字コード判定→UTF8変換
				my $contCC=&checkCharCode($ConfFile);
				if ($contCC eq 'shiftjis') {
					foreach (@ConfData) { Encode::from_to($_, 'shiftjis', 'utf8'); }
				}
				$vMenuGoto[$mi]=$ConfData[0]
			} else {
				$vMenuGoto[$mi]=$MenuLine[2];
			}
		} elsif ($MenuType[$mi] eq 'url') {
			$vMenuType[$mi]='URL';
			$vMenuGoto[$mi]=$MenuLine[2];
		} elsif ($MenuType[$mi] eq 'text') {
			$vMenuType[$mi]='テキスト文';
			$vMenuGoto[$mi]='-';
		} elsif ($MenuType[$mi] eq 'hr') {
			$vMenuType[$mi]='罫線 &lt;hr&gt;';
			$vMenuGoto[$mi]='-';
		}
		$MenuLabel[$mi] =~ s/\"/&quot;/g;
		$ListTag=$ListTag.'<tr><td><form action='.$cginame.' method=post>'
			.'<input type=submit value=▲><input type=hidden name=mode value=sort><input type=hidden name=key value='.$mi
			.'></form></td>'
			.'<td><form action='.$cginame.' method=post><input type=text name=newlabel value="'.$MenuLabel[$mi].'" size=40>'
			.'<input type=submit value="変更"><input type=hidden name=mode value=label>'
			.'<input type=hidden name=line value='.$mi.'></form></td>'
			.'<td>'.$vMenuGoto[$mi].'</td><td>'.$vMenuType[$mi].'</td>'
			.'<td><form action='.$cginame.' method=post>'
			.'<input type=submit value=メニュー削除><input type=hidden name=mode value=del>'
			.'<input type=hidden name=line value='.$mi.'></form></td></tr>';
	}
	$mi++;
}

##コンテンツリスト
my $DirLot=@DIR-1; my $dd=0;
my $dSelectGoto;my $tSelectGoto;
my $vSelectGoto;my $SelectGoto;
for (0..$DirLot) {
	($dSelectGoto,$tSelectGoto)=split(/\,/,$DIR[$dd]);
	##コンテンツ調査
	my $ConfFile='../'.$dSelectGoto.'/conf.dat';
	if (open(CONFRD,"$ConfFile")) {
		@ConfData = <CONFRD>;
		close(CONFRD);
		##コンテンツ文字コード判定→UTF8変換
		my $contCC=&checkCharCode($ConfFile);
		if ($contCC eq 'shiftjis') {
			foreach (@ConfData) { Encode::from_to($_, 'shiftjis', 'utf8'); }
		}
		$vSelectGoto=$ConfData[0];
	} else {
		$vSelectGoto=$dSelectGoto;
	}
	$vSelectGoto =~ s/\r//g;
	$vSelectGoto =~ s/\n//g;
	$SelectGoto=$SelectGoto.'  <option value="'.$dSelectGoto.'">'.$vSelectGoto.'</option>'."\n";
	$dd++;
}

##★変更画面の変更はここを訂正
my $htmlForm = <<"htmlForm";
<hr size="1" align="center">
  <h4 align="center">メニューリストの設定</h4>
<hr size="1" align="center">
<table width="95%" border="1" cellspacing="0" cellpadding="3" align="center" bgcolor="#FFFFFF">
<tr> 
  <td align="center" width=5%><b>順</b></td>
  <td align="center" width=30%><b>メニューラベル</b></td>
  <td align="center" width=30%><b>リンク先</b></td>
  <td align="center" width=25%><b>タイプ</b></td>
  <td align="center" width=10%><b>メニュー削除</b></td>
</tr>
$ListTag
</table>

<table width="95%" border=0 cellspacing=0 cellpadding=5 align="center">
<tr><td>
<form action="$cginame" method="post">
<br>
<strong>メニュー追加</strong>　<a href="adedit.cgi">[コンテンツ設定]</a>で登録された項目がリンク先に一覧表\示されます<br>
  　メニューラベル <input type=text name="MenuLabel" size=20>　
  リンク先 <select name="MenuGoto">
  <option value="url" selected>URLの場合のみ→</option>
  <option value="text">テキスト文</option>
  <option value="hr">罫線 - &lt;hr&gt;</option>
  $SelectGoto
  </select>　
  アドレス <input type=text name="MenuUrl" value='$DefRootPath/' size=30 class="Hankaku">　
  <input type=submit value="メニュー追加">
  <input type=hidden name="mode" value="add"><br>
  <br>
<strong>携帯メニューのSSIソースタグ</strong>　携帯サイトのトップメニューにもSSIが利用可能です<br>
  　 <input type="text" size="40" value="&lt;!--#include virtual=&quot;$DefRootPath/mobi/menu.inc&quot; --&gt;"><br>
  　※SSIファイルを利用するためには、<a href="adskin.cgi">[スキン編集]</a> にて/mobi/index.htmlを、*.shtml形式へ変更してください<br>
  　※/mobi/index.htmlが存在しない場合は、自動生成されませんので、<a href="adskin.cgi">[スキン編集]</a> にて作成してください<br>
</form>
</td></tr></table>

<hr size="1" align="center">
  <h4 align="center">デザインの設定</h4>
  <div align="center"><img src="../icon/conf.gif" align="absmiddle"><a href="adskin.cgi">[スキン編集]</a>
  にて直接HTMLソ\ース編集することもできます</div>
<hr size="1" align="center">
<table width="95%" border=0 cellspacing=0 cellpadding=5 align="center">
<tr><td>
  <form action=$cginame method=post>
  <strong>タイトル</strong>（全ページ共通）<br>
  　<input type=text name="TitleHtml" value="$TitleHtml" size=90><br>
  <br>
  <strong>BODYタグ</strong>（全ページ共通）<br>
  　<input type=text name="BodyTag" value='$BodyTag' size=90 class="Hankaku"><br>
  　 bgcolor = \"<a href=color.html target=tips>背景色</a>\"　
  text = \"<a href=color.html target=tips>文字色</a>\"　
  link = \"<a href=color.html target=tips>リンク文字色</a>\"　
  vlink = \"<a href=color.html target=tips>リンク文字の色(アクセス済)</a>\"<br>
  <br>
  <strong>ヘッダ</strong>（トップページのみ）<br>
  　<textarea type=text name="HeadHtml" rows="5" cols="80" onDblClick="AddRows('HeadHtml')">$HeadHtml</textarea><br>
  <br>
  　　　　△<br>
  　ここにメニューリストや本文などが挿入されます<br>
  　　　　▽<br>
  <br>
  <strong>フッタ</strong>（全ページ共通）<br>
  　<textarea type=text name="FootHtml" rows="5" cols="80" onDblClick="AddRows('FootHtml')">$FootHtml</textarea><br>
  <br>
  <input type=hidden name="mode" value="defset">
  　<input type=submit value="設定変更">
  </form>
</td>
<td valign=top><img src="img/mobi.gif"></td>
</tr></table>

htmlForm
print $htmlForm;
&html_foot;

exit;
}
##=======================================================================================
sub defset {

$in{'HeadHtml'} =~ s/\r\n/<br>/g;
$in{'HeadHtml'} =~ s/\r/<br>/g;
$in{'HeadHtml'} =~ s/\n/<br>/g;
$in{'FootHtml'} =~ s/\r\n/<br>/g;
$in{'FootHtml'} =~ s/\r/<br>/g;
$in{'FootHtml'} =~ s/\n/<br>/g;
$MenuData[0]=$in{'TitleHtml'}."\t".$in{'BodyTag'}."\t".$in{'HeadHtml'}."\t".$in{'FootHtml'}."\t\n";

##メニュー定義ファイル書込
my $tmpfile = "$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR @MenuData;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuDataFile);

##携帯HTMLファイル書式
&MakeHTML;

##携帯HTMLファイル書込
if (-e $MenuHtmlFile) {
	$tmpfile = "../mobi/$$\.tmp";
	if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
	print MENUWR $SourceTag;
	close(MENUWR);
	chmod(oct($WRMode),$tmpfile);
	rename($tmpfile,$MenuHtmlFile);
}

##携帯SSIファイル書込
$tmpfile = "../mobi/$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $MenuTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuIncludeFile);

##携帯スキン書込
$tmpfile = "../skin/$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $SkinTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$SkinHtmlFile);

##処理画面出力
my $jumpurl = "$cginame?mode=admin";
my $htJump = <<"htJump";
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>携帯サイト設定処理</title>
<meta http-equiv="Refresh" content="1;url=$jumpurl">
<link rel="stylesheet" href="style.css" type="text/css">
</head>
<body bgcolor="#FFFFFF" text="#000000">
<h3 align="center">只今、携帯サイトの設定処理中です。</h3>
</body></html>
htJump

print "Content-type: text/html\n\n";
print $htJump;

exit;
}
##=======================================================================================
sub add {

##★フォーム取得処理
my $MenuLabel = $in{'MenuLabel'};
my $MenuType;my $MenuGoto;
if ($in{'MenuGoto'} eq 'url') {
	$MenuType='url';
	$MenuGoto=$in{'MenuUrl'};
} elsif ($in{'MenuGoto'} eq 'text') {
	$MenuType='text';
	$MenuGoto=$in{'MenuGoto'};
} elsif ($in{'MenuGoto'} eq 'hr') {
	$MenuType='hr';
	$MenuGoto=$in{'MenuGoto'};
} else {
	$MenuType='dir';
	$MenuGoto=$in{'MenuGoto'};
}

##メニュー項目追加
my $format=$MenuLabel."\t".$MenuType."\t".$MenuGoto."\t\n";
push(@MenuData,$format);

##メニュー定義ファイル書込
my $tmpfile = "$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR @MenuData;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuDataFile);

##携帯HTMLファイル書式
($in{'TitleHtml'},$in{'BodyTag'},$in{'HeadHtml'},$in{'FootHtml'}) = split(/\t/,$MenuData[0]);
&MakeHTML;

##携帯HTMLファイル書込
if (-e $MenuHtmlFile) {
	$tmpfile = "../mobi/$$\.tmp";
	if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
	print MENUWR $SourceTag;
	close(MENUWR);
	chmod(oct($WRMode),$tmpfile);
	rename($tmpfile,$MenuHtmlFile);
}

##携帯SSIファイル書込
$tmpfile = "../mobi/$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $MenuTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuIncludeFile);

##携帯スキン書込
$tmpfile = "../skin/$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $SkinTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$SkinHtmlFile);

##★処理画面出力
my $jumpurl = "$cginame?mode=admin";
my $htJump = <<"htJump";
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>携帯サイトメニュー追加処理</title>
<meta http-equiv="Refresh" content="1;url=$jumpurl">
<link rel="stylesheet" href="style.css" type="text/css">
</head>
<body bgcolor="#FFFFFF" text="#000000">
<h3 align="center">只今、携帯サイトメニューの追加処理中です。</h3>
</body></html>
htJump

print "Content-type: text/html\n\n";
print $htJump;

exit;
}
##=======================================================================================
sub del {

##★フォーム取得処理
my $delLine = $in{'line'};

##メニュー項目追加
splice(@MenuData, $delLine, 1);

##メニュー定義ファイル書込
my $tmpfile = "$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR @MenuData;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuDataFile);

##携帯HTMLファイル書式
($in{'TitleHtml'},$in{'BodyTag'},$in{'HeadHtml'},$in{'FootHtml'}) = split(/\t/,$MenuData[0]);
&MakeHTML;

##携帯HTMLファイル書込
if (-e $MenuHtmlFile) {
	$tmpfile = "../mobi/$$\.tmp";
	if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
	print MENUWR $SourceTag;
	close(MENUWR);
	chmod(oct($WRMode),$tmpfile);
	rename($tmpfile,$MenuHtmlFile);
}

##携帯SSIファイル書込
$tmpfile = "../mobi/$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $MenuTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuIncludeFile);

##携帯スキン書込
$tmpfile = "../skin/$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $SkinTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$SkinHtmlFile);

##★処理画面出力
my $jumpurl = "$cginame?mode=admin";
my $htJump = <<"htJump";
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>携帯サイトメニュー削除処理</title>
<meta http-equiv="Refresh" content="1;url=$jumpurl">
<link rel="stylesheet" href="style.css" type="text/css">
</head>
<body bgcolor="#FFFFFF" text="#000000">
<h3 align="center">只今、携帯サイトメニューの削除処理中です。</h3>
</body></html>
htJump

print "Content-type: text/html\n\n";
print $htJump;

exit;
}
##=======================================================================================
sub sort {

##★フォーム取得処理
my $key=$in{'key'};

##並び替え処理
my $switch=$key-1;
my $upContent;my $dnContent;
if ($key > 1) {
	$upContent=$MenuData[$key];
	$dnContent=$MenuData[$switch];
	$MenuData[$key]=$dnContent;
	$MenuData[$switch]=$upContent;
}

##メニュー定義ファイル書込
my $tmpfile = "$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR @MenuData;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuDataFile);

##携帯HTMLファイル書式
($in{'TitleHtml'},$in{'BodyTag'},$in{'HeadHtml'},$in{'FootHtml'}) = split(/\t/,$MenuData[0]);
&MakeHTML;

##携帯HTMLファイル書込
if (-e $MenuHtmlFile) {
	$tmpfile = "../mobi/$$\.tmp";
	if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
	print MENUWR $SourceTag;
	close(MENUWR);
	chmod(oct($WRMode),$tmpfile);
	rename($tmpfile,$MenuHtmlFile);
}

##携帯SSIファイル書込
$tmpfile = "../mobi/$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $MenuTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuIncludeFile);

##携帯スキン書込
$tmpfile = "../skin/$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $SkinTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$SkinHtmlFile);

##★処理画面出力
my $jumpurl = "$cginame?mode=admin";
my $htJump = <<"htJump";
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>携帯サイトメニュー並び替え処理</title>
<meta http-equiv="Refresh" content="1;url=$jumpurl">
<link rel="stylesheet" href="style.css" type="text/css">
</head>
<body bgcolor="#FFFFFF" text="#000000">
<h3 align="center">只今、携帯サイトメニューの並び替え処理中です。</h3>
</body></html>
htJump

print "Content-type: text/html\n\n";
print $htJump;

exit;
}
##=======================================================================================
sub label {

##★フォーム取得処理
my $line=$in{'line'};

##ラベル名変更処理
my $TargLabel;my $TargDir;my $TargType;
($TargLabel,$TargDir,$TargType) = split(/\t/,$MenuData[$line]);
$MenuData[$line]=$in{'newlabel'}."\t".$TargDir."\t".$TargType."\t\n";

##メニュー定義ファイル書込
my $tmpfile = "$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR @MenuData;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuDataFile);

##携帯HTMLファイル書式
($in{'TitleHtml'},$in{'BodyTag'},$in{'HeadHtml'},$in{'FootHtml'}) = split(/\t/,$MenuData[0]);
&MakeHTML;

##携帯HTMLファイル書込
if (-e $MenuHtmlFile) {
	$tmpfile = "../mobi/$$\.tmp";
	if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
	print MENUWR $SourceTag;
	close(MENUWR);
	chmod(oct($WRMode),$tmpfile);
	rename($tmpfile,$MenuHtmlFile);
}

##携帯SSIファイル書込
$tmpfile = "../mobi/$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $MenuTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuIncludeFile);

##携帯スキン書込
$tmpfile = "../skin/$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $SkinTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$SkinHtmlFile);

##★処理画面出力
my $jumpurl = "$cginame?mode=admin";
my $htJump = <<"htJump";
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>携帯サイトメニュー並び替え処理</title>
<meta http-equiv="Refresh" content="1;url=$jumpurl">
<link rel="stylesheet" href="style.css" type="text/css">
</head>
<body bgcolor="#FFFFFF" text="#000000">
<h3 align="center">只今、携帯サイトメニューの並び替え処理中です。</h3>
</body></html>
htJump

print "Content-type: text/html\n\n";
print $htJump;

exit;
}
##=======================================================================================
sub MakeHTML {

my $mbsetCode;
if ($mboutCode eq 'sjis') { $mbsetCode='Shift_JIS'; } else {  $mbsetCode='UTF-8'; }

$MenuTag='';
$SourceTag = <<"HTMLHEAD";
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=$mbsetCode">
<title>$in{'TitleHtml'}</title>
</head>
$in{'BodyTag'}
$in{'HeadHtml'}
<hr>
HTMLHEAD

my $MenuLot=@MenuData-1;my $mi=1;
my @MenuLine;
for (1..$MenuLot) {
	@MenuLine=split(/\t/,$MenuData[$mi]);
	if ($MenuLine[1] eq 'url') {
		$MenuTag=$MenuTag.'<a href="'.$MenuLine[2].'">'.$MenuLine[0].'</a><br>'."\n";
	}
	if ($MenuLine[1] eq 'dir') {
		$MenuTag=$MenuTag.'<a href="../'.$MenuLine[2].'/mobi.cgi">'.$MenuLine[0].'</a><br>'."\n";
	}
	if ($MenuLine[1] eq 'text') {
		$MenuTag=$MenuTag.$MenuLine[0].'<br>'."\n";
	}
	if ($MenuLine[1] eq 'hr') {
		$MenuTag=$MenuTag.'<hr>'."\n";
	}
	$mi++;
}
$SourceTag = $SourceTag.$MenuTag.'';
$SourceTag = $SourceTag.'<hr>'.$in{'FootHtml'}."\n".'<body></html>';

$SkinTag = <<"HTMLHEAD";
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=$mbsetCode">
<title>$in{'TitleHtml'}</title>
</head>
$in{'BodyTag'}
<!-- MainZone -->
<hr>
$in{'FootHtml'}
<body></html>
HTMLHEAD

if ($mboutCode eq 'sjis') {
	Encode::from_to($SourceTag, 'utf8', 'shiftjis');
	Encode::from_to($MenuTag, 'utf8', 'shiftjis');
	Encode::from_to($SkinTag, 'utf8', 'shiftjis');
}

}
##=======================================================================================
