#!/usr/local/bin/perl

##=======================================================================##
## AD-EDIT GMAP v4.0.0
## (c)2008-2011 NorenzPRO Ltd. TakafumiArai 2011/11/13
##=======================================================================##
use CGI::Carp qw(fatalsToBrowser);

##=======================================================================##
## 設定項目
##=======================================================================##

##==============基本設定==============

##★ライブラリファイルのパス。
use Encode;
require '../admin/emoji.pl';
require '../admin/aelib.cgi';

##★データファイルのパス
$datafile = './data.dat';

##★このスクリプトの名前
$cginame = 'mobi.cgi';

##★アップロード画像格納ディレクトリ（相対・絶対パス）
$img_dir = './file/';

##★アップロード画像公開ディレクトリ（相対・絶対パス）
$img_path = './file/';

##=====================================================================================##
##メインルーチン
##=====================================================================================##

##キャリア識別
$ua = $ENV{"HTTP_USER_AGENT"};
if ($ua =~ /Android/i) { print "Location:smobi.cgi?".$ENV{'QUERY_STRING'}."\n\n"; exit; }
if ($ua =~ /iPhone/i) { print "Location:smobi.cgi?".$ENV{'QUERY_STRING'}."\n\n"; exit; }
if ($ua =~ /iPod/i) { print "Location:smobi.cgi?".$ENV{'QUERY_STRING'}."\n\n"; exit; }
if ($ua =~ /iPad/i) { print "Location:smobi.cgi?".$ENV{'QUERY_STRING'}."\n\n"; exit; }
if ($ua =~ /DoCoMo\/1\.0/i) { $xCR='dc'; }
elsif ($ua =~ /Mozilla/i) { $xCR='pc'; }
elsif ($ua =~ /(DoCoMo\/2\.0|FOMA)/i) { $xCR='dc'; }
elsif ($ua =~ /^(SoftBank|Vodafone|J\-PHONE|MOT\-[CV])/i) { $xCR='sb'; }
elsif ($ua =~ /^UP\.Browser/i) { $xCR='ez'; }
elsif ($ua =~ /^(KDDI\-|OPWV|MMP)/i) { $xCR='ez'; }
else { $xCR='pc'; }

##システム設定ファイル読込
$servconf = '../admin/conf.dat';
if (-e $servconf) {
	open(SVCFGRD,"$servconf");
	@SVCONF = <SVCFGRD>;
	close(SVCFGRD);
	##文字コード判定→UTF8変換
	my $contCC=&checkCharCode($servconf);
	if ($contCC eq 'shiftjis') {
		foreach (@SVCONF) { Encode::from_to($_, 'shiftjis', 'utf8'); }
	}
	$Domain =$SVCONF[3];
	$Domain =~ s/\r//g; $Domain =~ s/\n//g;
	$GmapAPIkey =$SVCONF[8];
	$GmapAPIkey =~ s/\r//g; $GmapAPIkey =~ s/\n//g;
	$RootPath =$SVCONF[10];
	$RootPath =~ s/\r//g; $RootPath =~ s/\n//g;
	$mboutCode =$SVCONF[23];
	$mboutCode =~ s/\r//g; $mboutCode =~ s/\n//g;
}
if ($mboutCode eq '') { $mboutCode='sjis'; }

##設定ファイル読込
$conffile='./conf.dat';
open(CONFRD,"$conffile");
@CONF = <CONFRD>;
close(CONFRD);
##文字コード判定→UTF8変換
my $contCC=&checkCharCode($conffile);
if ($contCC eq 'shiftjis') {
	foreach (@CONF) { Encode::from_to($_, 'shiftjis', 'utf8'); }
}
$MobiTitle =$CONF[11];
$MobiTitle =~ s/\r//g;$MobiTitle =~ s/\n//g;
$MobiColor =$CONF[12];
$MobiColor =~ s/\r//g;$MobiColor =~ s/\n//g;
$MobiView =$CONF[13];
$MobiView =~ s/\r//g;$MobiView =~ s/\n//g;
$mbHmark =$CONF[17];
$mbHmark =~ s/\r//g;$mbHmark =~ s/\n//g;
$mbHcolor =$CONF[18];
$mbHcolor =~ s/\r//g;$mbHcolor =~ s/\n//g;
$MobiHeadMsg =$CONF[20];
$MobiHeadMsg =~ s/\r//g;$MobiHeadMsg =~ s/\n//g;
$MobiHeadMsg = &inline_link($MobiHeadMsg);
$MobiHeadMsg = &tag_change($MobiHeadMsg);
$MobiBack =$CONF[23];
$MobiBack =~ s/\r//g;$MobiBack =~ s/\n//g;
$MobiNext =$CONF[24];
$MobiNext =~ s/\r//g;$MobiNext =~ s/\n//g;
$MobiToHome =$CONF[26];
$MobiToHome =~ s/\r//g;$MobiToHome =~ s/\n//g;
$MobiSkin =$CONF[27];
$MobiSkin =~ s/\r//g;$MobiSkin =~ s/\n//g;
$DirName =$CONF[31];
$DirName =~ s/\r//g;$DirName =~ s/\n//g;
$MobiHRcolor =$CONF[39];
$MobiHRcolor =~ s/\r//g;$MobiHRcolor =~ s/\n//g;
$hdMobiTitle =$CONF[41];
$hdMobiTitle =~ s/\r//g;$hdMobiTitle =~ s/\n//g;

$GmapKey=$GmapAPIkey;
if ($MobiSkin eq '') { $MobiSkin='/skin/mobi.html'; }
if ($MobiBack eq '') { $MobiBack='[＜前]'; }
if ($MobiNext eq '') { $MobiNext='[次＞]'; }
if ($MobiToHome eq '') { $MobiToHome='[HOME]'; }
if ($MobiHRcolor eq '') { $MobiHRcolor=''; } else { $MobiHRcolor=' color="'.$MobiHRcolor.'"'; }
if ($hdMobiTitle eq '') { $hdMobiTitle=$MobiTitle; }

##フォームの取得
$buffer = $ENV{'QUERY_STRING'};
@pairs = split(/&/,$buffer);
for $pair (@pairs) {
	($name, $value) = split(/=/, $pair);
	$value =~ tr/+/ /;
	$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
	if ($mboutCode eq 'sjis') { Encode::from_to($value, 'shiftjis', 'utf8'); }
	$in{$name} = $value;
}

##==============メインアクション==============

&list;
exit;

##=====================================================================================##
##サブルーチン
##=====================================================================================##
sub html_head {

if ($RootPath ne '') {
	$RssURL='http://'.$Domain.'/'.$RootPath.'/'.$DirName.'/rdfmb.cgi';
} else {
	$RssURL='http://'.$Domain.'/'.$DirName.'/rdfmb.cgi';
}
$RdfTag='<link rel="alternate" type="application/rss+xml" title="'.$hdMobiTitle.'" href="'.$RssURL.'" />';

#スキンページ読込
&page_read;

print "Content-type: text/html\n\n";
$phi=0;
foreach (@PHEAD) {
	$PHEAD[$phi]=~ s/<\/title>/ $hdMobiTitle<\/title>/g;
	$PHEAD[$phi]=~ s/<\/head>/$RdfTag\n<\/head>/g;
	if ($mboutCode eq 'sjis') { Encode::from_to($PHEAD[$phi], 'utf8', 'shiftjis'); }
	print $PHEAD[$phi];
	$phi++;
}
if ($MobiHeadMsg ne '') { $MobiHeadMsg='<br>'.$MobiHeadMsg; } else { $MobiHeadMsg=''; }
$htHead = <<"htHead";
<font color="$MobiColor">$MobiTitle</font>
$MobiHeadMsg
<hr$MobiHRcolor>
htHead
if ($mboutCode eq 'sjis') { Encode::from_to($htHead, 'utf8', 'shiftjis'); }
print $htHead;

}
##=======================================================================================
sub html_foot {

if ($MobiToHome ne 'none') { $TagHome='<hr'.$MobiHRcolor.'><a href="../mobi/">'.$MobiToHome.'</a>'; }

$htFoot = <<"htFoot";
$TagHome
htFoot
if ($mboutCode eq 'sjis') { Encode::from_to($htFoot, 'utf8', 'shiftjis'); }
print $htFoot;

#スキンページ読込
&page_read;
$pfi=0;
foreach (@PFOOT) {
	if ($mboutCode eq 'sjis') { Encode::from_to($PFOOT[$pfi], 'utf8', 'shiftjis'); }
	print $PFOOT[$pfi];
	$pfi++;
}

}
##=======================================================================================
sub list {

##★フォーム取得
$input_pline = $in{'pline'};

&html_head;
&html_list;
&html_foot;

exit;
}
##=======================================================================================
sub html_list {

##DATA取得
&data_read;
@TRUE = grep(/code=/,@DATA);
@NEW = grep(/\tshow=on\t/,@TRUE);

if ($in{'pline'} eq '') { $pline = 0; } else { $pline = $in{'pline'}; }
$end_data = @NEW - 1;
$page_top = $pline;
$page_end = $pline + ($MobiView - 1);
if ($page_end >= $end_data) { $page_end = $end_data; }

##LIST出力
foreach ($pline .. $page_end) {
	$f1_code=''; $f0_imgtag='';
	$f0_jpgpath=''; $h0_jpgpath='';
	$f0_gifpath=''; $h0_gifpath='';
	$f0_pngpath=''; $h0_pngpath='';
	@LINE = split(/\t/,$NEW[$_]);
	foreach (@LINE) {
		($key, $value) = split(/=/,$_);
		$value =~ s/\|eq\|/=/g;
		$value =~ s/\|quot\|/\"/g;
		$value =~ s/\|apos\|/\'/g;
		$FILE{$key} = $value;
	}
	$vCode = $FILE{'code'};
	$vShow = $FILE{'show'};
	$vTitle = $FILE{'title'};
		$vTitle = &tag_change($vTitle);
		$vTitle = &EmojiTagToGif($vTitle);
	$vMessage = $FILE{'message'};
		$vMessage =~ s/\|br\|//g;
		$vMessage = &inline_link($vMessage);
		$vMessage = &tag_change($vMessage);
		$vMessage = &EmojiTagToGif($vMessage);
		if ($vMessage ne "") { $vMessage=$vMessage.'<br>'; } else { $vMessage=''; }
	$vPhone = $FILE{'phone'};
		if ($vPhone ne "") { $vPhone='TEL: <a href="tel:'.$vPhone.'">'.$vPhone.'</a><br>'; } else { $vPhone=''; }
	$vFax = $FILE{'fax'};
		if ($vFax ne "") { $vFax='FAX: '.$vFax.'<br>'; } else { $vFax=''; }
	$vAlign = $FILE{'align'};
	$vIdo = $FILE{'ido'};
	$vKeido = $FILE{'keido'};
	##★画面リストの変更はここを訂正
	if ($vTitle ne '') {
		$htList='<a href="mbmap.cgi?code='.$vCode.'&pline='.$input_pline.'&align='.$vAlign.'">'.$mbHmark.$vTitle.'</a><br>'."\n";
	} else {
		$htList='<a href="mbmap.cgi?code='.$vCode.'&pline='.$input_pline.'&align='.$vAlign.'">'.$mbHmark.'詳細地図</a><br>'."\n";
	}
	if ($mboutCode eq 'sjis') { Encode::from_to($htList, 'utf8', 'shiftjis'); }
	print $htList;
}

$next_line = $page_end + 1;
$back_line = $page_top - $MobiView;

if (($page_top != 0)||($page_end != $end_data)) {
	print "<hr$MobiHRcolor>\n";
}
if (($page_top != 0)&&($MobiBack ne 'none')) {
	$tagNavigator= "<a href=\"$cginame?pline=$back_line\">$MobiBack</a>\n";
	if ($mboutCode eq 'sjis') { Encode::from_to($tagNavigator, 'utf8', 'shiftjis'); }
	print $tagNavigator;
}
if (($page_end != $end_data)&&($MobiNext ne 'none')) {
	$tagNavigator= "<a href=\"$cginame?pline=$next_line\">$MobiNext</a>\n";
	if ($mboutCode eq 'sjis') { Encode::from_to($tagNavigator, 'utf8', 'shiftjis'); }
	print $tagNavigator;
}


}
##=======================================================================================
sub data_read {
	if (open(DBREAD,"$datafile")) {
		@DATA = <DBREAD>;
		close(DBREAD);
		##文字コード判定→UTF8変換
		my $contCC=&checkCharCode($datafile);
		if ($contCC eq 'shiftjis') {
			foreach (@DATA) { Encode::from_to($_, 'shiftjis', 'utf8'); }
		}
	} else { &errorout('DBファイルの読込に失敗しました。'); }
}
##=======================================================================================
sub page_read {
	$rMobiSkin='..'.$MobiSkin;
	if (open(PAGEREAD,"$rMobiSkin")) {
		@PAGE = <PAGEREAD>;
		close(PAGEREAD);
		##文字コード判定→UTF8変換
		my $contCC=&checkCharCode($rMobiSkin);
		if ($contCC eq 'shiftjis') {
			foreach (@PAGE) { Encode::from_to($_, 'shiftjis', 'utf8'); }
		}
	} else {
		$alMobiSkin=$rMobiSkin; $alMobiSkin=~ s/\.\.//i;
		$PAGE[0] ='<html>'."\n";
		$PAGE[1] ='<head><meta http-equiv="Content-Type" content="text/html;charset='.$mboutCode.'"></head>'."\n";
		$PAGE[2] ='<body><font color="red">[設定]にて指定したスキンファイル ['.$alMobiSkin.'] が存在しません</font><br>'."\n";
		$PAGE[3] ='<font color="red">[設定]にて正しいスキンファイルを指定するか、[スキン編集]にて作成する必要があります</font>'."\n";
		$PAGE[4] ='<!-- MainZone -->'."\n";
		$PAGE[5] ='</body></html>'."\n";
	}
	$pageflag = 0;
	@PHEAD = (); @PFOOT = (); $pi = 0;
	foreach (@PAGE) {
		if ($PAGE[$pi] =~ /MainZone/i) { $pageflag = 1; }
		if ($pageflag==0) { push(@PHEAD,$PAGE[$pi]); }
		if ($pageflag==1) { push(@PFOOT,$PAGE[$pi]); }
		$pi++;
	}
}
##=======================================================================================
sub tag_change {
	##	$var = &tag_change($var); で変換する
	if ($RootPath ne '') { $TcRootPath='/'.$RootPath; } else { $TcRootPath=''; }
	local($_) = $_[0];
	1 while s/\[new\]/<img src=\"$TcRootPath\/icon\/new\.gif\" align=\"middle\" alt=\"new\" border=\"0\" \/>/g;
	1 while s/\[red\]/<font color=\"\#FF0000\">/g;
	1 while s/\[\/red\]/<\/font>/g;
	1 while s/\[blue\]/<font color=\"\#0000FF\">/g;
	1 while s/\[\/blue\]/<\/font>/g;
	1 while s/\[green\]/<font color=\"\#009900\">/g;
	1 while s/\[\/green\]/<\/font>/g;
	1 while s/AeDirTop/mobi.cgi/g;
	$_;
}
##=======================================================================================
sub errorout {

$error = $_[0];

##★エラーメッセージの変更はここを訂正
$errHTML = <<"ERRORMESS";
<font color="#ff0000">ERROR</font><br>
$error
ERRORMESS

if ($mboutCode eq 'sjis') { Encode::from_to($errHTML, 'utf8', 'shiftjis'); }
print $errHTML;
&html_foot;
exit;

}
##=======================================================================================
