#!/usr/local/bin/perl

##=======================================================================##
## AD-EDIT CALENDER v4.1.0
## (c)2008-2012 NorenzPRO Ltd. TakafumiArai 2012/6/7
##=======================================================================##
use CGI::Carp qw(fatalsToBrowser);

##=======================================================================##
## 設定項目
##=======================================================================##

##★ライブラリ
use CGI;
use Encode;
require './calendlib.pl';
require '../admin/emoji.pl';
require '../admin/aelib.cgi';

##★index.cgiのスクリプトの名前
our $cginame = 'index.cgi';

##★データファイルのパス
our $datafile = './data.dat';

##★休日や祝日のデータが入っているファイル。
$calenderfile = './calender.lib';

##★アップロード画像格納ディレクトリ（相対・絶対パス）
our $img_dir = './file/';

##★アップロード画像公開ディレクトリ（相対・絶対パス）
our $img_path = './file/';

##=====================================================================================##
##メインルーチン
##=====================================================================================##

our @DATA;
our @WRDATA;
our @CALENDER;

##システム設定ファイル読込
our $servconf = '../admin/conf.dat';
our @SVCONF;
if (-e $servconf) {
	open(SVCFGRD,"$servconf");
	@SVCONF = <SVCFGRD>;
	close(SVCFGRD);
	##文字コード判定→UTF8変換
	my $contCC=&checkCharCode($servconf);
	if ($contCC eq 'shiftjis') {
		foreach (@SVCONF) { Encode::from_to($_, 'shiftjis', 'utf8'); }
	}
}
our $Domain =$SVCONF[3];
$Domain =~ s/\r//g; $Domain =~ s/\n//g;
our $RootPath =$SVCONF[10];
$RootPath =~ s/\r//g; $RootPath =~ s/\n//g;
our $pcoutCode =$SVCONF[22];
$pcoutCode =~ s/\r//g; $pcoutCode =~ s/\n//g;

if ($pcoutCode eq '') { $pcoutCode='sjis'; }

##設定ファイル読込
our $conffile='./conf.dat';
our @CONF;
open(CONFRD,"$conffile");
@CONF = <CONFRD>;
close(CONFRD);
##文字コード判定→UTF8変換
my $contCC=&checkCharCode($conffile);
if ($contCC eq 'shiftjis') {
	foreach (@CONF) { Encode::from_to($_, 'shiftjis', 'utf8'); }
}
our $FileTypeLine =$CONF[1];
$FileTypeLine =~ s/\r//g;$FileTypeLine =~ s/\n//g;
our @FileType=split(/:/,$FileTypeLine);
our $DirName =$CONF[14];
$DirName =~ s/\r//g;$DirName =~ s/\n//g;
our $TimeStamp =$CONF[29];
$TimeStamp =~ s/\r//g;$TimeStamp =~ s/\n//g;
our $SSITitle =$CONF[38];
$SSITitle =~ s/\r//g;$SSITitle =~ s/\n//g;
our $SsiTitleClass =$CONF[39];
$SsiTitleClass =~ s/\r//g;$SsiTitleClass =~ s/\n//g;
our $ssiHeadMsg =$CONF[40];
$ssiHeadMsg =~ s/\r//g;$ssiHeadMsg =~ s/\n//g;
$ssiHeadMsg = &inline_link($ssiHeadMsg);
$ssiHeadMsg = &tag_change($ssiHeadMsg);
$ssiHeadMsg =~ s/<br>/<br \/>\&\#32\;/g;
our $SsiCalLayout =$CONF[41];
$SsiCalLayout =~ s/\r//g;$SsiCalLayout =~ s/\n//g;
our $ssiTxtDayColor =$CONF[42];
$ssiTxtDayColor =~ s/\r//g;$ssiTxtDayColor =~ s/\n//g;
our $ssiTxtSatColor =$CONF[43];
$ssiTxtSatColor =~ s/\r//g;$ssiTxtSatColor =~ s/\n//g;
our $ssiTxtHoliColor =$CONF[44];
$ssiTxtHoliColor =~ s/\r//g;$ssiTxtHoliColor =~ s/\n//g;
our $ssiBgDayColor =$CONF[45];
$ssiBgDayColor =~ s/\r//g;$ssiBgDayColor =~ s/\n//g;
our $ssiBgSatColor =$CONF[46];
$ssiBgSatColor =~ s/\r//g;$ssiBgSatColor =~ s/\n//g;
our $ssiBgHoliColor =$CONF[47];
$ssiBgHoliColor =~ s/\r//g;$ssiBgHoliColor =~ s/\n//g;
our $ssiNaviSkipBack =$CONF[48];
$ssiNaviSkipBack =~ s/\r//g;$ssiNaviSkipBack =~ s/\n//g;
our $ssiNaviBack =$CONF[49];
$ssiNaviBack =~ s/\r//g;$ssiNaviBack =~ s/\n//g;
our $ssiNaviCurrent =$CONF[50];
$ssiNaviCurrent =~ s/\r//g;$ssiNaviCurrent =~ s/\n//g;
our $ssiNaviNext =$CONF[51];
$ssiNaviNext =~ s/\r//g;$ssiNaviNext =~ s/\n//g;
our $ssiNaviSkipNext =$CONF[52];
$ssiNaviSkipNext =~ s/\r//g;$ssiNaviSkipNext =~ s/\n//g;

if ($SsiCalLayout eq '') { $SsiCalLayout='list'; }
if ($ssiTxtDayColor eq '') { $ssiTxtDayColor='#000000'; }
if ($ssiTxtSatColor eq '') { $ssiTxtSatColor='#0000CC'; }
if ($ssiTxtHoliColor eq '') { $ssiTxtHoliColor='#CC0000'; }
if ($ssiBgDayColor eq '') { $ssiBgDayColor='#FFFFFF'; }
if ($ssiBgSatColor eq '') { $ssiBgSatColor='#EEEEFF'; }
if ($ssiBgHoliColor eq '') { $ssiBgHoliColor='#FFEEEE'; }
if ($ssiNaviSkipBack eq '') { $ssiNaviSkipBack='[≪]'; }
if ($ssiNaviBack eq '') { $ssiNaviBack='[≪ＢＡＣＫ]'; }
if ($ssiNaviCurrent eq '') { $ssiNaviCurrent='[今月を表示]'; }
if ($ssiNaviNext eq '') { $ssiNaviNext='[ＮＥＸＴ≫]'; }
if ($ssiNaviSkipNext eq '') { $ssiNaviSkipNext='[≫]'; }

our $weekdaycolor=$ssiBgDayColor;
our $saturdaycolor=$ssiBgSatColor;
our $holidaycolor=$ssiBgHoliColor;
our $weekdaytextcolor=$ssiTxtDayColor;
our $saturdaytextcolor=$ssiTxtSatColor;
our $holidaytextcolor=$ssiTxtHoliColor;

##日付・時刻情報の取得
$ENV{'TZ'} = "JST-9";
our($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
$year += 1900;
$mon++;
$mon= sprintf("%02d",$mon);
$mday=sprintf("%02d",$mday);
$hour=sprintf("%02d",$mday);
$min= sprintf("%02d",$mday);
$youbi = ('日','月','火','水','木','金','土') [$wday];
$DATE = $year.'/'.$mon.'/'.$mday.' '.$hour.':'.min;

$vyear = $year;
$vmonth = $mon;
our $SsiRootPath;
if ($RootPath ne '') { $SsiRootPath='/'.$RootPath.'/'.$DirName.'/'; } else { $SsiRootPath='/'.$DirName.'/'; }
our $cgipath=$SsiRootPath.$cginame.'';

##==============メインアクション==============

print "Content-type: text/html\n\n";
&list;
exit;

##=====================================================================================##
##メインルーチン
##=====================================================================================##
sub list {

#★イニシャライズ
$view_month = int($vmonth);
$TableTitle = "$vyear"."年"." $view_month"."月";
$srcdate = "$vyear"."$vmonth";
$srcday = "$vyear"."$vmonth"."01";
$todaydate = "$year"."$mon";
$zennjitsuHoliFlag=0;
$zennjitsuHoliCheck=0;
$yokujitsuHoliFlag=0;

##★折畳み機能JS
$JsFols = <<"JsFols";
<script type="text/javascript">
function jsKiji(selectedID) {
  var xid; var targIDname; var obj;
  if(document.getElementById) {
    obj = document.getElementById(selectedID);
    if(obj) {
      if (obj.className == 'AeBoxDisplayHide') {
        obj.className = 'AeBoxDisplayShow';
      } else {
        obj.className = 'AeBoxDisplayHide';
      }
    }
  }
}
</script>
JsFols

#★データ読込
&data_read;
&calender_read;
$v_yearmonth = $srcdate;
$r_lastday = &calendlib'getmday($v_yearmonth);
$v_lastday = $r_lastday - 1;
$v_topweek = &calendlib'getweek($srcday);

#★曜日定義
if ($v_topweek eq "sun") { @v_youbi = ('日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土'); }
elsif ($v_topweek eq "mon") { @v_youbi = ('月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日'); }
elsif ($v_topweek eq "tue") { @v_youbi = ('火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月'); }
elsif ($v_topweek eq "wed") { @v_youbi = ('水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火'); }
elsif ($v_topweek eq "thu") { @v_youbi = ('木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水'); }
elsif ($v_topweek eq "fri") { @v_youbi = ('金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木'); }
elsif ($v_topweek eq "sat") { @v_youbi = ('土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金'); }
@v_weekcnt = ('1','1','1','1','1','1','1','2','2','2','2','2','2','2','3','3','3','3','3','3','3','4','4','4','4','4','4','4','5','5','5');

#★ナビボタン定義
if ($vmonth eq "01") {
	$nextyear = $vyear;		$nextmonth = int($vmonth)+1;
	$lastyear = $vyear-1;	$lastmonth = 12;
} elsif ($vmonth eq "12") {
	$nextyear = $vyear+1;	$nextmonth = 1;
	$lastyear = $vyear;		$lastmonth = int($vmonth)-1;
} else {
	$nextyear = $vyear;		$nextmonth = int($vmonth)+1;
	$lastyear = $vyear;		$lastmonth = int($vmonth)-1;
}
$nextmonth=sprintf("%02d",$nextmonth);
$lastmonth=sprintf("%02d",$lastmonth);
$MnextTag = "<a href=\"$cgipath?vyear=$nextyear&amp;vmonth=$nextmonth\">$ssiNaviNext</a>";
$MprevTag = "<a href=\"$cgipath?vyear=$lastyear&amp;vmonth=$lastmonth\">$ssiNaviBack</a>";
$vnextyear=$vyear+1;
$vprevyear=$vyear-1;
$YnextTag = "<a href=\"$cgipath?vyear=$vnextyear&amp;vmonth=$vmonth\">$ssiNaviSkipNext</a>";
$YprevTag = "<a href=\"$cgipath?vyear=$vprevyear&amp;vmonth=$vmonth\">$ssiNaviSkipBack</a>";
$CurrentTag = "<a href=\"$cgipath\">$ssiNaviCurrent</a>";

##★カレンダーテーブルの変更はここを訂正
if (($SsiCalLayout eq 'list')||($SsiCalLayout eq 'list2')) {
$htmlaList = <<"htLISTA";
<table class="AeCalTable" summary="$SSITitle">
  <tr>
    <th colspan="2" align="center">
    $YprevTag $MprevTag 　　　 <strong>$TableTitle</strong>$CurrentTag 　　　 $MnextTag $YnextTag
    </th>
  </tr>
htLISTA
} else {
$htmlaList = <<"htLISTA";
$JsFols
<table class="AeCalTable" summary="$SSITitle">
  <tr>
    <th colspan="7" align="center">
    $YprevTag $MprevTag 　　　 <strong>$TableTitle</strong>$CurrentTag 　　　 $MnextTag $YnextTag
    </th>
  </tr>
  <tr>
    <td style="color:$ssiTxtHoliColor;background-color:$ssiBgHoliColor;text-align:center;width:14\%;">日曜日 Sun</td>
    <td style="color:$ssiTxtDayColor;background-color:$ssiBgDayColor;text-align:center;width:14\%;">月曜日 Mon</td>
    <td style="color:$ssiTxtDayColor;background-color:$ssiBgDayColor;text-align:center;width:14\%;">火曜日 Tue</td>
    <td style="color:$ssiTxtDayColor;background-color:$ssiBgDayColor;text-align:center;width:14\%;">水曜日 Wed</td>
    <td style="color:$ssiTxtDayColor;background-color:$ssiBgDayColor;text-align:center;width:14\%;">木曜日 Thu</td>
    <td style="color:$ssiTxtDayColor;background-color:$ssiBgDayColor;text-align:center;width:14\%;">金曜日 Fri</td>
    <td style="color:$ssiTxtSatColor;background-color:$ssiBgSatColor;text-align:center;width:14\%;">土曜日 Sat</td>
  </tr>
htLISTA
}
$htmlbList = <<"htLISTB";
</table>
htLISTB

##★カレンダー出力
if ($SsiTitleClass ne '') { $addTitleClass=' class="'.$SsiTitleClass.'"'; }
if ($SSITitle ne '') {
	$tagMessage= '<h2'.$addTitleClass.'>'.$SSITitle.'</h2>';
	if ($pcoutCode eq 'sjis') { Encode::from_to($tagMessage, 'utf8', 'shiftjis'); }
	print $tagMessage;
}
if ($ssiHeadMsg ne '') {
	$tagMessage= '<div class="KijiArea"><p>'.$ssiHeadMsg.'</p></div>';
	if ($pcoutCode eq 'sjis') { Encode::from_to($tagMessage, 'utf8', 'shiftjis'); }
	print $tagMessage;
}
if ($pcoutCode eq 'sjis') { Encode::from_to($htmlaList, 'utf8', 'shiftjis'); }
print $htmlaList;
if (($SsiCalLayout eq 'list')||($SsiCalLayout eq 'list2')) { &listTable; } else { &listMatrix; }
if ($pcoutCode eq 'sjis') { Encode::from_to($htmlbList, 'utf8', 'shiftjis'); }
print $htmlbList;

exit;
}
##=======================================================================================
sub listTable {

$daycount=1;
$weekcount=0;

#暦情報取得(春分日/秋分日)
if ($vmonth eq '03') {
	my $spday=&calendlib'getspring($vyear);
	$spday=sprintf("%02d",$spday);
	my $spformat='monthday='.$vmonth.$spday."\t".'dayname=春分の日'."\t".'condition=holiday'."\t\n";
	push(@CALENDER,$spformat);
} elsif ($vmonth eq '09') {
	my $spday=&calendlib'getautmn($vyear);
	$spday=sprintf("%02d",$spday);
	my $spformat='monthday='.$vmonth.$spday."\t".'dayname=秋分の日'."\t".'condition=holiday'."\t\n";
	push(@CALENDER,$spformat);
}

#カレンダーリスト出力
for (0..$v_lastday) {
	$dayname='';
	$condition='';
	$daytablecolor = $weekdaycolor;
	$daytextcolor = $weekdaytextcolor;
	if ($a_furikae==1) { $b_furikae=1; }
	$yokujitsuHoliFlag=0;
	if ($zennjitsuHoliCheck==1) { $zennjitsuHoliCheck=0; $zennjitsuHoliFlag=1; }
	else { $zennjitsuHoliCheck=0; $zennjitsuHoliFlag=0; }
	#日数桁数調整
	if ($daycount < 10) { $caldaycount = "0"."$daycount"; }
	else { $caldaycount = $daycount; }
	#祝日判定(固定月日タイプ)
	$va_monthday = "$vmonth"."$caldaycount";
	@HOLIDAYA = grep(/monthday=$va_monthday/,@CALENDER);
	if (@HOLIDAYA) {
		@HALINE = split(/\t/,$HOLIDAYA[0]);
		foreach (@HALINE) {
			($key, $value) = split(/=/,$_);
			$HOLA{$key} = $value;
		}
		$dayname = $HOLA{'dayname'};
		$condition = $HOLA{'condition'};
		if ($HOLA{'condition'} eq 'holiday') { $zennjitsuHoliCheck=1; }
	}
	#祝日判定(第Ｘ曜日タイプ)
	if ($v_youbi[$weekcount] eq "日") { $vc_weekday = "sun"; }
	elsif ($v_youbi[$weekcount] eq "月") { $vc_weekday = "mon"; }
	elsif ($v_youbi[$weekcount] eq "火") { $vc_weekday = "tue"; }
	elsif ($v_youbi[$weekcount] eq "水") { $vc_weekday = "wed"; }
	elsif ($v_youbi[$weekcount] eq "木") { $vc_weekday = "thu"; }
	elsif ($v_youbi[$weekcount] eq "金") { $vc_weekday = "fri"; }
	elsif ($v_youbi[$weekcount] eq "土") { $vc_weekday = "sat"; }
	$vb_monthday = "$vmonth"."$vc_weekday"."$v_weekcnt[$weekcount]";
	@HOLIDAYB = grep(/monthday=$vb_monthday/,@CALENDER);
	if (@HOLIDAYB) {
		@HBLINE = split(/\t/,$HOLIDAYB[0]);
		foreach (@HBLINE) {
			($key, $value) = split(/=/,$_);
			$HOLB{$key} = $value;
		}
		$dayname = $HOLB{'dayname'};
		$condition = $HOLB{'condition'};
		if ($HOLB{'condition'} eq 'holiday') { $zennjitsuHoliCheck=1; }
	}
	#国民の休日判定(前後が祝日である)
	$xthisdate=$vyear.$vmonth.''.sprintf("%02d",$daycount);
	$xnextdate=&calendlib'gettomorrow($xthisdate);
	$xnextyear=substr($xnextdate,0,4);
	$xnextmon= substr($xnextdate,4,2);
	$xnextday= substr($xnextdate,6,2);
	if ($vc_weekday eq "sun") { $xnextweek = "mon"; }
	elsif ($vc_weekday eq "mon") { $xnextweek = "tue"; }
	elsif ($vc_weekday eq "tue") { $xnextweek = "wed"; }
	elsif ($vc_weekday eq "wed") { $xnextweek = "thu"; }
	elsif ($vc_weekday eq "thu") { $xnextweek = "fri"; }
	elsif ($vc_weekday eq "fri") { $xnextweek = "sat"; }
	elsif ($vc_weekday eq "sat") { $xnextweek = "sun"; }
	#翌日が固定月日タイプの祝日の場合
	@xNextHoliday=();
	@xNextHolipre=grep(/monthday=$xnextmon$xnextday\t/,@CALENDER);
	@xNextHoliday=grep(/\tcondition=holiday\t/,@xNextHolipre);
	$LotNextHoliday=@xNextHoliday;
	if ($LotNextHoliday>0) { $yokujitsuHoliFlag=1; }
	#翌日が第Ｘ曜日タイプの祝日の場合
	if ($daycount==$r_lastday) { $xnextwcount=1; } else { $xnextwcount=$v_weekcnt[$weekcount+1]; }
	@xNextHoliday=();
	@xNextHolipre=grep(/monthday=$xnextmon$xnextweek$xnextwcount\t/,@CALENDER);
	@xNextHoliday=grep(/\tcondition=holiday\t/,@xNextHolipre);
	$LotNextHoliday=@xNextHoliday;
	if ($LotNextHoliday>0) { $yokujitsuHoliFlag=1; }
	if (($zennjitsuHoliFlag==1)&&($yokujitsuHoliFlag==1)) {
		$daytablecolor = $holidaycolor;
		$daytextcolor = $holidaytextcolor;
		$daytablecolor = $holidaycolor;
		$daytextcolor = $holidaytextcolor;
		if ($dayname eq '') { $dayname = '国民の休日'; }
	}
	#振替休日判定
	if ($v_youbi[$weekcount] eq "日") { $daytablecolor = $holidaycolor; $daytextcolor = $holidaytextcolor; }
	if ($v_youbi[$weekcount] eq "土") { $daytablecolor = $saturdaycolor; $daytextcolor = $saturdaytextcolor;}
	if ($condition eq "holiday") {
		$daytablecolor = $holidaycolor;
		$daytextcolor = $holidaytextcolor;
		if ($v_youbi[$weekcount] eq "日") { $a_furikae=1; }
	}
	if (($b_furikae == 1) && ($condition ne "holiday")) {
		$daytablecolor = $holidaycolor;
		$daytextcolor = $holidaytextcolor;
		$dayname = '振替休日';
		$a_furikae=0;
	}
	
	#各日データ読込出力
	$v_thisday = "$srcdate"."$caldaycount";
	if ($in{'mode'} eq 'preview') {
		@VIEWDATA = grep(/code=$v_thisday/,@DATA);
	} else {
		@PRE = grep(/code=$v_thisday/,@DATA);
		@VIEWDATA = grep(/\tshow=on\t/,@PRE);
	}
	$v1_lot=@VIEWDATA;
	if ($v1_lot==0) { $v_rowspan=1; }
	elsif ($v1_lot==1) { $v_rowspan=1; }
	else { $v_rowspan= $v1_lot; }
	
	print"<tr>\n";
	print"  <td style=\"background-color:$daytablecolor;\" width=\"18\%\" rowspan=\"$v_rowspan\" align=\"center\">\n";
	$tagTable="  <span style=\"color:$daytextcolor;font-weight:bold;\">$daycount ($v_youbi[$weekcount])</span><br />$dayname</td>\n";
	if ($pcoutCode eq 'sjis') { Encode::from_to($tagTable, 'utf8', 'shiftjis'); }
	print $tagTable;
	if ($v1_lot != 0) {
		foreach $vd_line (@VIEWDATA) {
			@VIEWLINE = split(/\t/,$vd_line);
			foreach (@VIEWLINE) {
				($key, $value) = split(/=/,$_);
				$VIEWDATA{$key} = $value;
			}
			
			$v_code = $VIEWDATA{'code'};
			$v_show = $VIEWDATA{'show'};
			$v_date = $VIEWDATA{'date'};
			$v_title = $VIEWDATA{'title'};
				$v_title =~ s/\|br\|//g;
				$v_title =~ s/\|amp\|/\&/g;
				$v_title =~ s/\|eq\|/=/g;
				$v_title =~ s/\|quot\|/\"/g;
				$v_title =~ s/\|squot\|/\'/g;
				$v_title = &tag_change($v_title);
				$v_title = &EmojiTagToGif($v_title);
			$v_message = $VIEWDATA{'message'};
				$v_message =~ s/\|br\|//g;
				$v_message =~ s/\|amp\|/\&/g;
				$v_message =~ s/\|eq\|/=/g;
				$v_message =~ s/\|quot\|/\"/g;
				$v_message =~ s/\|squot\|/\'/g;
				$v_message = &inline_link($v_message);
				$v_message = &tag_change($v_message);
				$v_message = &EmojiTagToGif($v_message);
			$v_url = $VIEWDATA{'url'};
			$v_targ = $VIEWDATA{'targ'};
			$v_mrl = $VIEWDATA{'mrl'};
			##添付ファイルがあれば表示
			$FtLot=@FileType-1;$i=0;
			for (0..$FtLot) {
				$f_filepath = $img_dir.$v_code.'0.'.$FileType[$i];
				$h_filepath = $img_path.$v_code.'0.'.$FileType[$i];
				if ($FileType[$i] eq 'jpg') { $FtypeName='[JPG画像]'; }
				elsif ($FileType[$i] eq 'gif') { $FtypeName='[GIF画像]'; }
				elsif ($FileType[$i] eq 'png') { $FtypeName='[PNG画像]'; }
				elsif ($FileType[$i] eq 'doc') { $FtypeName='[WORD書類]'; }
				elsif ($FileType[$i] eq 'docx') { $FtypeName='[WORD2007書類]'; }
				elsif ($FileType[$i] eq 'xls') { $FtypeName='[EXCEL書類]'; }
				elsif ($FileType[$i] eq 'xlsx') { $FtypeName='[EXCEL2007書類]'; }
				elsif ($FileType[$i] eq 'ppt') { $FtypeName='[PPT書類]'; }
				elsif ($FileType[$i] eq 'pptx') { $FtypeName='[PPT2007書類]'; }
				elsif ($FileType[$i] eq 'jtd') { $FtypeName='[一太郎書類]'; }
				elsif ($FileType[$i] eq 'txt') { $FtypeName='[テキスト書類]'; }
				elsif ($FileType[$i] eq 'pdf') { $FtypeName='[PDF書類]'; }
				elsif ($FileType[$i] eq 'mp3') { $FtypeName='[MP3音声]'; }
				elsif ($FileType[$i] eq 'wma') { $FtypeName='[WMA音声]'; }
				elsif ($FileType[$i] eq 'mmf') { $FtypeName='[MMF音声]'; }
				elsif ($FileType[$i] eq 'mld') { $FtypeName='[MLD音声]'; }
				elsif ($FileType[$i] eq 'wmv') { $FtypeName='[WMV動画]'; }
				elsif ($FileType[$i] eq 'mp4') { $FtypeName='[MPEG4動画]'; }
				elsif ($FileType[$i] eq '3gp') { $FtypeName='[QuickTime動画]'; }
				elsif ($FileType[$i] eq '3g2') { $FtypeName='[QuickTime動画]'; }
				elsif ($FileType[$i] eq 'zip') { $FtypeName='[ZIPファイル]'; }
				elsif ($FileType[$i] eq 'lzh') { $FtypeName='[LZHファイル]'; }
				if (-e $f_filepath) {
					$v_filetag = '<a href='.$h_filepath.' target="_blank"><img src="../icon/'.$FileType[$i]
						.'.gif" align="middle" border="0" />'.$FtypeName.'</a>　';
					last;
				} else { $v_filetag=''; }
				if ($VIEWDATA{'url'} ne '') {
					$v_filetag = '<a href="'.$v_url.'" target="'.$v_targ.'">'
						.'<img src=../icon/home.gif align="middle" border="0" />[参照URL]</a>　';
				}
				$i++;
			}
			#記事出力
			&listBox;
			
			$v_code = "";
			$v_date = "";
		}
	} else {
		print"<td bgcolor=\"$daytablecolor\" width=\"82\%\">&nbsp;</td>\n";
	}
	print"</tr>\n";
	
	$daycount++;
	$weekcount++;
	$b_furikae=0;
}

}
##=======================================================================================
sub listBox {

if ($TimeStamp eq 'on') { $selDate=$v_date.' '; }
else { $selDate=''; }

##★リスト画面の変更はここを訂正
if ($SsiCalLayout eq 'list') {
$htmldList = <<"htLISTD";
<td bgcolor="$daytablecolor" width="82\%">
$selDate
<b>$v_title</b><br />
$v_message  $v_filetag
</td>
</tr>
<tr>
htLISTD
}
if ($SsiCalLayout eq 'list2') {
if ($daytablecolor eq $weekdaycolor) { $dtype='d'; }
if ($daytablecolor eq $saturdaycolor) { $dtype='s'; }
if ($daytablecolor eq $holidaycolor) { $dtype='h'; }
$htmldList = <<"htLISTD";
<td bgcolor="$daytablecolor" width="82\%">
$selDate
<a href="$cgipath?pg=$v_code&amp;d=$dtype&amp;vyear=$vyear&amp;vmonth=$vmonth"><b>$v_title</b></a>
</td>
</tr>
<tr>
htLISTD
}
if ($pcoutCode eq 'sjis') { Encode::from_to($htmldList, 'utf8', 'shiftjis'); }
print $htmldList;

}
##=======================================================================================
sub listMatrix {

$daycount=1;
$weekcount=0;
$sh=1000;

#暦情報取得(春分日/秋分日)
if ($vmonth eq '03') {
	my $spday=&calendlib'getspring($vyear);
	$spday=sprintf("%02d",$spday);
	my $spformat='monthday='.$vmonth.$spday."\t".'dayname=春分の日'."\t".'condition=holiday'."\t\n";
	push(@CALENDER,$spformat);
} elsif ($vmonth eq '09') {
	my $spday=&calendlib'getautmn($vyear);
	$spday=sprintf("%02d",$spday);
	my $spformat='monthday='.$vmonth.$spday."\t".'dayname=秋分の日'."\t".'condition=holiday'."\t\n";
	push(@CALENDER,$spformat);
}

our $MatrixNum=0;
if ($v_topweek eq 'sun') {
	$MatrixNum=0;
}
if ($v_topweek eq 'mon') {
	$startTdTag=$startTdTag.'<td style="background-color:'.$ssiBgHoliColor.'">&nbsp;</td>'."\n";
	$MatrixNum=1;
}
if ($v_topweek eq 'tue') {
	$startTdTag=$startTdTag.'<td style="background-color:'.$ssiBgHoliColor.'">&nbsp;</td>'."\n";
	$startTdTag=$startTdTag.'<td style="background-color:'.$ssiBgDayColor.'">&nbsp;</td>'."\n";
	$MatrixNum=2;
}
if ($v_topweek eq 'wed') {
	$startTdTag=$startTdTag.'<td style="background-color:'.$ssiBgHoliColor.'">&nbsp;</td>'."\n";
	$startTdTag=$startTdTag.'<td style="background-color:'.$ssiBgDayColor.'">&nbsp;</td>'."\n";
	$startTdTag=$startTdTag.'<td style="background-color:'.$ssiBgDayColor.'">&nbsp;</td>'."\n";
	$MatrixNum=3;
}
if ($v_topweek eq 'thu') {
	$startTdTag=$startTdTag.'<td style="background-color:'.$ssiBgHoliColor.'">&nbsp;</td>'."\n";
	$startTdTag=$startTdTag.'<td style="background-color:'.$ssiBgDayColor.'">&nbsp;</td>'."\n";
	$startTdTag=$startTdTag.'<td style="background-color:'.$ssiBgDayColor.'">&nbsp;</td>'."\n";
	$startTdTag=$startTdTag.'<td style="background-color:'.$ssiBgDayColor.'">&nbsp;</td>'."\n";
	$MatrixNum=4;
}
if ($v_topweek eq 'fri') {
	$startTdTag=$startTdTag.'<td style="background-color:'.$ssiBgHoliColor.'">&nbsp;</td>'."\n";
	$startTdTag=$startTdTag.'<td style="background-color:'.$ssiBgDayColor.'">&nbsp;</td>'."\n";
	$startTdTag=$startTdTag.'<td style="background-color:'.$ssiBgDayColor.'">&nbsp;</td>'."\n";
	$startTdTag=$startTdTag.'<td style="background-color:'.$ssiBgDayColor.'">&nbsp;</td>'."\n";
	$startTdTag=$startTdTag.'<td style="background-color:'.$ssiBgDayColor.'">&nbsp;</td>'."\n";
	$MatrixNum=5;
}
if ($v_topweek eq 'sat') {
	$startTdTag=$startTdTag.'<td style="background-color:'.$ssiBgHoliColor.'">&nbsp;</td>'."\n";
	$startTdTag=$startTdTag.'<td style="background-color:'.$ssiBgDayColor.'">&nbsp;</td>'."\n";
	$startTdTag=$startTdTag.'<td style="background-color:'.$ssiBgDayColor.'">&nbsp;</td>'."\n";
	$startTdTag=$startTdTag.'<td style="background-color:'.$ssiBgDayColor.'">&nbsp;</td>'."\n";
	$startTdTag=$startTdTag.'<td style="background-color:'.$ssiBgDayColor.'">&nbsp;</td>'."\n";
	$startTdTag=$startTdTag.'<td style="background-color:'.$ssiBgDayColor.'">&nbsp;</td>'."\n";
	$MatrixNum=6;
}

#カレンダーリスト出力
for (0..$v_lastday) {
	if ($MatrixNum==7) { print "</tr>\n"; $MatrixNum=0; }
	if (($MatrixNum==0)||($daycount==1)) { print "<tr>\n"; }
	if ($daycount==1) { print $startTdTag; }
	$dayname='';
	$condition='';
	$daytablecolor = $weekdaycolor;
	$daytextcolor = $weekdaytextcolor;
	if ($a_furikae==1) { $b_furikae=1; }
	$yokujitsuHoliFlag=0;
	if ($zennjitsuHoliCheck==1) { $zennjitsuHoliCheck=0; $zennjitsuHoliFlag=1; }
	else { $zennjitsuHoliCheck=0; $zennjitsuHoliFlag=0; }
	#日数桁数調整
	if ($daycount < 10) { $caldaycount = "0"."$daycount"; }
	else { $caldaycount = $daycount; }
	#祝日判定(固定月日タイプ)
	$va_monthday = "$vmonth"."$caldaycount";
	@HOLIDAYA = grep(/monthday=$va_monthday/,@CALENDER);
	if (@HOLIDAYA) {
		@HALINE = split(/\t/,$HOLIDAYA[0]);
		foreach (@HALINE) {
			($key, $value) = split(/=/,$_);
			$HOLA{$key} = $value;
		}
		$dayname = $HOLA{'dayname'};
		$condition = $HOLA{'condition'};
		if ($HOLA{'condition'} eq 'holiday') { $zennjitsuHoliCheck=1; }
	}
	#祝日判定(第Ｘ曜日タイプ)
	if ($v_youbi[$weekcount] eq "日") { $vc_weekday = "sun"; }
	elsif ($v_youbi[$weekcount] eq "月") { $vc_weekday = "mon"; }
	elsif ($v_youbi[$weekcount] eq "火") { $vc_weekday = "tue"; }
	elsif ($v_youbi[$weekcount] eq "水") { $vc_weekday = "wed"; }
	elsif ($v_youbi[$weekcount] eq "木") { $vc_weekday = "thu"; }
	elsif ($v_youbi[$weekcount] eq "金") { $vc_weekday = "fri"; }
	elsif ($v_youbi[$weekcount] eq "土") { $vc_weekday = "sat"; }
	$vb_monthday = "$vmonth"."$vc_weekday"."$v_weekcnt[$weekcount]";
	@HOLIDAYB = grep(/monthday=$vb_monthday/,@CALENDER);
	if (@HOLIDAYB) {
		@HBLINE = split(/\t/,$HOLIDAYB[0]);
		foreach (@HBLINE) {
			($key, $value) = split(/=/,$_);
			$HOLB{$key} = $value;
		}
		$dayname = $HOLB{'dayname'};
		$condition = $HOLB{'condition'};
		if ($HOLB{'condition'} eq 'holiday') { $zennjitsuHoliCheck=1; }
	}
	#国民の休日判定(前後が祝日である)
	$xthisdate=$vyear.$vmonth.''.sprintf("%02d",$daycount);
	$xnextdate=&calendlib'gettomorrow($xthisdate);
	$xnextyear=substr($xnextdate,0,4);
	$xnextmon= substr($xnextdate,4,2);
	$xnextday= substr($xnextdate,6,2);
	if ($vc_weekday eq "sun") { $xnextweek = "mon"; }
	elsif ($vc_weekday eq "mon") { $xnextweek = "tue"; }
	elsif ($vc_weekday eq "tue") { $xnextweek = "wed"; }
	elsif ($vc_weekday eq "wed") { $xnextweek = "thu"; }
	elsif ($vc_weekday eq "thu") { $xnextweek = "fri"; }
	elsif ($vc_weekday eq "fri") { $xnextweek = "sat"; }
	elsif ($vc_weekday eq "sat") { $xnextweek = "sun"; }
	#翌日が固定月日タイプの祝日の場合
	@xNextHoliday=();
	@xNextHolipre=grep(/monthday=$xnextmon$xnextday\t/,@CALENDER);
	@xNextHoliday=grep(/\tcondition=holiday\t/,@xNextHolipre);
	$LotNextHoliday=@xNextHoliday;
	if ($LotNextHoliday>0) { $yokujitsuHoliFlag=1; }
	#翌日が第Ｘ曜日タイプの祝日の場合
	if ($daycount==$r_lastday) { $xnextwcount=1; } else { $xnextwcount=$v_weekcnt[$weekcount+1]; }
	@xNextHoliday=();
	@xNextHolipre=grep(/monthday=$xnextmon$xnextweek$xnextwcount\t/,@CALENDER);
	@xNextHoliday=grep(/\tcondition=holiday\t/,@xNextHolipre);
	$LotNextHoliday=@xNextHoliday;
	if ($LotNextHoliday>0) { $yokujitsuHoliFlag=1; }
	if (($zennjitsuHoliFlag==1)&&($yokujitsuHoliFlag==1)) {
		$daytablecolor = $holidaycolor;
		$daytextcolor = $holidaytextcolor;
		$daytablecolor = $holidaycolor;
		$daytextcolor = $holidaytextcolor;
		if ($dayname eq '') { $dayname = '国民の休日'; }
	}
	#振替休日判定
	if ($v_youbi[$weekcount] eq "日") { $daytablecolor = $holidaycolor; $daytextcolor = $holidaytextcolor; }
	if ($v_youbi[$weekcount] eq "土") { $daytablecolor = $saturdaycolor; $daytextcolor = $saturdaytextcolor;}
	if ($condition eq "holiday") {
		$daytablecolor = $holidaycolor;
		$daytextcolor = $holidaytextcolor;
		if ($v_youbi[$weekcount] eq "日") { $a_furikae=1; }
	}
	if (($b_furikae == 1) && ($condition ne "holiday")) {
		$daytablecolor = $holidaycolor;
		$daytextcolor = $holidaytextcolor;
		$dayname = '振替休日';
		$a_furikae=0;
	}
	
	#各日データ読込出力
	$v_thisday = "$srcdate"."$caldaycount";
	if ($in{'mode'} eq 'preview') {
		@VIEWDATA = grep(/code=$v_thisday/,@DATA);
	} else {
		@PRE = grep(/code=$v_thisday/,@DATA);
		@VIEWDATA = grep(/\tshow=on\t/,@PRE);
	}
	$v1_lot=@VIEWDATA;
	
	print"  <td style=\"background-color:$daytablecolor;height:60px;\" valign=\"top\">\n";
	if ($dayname ne '') { $vDayname='<span style="font-size:smaller">'.$dayname.'</span>'; } else { $vDayname=''; }
	$tagTable="  <span style=\"color:$daytextcolor;font-weight:bold;\">$daycount</span> $vDayname<br />\n";
	if ($pcoutCode eq 'sjis') { Encode::from_to($tagTable, 'utf8', 'shiftjis'); }
	print $tagTable;
	if ($v1_lot != 0) {
		foreach $vd_line (@VIEWDATA) {
			@VIEWLINE = split(/\t/,$vd_line);
			foreach (@VIEWLINE) {
				($key, $value) = split(/=/,$_);
				$VIEWDATA{$key} = $value;
			}
			
			$v_code = $VIEWDATA{'code'};
			$v_show = $VIEWDATA{'show'};
			$v_date = $VIEWDATA{'date'};
			$v_title = $VIEWDATA{'title'};
				$v_title =~ s/\|br\|//g;
				$v_title =~ s/\|amp\|/\&/g;
				$v_title =~ s/\|eq\|/=/g;
				$v_title =~ s/\|quot\|/\"/g;
				$v_title =~ s/\|squot\|/\'/g;
				$v_title = &tag_change($v_title);
				$v_title = &EmojiTagToGif($v_title);
			$v_message = $VIEWDATA{'message'};
				$v_message =~ s/\|br\|//g;
				$v_message =~ s/\|amp\|/\&/g;
				$v_message =~ s/\|eq\|/=/g;
				$v_message =~ s/\|quot\|/\"/g;
				$v_message =~ s/\|squot\|/\'/g;
				$v_message = &inline_link($v_message);
				$v_message = &tag_change($v_message);
				$v_message = &EmojiTagToGif($v_message);
			$v_url = $VIEWDATA{'url'};
			$v_targ = $VIEWDATA{'targ'};
			$v_mrl = $VIEWDATA{'mrl'};
			##添付ファイルがあれば表示
			$FtLot=@FileType-1;$i=0;
			for (0..$FtLot) {
				$f_filepath = $img_dir.$v_code.'0.'.$FileType[$i];
				$h_filepath = $img_path.$v_code.'0.'.$FileType[$i];
				if ($FileType[$i] eq 'jpg') { $FtypeName='[JPG画像]'; }
				elsif ($FileType[$i] eq 'gif') { $FtypeName='[GIF画像]'; }
				elsif ($FileType[$i] eq 'png') { $FtypeName='[PNG画像]'; }
				elsif ($FileType[$i] eq 'doc') { $FtypeName='[WORD書類]'; }
				elsif ($FileType[$i] eq 'docx') { $FtypeName='[WORD2007書類]'; }
				elsif ($FileType[$i] eq 'xls') { $FtypeName='[EXCEL書類]'; }
				elsif ($FileType[$i] eq 'xlsx') { $FtypeName='[EXCEL2007書類]'; }
				elsif ($FileType[$i] eq 'ppt') { $FtypeName='[PPT書類]'; }
				elsif ($FileType[$i] eq 'pptx') { $FtypeName='[PPT2007書類]'; }
				elsif ($FileType[$i] eq 'jtd') { $FtypeName='[一太郎書類]'; }
				elsif ($FileType[$i] eq 'txt') { $FtypeName='[テキスト書類]'; }
				elsif ($FileType[$i] eq 'pdf') { $FtypeName='[PDF書類]'; }
				elsif ($FileType[$i] eq 'mp3') { $FtypeName='[MP3音声]'; }
				elsif ($FileType[$i] eq 'wma') { $FtypeName='[WMA音声]'; }
				elsif ($FileType[$i] eq 'mmf') { $FtypeName='[MMF音声]'; }
				elsif ($FileType[$i] eq 'mld') { $FtypeName='[MLD音声]'; }
				elsif ($FileType[$i] eq 'wmv') { $FtypeName='[WMV動画]'; }
				elsif ($FileType[$i] eq 'mp4') { $FtypeName='[MPEG4動画]'; }
				elsif ($FileType[$i] eq '3gp') { $FtypeName='[QuickTime動画]'; }
				elsif ($FileType[$i] eq '3g2') { $FtypeName='[QuickTime動画]'; }
				elsif ($FileType[$i] eq 'zip') { $FtypeName='[ZIPファイル]'; }
				elsif ($FileType[$i] eq 'lzh') { $FtypeName='[LZHファイル]'; }
				if (-e $f_filepath) {
					$v_filetag = '<a href='.$h_filepath.' target="_blank"><img src="../icon/'.$FileType[$i]
						.'.gif" align="middle" border="0" />'.$FtypeName.'</a>　';
					last;
				} else { $v_filetag=''; }
				$i++;
			}
			if ($VIEWDATA{'url'} ne '') {
				$v_filetag = '<a href="'.$v_url.'" target="'.$v_targ.'">'
					.'<img src=../icon/home.gif align="middle" border="0" />[参照URL]</a>　';
			}
			#記事出力
			&matrixBox;
			
			$sh++;
			$v_code = "";
			$v_date = "";
		}
	}
	print "</td>\n";
	if ($v_lastday==$weekcount) {
		if ($MatrixNum==0) {
			$endTdTag=$endTdTag.'<td style="background-color:'.$ssiBgDayColor.'">&nbsp;</td>'."\n";
			$endTdTag=$endTdTag.'<td style="background-color:'.$ssiBgDayColor.'">&nbsp;</td>'."\n";
			$endTdTag=$endTdTag.'<td style="background-color:'.$ssiBgDayColor.'">&nbsp;</td>'."\n";
			$endTdTag=$endTdTag.'<td style="background-color:'.$ssiBgDayColor.'">&nbsp;</td>'."\n";
			$endTdTag=$endTdTag.'<td style="background-color:'.$ssiBgDayColor.'">&nbsp;</td>'."\n";
			$endTdTag=$endTdTag.'<td style="background-color:'.$ssiBgSatColor.'">&nbsp;</td>'."\n</tr>\n";
		}
		if ($MatrixNum==1) {
			$endTdTag=$endTdTag.'<td style="background-color:'.$ssiBgDayColor.'">&nbsp;</td>'."\n";
			$endTdTag=$endTdTag.'<td style="background-color:'.$ssiBgDayColor.'">&nbsp;</td>'."\n";
			$endTdTag=$endTdTag.'<td style="background-color:'.$ssiBgDayColor.'">&nbsp;</td>'."\n";
			$endTdTag=$endTdTag.'<td style="background-color:'.$ssiBgDayColor.'">&nbsp;</td>'."\n";
			$endTdTag=$endTdTag.'<td style="background-color:'.$ssiBgSatColor.'">&nbsp;</td>'."\n</tr>\n";
		}
		if ($MatrixNum==2) {
			$endTdTag=$endTdTag.'<td style="background-color:'.$ssiBgDayColor.'">&nbsp;</td>'."\n";
			$endTdTag=$endTdTag.'<td style="background-color:'.$ssiBgDayColor.'">&nbsp;</td>'."\n";
			$endTdTag=$endTdTag.'<td style="background-color:'.$ssiBgDayColor.'">&nbsp;</td>'."\n";
			$endTdTag=$endTdTag.'<td style="background-color:'.$ssiBgSatColor.'">&nbsp;</td>'."\n</tr>\n";
		}
		if ($MatrixNum==3) {
			$endTdTag=$endTdTag.'<td style="background-color:'.$ssiBgDayColor.'">&nbsp;</td>'."\n";
			$endTdTag=$endTdTag.'<td style="background-color:'.$ssiBgDayColor.'">&nbsp;</td>'."\n";
			$endTdTag=$endTdTag.'<td style="background-color:'.$ssiBgSatColor.'">&nbsp;</td>'."\n</tr>\n";
		}
		if ($MatrixNum==4) {
			$endTdTag=$endTdTag.'<td style="background-color:'.$ssiBgDayColor.'">&nbsp;</td>'."\n";
			$endTdTag=$endTdTag.'<td style="background-color:'.$ssiBgSatColor.'">&nbsp;</td>'."\n</tr>\n";
		}
		if ($MatrixNum==5) {
			$endTdTag=$endTdTag.'<td style="background-color:'.$ssiBgSatColor.'">&nbsp;</td>'."\n</tr>\n";
		}
		if ($MatrixNum==6) {
			$endTdTag=$endTdTag."\n</tr>\n";
		}
		print $endTdTag;
	}
	if ($MatrixNum==7) { print "</tr>\n"; }
	
	$daycount++;
	$weekcount++;
	$MatrixNum++;
	$b_furikae=0;
}

}
##=======================================================================================
sub matrixBox {

if ($TimeStamp eq 'on') { $selDate=$v_date.'<br />'; }
else { $selDate=''; }

if ($SsiCalLayout eq 'matrix') {
##★リスト画面の変更はここを訂正
$htmldList = <<"htLISTD";
$selDate
<a href="javascript:void(0);" onclick="javascript:jsKiji('xKiji$sh');" style="font-weight:bold;">$v_title</a>
<div id="xKiji$sh" class="AeBoxDisplayHide">
<p class="AePopupBox">
<a href="javascript:void(0);" onclick="javascript:jsKiji('xKiji$sh');"><img src="../icon/close.gif" align="right" border="0" /></a>
$selDate <span style="font-weight:bold;">$v_title</span></p>
$v_message  $v_filetag
</div>
htLISTD
}
if ($SsiCalLayout eq 'matrix2') {
if ($daytablecolor eq $weekdaycolor) { $dtype='d'; }
if ($daytablecolor eq $saturdaycolor) { $dtype='s'; }
if ($daytablecolor eq $holidaycolor) { $dtype='h'; }
##★リスト画面の変更はここを訂正
$htmldList = <<"htLISTD";
$selDate
<a href="$cgipath?pg=$v_code&amp;d=$dtype&amp;vyear=$vyear&amp;vmonth=$vmonth" style="font-weight:bold;">$v_title</a>
htLISTD
}

if ($pcoutCode eq 'sjis') { Encode::from_to($htmldList, 'utf8', 'shiftjis'); }
print $htmldList;

}
##=======================================================================================
sub data_read {
	if (open(DBREAD,"$datafile")) {
		@DATA = <DBREAD>;
		close(DBREAD);
		##文字コード判定→UTF8変換
		my $contCC=&checkCharCode($datafile);
		if ($contCC eq 'shiftjis') {
			foreach (@DATA) { Encode::from_to($_, 'shiftjis', 'utf8'); }
		}
	} else { &errorout('DBファイルの読込に失敗しました。'); }
}
##=======================================================================================
sub calender_read {
	if (open(CLDREAD,"$calenderfile")) {
		@CALENDER = <CLDREAD>;
		close(CLDREAD);
		##文字コード判定→UTF8変換
		my $contCC=&checkCharCode($calenderfile);
		if ($contCC eq 'shiftjis') {
			foreach (@CALENDER) { Encode::from_to($_, 'shiftjis', 'utf8'); }
		}
	} else { &errorout('カレンダー祝日定義ファイルが存在しません'); }
}
##=======================================================================================
sub tag_change {
	##	$var = &tag_change($var); で変換する
	if ($RootPath ne '') { $TcRootPath='/'.$RootPath; } else { $TcRootPath=''; }
	local($_) = $_[0];
	1 while s/\[new\]/<img src=\"$TcRootPath\/icon\/new\.gif\" align=\"middle\" alt=\"new\" border=\"0\" \/>/g;
	1 while s/\[red\]/<span style=\"color\:\#FF0000\">/g;
	1 while s/\[\/red\]/<\/span>/g;
	1 while s/\[blue\]/<span style=\"color\:\#0000FF\">/g;
	1 while s/\[\/blue\]/<\/span>/g;
	1 while s/\[green\]/<span style=\"color\:\#009900\">/g;
	1 while s/\[\/green\]/<\/span>/g;
	1 while s/\/TD>/\/td>/g;
	1 while s/<TD/<td/g;
	1 while s/\/TR>/\/tr>/g;
	1 while s/<TR/<tr/g;
	1 while s/\/TABLE>/\/table>/g;
	1 while s/<TABLE/<table/g;
	1 while s/\/TBODY>/\/tbody>/g;
	1 while s/<TBODY/<tbody/g;
	1 while s/AeDirTop/index.cgi/g;
	$_;
}
##=======================================================================================
sub errorout {

$error = $_[0];


##★エラーメッセージの変更はここを訂正
$errHTML = <<"ERRORMESS";
<h4 align="center"><span style="color:#ff0000">ERROR</span></h4>
<div align="center">&nbsp;<br>$error<br>&nbsp;</div>
ERRORMESS

if ($pcoutCode eq 'sjis') { Encode::from_to($errHTML, 'utf8', 'shiftjis'); }
print $errHTML;
exit;

}
##=======================================================================================
