
# script for GNU-Ada on OSX

rm *.o
rm obj/*

export GROOT=/opt/gcc-11.2.0/bin
export PATH=$GROOT:$PATH

export SDKROOT=$(xcrun --show-sdk-path)

export FWROOT=/System/Library/Frameworks



$GROOT/g++ -c ../OalBinding/oal.cpp \
-std=c++11 \
-fpermissive \
-I.. \
-I../OalBinding \
-I../OalBinding/incoal




$GROOT/gnatmake $1 \
-o $1_osx \
-D obj \
-I.. -I../OalBinding \
-largs \
oal.o \
-L$SDKROOT/usr/lib \
-lstdc++ \
\
-F$FWROOT \
-framework CoreAudio \
-framework AudioUnit \
-framework AudioToolBox \
-framework OpenAL \
-pthread 

rm *.o
rm *.ali

