/*
 * Decompiled with CFR 0.152.
 */
package asandatabasebrowser;

import asandatabasebrowser.model.DbData;
import asandatabasebrowser.model.DbException;
import asandatabasebrowser.model.DbLargeObject;
import asandatabasebrowser.model.FavoriteSQL;
import asandatabasebrowser.model.FavoriteTable;
import asandatabasebrowser.model.ITableInfo;
import asandatabasebrowser.model.SchemaInfo;
import asandatabasebrowser.model.TableInfo;
import asandatabasebrowser.model.VvDatabase;
import asandatabasebrowser.model.VvDocument;
import asandatabasebrowser.view.ConnectDialog;
import asandatabasebrowser.view.DbExecuteFrame;
import asandatabasebrowser.view.DbSqlFrame;
import asandatabasebrowser.view.DbTableFrame2;
import asandatabasebrowser.view.DbTextFrame;
import asandatabasebrowser.view.DbTreeFrame;
import asandatabasebrowser.view.DbTreeView;
import asandatabasebrowser.view.SqlLogView;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.sql.Array;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Struct;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import net.sourceforge.swingx.SxMessageBox;
import net.sourceforge.swingx.SxTextUtilities;

public class AsanDatabaseBrowser {
    public static final String TITLE = "AsanDatabaseBrowser";
    public static final String ASAN_DATABASE_BROWSER_FILE = "AsanDatabaseBrowser.xml";
    public static final String VERTICAL_VIEWER_FILE = "VerticalViewer.xml";
    public static AsanDatabaseBrowser theApp;
    public static String[] args;
    DbTreeFrame treeFrame = null;
    private ArrayList frameList = new ArrayList();
    public VvDocument doc = new VvDocument();
    public SqlLogView logView = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    private AsanDatabaseBrowser() {
    }

    public boolean initInstance(String[] args) {
        try {
            File file = new File(ASAN_DATABASE_BROWSER_FILE);
            File file2 = new File(VERTICAL_VIEWER_FILE);
            if (file.exists()) {
                this.doc.loadXml(file);
            } else if (file2.exists()) {
                this.doc.loadVerticalViewerXml(file2);
            } else {
                this.doc.loadProperties();
            }
            return true;
        }
        catch (DbException e) {
            this.showMessage(this.treeFrame, "\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e, 1, 0);
            return false;
        }
    }

    public void exitInstance() {
        for (int i = 0; i < this.doc.databaseList.size(); ++i) {
            VvDatabase db = (VvDatabase)this.doc.databaseList.get(i);
            if (db.getConnection() == null) continue;
            try {
                db.disconnect();
                continue;
            }
            catch (DbException e) {
                e.printStackTrace();
            }
        }
        try {
            File file = new File(ASAN_DATABASE_BROWSER_FILE);
            if (this.doc.isModified() || !file.exists()) {
                if (file.exists()) {
                    SimpleDateFormat f = new SimpleDateFormat("yyyyMMdd_HHmm");
                    Date now = Calendar.getInstance().getTime();
                    String bakname = TITLE + f.format(now) + ".xml";
                    file.renameTo(new File(bakname));
                }
                this.doc.storeXml(file);
            }
        }
        catch (DbException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    public void close(JFrame frame) {
        this.frameList.remove(frame);
    }

    public void openFrame(JFrame newFrame) {
        newFrame.setLocation(300, this.frameList.size() * 20);
        this.frameList.add(newFrame);
        newFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AsanDatabaseBrowser.this.close((JFrame)e.getWindow());
            }
        });
        newFrame.setVisible(true);
    }

    public void openSqlFrame(VvDatabase db, String sql) throws DbException {
        DbSqlFrame newFrame = new DbSqlFrame(db);
        newFrame.addSqlTab(sql);
        DbData data = db.getRecordList(sql);
        newFrame.updateData(data);
        this.openFrame(newFrame);
    }

    public void openSqlFrame(VvDatabase db, FavoriteSQL sql) throws DbException {
        DbSqlFrame newFrame = new DbSqlFrame(db);
        for (int i = 0; i < sql.getCount(); ++i) {
            newFrame.addSqlTab(sql.getSql(i));
        }
        if (sql.getCount() > 0) {
            DbData data = db.getRecordList(sql.getSql(0));
            newFrame.updateData(data);
            newFrame.textarea.setSelectedIndex(0);
        }
        this.openFrame(newFrame);
    }

    public void openTableFrame(TableInfo table) throws DbException {
        DbTableFrame2 newFrame2 = new DbTableFrame2(table);
        this.openFrame(newFrame2);
    }

    public void openTableFrame(FavoriteTable fav) throws DbException {
        VvDatabase db = null;
        for (int i = 0; i < this.doc.databaseList.size(); ++i) {
            VvDatabase d = (VvDatabase)this.doc.databaseList.get(i);
            if (!d.name.equals(fav.dbName)) continue;
            db = d;
            break;
        }
        if (db == null) {
            throw new DbException("\u63a5\u7d9a\u5148\u304c\u5b58\u5728\u3057\u307e\u305b\u3093:" + db.name);
        }
        Connection conn = db.getConnection();
        if (conn == null) {
            try {
                boolean rc = this.connect(db);
                if (!rc) {
                    return;
                }
                conn = db.getConnection();
                if (!$assertionsDisabled && conn == null) {
                    throw new AssertionError();
                }
                DbTreeView dbtree = this.treeFrame.getTree();
                DefaultMutableTreeNode dbnode = dbtree.getNodeByUserObject(db);
                dbtree.\u63a5\u7d9a\u3057\u305f\u306e\u3067\u679d\u3092\u4f5c\u308b(dbnode, db);
            }
            catch (DbException e1) {
                throw new DbException("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306e\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e1);
            }
        }
        try {
            SchemaInfo schema = null;
            ArrayList list = db.getSchemaInfoList();
            for (int i = 0; i < list.size(); ++i) {
                SchemaInfo s = (SchemaInfo)list.get(i);
                if (!SxTextUtilities.equalsString(fav.tableCatalog, s.getCatalogName()) || !SxTextUtilities.equalsString(fav.tableSchema, s.getSchemaName())) continue;
                schema = s;
                break;
            }
            if (schema == null) {
                throw new DbException("\u305d\u306e\u3088\u3046\u306a\u30ab\u30bf\u30ed\u30b0/\u30b9\u30ad\u30fc\u30de\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002catalog=" + fav.tableCatalog + " schema=" + fav.tableSchema);
            }
            TableInfo table = schema.getTableTypeInfo(fav.tableType).getTableInfo(fav.tableName);
            this.openTableFrame(table);
        }
        catch (DbException ex) {
            throw new DbException("\u30c6\u30fc\u30d6\u30eb\u3092\u958b\u304f\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093", ex);
        }
    }

    public void openExecuteFrame(VvDatabase db) {
        DbExecuteFrame newFrame = new DbExecuteFrame(db);
        this.openFrame(newFrame);
    }

    public void openTextFrame(String title, String text, boolean editable) throws DbException {
        DbTextFrame newFrame = new DbTextFrame(title, editable);
        newFrame.setText(text);
        this.openFrame(newFrame);
    }

    public void openBinaryFrame(String title, byte[] data) throws DbException {
        String text = SxTextUtilities.dump(data);
        DbTextFrame newFrame = new DbTextFrame(title, false);
        newFrame.setText(text);
        newFrame.setContent(data);
        this.openFrame(newFrame);
    }

    public void openLargeObject(Object data, ITableInfo tableInfo, Object[] rec, int row) throws DbException {
        if (data instanceof DbLargeObject) {
            DbLargeObject lob = (DbLargeObject)data;
            String title = lob.title;
            data = lob.getValue();
            if (data == null) {
                if (tableInfo instanceof TableInfo) {
                    theApp.showMessage(this.treeFrame, "\u30e1\u30e2\u30ea\u4e0d\u8db3\u306e\u305f\u3081\u3001\u30c7\u30fc\u30bf\u306f\u89e3\u653e\u3055\u308c\u307e\u3057\u305f\u3002\n\u518d\u691c\u7d22\u3057\u307e\u3059\u304b\uff1f", null, 3, 3);
                    TableInfo table = (TableInfo)tableInfo;
                    Object obj = table.db.getColumnValue(table, rec, row);
                    if (obj == null) {
                        theApp.showMessage(this.treeFrame, "NULL \u3067\u3059\u3002", null, 1, 1);
                        return;
                    }
                    lob = (DbLargeObject)obj;
                    data = lob.getValue();
                } else {
                    theApp.showMessage(this.treeFrame, "\u30e1\u30e2\u30ea\u4e0d\u8db3\u306e\u305f\u3081\u3001\u30c7\u30fc\u30bf\u306f\u89e3\u653e\u3055\u308c\u307e\u3057\u305f\u3002", null, 1, 0);
                    return;
                }
            }
            try {
                if (data instanceof String) {
                    theApp.openTextFrame(title, (String)data, false);
                } else if (data instanceof byte[]) {
                    theApp.openBinaryFrame(title, (byte[])data);
                } else if (data instanceof Struct) {
                    Struct struct = (Struct)data;
                    System.out.println("SQLTypeName=" + struct.getSQLTypeName());
                    Object[] objs = struct.getAttributes();
                    for (int i = 0; i < objs.length; ++i) {
                        System.out.println("[" + i + "]=" + objs[i]);
                        if (objs[i] == null || !(objs[i] instanceof Array)) continue;
                        Array ary = (Array)objs[i];
                        System.out.println("BaseTypeName=" + ary.getBaseTypeName());
                        System.out.println("getArray()=" + ary.getArray());
                        if (!(ary.getArray() instanceof Object[])) continue;
                        Object[] o = (Object[])ary.getArray();
                        for (int j = 0; j < o.length; ++j) {
                            System.out.println("o[" + j + "]=" + o[j]);
                        }
                    }
                } else {
                    System.out.println(data);
                }
            }
            catch (SQLException e) {
                throw new DbException("LargeObject\u306e\u5024\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect(VvDatabase db) throws DbException {
        String user = db.user;
        String pass = db.password;
        if (db.isShowLoginDialog) {
            ConnectDialog dialog = new ConnectDialog();
            dialog.setDatabase(db);
            int ret = JOptionPane.showConfirmDialog(this.treeFrame, dialog, "\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u3078\u306e\u63a5\u7d9a", 2, -1);
            if (ret != 0) {
                return false;
            }
            user = dialog.getUser();
            pass = dialog.getPass();
        }
        try {
            this.treeFrame.setCursor(new Cursor(3));
            db.connect(user, pass);
            boolean bl = true;
            return bl;
        }
        finally {
            this.treeFrame.setCursor(Cursor.getDefaultCursor());
            this.treeFrame.updateMainFrame();
        }
    }

    public List getFrameList() {
        return this.frameList;
    }

    public DbTreeFrame getTreeFrame() {
        return this.treeFrame;
    }

    public int showMessage(Component parent, String message, Throwable t, int optionType, int messageType) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        return SxMessageBox.show(parent, TITLE, message, t, optionType, messageType);
    }

    public int showMessage(Component parent, String message, Throwable t, int messageType) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        return this.showMessage(parent, message, t, 1, messageType);
    }

    public void invokeShowMessage(final Component parent, final String message, final Throwable t, final int optionType, final int messageType) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    SxMessageBox.show(parent, AsanDatabaseBrowser.TITLE, message, t, optionType, messageType);
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void main(final String[] args) throws DbException {
        System.setProperty("swing.plaf.metal.controlFont", "Dialog-12");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                args = args;
                theApp = new AsanDatabaseBrowser();
                if (theApp.initInstance(args)) {
                    AsanDatabaseBrowser.theApp.treeFrame = new DbTreeFrame(theApp);
                    AsanDatabaseBrowser.theApp.treeFrame.updateMainFrame();
                    AsanDatabaseBrowser.theApp.logView = new SqlLogView();
                }
            }
        });
    }

    static {
        $assertionsDisabled = !AsanDatabaseBrowser.class.desiredAssertionStatus();
    }
}

