/*
 * Decompiled with CFR 0.152.
 */
package asandatabasebrowser.action;

import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.model.DbException;
import asandatabasebrowser.model.FavoriteGroup;
import asandatabasebrowser.model.FavoriteTable;
import asandatabasebrowser.model.SchemaInfo;
import asandatabasebrowser.model.TableInfo;
import asandatabasebrowser.model.TableTypeInfo;
import asandatabasebrowser.model.VvDatabase;
import asandatabasebrowser.view.DbCountDialog;
import asandatabasebrowser.view.FavoriteTree;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class CountListAction
extends AbstractAction {
    AsanDatabaseBrowser tools;

    public CountListAction(AsanDatabaseBrowser tools) {
        super("\u30ec\u30b3\u30fc\u30c9\u4ef6\u6570");
        this.putValue("ShortDescription", "\u9078\u629e\u3055\u308c\u305f\u30c6\u30fc\u30d6\u30eb\u3001\u3082\u3057\u304f\u306f\u30b9\u30ad\u30fc\u30de/\u30ab\u30bf\u30ed\u30b0\u306b\u3042\u308b\u5168\u30c6\u30fc\u30d6\u30eb\u306e\u30ec\u30b3\u30fc\u30c9\u4ef6\u6570\u3092\u8868\u793a\u3057\u307e\u3059");
        this.putValue("LongDescription", "\u9078\u629e\u3055\u308c\u305f\u30c6\u30fc\u30d6\u30eb\u3001\u3082\u3057\u304f\u306f\u30b9\u30ad\u30fc\u30de/\u30ab\u30bf\u30ed\u30b0\u306b\u3042\u308b\u5168\u30c6\u30fc\u30d6\u30eb\u306e\u30ec\u30b3\u30fc\u30c9\u4ef6\u6570\u3092\u8868\u793a\u3057\u307e\u3059");
        this.tools = tools;
    }

    public void actionPerformed(ActionEvent ev) {
        try {
            JTree tree;
            ArrayList<Object> list = new ArrayList<Object>();
            if (this.tools.getTreeFrame().tab.getSelectedIndex() == 0) {
                tree = this.tools.getTreeFrame().getTree();
                TreePath[] paths = tree.getSelectionPaths();
                for (int i = 0; i < paths.length; ++i) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
                    Object obj = node.getUserObject();
                    if (obj instanceof SchemaInfo) {
                        SchemaInfo schema = (SchemaInfo)node.getUserObject();
                        for (int j = 0; j < schema.getCount(); ++j) {
                            TableTypeInfo type = schema.getTableTypeInfo(j);
                            for (int t = 0; t < type.getCount(); ++t) {
                                if (list.contains(type.getTableInfo(t))) continue;
                                list.add(type.getTableInfo(t));
                            }
                        }
                        continue;
                    }
                    if (obj instanceof TableTypeInfo) {
                        TableTypeInfo type = (TableTypeInfo)obj;
                        for (int t = 0; t < type.getCount(); ++t) {
                            if (list.contains(type.getTableInfo(t))) continue;
                            list.add(type.getTableInfo(t));
                        }
                        continue;
                    }
                    if (!(obj instanceof TableInfo) || list.contains(obj)) continue;
                    list.add(obj);
                }
            } else {
                int i;
                tree = this.tools.getTreeFrame().getFavTree();
                Object[] objs = ((FavoriteTree)tree).getSelectionNodeObjects();
                if (objs == null) {
                    return;
                }
                ArrayList<Object> favlist = new ArrayList<Object>();
                for (i = 0; i < objs.length; ++i) {
                    if (!(objs[i] instanceof FavoriteTable)) continue;
                    favlist.add(objs[i]);
                }
                if (favlist.size() == 0) {
                    for (i = 0; i < objs.length; ++i) {
                        if (!(objs[i] instanceof FavoriteGroup)) continue;
                        FavoriteGroup fg = (FavoriteGroup)objs[i];
                        for (int g = 0; g < fg.getCount(); ++g) {
                            favlist.add(fg.get(g));
                        }
                    }
                }
                for (i = 0; i < favlist.size(); ++i) {
                    FavoriteTable favtable = (FavoriteTable)favlist.get(i);
                    VvDatabase db = this.tools.doc.getDatabaseFromFavorite(favtable);
                    if (db == null) {
                        this.tools.showMessage(this.tools.getTreeFrame(), "\u6307\u5b9a\u3055\u308c\u305fDB\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002:" + favtable.dbName, null, 1, 0);
                        return;
                    }
                    if (db.getConnection() == null) {
                        this.tools.showMessage(this.tools.getTreeFrame(), "\u6307\u5b9a\u3055\u308c\u305fDB\u306f\u63a5\u7d9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002:" + favtable.dbName, null, 1, 0);
                        return;
                    }
                    TableInfo t = this.tools.doc.getTableInfoFromFavorite(favtable);
                    list.add(t);
                }
            }
            if (list.size() == 0) {
                return;
            }
            if (list.size() == 1) {
                TableInfo tableInfo = (TableInfo)list.get(0);
                int count = tableInfo.db.getRecordCount(tableInfo);
                JOptionPane.showMessageDialog(this.tools.getTreeFrame(), tableInfo.getSqlTableName() + "\n" + count + " \u4ef6", "count(*)", 1);
            } else {
                DbCountDialog dialog = new DbCountDialog((Frame)this.tools.getTreeFrame(), list);
                dialog.pack();
                dialog.setVisible(true);
            }
        }
        catch (DbException e) {
            this.tools.showMessage(this.tools.getTreeFrame(), "\u30ec\u30b3\u30fc\u30c9\u4ef6\u6570\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e, 1, 0);
        }
    }
}

