/*
 * Decompiled with CFR 0.152.
 */
package asandatabasebrowser.action;

import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.model.FavoriteGroup;
import asandatabasebrowser.model.FavoriteTable;
import asandatabasebrowser.model.SchemaInfo;
import asandatabasebrowser.model.TableInfo;
import asandatabasebrowser.model.TableTypeInfo;
import asandatabasebrowser.model.VvDatabase;
import asandatabasebrowser.util.SqlGenerator;
import asandatabasebrowser.view.FavoriteTree;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class CreateDdlAction
extends AbstractAction {
    AsanDatabaseBrowser tools;

    public CreateDdlAction(AsanDatabaseBrowser tools) {
        super("DDL\u4f5c\u6210");
        this.putValue("ShortDescription", "\u9078\u629e\u3055\u308c\u305f\u30c6\u30fc\u30d6\u30eb\u306eDDL\u3092\u4f5c\u6210\u3057\u307e\u3059");
        this.putValue("LongDescription", "\u9078\u629e\u3055\u308c\u305f\u30c6\u30fc\u30d6\u30eb\u306eDDL\u3092\u4f5c\u6210\u3057\u307e\u3059");
        this.tools = tools;
    }

    public void actionPerformed(ActionEvent ev) {
        JTree tree;
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.tools.getTreeFrame().tab.getSelectedIndex() == 0) {
            tree = this.tools.getTreeFrame().getTree();
            TreePath[] paths = tree.getSelectionPaths();
            for (int i = 0; i < paths.length; ++i) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
                Object obj = node.getUserObject();
                if (obj instanceof SchemaInfo) {
                    SchemaInfo schema = (SchemaInfo)node.getUserObject();
                    for (int j = 0; j < schema.getCount(); ++j) {
                        TableTypeInfo type = schema.getTableTypeInfo(j);
                        for (int t = 0; t < type.getCount(); ++t) {
                            if (list.contains(type.getTableInfo(t))) continue;
                            list.add(type.getTableInfo(t));
                        }
                    }
                    continue;
                }
                if (obj instanceof TableTypeInfo) {
                    TableTypeInfo type = (TableTypeInfo)obj;
                    for (int t = 0; t < type.getCount(); ++t) {
                        if (list.contains(type.getTableInfo(t))) continue;
                        list.add(type.getTableInfo(t));
                    }
                    continue;
                }
                if (!(obj instanceof TableInfo) || list.contains(obj)) continue;
                list.add(obj);
            }
        } else {
            int i;
            tree = this.tools.getTreeFrame().getFavTree();
            Object[] objs = ((FavoriteTree)tree).getSelectionNodeObjects();
            if (objs == null) {
                return;
            }
            ArrayList<Object> favlist = new ArrayList<Object>();
            for (i = 0; i < objs.length; ++i) {
                if (!(objs[i] instanceof FavoriteTable)) continue;
                favlist.add(objs[i]);
            }
            if (favlist.size() == 0) {
                for (i = 0; i < objs.length; ++i) {
                    if (!(objs[i] instanceof FavoriteGroup)) continue;
                    FavoriteGroup fg = (FavoriteGroup)objs[i];
                    for (int g = 0; g < fg.getCount(); ++g) {
                        favlist.add(fg.get(g));
                    }
                }
            }
            for (i = 0; i < favlist.size(); ++i) {
                FavoriteTable favtable = (FavoriteTable)favlist.get(i);
                VvDatabase db = this.tools.doc.getDatabaseFromFavorite(favtable);
                if (db == null) {
                    this.tools.showMessage(this.tools.getTreeFrame(), "\u6307\u5b9a\u3055\u308c\u305fDB\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002:" + favtable.dbName, null, 64);
                    return;
                }
                if (db.getConnection() == null) {
                    this.tools.showMessage(this.tools.getTreeFrame(), "\u6307\u5b9a\u3055\u308c\u305fDB\u306f\u63a5\u7d9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002:" + favtable.dbName, null, 64);
                    return;
                }
                TableInfo t = this.tools.doc.getTableInfoFromFavorite(favtable);
                list.add(t);
            }
        }
        if (list.size() == 0) {
            this.tools.showMessage(this.tools.getTreeFrame(), "\u30c6\u30fc\u30d6\u30eb\u304c\u9078\u629e\u3055\u308c\u3066\u3044\u307e\u305b\u3093", null, 2);
            return;
        }
        try {
            SqlGenerator generator = new SqlGenerator("templateDDL.xml");
            String ddl = generator.generate(list);
            System.out.println("DDL=" + ddl);
            this.tools.openTextFrame("DDL\u4f5c\u6210", ddl, true);
        }
        catch (Exception e) {
            this.tools.showMessage(this.tools.getTreeFrame(), "DDL\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e, 0);
        }
    }
}

