/*
 * Decompiled with CFR 0.152.
 */
package asandatabasebrowser.action;

import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.model.ColumnInfo;
import asandatabasebrowser.model.DbException;
import asandatabasebrowser.model.TableInfo;
import asandatabasebrowser.model.VvDatabase;
import asandatabasebrowser.view.DbResultSetView;
import asandatabasebrowser.view.DbTableView;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JTable;
import net.sourceforge.swingx.jspread.JSpread;

public class CreateInsertAction
extends AbstractAction {
    final AsanDatabaseBrowser tools;
    final JComponent view;
    final VvDatabase db;

    public CreateInsertAction(AsanDatabaseBrowser tools, VvDatabase db, JComponent view) {
        super("\u9078\u629e\u3055\u308c\u305f\u30ec\u30b3\u30fc\u30c9\u306eINSERT\u6587\u3092\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u4f5c\u6210");
        this.putValue("ShortDescription", "\u9078\u629e\u3055\u308c\u305f\u30ec\u30b3\u30fc\u30c9\u306eINSERT\u6587\u3092\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u4f5c\u6210\u3057\u307e\u3059");
        this.putValue("LongDescription", "\u9078\u629e\u3055\u308c\u305f\u30ec\u30b3\u30fc\u30c9\u306eINSERT\u6587\u3092\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u4f5c\u6210\u3057\u307e\u3059");
        this.tools = tools;
        this.db = db;
        this.view = view;
    }

    public void actionPerformed(ActionEvent ev) {
        try {
            JComponent view2;
            StringBuffer sb = new StringBuffer();
            sb.append("-- \u9593\u9055\u3063\u3066\u3044\u308b\u304b\u3082\u3057\u308c\u306a\u3044\u306e\u3067\u3001\u3042\u307e\u308a\u4fe1\u7528\u3057\u306a\u3044\u3088\u3046\u306b\u3002\n");
            if (this.view instanceof DbResultSetView) {
                view2 = (DbResultSetView)this.view;
                int[] rows = ((JTable)view2).getSelectedRows();
                TableInfo info = (TableInfo)((DbResultSetView)view2).data.tableInfo;
                for (int i = 0; i < rows.length; ++i) {
                    System.out.println(rows[i]);
                    String sql = this.createInsert(info, ((DbResultSetView)view2).data.getRecord(rows[i]));
                    sb.append(sql).append("\n");
                }
            } else {
                view2 = (DbTableView)this.view;
                TableInfo info = (TableInfo)((DbTableView)view2).data.tableInfo;
                boolean[] sel = ((JSpread)view2).getSheet().getSelectionArray(1);
                for (int i = 0; i < sel.length; ++i) {
                    if (!sel[i]) continue;
                    String sql = this.createInsert(info, ((DbTableView)view2).data.getRecord(i));
                    sb.append(sql).append("\n");
                }
            }
            StringSelection ss = new StringSelection(sb.toString());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, ss);
        }
        catch (DbException e) {
            this.tools.showMessage(this.view, "INSERT\u6587\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e, 0);
        }
    }

    String createInsert(TableInfo info, Object[] data) throws DbException {
        ColumnInfo col;
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("insert into ");
        sb.append(info.getSqlTableName());
        for (i = 0; i < info.getColumnCount(); ++i) {
            if (i != 0) {
                sb.append("\n    ,");
            } else {
                sb.append(" (\n    ");
            }
            col = info.getColumnInfo(i);
            sb.append(col.columnName);
        }
        sb.append("\n) values (\n");
        for (i = 0; i < info.getColumnCount(); ++i) {
            if (i != 0) {
                sb.append("\n    ,");
            } else {
                sb.append("    ");
            }
            col = info.getColumnInfo(i);
            String sqlvalue = this.db.getValueStr(col, data[i]);
            sb.append(sqlvalue);
        }
        sb.append("\n);");
        System.out.println(sb.toString());
        return sb.toString();
    }
}

