/*
 * Decompiled with CFR 0.152.
 */
package asandatabasebrowser.action;

import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.model.DbException;
import asandatabasebrowser.model.VvDatabase;
import asandatabasebrowser.view.ConnectDialog;
import asandatabasebrowser.view.DbTreeFrame;
import asandatabasebrowser.view.DbTreeView;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import net.sourceforge.swingx.SxHeavyAction;
import net.sourceforge.swingx.SxProgressDialog;

public class DatabaseConnectAction
extends SxHeavyAction {
    AsanDatabaseBrowser tools;
    SxProgressDialog progressDialog;

    public DatabaseConnectAction(AsanDatabaseBrowser tools) {
        super("\u63a5\u7d9a(C)");
        this.putValue("MnemonicKey", new Integer(67));
        this.putValue("ShortDescription", "\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306b\u63a5\u7d9a");
        this.putValue("LongDescription", "\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306b\u63a5\u7d9a");
        this.tools = tools;
    }

    public void actionPerformed(ActionEvent ev) {
        DbTreeFrame treeFrame = this.tools.getTreeFrame();
        DbTreeView tree = this.tools.getTreeFrame().getTree();
        VvDatabase db = tree.getSelectedDatabase(false);
        if (db == null) {
            return;
        }
        if (db.getConnection() != null) {
            return;
        }
        String user = db.user;
        String pass = db.password;
        if (db.isShowLoginDialog) {
            ConnectDialog dialog = new ConnectDialog();
            dialog.setDatabase(db);
            int ret = JOptionPane.showConfirmDialog(treeFrame, dialog, "\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u3078\u306e\u63a5\u7d9a", 2, -1);
            if (ret != 0) {
                return;
            }
            user = dialog.getUser();
            pass = dialog.getPass();
        }
        ConnectThread thread = new ConnectThread(db, user, pass);
        this.progressDialog = new SxProgressDialog((Frame)treeFrame, "\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u3078\u306e\u63a5\u7d9a", thread);
        this.progressDialog.setProgress(10, "<html><center>\u63a5\u7d9a\u4e2d...<br>\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9: " + db.name + "<br>\u30e6\u30fc\u30b6\u540d: " + user + "</center></html>");
        this.progressDialog.start();
    }

    public void updateStatus() {
    }

    class ConnectThread
    extends Thread {
        VvDatabase db;
        String user;
        String pass;

        ConnectThread(VvDatabase db, String user, String pass) {
            this.db = db;
            this.user = user;
            this.pass = pass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            final DbTreeFrame treeFrame = DatabaseConnectAction.this.tools.getTreeFrame();
            DatabaseConnectAction.this.setMouseCursor(treeFrame, new Cursor(3));
            try {
                this.db.connect(this.user, this.pass);
                DatabaseConnectAction.this.progressDialog.setProgress(80, "\u63a5\u7d9a\u5b8c\u4e86");
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        try {
                            DbTreeView tree = treeFrame.getTree();
                            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getSelectionPath().getLastPathComponent();
                            tree.\u63a5\u7d9a\u3057\u305f\u306e\u3067\u679d\u3092\u4f5c\u308b(node, ConnectThread.this.db);
                            treeFrame.updateMainFrame();
                        }
                        catch (DbException e) {
                            ((ConnectThread)ConnectThread.this).DatabaseConnectAction.this.tools.showMessage(treeFrame, "\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306e\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + ConnectThread.this.db.name, e, 1, 0);
                        }
                    }
                });
            }
            catch (DbException e) {
                DatabaseConnectAction.this.tools.invokeShowMessage(treeFrame, "\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306e\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + this.db.name, e, 1, 0);
                e.printStackTrace();
            }
            finally {
                if (DatabaseConnectAction.this.progressDialog != null) {
                    DatabaseConnectAction.this.progressDialog.dispose();
                }
            }
            DatabaseConnectAction.this.setMouseCursor(treeFrame, Cursor.getDefaultCursor());
        }
    }
}

