/*
 * Decompiled with CFR 0.152.
 */
package asandatabasebrowser.action;

import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.Global;
import asandatabasebrowser.model.FavoriteGroup;
import asandatabasebrowser.model.FavoriteTable;
import asandatabasebrowser.model.VvDatabase;
import asandatabasebrowser.model.VvDocument;
import asandatabasebrowser.view.DbTreeFrame;
import asandatabasebrowser.view.DbTreeView;
import asandatabasebrowser.view.FavoriteTree;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.sourceforge.swingx.SxAction;

public class NodeDownAction
extends SxAction {
    public NodeDownAction() {
        super("\u30ce\u30fc\u30c9\u3092\u4e0b\u3078", Global.arrowDownIcon);
        this.putValue("ShortDescription", "\u30ce\u30fc\u30c9\u3092\u4e0b\u3078");
        this.putValue("LongDescription", "\u30ce\u30fc\u30c9\u3092\u4e0b\u3078");
    }

    public void actionPerformed(ActionEvent e) {
        DbTreeFrame frame = AsanDatabaseBrowser.theApp.getTreeFrame();
        VvDocument doc = AsanDatabaseBrowser.theApp.doc;
        if (frame.tab.getSelectedIndex() == 0) {
            DbTreeView tree = frame.getTree();
            DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
            TreePath selPath = tree.getSelectionPath();
            if (selPath == null) {
                return;
            }
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)selPath.getLastPathComponent();
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)child.getParent();
            if (!(child.getUserObject() instanceof VvDatabase)) {
                return;
            }
            int index = model.getIndexOfChild(parent, child);
            if (index == parent.getChildCount() - 1) {
                return;
            }
            model.removeNodeFromParent(child);
            model.insertNodeInto(child, parent, index + 1);
            tree.addSelectionRow(tree.getRow(child));
            VvDatabase db = (VvDatabase)child.getUserObject();
            ArrayList dblist = doc.databaseList;
            dblist.remove(db);
            dblist.add(index + 1, db);
            doc.setModified(true);
            frame.updateMainFrame();
        } else {
            FavoriteTree tree = frame.getFavTree();
            DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
            TreePath selPath = tree.getSelectionPath();
            if (selPath == null) {
                return;
            }
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)selPath.getLastPathComponent();
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)child.getParent();
            int index = model.getIndexOfChild(parent, child);
            if (index == parent.getChildCount() - 1) {
                return;
            }
            model.removeNodeFromParent(child);
            model.insertNodeInto(child, parent, index + 1);
            tree.addSelectionRow(tree.getRow(child));
            if (child.getUserObject() instanceof FavoriteGroup) {
                FavoriteGroup g = (FavoriteGroup)child.getUserObject();
                ArrayList favList = doc.favList;
                favList.remove(g);
                favList.add(index + 1, g);
            } else if (child.getUserObject() instanceof FavoriteTable) {
                FavoriteGroup g = (FavoriteGroup)parent.getUserObject();
                FavoriteTable t = (FavoriteTable)child.getUserObject();
                g.list.remove(t);
                g.list.add(index + 1, t);
            }
            doc.setModified(true);
            frame.updateMainFrame();
        }
    }

    public void updateStatus() {
        DbTreeFrame frame = AsanDatabaseBrowser.theApp.getTreeFrame();
        if (frame.tab.getSelectedIndex() == 0) {
            DbTreeView tree = frame.getTree();
            DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
            TreePath selPath = tree.getSelectionPath();
            if (selPath == null) {
                this.setEnabled(false);
                return;
            }
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)selPath.getLastPathComponent();
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)child.getParent();
            if (!(child.getUserObject() instanceof VvDatabase)) {
                this.setEnabled(false);
                return;
            }
            int index = model.getIndexOfChild(parent, child);
            if (index == parent.getChildCount() - 1) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(true);
        } else {
            FavoriteTree tree = frame.getFavTree();
            DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
            TreePath selPath = tree.getSelectionPath();
            if (selPath == null) {
                this.setEnabled(false);
                return;
            }
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)selPath.getLastPathComponent();
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)child.getParent();
            if (parent == null) {
                this.setEnabled(false);
                return;
            }
            int index = model.getIndexOfChild(parent, child);
            if (index == parent.getChildCount() - 1) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(true);
        }
    }
}

