/*
 * Decompiled with CFR 0.152.
 */
package asandatabasebrowser.action;

import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.Global;
import asandatabasebrowser.model.DbData;
import asandatabasebrowser.model.FavoriteTable;
import asandatabasebrowser.model.VvDatabase;
import asandatabasebrowser.view.DbDatabaseDefinitionFrame;
import java.awt.event.ActionEvent;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import net.sourceforge.swingx.SxHeavyAction;
import net.sourceforge.swingx.SxProgressDialog;

public class OpenDatabaseDefinitionAction
extends SxHeavyAction {
    final AsanDatabaseBrowser tools;
    SxProgressDialog progressDialog;

    public OpenDatabaseDefinitionAction(AsanDatabaseBrowser tools) {
        super("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u5b9a\u7fa9\u3092\u958b\u304f");
        this.putValue("ShortDescription", "\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u5b9a\u7fa9\u3092\u958b\u304d\u307e\u3059");
        this.putValue("LongDescription", "\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u5b9a\u7fa9\u3092\u958b\u304d\u307e\u3059");
        this.putValue("SmallIcon", Global.getImageIcon("/resources/DatabaseDefinition.png"));
        this.tools = tools;
    }

    public void actionPerformed(ActionEvent e) {
        VvDatabase db = null;
        int index = this.tools.getTreeFrame().tab.getSelectedIndex();
        if (index == 0) {
            db = this.tools.getTreeFrame().getTree().getSelectedDatabase(true);
        } else {
            FavoriteTable favtable;
            Object obj = this.tools.getTreeFrame().getFavTree().getSelectionNodeObject();
            if (obj instanceof FavoriteTable && (db = this.tools.doc.getDatabaseFromFavorite(favtable = (FavoriteTable)obj)) == null) {
                this.tools.showMessage(this.tools.getTreeFrame(), "\u6307\u5b9a\u3055\u308c\u305f\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u304c\u3042\u308a\u307e\u305b\u3093\u3002:" + favtable.dbName, null, 0);
                return;
            }
        }
        if (db == null) {
            return;
        }
        if (db.getConnection() == null) {
            this.tools.showMessage(this.tools.getTreeFrame(), "\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306b\u63a5\u7d9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002:" + db.name, null, 0);
            return;
        }
        HeavyThread thread = new HeavyThread(db);
        this.progressDialog = new SxProgressDialog(this.tools.getTreeFrame(), "\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u5b9a\u7fa9\u306e\u53d6\u5f97", thread, 0, 12);
        this.progressDialog.start();
    }

    public void updateStatus() {
    }

    class HeavyThread
    extends Thread {
        VvDatabase db;

        HeavyThread(VvDatabase db) {
            this.db = db;
        }

        public void run() {
            DbData data;
            ResultSet rs;
            final ArrayList<Object[]> list = new ArrayList<Object[]>();
            DatabaseMetaData meta = this.db.getMetaData();
            int prog = 0;
            OpenDatabaseDefinitionAction.this.progressDialog.setProgress(prog++, "Catalogs");
            if (OpenDatabaseDefinitionAction.this.progressDialog.isAbort()) {
                return;
            }
            try {
                rs = meta.getCatalogs();
                data = new DbData(this.db.createResultSetInfo(rs), this.db.getRecordList(rs));
                list.add(new Object[]{"Catalogs", data});
            }
            catch (Exception e) {
                list.add(new Object[]{"Catalogs", e});
            }
            OpenDatabaseDefinitionAction.this.progressDialog.setProgress(prog++, "Schemas");
            if (OpenDatabaseDefinitionAction.this.progressDialog.isAbort()) {
                return;
            }
            try {
                rs = meta.getSchemas();
                data = new DbData(this.db.createResultSetInfo(rs), this.db.getRecordList(rs));
                list.add(new Object[]{"Schemas", data});
            }
            catch (Exception e) {
                list.add(new Object[]{"Schemas", e});
            }
            OpenDatabaseDefinitionAction.this.progressDialog.setProgress(prog++, "TableTypes");
            if (OpenDatabaseDefinitionAction.this.progressDialog.isAbort()) {
                return;
            }
            try {
                rs = meta.getTableTypes();
                data = new DbData(this.db.createResultSetInfo(rs), this.db.getRecordList(rs));
                list.add(new Object[]{"TableTypes", data});
            }
            catch (Exception e) {
                list.add(new Object[]{"TableTypes", e});
            }
            OpenDatabaseDefinitionAction.this.progressDialog.setProgress(prog++, "TypeInfo");
            if (OpenDatabaseDefinitionAction.this.progressDialog.isAbort()) {
                return;
            }
            try {
                rs = meta.getTypeInfo();
                data = new DbData(this.db.createResultSetInfo(rs), this.db.getRecordList(rs));
                list.add(new Object[]{"TypeInfo", data});
            }
            catch (Exception e) {
                list.add(new Object[]{"TypeInfo", e});
            }
            OpenDatabaseDefinitionAction.this.progressDialog.setProgress(prog++, "Attributes");
            if (OpenDatabaseDefinitionAction.this.progressDialog.isAbort()) {
                return;
            }
            try {
                rs = meta.getAttributes(null, null, null, null);
                data = new DbData(this.db.createResultSetInfo(rs), this.db.getRecordList(rs));
                list.add(new Object[]{"Attributes", data});
            }
            catch (UnsupportedOperationException ex) {
                list.add(new Object[]{"Attributes", ex});
            }
            catch (Exception e) {
                list.add(new Object[]{"Attributes", e});
            }
            OpenDatabaseDefinitionAction.this.progressDialog.setProgress(prog++, "Procedures");
            if (OpenDatabaseDefinitionAction.this.progressDialog.isAbort()) {
                return;
            }
            try {
                rs = meta.getProcedures(null, null, null);
                data = new DbData(this.db.createResultSetInfo(rs), this.db.getRecordList(rs));
                list.add(new Object[]{"Procedures", data});
            }
            catch (Exception e) {
                list.add(new Object[]{"Procedures", e});
            }
            OpenDatabaseDefinitionAction.this.progressDialog.setProgress(prog++, "ProcedureColumns");
            if (OpenDatabaseDefinitionAction.this.progressDialog.isAbort()) {
                return;
            }
            try {
                rs = meta.getProcedureColumns(null, null, null, null);
                data = new DbData(this.db.createResultSetInfo(rs), this.db.getRecordList(rs));
                list.add(new Object[]{"ProcedureColumns", data});
            }
            catch (RuntimeException e) {
                list.add(new Object[]{"ProcedureColumns", e});
            }
            catch (Exception e) {
                list.add(new Object[]{"ProcedureColumns", e});
            }
            OpenDatabaseDefinitionAction.this.progressDialog.setProgress(prog++, "CrossReference");
            if (OpenDatabaseDefinitionAction.this.progressDialog.isAbort()) {
                return;
            }
            try {
                rs = meta.getCrossReference(null, null, null, null, null, null);
                data = new DbData(this.db.createResultSetInfo(rs), this.db.getRecordList(rs));
                list.add(new Object[]{"CrossReference", data});
            }
            catch (Exception e) {
                list.add(new Object[]{"CrossReference", e});
            }
            OpenDatabaseDefinitionAction.this.progressDialog.setProgress(prog++, "SuperTables");
            if (OpenDatabaseDefinitionAction.this.progressDialog.isAbort()) {
                return;
            }
            try {
                rs = meta.getSuperTables(null, null, null);
                data = new DbData(this.db.createResultSetInfo(rs), this.db.getRecordList(rs));
                list.add(new Object[]{"SuperTables", data});
            }
            catch (UnsupportedOperationException e) {
                list.add(new Object[]{"SuperTables", e});
            }
            catch (Exception e) {
                list.add(new Object[]{"SuperTables", e});
            }
            OpenDatabaseDefinitionAction.this.progressDialog.setProgress(prog++, "SuperTypes");
            if (OpenDatabaseDefinitionAction.this.progressDialog.isAbort()) {
                return;
            }
            try {
                rs = meta.getSuperTypes(null, null, null);
                data = new DbData(this.db.createResultSetInfo(rs), this.db.getRecordList(rs));
                list.add(new Object[]{"SuperTypes", data});
            }
            catch (UnsupportedOperationException e) {
                list.add(new Object[]{"SuperTypes", e});
            }
            catch (Exception e) {
                list.add(new Object[]{"SuperTypes", e});
            }
            OpenDatabaseDefinitionAction.this.progressDialog.setProgress(prog++, "Tables");
            if (OpenDatabaseDefinitionAction.this.progressDialog.isAbort()) {
                return;
            }
            try {
                rs = meta.getTables(null, null, null, null);
                data = new DbData(this.db.createResultSetInfo(rs), this.db.getRecordList(rs));
                list.add(new Object[]{"Tables", data});
            }
            catch (Exception e) {
                list.add(new Object[]{"Tables", e});
            }
            OpenDatabaseDefinitionAction.this.progressDialog.setProgress(prog++, "UDTs");
            if (OpenDatabaseDefinitionAction.this.progressDialog.isAbort()) {
                return;
            }
            try {
                rs = meta.getUDTs(null, null, null, null);
                data = new DbData(this.db.createResultSetInfo(rs), this.db.getRecordList(rs));
                list.add(new Object[]{"UDTs", data});
            }
            catch (UnsupportedOperationException ex) {
                list.add(new Object[]{"UDTs", ex});
            }
            catch (Exception e) {
                list.add(new Object[]{"UDTs", e});
            }
            OpenDatabaseDefinitionAction.this.progressDialog.dispose();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ((HeavyThread)HeavyThread.this).OpenDatabaseDefinitionAction.this.tools.openFrame(new DbDatabaseDefinitionFrame(HeavyThread.this.db.name, Global.getImage("/resources/DatabaseDefinition.png"), list));
                }
            });
        }
    }
}

