/*
 * Decompiled with CFR 0.152.
 */
package asandatabasebrowser.action;

import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.Global;
import asandatabasebrowser.model.DbException;
import asandatabasebrowser.model.FavoriteTable;
import asandatabasebrowser.model.TableInfo;
import asandatabasebrowser.model.VvDatabase;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class OpenSqlFrameAction
extends AbstractAction {
    final AsanDatabaseBrowser tools;

    public OpenSqlFrameAction(AsanDatabaseBrowser tools) {
        super("SQL\u30a6\u30a3\u30f3\u30c9\u30a6");
        this.putValue("ShortDescription", "SQL\u30a6\u30a3\u30f3\u30c9\u30a6\u3092\u958b\u304d\u307e\u3059");
        this.putValue("LongDescription", "SQL\u30a6\u30a3\u30f3\u30c9\u30a6\u30eb\u3092\u958b\u304d\u307e\u3059");
        this.putValue("SmallIcon", Global.getImageIcon("/resources/SQLView.png"));
        this.tools = tools;
    }

    public void actionPerformed(ActionEvent ev) {
        TableInfo tableInfo = null;
        int index = this.tools.getTreeFrame().tab.getSelectedIndex();
        if (index == 0) {
            tableInfo = this.tools.getTreeFrame().getTree().getSelectedTableInfo();
        } else {
            Object obj = this.tools.getTreeFrame().getFavTree().getSelectionNodeObject();
            if (obj instanceof FavoriteTable) {
                FavoriteTable favtable = (FavoriteTable)obj;
                VvDatabase db = this.tools.doc.getDatabaseFromFavorite(favtable);
                if (db == null) {
                    this.tools.showMessage(this.tools.getTreeFrame(), "\u6307\u5b9a\u3055\u308c\u305f\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u304c\u3042\u308a\u307e\u305b\u3093\u3002:" + favtable.dbName, null, 0);
                    return;
                }
                if (db.getConnection() == null) {
                    this.tools.showMessage(this.tools.getTreeFrame(), "\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306b\u63a5\u7d9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002:" + favtable.dbName, null, 0);
                    return;
                }
                tableInfo = this.tools.doc.getTableInfoFromFavorite(favtable);
            }
        }
        if (tableInfo == null) {
            return;
        }
        try {
            String sql = "select * from " + tableInfo.getSqlTableName();
            this.tools.openSqlFrame(tableInfo.db, sql);
        }
        catch (DbException e) {
            this.tools.showMessage(this.tools.getTreeFrame(), "\u30c6\u30fc\u30d6\u30eb\u3092\u958b\u304f\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093", e, 0);
        }
    }
}

