/*
 * Decompiled with CFR 0.152.
 */
package asandatabasebrowser.action;

import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.Global;
import asandatabasebrowser.model.DbData;
import asandatabasebrowser.model.FavoriteTable;
import asandatabasebrowser.model.ResultSetInfo;
import asandatabasebrowser.model.TableInfo;
import asandatabasebrowser.model.VvDatabase;
import asandatabasebrowser.view.DbDatabaseDefinitionFrame;
import java.awt.event.ActionEvent;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import net.sourceforge.swingx.SxHeavyAction;
import net.sourceforge.swingx.SxProgressDialog;

public class OpenTableDefinitionAction
extends SxHeavyAction {
    final AsanDatabaseBrowser tools;
    SxProgressDialog progressDialog;
    static /* synthetic */ Class class$asandatabasebrowser$action$OpenTableDefinitionAction;

    public OpenTableDefinitionAction(AsanDatabaseBrowser tools) {
        super("\u30c6\u30fc\u30d6\u30eb\u5b9a\u7fa9\u3092\u958b\u304f");
        this.putValue("ShortDescription", "\u30c6\u30fc\u30d6\u30eb\u5b9a\u7fa9\u3092\u958b\u304d\u307e\u3059");
        this.putValue("LongDescription", "\u30c6\u30fc\u30d6\u30eb\u5b9a\u7fa9\u3092\u958b\u304d\u307e\u3059");
        this.putValue("SmallIcon", Global.getImageIcon("/resources/TableDefinition.png"));
        this.tools = tools;
    }

    public void actionPerformed(ActionEvent e) {
        Object obj;
        TableInfo tableInfo = null;
        int index = this.tools.getTreeFrame().tab.getSelectedIndex();
        if (index == 0) {
            obj = this.tools.getTreeFrame().getTree().getSelectionNodeObject();
            if (obj instanceof TableInfo) {
                tableInfo = (TableInfo)obj;
            }
        } else {
            obj = this.tools.getTreeFrame().getFavTree().getSelectionNodeObject();
            if (obj instanceof FavoriteTable) {
                FavoriteTable favtable = (FavoriteTable)obj;
                VvDatabase db = this.tools.doc.getDatabaseFromFavorite(favtable);
                if (db == null) {
                    this.tools.showMessage(this.tools.getTreeFrame(), "\u6307\u5b9a\u3055\u308c\u305f\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u304c\u3042\u308a\u307e\u305b\u3093\u3002:" + favtable.dbName, null, 0);
                    return;
                }
                if (db.getConnection() == null) {
                    this.tools.showMessage(this.tools.getTreeFrame(), "\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306b\u63a5\u7d9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002:" + favtable.dbName, null, 0);
                    return;
                }
                tableInfo = this.tools.doc.getTableInfoFromFavorite(favtable);
            }
        }
        if (tableInfo == null) {
            return;
        }
        HeavyThread thread = new HeavyThread(tableInfo.db, tableInfo);
        this.progressDialog = new SxProgressDialog(this.tools.getTreeFrame(), "\u30c6\u30fc\u30d6\u30eb\u5b9a\u7fa9\u306e\u53d6\u5f97", thread, 0, 12);
        this.progressDialog.start();
    }

    public void updateStatus() {
    }

    class HeavyThread
    extends Thread {
        TableInfo tableInfo;
        VvDatabase db;
        static final /* synthetic */ boolean $assertionsDisabled;

        HeavyThread(VvDatabase db, TableInfo tableInfo) {
            if (!$assertionsDisabled && db == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && tableInfo == null) {
                throw new AssertionError();
            }
            this.db = db;
            this.tableInfo = tableInfo;
        }

        public void run() {
            DbData data;
            ResultSet rs;
            DatabaseMetaData meta = this.tableInfo.db.getMetaData();
            final ArrayList<Object[]> list = new ArrayList<Object[]>();
            int prog = 0;
            OpenTableDefinitionAction.this.progressDialog.setProgress(prog++, "Column");
            if (OpenTableDefinitionAction.this.progressDialog.isAbort()) {
                return;
            }
            try {
                rs = meta.getColumns(this.tableInfo.getCatalogName(), this.tableInfo.getSchemaName(), this.tableInfo.getTableName(), null);
                data = new DbData(this.db.createResultSetInfo(rs), this.db.getRecordList(rs));
                list.add(new Object[]{"Column", data});
            }
            catch (Exception e) {
                list.add(new Object[]{"Column", e});
            }
            OpenTableDefinitionAction.this.progressDialog.setProgress(prog++, "PrimaryKey");
            if (OpenTableDefinitionAction.this.progressDialog.isAbort()) {
                return;
            }
            try {
                rs = meta.getPrimaryKeys(this.tableInfo.getCatalogName(), this.tableInfo.getSchemaName(), this.tableInfo.getTableName());
                data = new DbData(this.db.createResultSetInfo(rs), this.db.getRecordList(rs));
                list.add(new Object[]{"PrimaryKey", data});
            }
            catch (Exception e) {
                list.add(new Object[]{"PrimaryKey", e});
            }
            OpenTableDefinitionAction.this.progressDialog.setProgress(prog++, "ExportedKeys");
            if (OpenTableDefinitionAction.this.progressDialog.isAbort()) {
                return;
            }
            try {
                rs = meta.getExportedKeys(this.tableInfo.getCatalogName(), this.tableInfo.getSchemaName(), this.tableInfo.getTableName());
                data = new DbData(this.db.createResultSetInfo(rs), this.db.getRecordList(rs));
                list.add(new Object[]{"ExportedKeys", data});
            }
            catch (Exception e) {
                list.add(new Object[]{"ExportedKeys", e});
            }
            OpenTableDefinitionAction.this.progressDialog.setProgress(prog++, "ImportedKeys");
            if (OpenTableDefinitionAction.this.progressDialog.isAbort()) {
                return;
            }
            try {
                rs = meta.getImportedKeys(this.tableInfo.getCatalogName(), this.tableInfo.getSchemaName(), this.tableInfo.getTableName());
                data = new DbData(this.db.createResultSetInfo(rs), this.db.getRecordList(rs));
                list.add(new Object[]{"ImportedKeys", data});
            }
            catch (Exception e) {
                list.add(new Object[]{"ImportedKeys", e});
            }
            OpenTableDefinitionAction.this.progressDialog.setProgress(prog++, "Index");
            if (OpenTableDefinitionAction.this.progressDialog.isAbort()) {
                return;
            }
            try {
                rs = meta.getIndexInfo(this.tableInfo.getCatalogName(), this.tableInfo.getSchemaName(), this.tableInfo.getTableName(), false, true);
                data = new DbData(this.db.createResultSetInfo(rs), this.db.getRecordList(rs));
                list.add(new Object[]{"Index", data});
            }
            catch (Exception e) {
                list.add(new Object[]{"Index", e});
            }
            OpenTableDefinitionAction.this.progressDialog.setProgress(prog++, "TablePrivileges");
            if (OpenTableDefinitionAction.this.progressDialog.isAbort()) {
                return;
            }
            try {
                rs = meta.getTablePrivileges(this.tableInfo.getCatalogName(), this.tableInfo.getSchemaName(), this.tableInfo.getTableName());
                data = new DbData(this.db.createResultSetInfo(rs), this.db.getRecordList(rs));
                list.add(new Object[]{"TablePrivileges", data});
            }
            catch (Exception e) {
                list.add(new Object[]{"TablePrivileges", e});
            }
            OpenTableDefinitionAction.this.progressDialog.setProgress(prog++, "ColumnPrivileges");
            if (OpenTableDefinitionAction.this.progressDialog.isAbort()) {
                return;
            }
            try {
                rs = meta.getColumnPrivileges(this.tableInfo.getCatalogName(), this.tableInfo.getSchemaName(), this.tableInfo.getTableName(), null);
                data = new DbData(this.db.createResultSetInfo(rs), this.db.getRecordList(rs));
                list.add(new Object[]{"ColumnPrivileges", data});
            }
            catch (Exception e) {
                list.add(new Object[]{"ColumnPrivileges", e});
            }
            OpenTableDefinitionAction.this.progressDialog.setProgress(prog++, "BestRowIdentifier");
            if (OpenTableDefinitionAction.this.progressDialog.isAbort()) {
                return;
            }
            try {
                rs = meta.getBestRowIdentifier(this.tableInfo.getCatalogName(), this.tableInfo.getSchemaName(), this.tableInfo.getTableName(), 0, false);
                ArrayList list1 = this.db.getRecordList(rs);
                rs = meta.getBestRowIdentifier(this.tableInfo.getCatalogName(), this.tableInfo.getSchemaName(), this.tableInfo.getTableName(), 1, false);
                ArrayList list2 = this.db.getRecordList(rs);
                list1.addAll(list2);
                rs = meta.getBestRowIdentifier(this.tableInfo.getCatalogName(), this.tableInfo.getSchemaName(), this.tableInfo.getTableName(), 2, false);
                ArrayList list3 = this.db.getRecordList(rs);
                list1.addAll(list3);
                ResultSetInfo resultSetInfo = this.db.createResultSetInfo(rs);
                DbData data2 = new DbData(resultSetInfo, list1);
                list.add(new Object[]{"BestRowIdentifier", data2});
            }
            catch (Exception e) {
                list.add(new Object[]{"BestRowIdentifier", e});
            }
            OpenTableDefinitionAction.this.progressDialog.setProgress(prog++, "VersionColumns");
            if (OpenTableDefinitionAction.this.progressDialog.isAbort()) {
                return;
            }
            try {
                rs = meta.getVersionColumns(this.tableInfo.getCatalogName(), this.tableInfo.getSchemaName(), this.tableInfo.getTableName());
                data = new DbData(this.db.createResultSetInfo(rs), this.db.getRecordList(rs));
                list.add(new Object[]{"VersionColumns", data});
            }
            catch (Exception e) {
                list.add(new Object[]{"VersionColumns", e});
            }
            OpenTableDefinitionAction.this.progressDialog.dispose();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ((HeavyThread)HeavyThread.this).OpenTableDefinitionAction.this.tools.openFrame(new DbDatabaseDefinitionFrame(HeavyThread.this.tableInfo.getSqlTableName(), Global.getImage("/resources/TableDefinition.png"), list));
                }
            });
        }

        static {
            $assertionsDisabled = !(class$asandatabasebrowser$action$OpenTableDefinitionAction == null ? (class$asandatabasebrowser$action$OpenTableDefinitionAction = OpenTableDefinitionAction.class$("asandatabasebrowser.action.OpenTableDefinitionAction")) : class$asandatabasebrowser$action$OpenTableDefinitionAction).desiredAssertionStatus();
        }
    }
}

