/*
 * Decompiled with CFR 0.152.
 */
package asandatabasebrowser.model;

import asandatabasebrowser.model.ColumnInfo;
import asandatabasebrowser.model.EditingRecord;
import asandatabasebrowser.model.ITableInfo;
import asandatabasebrowser.model.TableInfo;
import asandatabasebrowser.model.VvDatabase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class DbData {
    public static final int NONE = -1;
    public static final int INSERT = 0;
    public static final int UPDATE = 1;
    public static final int DELETE = 2;
    public ITableInfo tableInfo;
    private ArrayList records;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DbData(ITableInfo tableInfo, ArrayList records) {
        if (!$assertionsDisabled && tableInfo == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && records == null) {
            throw new AssertionError();
        }
        this.tableInfo = tableInfo;
        this.records = records;
    }

    public ITableInfo getTableInfo() {
        return this.tableInfo;
    }

    public Object[] getRecord(int row) {
        if (this.records.get(row) instanceof EditingRecord) {
            EditingRecord editRec = (EditingRecord)this.records.get(row);
            return editRec.rec;
        }
        return (Object[])this.records.get(row);
    }

    public void setRecord(int row, EditingRecord rec) {
        if (!$assertionsDisabled && rec == null) {
            throw new AssertionError();
        }
        this.records.set(row, rec);
    }

    public void addRecord(EditingRecord rec) {
        if (!$assertionsDisabled && rec == null) {
            throw new AssertionError();
        }
        this.records.add(rec);
    }

    public int getRecordCount() {
        return this.records.size();
    }

    public int getMode(int row) {
        if (this.records.get(row) instanceof EditingRecord) {
            EditingRecord editRec = (EditingRecord)this.records.get(row);
            return editRec.mode;
        }
        return -1;
    }

    public Object getOriginalValue(int row, int col) {
        if (!$assertionsDisabled && this.getMode(row) == -1) {
            throw new AssertionError();
        }
        EditingRecord editRec = (EditingRecord)this.records.get(row);
        return editRec.org[col];
    }

    public void editCancel(int row) {
        if (this.records.get(row) instanceof EditingRecord) {
            EditingRecord rec = (EditingRecord)this.records.get(row);
            switch (rec.mode) {
                case 1: 
                case 2: {
                    this.records.set(row, rec.org);
                    break;
                }
                case 0: {
                    this.records.remove(row);
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError(rec.mode);
                    } else {
                        break;
                    }
                }
            }
        } else if (!$assertionsDisabled) {
            throw new AssertionError(row);
        }
    }

    public void sort(Comparator comp) {
        Collections.sort(this.records, comp);
    }

    private static boolean equals(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    public String createSql(int row) {
        VvDatabase db = this.tableInfo.getDatabase();
        EditingRecord editRec = (EditingRecord)this.records.get(row);
        switch (editRec.mode) {
            case 0: {
                return this.createInsertSql(db, editRec);
            }
            case 1: {
                return this.createUpdateSql(db, editRec);
            }
            case 2: {
                return this.createDeleteSql(db, editRec);
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError(editRec.mode);
        }
        return null;
    }

    private String createInsertSql(VvDatabase db, EditingRecord editRec) {
        ColumnInfo col;
        int i;
        if (!$assertionsDisabled && !(this.tableInfo instanceof TableInfo)) {
            throw new AssertionError(this.tableInfo);
        }
        TableInfo info = (TableInfo)this.tableInfo;
        StringBuffer sb = new StringBuffer();
        Object[] newRec = editRec.rec;
        sb.append("insert into ");
        sb.append(info.getSqlTableName());
        for (i = 0; i < info.getColumnCount(); ++i) {
            if (i != 0) {
                sb.append("\n    ,");
            } else {
                sb.append(" (\n    ");
            }
            col = info.getColumnInfo(i);
            sb.append(col.columnName);
        }
        sb.append("\n) values (\n");
        for (i = 0; i < info.getColumnCount(); ++i) {
            if (i != 0) {
                sb.append("\n    ,");
            } else {
                sb.append("    ");
            }
            col = info.getColumnInfo(i);
            String sqlvalue = db.getValueStr(col, newRec[i]);
            sb.append(sqlvalue);
        }
        sb.append("\n)");
        System.out.println(sb.toString());
        return sb.toString();
    }

    private String createUpdateSql(VvDatabase db, EditingRecord editRec) {
        String sqlvalue;
        ColumnInfo col;
        int i;
        if (!$assertionsDisabled && !(this.tableInfo instanceof TableInfo)) {
            throw new AssertionError(this.tableInfo);
        }
        TableInfo info = (TableInfo)this.tableInfo;
        StringBuffer sb = new StringBuffer();
        sb.append("update ");
        sb.append(info.getSqlTableName());
        sb.append(" set \n    ");
        boolean first = true;
        Object[] newRec = editRec.rec;
        Object[] orgRec = editRec.org;
        for (i = 0; i < info.getColumnCount(); ++i) {
            col = info.getColumnInfo(i);
            if (DbData.equals(orgRec[i], newRec[i])) continue;
            if (!first) {
                sb.append("\n    ,");
            }
            sqlvalue = db.getValueStr(col, newRec[i]);
            sb.append(col.columnName + "=" + sqlvalue);
            first = false;
        }
        if (first) {
            return null;
        }
        sb.append("\nwhere ");
        if (info.pkList != null && info.pkList.size() > 0) {
            for (i = 0; i < info.pkList.size(); ++i) {
                if (i != 0) {
                    sb.append("\n    and ");
                }
                String pk = (String)info.pkList.get(i);
                int index = info.getColumnIndexByName(pk);
                if (!$assertionsDisabled && index == -1) {
                    throw new AssertionError(index);
                }
                ColumnInfo col2 = info.getColumnInfo(index);
                if (orgRec[index] != null) {
                    String sqlvalue2 = db.getValueStr(col2, orgRec[index]);
                    sb.append(col2.columnName + "=" + sqlvalue2);
                    continue;
                }
                sb.append(col2.columnName + " is null");
            }
        } else {
            for (i = 0; i < info.getColumnCount(); ++i) {
                if (i != 0) {
                    sb.append("\n    and ");
                }
                col = info.getColumnInfo(i);
                if (orgRec[i] != null) {
                    sqlvalue = db.getValueStr(col, orgRec[i]);
                    sb.append(col.columnName + "=" + sqlvalue);
                    continue;
                }
                sb.append(col.columnName + " is null");
            }
        }
        return sb.toString();
    }

    private String createDeleteSql(VvDatabase db, EditingRecord editRec) {
        if (!$assertionsDisabled && !(this.tableInfo instanceof TableInfo)) {
            throw new AssertionError(this.tableInfo);
        }
        TableInfo info = (TableInfo)this.tableInfo;
        StringBuffer sb = new StringBuffer();
        sb.append("delete from ");
        sb.append(info.getSqlTableName());
        sb.append("\nwhere ");
        Object[] orgRec = editRec.org;
        if (info.pkList != null && info.pkList.size() > 0) {
            for (int i = 0; i < info.pkList.size(); ++i) {
                if (i != 0) {
                    sb.append("\n    and ");
                }
                String pk = (String)info.pkList.get(i);
                int index = info.getColumnIndexByName(pk);
                if (!$assertionsDisabled && index == -1) {
                    throw new AssertionError(index);
                }
                ColumnInfo col = info.getColumnInfo(index);
                if (orgRec[index] != null) {
                    String sqlvalue = db.getValueStr(col, orgRec[index]);
                    sb.append(col.columnName + "=" + sqlvalue);
                    continue;
                }
                sb.append(col.columnName + " is null");
            }
        } else {
            for (int i = 0; i < info.getColumnCount(); ++i) {
                if (i != 0) {
                    sb.append("\n    and ");
                }
                ColumnInfo col = info.getColumnInfo(i);
                if (orgRec[i] != null) {
                    String sqlvalue = db.getValueStr(col, orgRec[i]);
                    sb.append(col.columnName + "=" + sqlvalue);
                    continue;
                }
                sb.append(col.columnName + " is null");
            }
        }
        return sb.toString();
    }

    static {
        $assertionsDisabled = !DbData.class.desiredAssertionStatus();
    }
}

