/*
 * Decompiled with CFR 0.152.
 */
package asandatabasebrowser.model;

import asandatabasebrowser.model.ColumnInfo;
import asandatabasebrowser.model.DbException;
import asandatabasebrowser.model.IColumnInfo;
import asandatabasebrowser.model.ITableInfo;
import asandatabasebrowser.model.VvDatabase;
import java.sql.SQLException;
import java.util.ArrayList;
import net.sourceforge.swingx.SxTextUtilities;

public class TableInfo
implements ITableInfo {
    final String tableCatalog;
    final String tableSchema;
    final String tableName;
    final String tableType;
    String remarks;
    public final VvDatabase db;
    ArrayList columnInfoList = null;
    public ArrayList pkList = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TableInfo(VvDatabase db, String tableCatalog, String tableSchema, String tableName, String tableType, String remarks, ArrayList columnInfoList) {
        if (!$assertionsDisabled && db == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && tableName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && tableType == null) {
            throw new AssertionError();
        }
        this.db = db;
        this.tableCatalog = tableCatalog;
        this.tableSchema = tableSchema;
        this.tableName = tableName;
        this.tableType = tableType;
        this.remarks = remarks;
        this.columnInfoList = columnInfoList;
    }

    public String getCatalogName() {
        return this.tableCatalog;
    }

    public String getSchemaName() {
        return this.tableSchema;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableType() {
        return this.tableType;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void updateColumnInfoList() throws DbException {
        if (this.columnInfoList == null) {
            this.columnInfoList = this.db.getColumnInfoList(this.tableCatalog, this.tableSchema, this.tableName);
            this.pkList = this.db.getPrimaryKeyList(this.tableCatalog, this.tableSchema, this.tableName);
        }
    }

    public ArrayList getColumnInfoList() {
        return this.columnInfoList;
    }

    public int getColumnCount() {
        return this.getColumnInfoList().size();
    }

    public IColumnInfo getIColumnInfo(int index) {
        return this.getColumnInfo(index);
    }

    public ColumnInfo getColumnInfo(int index) {
        return (ColumnInfo)this.getColumnInfoList().get(index);
    }

    public int getColumnIndexByName(String name) {
        ArrayList list = this.getColumnInfoList();
        for (int i = 0; i < list.size(); ++i) {
            ColumnInfo info = (ColumnInfo)list.get(i);
            if (!name.equalsIgnoreCase(info.columnName)) continue;
            return i;
        }
        return -1;
    }

    public String getColumnName(int index) {
        ColumnInfo info = (ColumnInfo)this.getColumnInfoList().get(index);
        return info.columnName;
    }

    public VvDatabase getDatabase() {
        return this.db;
    }

    public String getSqlTableName() {
        try {
            String q = this.db.getMetaData().getIdentifierQuoteString();
            if (q != null && q.length() > 0) {
                if (this.tableSchema != null && this.tableSchema.length() > 0) {
                    return q + this.tableSchema + q + "." + q + this.tableName + q;
                }
                if (this.tableCatalog != null && this.tableCatalog.length() > 0) {
                    return q + this.tableCatalog + q + "." + q + this.tableName + q;
                }
                return q + this.tableName + q;
            }
            if (this.db.getMetaData().supportsMixedCaseQuotedIdentifiers()) {
                if (this.tableSchema != null && this.tableSchema.length() > 0) {
                    return this.tableSchema + ".\"" + this.tableName + "\"";
                }
                if (this.tableCatalog != null && this.tableCatalog.length() > 0) {
                    return this.tableCatalog + ".\"" + this.tableName + "\"";
                }
                return "\"" + this.tableName + "\"";
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (this.tableSchema != null && this.tableSchema.length() > 0) {
            return this.tableSchema + "." + this.tableName;
        }
        if (this.tableCatalog != null && this.tableCatalog.length() > 0) {
            return this.tableCatalog + "." + this.tableName;
        }
        return this.tableName;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TableInfo)) {
            return false;
        }
        TableInfo info = (TableInfo)obj;
        if (SxTextUtilities.compareString(this.tableCatalog, info.tableCatalog) != 0) {
            return false;
        }
        if (SxTextUtilities.compareString(this.tableSchema, info.tableSchema) != 0) {
            return false;
        }
        if (SxTextUtilities.compareString(this.tableName, info.tableName) != 0) {
            return false;
        }
        return SxTextUtilities.compareString(this.tableType, info.tableType) == 0;
    }

    public Object[] createDefaultRecord() {
        Object[] result = new Object[this.columnInfoList.size()];
        for (int i = 0; i < this.columnInfoList.size(); ++i) {
            result[i] = this.getColumnInfo((int)i).columnDefault;
        }
        return result;
    }

    public int getPrimaryKeySeq(String colname) {
        if (!$assertionsDisabled && colname == null) {
            throw new AssertionError();
        }
        if (this.pkList == null) {
            return -1;
        }
        for (int i = 0; i < this.pkList.size(); ++i) {
            if (colname.compareTo((String)this.pkList.get(i)) != 0) continue;
            return i + 1;
        }
        return -1;
    }

    public String toString() {
        return this.tableName;
    }

    static {
        $assertionsDisabled = !TableInfo.class.desiredAssertionStatus();
    }
}

