/*
 * Decompiled with CFR 0.152.
 */
package asandatabasebrowser.model;

import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.model.ColumnInfo;
import asandatabasebrowser.model.DbData;
import asandatabasebrowser.model.DbException;
import asandatabasebrowser.model.DbLargeObject;
import asandatabasebrowser.model.DbTypeInfo;
import asandatabasebrowser.model.HighlightList;
import asandatabasebrowser.model.ResultInfo;
import asandatabasebrowser.model.ResultSetInfo;
import asandatabasebrowser.model.SchemaInfo;
import asandatabasebrowser.model.TableInfo;
import asandatabasebrowser.model.TableTypeInfo;
import asandatabasebrowser.util.JarClassLoader;
import blanco.commons.sql.format.BlancoSqlRule;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import net.sourceforge.swingx.SxTextUtilities;

public class VvDatabase {
    static JarClassLoader loader;
    public static final String ORACLE = "Oracle";
    public static final String DB2 = "DB2";
    public static final String SQLSERVER = "SQLServer";
    public static final String MYSQL = "MySQL";
    public static final String POSTGRES = "Postgres";
    public static final String OTHER = "other";
    public static String[] productNames;
    private static DecimalFormat f;
    public String name = "\u30c6\u30b9\u30c8";
    public String driverName = "org.gjt.mm.mysql.Driver";
    public String url = "jdbc:mysql:///mysql?useUnicode=true&characterEncoding=SJIS";
    public String user = "";
    public String password = "";
    public ArrayList jarnames = null;
    public boolean isShowLoginDialog = false;
    public boolean rollbackBeforeClose = true;
    public boolean rollbackAfterQuery = true;
    public String highlightFilename;
    public HighlightList highlightList = null;
    public boolean useOracleTableComments = false;
    public boolean useOracleColumnComments = false;
    public boolean hideOracleBinTable = false;
    public int keywordCase = 0;
    public String functionNames = "";
    public String productName = "other";
    public String nameFilter = null;
    private Connection conn = null;
    private DatabaseMetaData meta = null;
    private ArrayList schemaList = null;
    private ArrayList typeInfoList = null;
    static SimpleDateFormat formatter;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$lang$String;

    public VvDatabase(String name, String driverName, String url, String user, String password, ArrayList jarnames, String productName, String highlightFilename, boolean isShow, boolean rollBackBeforeClose, boolean rollbackAfterQuery, boolean useOracleTableComments, boolean useOracleColumnComments, boolean hideOracleBinTable, int keywordCase, String functionNames) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && driverName == null) {
            throw new AssertionError((Object)"driverName\u306f\u5fc5\u9808\u3067\u3059\u3002");
        }
        if (!$assertionsDisabled && url == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && keywordCase != 0 && keywordCase != 1 && keywordCase != 2) {
            throw new AssertionError(keywordCase);
        }
        this.name = name;
        this.driverName = driverName;
        this.url = url;
        this.user = user;
        this.password = password;
        this.jarnames = jarnames;
        this.productName = productName;
        this.isShowLoginDialog = isShow;
        this.rollbackBeforeClose = rollBackBeforeClose;
        this.rollbackAfterQuery = rollbackAfterQuery;
        this.highlightFilename = highlightFilename;
        this.useOracleTableComments = useOracleTableComments;
        this.useOracleColumnComments = useOracleColumnComments;
        this.hideOracleBinTable = hideOracleBinTable;
        this.keywordCase = keywordCase;
        this.functionNames = functionNames;
        if (highlightFilename != null) {
            this.highlightList = HighlightList.loadHighlightList(highlightFilename);
        }
    }

    public void copyFrom(VvDatabase db) {
        if (!$assertionsDisabled && db == null) {
            throw new AssertionError();
        }
        this.name = db.name;
        this.driverName = db.driverName;
        this.url = db.url;
        this.user = db.user;
        this.password = db.password;
        this.jarnames = db.jarnames;
        this.productName = db.productName;
        this.isShowLoginDialog = db.isShowLoginDialog;
        this.rollbackBeforeClose = db.rollbackBeforeClose;
        this.rollbackAfterQuery = db.rollbackAfterQuery;
        this.highlightFilename = db.highlightFilename;
        this.useOracleTableComments = db.useOracleTableComments;
        this.useOracleColumnComments = db.useOracleColumnComments;
        this.hideOracleBinTable = db.hideOracleBinTable;
        this.keywordCase = db.keywordCase;
        this.functionNames = db.functionNames;
        if (this.highlightFilename != null) {
            this.highlightList = HighlightList.loadHighlightList(this.highlightFilename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String user, String pass) throws DbException {
        Driver driver = null;
        try {
            loader.setJarFilenames(this.jarnames);
            Class<?> driverClass = Class.forName(this.driverName, true, loader);
            driver = (Driver)driverClass.newInstance();
            VvDatabase.outputLog("driver=" + driver);
            DriverManager.registerDriver(driver);
        }
        catch (InstantiationException e) {
            throw new DbException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306e\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + this.driverName, e);
        }
        catch (IllegalAccessException e) {
            throw new DbException("\u4e0d\u6b63\u30a2\u30af\u30bb\u30b9\u3092\u884c\u3044\u307e\u3057\u305f:" + this.driverName, e);
        }
        catch (SQLException e) {
            throw new DbException("SQL\u30a8\u30e9\u30fc:" + this.driverName, e);
        }
        catch (ClassNotFoundException e) {
            throw new DbException("\u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093:" + this.driverName, e);
        }
        try {
            Properties prop = new Properties();
            prop.put("user", user);
            prop.put("password", pass);
            VvDatabase.outputLog("connect " + this.name + " " + user + "/" + pass);
            this.conn = driver.connect(this.url, prop);
            this.conn.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new DbException("DB\u306e\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f url=" + this.url + " user=" + user, e);
        }
        try {
            this.meta = this.conn.getMetaData();
            long start = System.currentTimeMillis();
            this.createSchemaList();
            System.out.println(System.currentTimeMillis() - start + "msec");
        }
        catch (SQLException e) {
            throw new DbException("\u30e1\u30bf\u30c7\u30fc\u30bf\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
        this.typeInfoList = this.getTypeInfoList();
        if (this.productName.equals(ORACLE) && this.useOracleTableComments) {
            String sql = "select * from SYS.ALL_TAB_COMMENTS where COMMENTS is not null";
            Statement statement = null;
            ResultSet rs = null;
            try {
                statement = this.conn.createStatement();
                VvDatabase.outputLog(sql);
                rs = statement.executeQuery(sql);
                while (rs.next()) {
                    String comments;
                    String owner = rs.getString("OWNER");
                    String table_name = rs.getString("TABLE_NAME");
                    String table_type = rs.getString("TABLE_TYPE");
                    this.getSchemaInfo(null, (String)owner).getTableTypeInfo((String)table_type).getTableInfo((String)table_name).remarks = comments = rs.getString("COMMENTS");
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {}
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e) {}
                }
                if (this.rollbackAfterQuery) {
                    this.rollback();
                }
            }
        }
    }

    public void disconnect() throws DbException {
        try {
            if (this.rollbackBeforeClose) {
                this.rollback();
            }
            VvDatabase.outputLog("disconnect " + this.name);
            this.conn.close();
            System.out.println("disconnect()");
        }
        catch (SQLException e) {
            throw new DbException("DB\u306e\u5207\u65ad\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
        finally {
            this.conn = null;
            this.meta = null;
        }
    }

    public Connection getConnection() {
        return this.conn;
    }

    public DatabaseMetaData getMetaData() {
        if (!$assertionsDisabled && this.meta == null) {
            throw new AssertionError();
        }
        return this.meta;
    }

    public void commit() throws DbException {
        if (!$assertionsDisabled && this.conn == null) {
            throw new AssertionError();
        }
        try {
            VvDatabase.outputLog("commit");
            this.conn.commit();
        }
        catch (SQLException e) {
            throw new DbException("\u30b3\u30df\u30c3\u30c8\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
    }

    public void rollback() throws DbException {
        if (!$assertionsDisabled && this.conn == null) {
            throw new AssertionError();
        }
        try {
            VvDatabase.outputLog("rollback");
            this.conn.rollback();
        }
        catch (SQLException e) {
            throw new DbException("\u30ed\u30fc\u30eb\u30d0\u30c3\u30af\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
    }

    public int executeUpdate(String sql) throws DbException {
        if (!$assertionsDisabled && sql == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.conn == null) {
            throw new AssertionError();
        }
        Statement statement = null;
        try {
            int rc;
            statement = this.conn.createStatement();
            VvDatabase.outputLog(sql);
            int n = rc = statement.executeUpdate(sql);
            return n;
        }
        catch (SQLException e) {
            throw new DbException("\uff24\uff22\u306e\u66f4\u65b0\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\n" + sql, e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    public ResultSetInfo createResultSetInfo(ResultSet rs) throws DbException {
        if (!$assertionsDisabled && rs == null) {
            throw new AssertionError();
        }
        try {
            ResultSetMetaData meta = rs.getMetaData();
            ArrayList<ResultInfo> resultInfoList = new ArrayList<ResultInfo>();
            int cols = meta.getColumnCount();
            for (int i = 0; i < cols; ++i) {
                int precision = -1;
                try {
                    precision = meta.getPrecision(i + 1);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                ResultInfo info = new ResultInfo(meta.isAutoIncrement(i + 1), meta.isCaseSensitive(i + 1), meta.isSearchable(i + 1), meta.isCurrency(i + 1), meta.isNullable(i + 1), meta.isSigned(i + 1), meta.getColumnDisplaySize(i + 1), meta.getColumnLabel(i + 1), meta.getColumnName(i + 1), meta.getSchemaName(i + 1), precision, meta.getScale(i + 1), meta.getTableName(i + 1), meta.getCatalogName(i + 1), meta.getColumnType(i + 1), meta.getColumnTypeName(i + 1), meta.isReadOnly(i + 1), meta.isWritable(i + 1), meta.isDefinitelyWritable(i + 1), meta.getColumnClassName(i + 1));
                resultInfoList.add(info);
            }
            return new ResultSetInfo(this, resultInfoList);
        }
        catch (SQLException e) {
            throw new DbException("\u691c\u7d22\u7d50\u679c\u306e\u60c5\u5831\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
    }

    public ArrayList getRecordList(ResultSet rs) throws SQLException {
        if (!$assertionsDisabled && rs == null) {
            throw new AssertionError();
        }
        ArrayList<Object[]> records = new ArrayList<Object[]>();
        ResultSetMetaData rsmeta = rs.getMetaData();
        int cols = rsmeta.getColumnCount();
        for (int r = 0; rs.next() && (AsanDatabaseBrowser.theApp.doc.maxRecord == -1 || r < AsanDatabaseBrowser.theApp.doc.maxRecord); ++r) {
            Object[] rec = new Object[cols];
            for (int i = 0; i < cols; ++i) {
                try {
                    rec[i] = rs.getObject(i + 1);
                    if (this.productName.equals(ORACLE)) {
                        try {
                            if (rec[i] != null && rec[i].getClass().getSuperclass().getName().equals("oracle.sql.Datum")) {
                                Method m = rec[i].getClass().getMethod("toJdbc", null);
                                rec[i] = m.invoke(rec[i], null);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (rec[i] == null) continue;
                    String typename = rsmeta.getColumnTypeName(i + 1);
                    rec[i] = VvDatabase.convertLargeObject(rec[i], typename, true);
                    continue;
                }
                catch (SQLException e) {
                    if (rs.getMetaData().getColumnType(i + 1) == 12) {
                        rec[i] = rs.getString(i + 1);
                        continue;
                    }
                    rec[i] = "\u53d6\u5f97\u5931\u6557:" + rs.getMetaData().getColumnTypeName(i + 1);
                    System.out.println("i=" + i + " getColumnType=" + rs.getMetaData().getColumnType(i + 1));
                    e.printStackTrace();
                }
            }
            records.add(rec);
        }
        return records;
    }

    static Object convertLargeObject(Object obj, String typename, boolean enableCache) {
        if (obj != null) {
            try {
                if (obj instanceof Blob) {
                    Blob blob = (Blob)obj;
                    long len = blob.length();
                    String title = typename + "(" + f.format(len) + " \u30d0\u30a4\u30c8)";
                    byte[] bytes = blob.getBytes(1L, (int)len);
                    obj = new DbLargeObject(typename, title, bytes, enableCache);
                } else if (obj instanceof Clob) {
                    Clob clob = (Clob)obj;
                    long len = clob.length();
                    String title = typename + "(" + f.format(len) + " \u6587\u5b57)";
                    String str = clob.getSubString(1L, (int)len);
                    obj = new DbLargeObject(typename, title, str, enableCache);
                } else if (obj instanceof byte[]) {
                    byte[] bytes = (byte[])obj;
                    String title = typename + "(" + f.format(bytes.length) + " \u30d0\u30a4\u30c8)";
                    obj = new DbLargeObject(typename, title, bytes, enableCache);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return obj;
    }

    public DbData getRecordList(String sql) throws DbException {
        if (!$assertionsDisabled && sql == null) {
            throw new AssertionError();
        }
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = this.conn.createStatement();
            VvDatabase.outputLog(sql);
            rs = statement.executeQuery(sql);
            ResultSetInfo rsinfo = this.createResultSetInfo(rs);
            ArrayList records = this.getRecordList(rs);
            DbData dbData = new DbData(rsinfo, records);
            return dbData;
        }
        catch (SQLException e) {
            throw new DbException("\uff24\uff22\u306e\u691c\u7d22\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + sql, e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
            }
            if (this.rollbackAfterQuery) {
                this.rollback();
            }
        }
    }

    public DbData queryTable(TableInfo tableInfo, String sql, boolean doRollback) throws DbException {
        if (!$assertionsDisabled && tableInfo == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && sql == null) {
            throw new AssertionError();
        }
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = this.conn.createStatement();
            VvDatabase.outputLog(sql);
            rs = statement.executeQuery(sql);
            ArrayList records = this.getRecordList(rs);
            DbData dbData = new DbData(tableInfo, records);
            return dbData;
        }
        catch (SQLException e) {
            throw new DbException("\uff24\uff22\u306e\u691c\u7d22\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + sql, e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
            }
            if (doRollback && this.rollbackAfterQuery) {
                this.rollback();
            }
        }
    }

    public int getRecordCount(TableInfo table) throws DbException {
        String sql = "select count(*) from " + table.getSqlTableName();
        try {
            Statement stat = this.conn.createStatement();
            VvDatabase.outputLog(sql);
            ResultSet rs = stat.executeQuery(sql);
            rs.next();
            int count = rs.getInt(1);
            rs.close();
            stat.close();
            if (this.rollbackAfterQuery) {
                this.rollback();
            }
            return count;
        }
        catch (SQLException e) {
            throw new DbException("\u4ef6\u6570\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f[" + sql + "]", e);
        }
    }

    public Object getColumnValue(TableInfo table, Object[] rec, int col) throws DbException {
        int i;
        if (!$assertionsDisabled && table == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && rec == null) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || 0 <= col && col < rec.length)) {
            throw new AssertionError(col);
        }
        ColumnInfo colInfo = table.getColumnInfo(col);
        String sql = "select " + colInfo.columnName;
        sql = sql + " from " + table.getSqlTableName();
        String where = "";
        if (table.pkList != null && table.pkList.size() > 0) {
            for (i = 0; i < table.pkList.size(); ++i) {
                if (i != 0) {
                    where = where + " and ";
                }
                String pk = (String)table.pkList.get(i);
                int index = table.getColumnIndexByName(pk);
                if (!$assertionsDisabled && index == -1) {
                    throw new AssertionError(index);
                }
                ColumnInfo c = table.getColumnInfo(index);
                if (rec[index] != null) {
                    String sqlvalue = this.getValueStr(c, rec[index]);
                    where = where + c.columnName + "=" + sqlvalue;
                    continue;
                }
                where = where + c.columnName + " is null";
            }
        } else {
            for (i = 0; i < table.getColumnCount(); ++i) {
                ColumnInfo c = table.getColumnInfo(i);
                if (rec[i] != null) {
                    if (rec[i] instanceof Blob || rec[i] instanceof Clob || rec[i] instanceof byte[] || rec[i] instanceof DbLargeObject) continue;
                    if (where.length() > 0) {
                        where = where + " and ";
                    }
                    String sqlvalue = this.getValueStr(c, rec[i]);
                    where = where + c.columnName + "=" + sqlvalue;
                    continue;
                }
                if (where.length() > 0) {
                    where = where + " and ";
                }
                where = where + c.columnName + " is null";
            }
        }
        if (where.length() == 0) {
            throw new DbException("\u3053\u306e\u30c6\u30fc\u30d6\u30eb\u3067\u306f\u30ec\u30b3\u30fc\u30c9\u304c\u7279\u5b9a\u3067\u304d\u307e\u305b\u3093:" + table.getSqlTableName());
        }
        sql = sql + " where " + where;
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = this.conn.createStatement();
            VvDatabase.outputLog(sql);
            rs = statement.executeQuery(sql);
            System.out.println("rs.getFetchSize()=" + rs.getFetchSize());
            boolean rc = rs.next();
            if (!rc) {
                throw new DbException("\u30ec\u30b3\u30fc\u30c9\u304c\u7279\u5b9a\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u30020\u4ef6");
            }
            Object obj = rs.getObject(1);
            String typename = rs.getMetaData().getColumnTypeName(1);
            obj = VvDatabase.convertLargeObject(obj, typename, false);
            rc = rs.next();
            if (rc) {
                throw new DbException("\u30ec\u30b3\u30fc\u30c9\u304c\u7279\u5b9a\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u30022\u4ef6\u4ee5\u4e0a");
            }
            Object object = obj;
            return object;
        }
        catch (SQLException e) {
            throw new DbException("\uff24\uff22\u306e\u691c\u7d22\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + sql, e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
            }
            if (this.rollbackAfterQuery) {
                this.rollback();
            }
        }
    }

    public ArrayList getSchemaInfoList() {
        return this.schemaList;
    }

    public void createSchemaList() throws DbException {
        if (!$assertionsDisabled && this.meta == null) {
            throw new AssertionError();
        }
        ResultSet rs = null;
        this.schemaList = new ArrayList();
        DbException ex = null;
        String msg = "";
        try {
            if (this.meta.supportsSchemasInDataManipulation()) {
                rs = this.meta.getSchemas();
                while (rs.next()) {
                    String schem = rs.getString("TABLE_SCHEM");
                    String cat = rs.getMetaData().getColumnCount() >= 2 ? rs.getString("TABLE_CATALOG") : null;
                    try {
                        SchemaInfo info = this.getSchemaInfo(cat, schem, null, null);
                        this.schemaList.add(info);
                    }
                    catch (DbException e) {
                        if (ex == null) {
                            ex = e;
                        }
                        msg = msg + "catalog=" + cat + " schema=" + schem + "\n";
                    }
                }
            }
            if (this.schemaList.size() == 0) {
                rs = this.meta.getCatalogs();
                while (rs.next()) {
                    String cat = rs.getString("TABLE_CAT");
                    try {
                        SchemaInfo info = this.getSchemaInfo(cat, null, null, null);
                        this.schemaList.add(info);
                    }
                    catch (DbException e) {
                        if (ex == null) {
                            ex = e;
                        }
                        msg = msg + "catalog=" + cat + "\n";
                    }
                }
            }
            if (ex != null) {
                throw new DbException("\u30b9\u30ad\u30fc\u30de/\u30ab\u30bf\u30ed\u30b0\u60c5\u5831\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\n" + msg, ex);
            }
        }
        catch (SQLException e) {
            throw new DbException("\u30b9\u30ad\u30fc\u30de/\u30ab\u30bf\u30ed\u30b0\u60c5\u5831\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    SchemaInfo getSchemaInfo(String cat, String schema, String tableNamePattern, String[] types) throws DbException {
        ResultSet rs = null;
        ArrayList<TableTypeInfo> list = new ArrayList<TableTypeInfo>();
        try {
            HashMap<String, TableTypeInfo> map = new HashMap<String, TableTypeInfo>();
            rs = this.meta.getTables(cat, schema, tableNamePattern, types);
            while (rs.next()) {
                String catalog = rs.getString("TABLE_CAT");
                String schem = rs.getString("TABLE_SCHEM");
                String tableName = rs.getString("TABLE_NAME");
                String tableType = rs.getString("TABLE_TYPE");
                ArrayList collist = null;
                TableInfo info = new TableInfo(this, catalog, schem, tableName, tableType, rs.getString("REMARKS"), collist);
                TableTypeInfo ti = (TableTypeInfo)map.get(tableType);
                if (ti == null) {
                    ti = new TableTypeInfo(tableType);
                    map.put(tableType, ti);
                    list.add(ti);
                }
                ti.add(info);
            }
            SchemaInfo schemaInfo = new SchemaInfo(this, cat, schema, list);
            return schemaInfo;
        }
        catch (SQLException e) {
            throw new DbException("\u30c6\u30fc\u30d6\u30eb\u60c5\u5831\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f: catalog=" + cat + " schema=" + schema, e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList getColumnInfoList(String catalog, String schemaPattern, String tableName) throws DbException {
        ResultSet rs = null;
        ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
        try {
            rs = this.meta.getColumns(catalog, schemaPattern, tableName, null);
            while (rs.next()) {
                String table_cat = rs.getString("TABLE_CAT");
                String table_schem = rs.getString("TABLE_SCHEM");
                String table_name = rs.getString("TABLE_NAME");
                String column_name = rs.getString("COLUMN_NAME");
                short data_type = rs.getShort("DATA_TYPE");
                String type_name = rs.getString("TYPE_NAME");
                int column_size = rs.getInt("COLUMN_SIZE");
                int decimal_digits = rs.getInt("DECIMAL_DIGITS");
                int num_prec_radix = rs.getInt("NUM_PREC_RADIX");
                int nullable = rs.getInt("NULLABLE");
                String remarks = rs.getString("REMARKS");
                String column_def = rs.getString("COLUMN_DEF");
                int sql_data_type = rs.getInt("SQL_DATA_TYPE");
                int sql_datetime_sub = rs.getInt("SQL_DATETIME_SUB");
                int char_octet_length = rs.getInt("CHAR_OCTET_LENGTH");
                int ordinal_position = rs.getInt("ORDINAL_POSITION");
                String is_nullable = rs.getString("IS_NULLABLE");
                ArrayList<Object> others = new ArrayList<Object>();
                for (int i = 19; i <= rs.getMetaData().getColumnCount(); ++i) {
                    others.add(rs.getObject(i));
                }
                ColumnInfo col = new ColumnInfo(table_cat, table_schem, table_name, column_name, data_type, type_name, column_size, decimal_digits, num_prec_radix, nullable, remarks, column_def, sql_data_type, sql_datetime_sub, char_octet_length, ordinal_position, is_nullable, others);
                list.add(col);
            }
        }
        catch (SQLException e) {
            throw new DbException("\u30ab\u30e9\u30e0\u60c5\u5831\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {}
            }
        }
        if (this.productName.equals(ORACLE) && this.useOracleColumnComments) {
            String sql = "select * from SYS.ALL_COL_COMMENTS where OWNER='" + schemaPattern + "' and TABLE_NAME='" + tableName + "' and COMMENTS is not null";
            Statement statement = null;
            rs = null;
            try {
                statement = this.conn.createStatement();
                VvDatabase.outputLog(sql);
                rs = statement.executeQuery(sql);
                block28: while (rs.next()) {
                    String column_name = rs.getString("COLUMN_NAME");
                    String comments = rs.getString("COMMENTS");
                    for (int i = 0; i < list.size(); ++i) {
                        ColumnInfo col = (ColumnInfo)list.get(i);
                        if (!col.columnName.equals(column_name)) continue;
                        col.remarks = comments;
                        continue block28;
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {}
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e) {}
                }
                if (this.rollbackAfterQuery) {
                    this.rollback();
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getPrimaryKeyList(String catalog, String schemaPattern, String tableName) throws DbException {
        class StrInt {
            final int num;
            final String str;

            StrInt(int num, String str) {
                this.num = num;
                this.str = str;
            }
        }
        ArrayList<StrInt> list = new ArrayList<StrInt>();
        ResultSet rs = null;
        try {
            rs = this.meta.getPrimaryKeys(catalog, schemaPattern, tableName);
            while (rs.next()) {
                list.add(new StrInt(rs.getInt("KEY_SEQ"), rs.getString("COLUMN_NAME")));
            }
            Collections.sort(list, new Comparator(){

                public int compare(Object o1, Object o2) {
                    StrInt s1 = (StrInt)o1;
                    StrInt s2 = (StrInt)o2;
                    return s1.num - s2.num;
                }
            });
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                StrInt s = (StrInt)list.get(i);
                result.add(s.str);
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        catch (SQLException e) {
            e.printStackTrace();
            ArrayList arrayList = null;
            return arrayList;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {}
            }
        }
    }

    public ArrayList getTypeInfoList() throws DbException {
        ArrayList<Object> list = new ArrayList<Object>();
        ResultSet rs = null;
        try {
            Object info;
            rs = this.meta.getTypeInfo();
            while (rs.next()) {
                info = new DbTypeInfo(rs.getString("TYPE_NAME"), rs.getInt("DATA_TYPE"), rs.getInt("PRECISION"), rs.getString("LITERAL_PREFIX"), rs.getString("LITERAL_SUFFIX"), rs.getString("CREATE_PARAMS"), rs.getShort("NULLABLE"), rs.getBoolean("CASE_SENSITIVE"), rs.getShort("SEARCHABLE"), rs.getBoolean("UNSIGNED_ATTRIBUTE"), rs.getBoolean("FIXED_PREC_SCALE"), rs.getBoolean("AUTO_INCREMENT"), rs.getString("LOCAL_TYPE_NAME"), rs.getShort("MINIMUM_SCALE"), rs.getShort("MAXIMUM_SCALE"), rs.getInt("SQL_DATA_TYPE"), rs.getInt("SQL_DATETIME_SUB"), rs.getInt("NUM_PREC_RADIX"));
                list.add(info);
            }
            info = list;
            return info;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new DbException("\u30e1\u30bf\u30c7\u30fc\u30bf\u304b\u3089\u578b\u60c5\u5831\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {}
            }
        }
    }

    public DbTypeInfo getTypeInfo(int dataType) {
        for (int i = 0; i < this.typeInfoList.size(); ++i) {
            DbTypeInfo info = (DbTypeInfo)this.typeInfoList.get(i);
            if (info.dataType != dataType) continue;
            return info;
        }
        if (ORACLE.equals(this.productName) && dataType == 3) {
            DbTypeInfo info = new DbTypeInfo("DECIMAL", 3, 1, null, null, "(1)", 1, false, 3, false, true, false, "NUMBER", -84, 127, 0, 0, 10);
            this.typeInfoList.add(info);
            return info;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError(dataType);
        }
        return null;
    }

    public Object[][] getMetaDataProperties() {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        Method[] methods = DatabaseMetaData.class.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Object val = null;
            Method m = methods[i];
            try {
                if (m.getParameterTypes().length > 0) continue;
                Class<?> retClass = m.getReturnType();
                if (retClass.equals(Integer.TYPE)) {
                    val = (Integer)m.invoke((Object)this.meta, null);
                } else if (retClass.equals(Boolean.TYPE)) {
                    val = (Boolean)m.invoke((Object)this.meta, null);
                } else {
                    if (!retClass.equals(class$java$lang$String == null ? VvDatabase.class$("java.lang.String") : class$java$lang$String)) continue;
                    val = (String)m.invoke((Object)this.meta, null);
                }
            }
            catch (Throwable e) {
                System.out.println(methods[i]);
                System.out.println(e);
                val = "\u53d6\u5f97\u5931\u6557:" + e.toString();
            }
            names.add(m.getName());
            values.add(val);
        }
        Object[][] result = new Object[names.size()][2];
        for (int i = 0; i < names.size(); ++i) {
            result[i][0] = names.get(i);
            result[i][1] = values.get(i);
        }
        return result;
    }

    public String toString() {
        return this.name;
    }

    public String getValueStr(ColumnInfo col, Object value) {
        DbTypeInfo info = this.getTypeInfo(col.dataType);
        if (value == null) {
            return "NULL";
        }
        String result = value.toString();
        if (info.literalPrefix != null) {
            result = info.literalPrefix + result;
        }
        if (info.literalSuffix != null) {
            result = result + info.literalSuffix;
        }
        if (ORACLE.equals(this.productName)) {
            switch (info.dataType) {
                case -104: 
                case -103: 
                case -102: 
                case -101: 
                case 91: 
                case 92: 
                case 93: {
                    if (info.literalPrefix != null && info.literalSuffix != null) break;
                    result = "'" + value.toString() + "'";
                }
            }
        } else if (POSTGRES.equals(this.productName)) {
            switch (info.dataType) {
                case 1: 
                case 12: 
                case 91: 
                case 92: 
                case 93: {
                    if (info.literalPrefix != null && info.literalSuffix != null) break;
                    result = "'" + value.toString() + "'";
                }
            }
        }
        return result;
    }

    public String getTypeStr(ColumnInfo col) {
        if (DB2.equals(this.productName)) {
            DbTypeInfo type = this.getTypeInfo(col.dataType);
            String typestr = col.typeName;
            if (type.createParams != null) {
                if (type.createParams.equals("PRECISION,SCALE") || type.createParams.equals("\u7cbe\u5ea6,\u4f4d\u53d6\u308a")) {
                    typestr = typestr + "(" + col.columnSize + "," + col.decimalDigits + ")";
                } else if (type.createParams.equals("LENGTH") || type.createParams.equals("\u6700\u5927\u9577")) {
                    typestr = typestr + "(" + col.columnSize + ")";
                } else {
                    System.out.println("???" + type.createParams);
                }
            }
            typestr = typestr + ("YES".equals(col.isNullable) ? "" : " NOT NULL");
            return typestr;
        }
        if (MYSQL.equals(this.productName)) {
            DbTypeInfo type = this.getTypeInfo(col.dataType);
            String typestr = col.typeName;
            if ("(M)".equals(type.createParams)) {
                typestr = typestr + "(" + col.columnSize + ")";
            }
            typestr = typestr + ("YES".equals(col.isNullable) ? "" : " NOT NULL");
            return typestr;
        }
        String typestr = col.typeName;
        if (col.columnSize != 0) {
            typestr = typestr + "(" + col.columnSize + (col.decimalDigits != 0 ? ", " + col.decimalDigits : "") + ")";
        }
        typestr = typestr + ("YES".equals(col.isNullable) ? "" : " NOT NULL");
        return typestr;
    }

    public String getToolTipText(TableInfo table, ColumnInfo info) {
        String msg = "<b>" + this.getTypeStr(info) + "</b><br>";
        int pk = table.getPrimaryKeySeq(info.columnName);
        if (pk != -1) {
            msg = msg + "<b>PK</b>:" + pk + "<br>";
        }
        msg = msg + "column:<b>" + info.columnName + "</b><br>" + "dataType:<b>" + info.dataType + "</b><br>" + "typeName:<b>" + info.typeName + "</b><br>" + "columnSize:<b>" + info.columnSize + "</b><br>" + "decimalDigits:<b>" + info.decimalDigits + "</b><br>" + "numPrecRadix:<b>" + info.numPrecRadix + "</b><br>" + "nullable:<b>" + info.nullable + "</b><br>" + "remarks:<b>" + info.remarks + "</b><br>" + "columnDefault:<b>" + info.columnDefault + "</b><br>" + "charOctetLength:<b>" + info.charOctetLength + "</b><br>" + "ordinalPosition:<b>" + info.ordinalPosition + "</b><br>" + "isNullable:<b>" + info.isNullable + "</b><br>" + "scopeCatalog:<b>" + info.scopeCatalog + "</b><br>" + "scopeSchema:<b>" + info.scopeSchema + "</b><br>" + "scopeTable:<b>" + info.scopeTable + "</b><br>" + "sourceDataType:<b>" + info.sourceDataType + "</b>";
        return "<html>" + msg + "</html>";
    }

    public String getToolTipText(ResultInfo info) {
        return "<html>isAutoIncrement:<b>" + info.isAutoIncrement + "</b><br>" + "isCaseSensitive:<b>" + info.isCaseSensitive + "</b><br>" + "isSearchable:<b>" + info.isSearchable + "</b><br>" + "isCurrency:<b>" + info.isCurrency + "</b><br>" + "isNullable:<b>" + info.isNullable + "</b><br>" + "isSigned:<b>" + info.isSigned + "</b><br>" + "columnDisplaySize:<b>" + info.columnDisplaySize + "</b><br>" + "columnLabel:<b>" + info.columnLabel + "</b><br>" + "columnName:<b>" + info.columnName + "</b><br>" + "schemaName:<b>" + info.schemaName + "</b><br>" + "precision:<b>" + info.precision + "</b><br>" + "scale:<b>" + info.scale + "</b><br>" + "tableName:<b>" + info.tableName + "</b><br>" + "catalogName:<b>" + info.catalogName + "</b><br>" + "columnType:<b>" + info.columnType + "</b><br>" + "columnTypeName:<b>" + info.columnTypeName + "</b><br>" + "isReadOnly:<b>" + info.isReadOnly + "</b><br>" + "isWritable:<b>" + info.isWritable + "</b><br>" + "isDefinitelyWritable:<b>" + info.isDefinitelyWritable + "</b><br>" + "columnClassName:<b>" + info.columnClassName + "</b></html>";
    }

    SchemaInfo getSchemaInfo(String catalog, String schema) {
        for (int i = 0; i < this.schemaList.size(); ++i) {
            SchemaInfo s = (SchemaInfo)this.schemaList.get(i);
            if (SxTextUtilities.compareString(s.tableCatalog, catalog) != 0 || SxTextUtilities.compareString(s.tableSchema, schema) != 0) continue;
            return s;
        }
        return null;
    }

    public BlancoSqlRule getBlancoSqlRule() {
        BlancoSqlRule rule = new BlancoSqlRule();
        rule.setKeywordCase(this.keywordCase);
        String[] lines = this.functionNames.split("\n");
        ArrayList<String> funclist = new ArrayList<String>();
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].length() < 1 || lines[i].charAt(0) == ';') continue;
            StringTokenizer st = new StringTokenizer(lines[i], " ,\t");
            while (st.hasMoreTokens()) {
                funclist.add(st.nextToken());
            }
        }
        String[] funcs = funclist.toArray(new String[funclist.size()]);
        rule.setFunctionNames(funcs);
        return rule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void outputLog(String message) {
        String str = formatter.format(new Date()) + " " + message;
        File file = new File("AsanDatabaseBrowser.log");
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(file, true));
            out.println(str);
            AsanDatabaseBrowser.theApp.logView.append(str + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    static {
        $assertionsDisabled = !VvDatabase.class.desiredAssertionStatus();
        loader = new JarClassLoader();
        productNames = new String[]{ORACLE, DB2, SQLSERVER, MYSQL, POSTGRES, OTHER};
        f = new DecimalFormat();
        formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
    }
}

