/*
 * Decompiled with CFR 0.152.
 */
package asandatabasebrowser.model;

import asandatabasebrowser.model.DbException;
import asandatabasebrowser.model.FavoriteGroup;
import asandatabasebrowser.model.FavoriteSQL;
import asandatabasebrowser.model.FavoriteTable;
import asandatabasebrowser.model.SchemaInfo;
import asandatabasebrowser.model.TableInfo;
import asandatabasebrowser.model.VvDatabase;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sourceforge.swingx.SxTextUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VvDocument {
    public static final String DATE_FORMAT = "yyyy/MM/dd HH:mm:ss.SSS";
    private static final String PROPERTIES_FILE = "./verticalviewer.properties";
    public ArrayList databaseList = new ArrayList();
    public ArrayList favList = new ArrayList();
    public int maxRecord = 1000;
    public String fontName = "Monospaced";
    public int fontSize = 12;
    private Font font = null;
    private boolean modified = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean mod) {
        this.modified = mod;
    }

    public Font getFont() {
        if (this.font == null || this.font.getSize() != this.fontSize) {
            int style = 0;
            this.font = new Font(this.fontName, style, this.fontSize);
        }
        return this.font;
    }

    public VvDatabase getDatabaseFromFavorite(FavoriteTable fav) {
        for (int i = 0; i < this.databaseList.size(); ++i) {
            VvDatabase d = (VvDatabase)this.databaseList.get(i);
            if (!d.name.equals(fav.dbName)) continue;
            return d;
        }
        return null;
    }

    public TableInfo getTableInfoFromFavorite(FavoriteTable fav) {
        VvDatabase db = this.getDatabaseFromFavorite(fav);
        if (db == null) {
            return null;
        }
        Connection conn = db.getConnection();
        if (conn == null) {
            return null;
        }
        SchemaInfo schema = null;
        ArrayList list = db.getSchemaInfoList();
        for (int i = 0; i < list.size(); ++i) {
            SchemaInfo s = (SchemaInfo)list.get(i);
            if (!SxTextUtilities.equalsString(fav.tableCatalog, s.getCatalogName()) || !SxTextUtilities.equalsString(fav.tableSchema, s.getSchemaName())) continue;
            schema = s;
            break;
        }
        if (schema == null) {
            return null;
        }
        TableInfo table = schema.getTableTypeInfo(fav.tableType).getTableInfo(fav.tableName);
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProperties() throws DbException {
        Properties prop = new Properties();
        FileInputStream in = null;
        try {
            File file = new File(PROPERTIES_FILE);
            if (!file.exists()) {
                file = new File("./dbtools.properties");
            }
            in = new FileInputStream(file);
            prop.load(in);
            int dbUserSize = Integer.parseInt(prop.getProperty("Database.size", "0"));
            for (int i = 0; i < dbUserSize; ++i) {
                String path = "Database." + i;
                String name = prop.getProperty(path + ".name");
                String driverName = prop.getProperty(path + ".driverName");
                String dbUrl = prop.getProperty(path + ".url");
                String dbUser = prop.getProperty(path + ".user");
                String dbPassword = prop.getProperty(path + ".password");
                String highlight = prop.getProperty(path + ".highlight");
                int zipname_count = Integer.parseInt(prop.getProperty(path + ".zipnames", "0"));
                ArrayList<String> zipnames = new ArrayList<String>();
                for (int z = 0; z < zipname_count; ++z) {
                    String zipname = prop.getProperty(path + ".zipnames." + z);
                    zipnames.add(zipname);
                }
                boolean isShow = "true".equals(prop.getProperty(path + ".isShow"));
                VvDatabase db = new VvDatabase(name, driverName, dbUrl, dbUser, dbPassword, zipnames, "other", highlight, isShow, true, true, false, false, false, 0, "");
                this.databaseList.add(db);
            }
            this.maxRecord = Integer.parseInt(prop.getProperty("maxRecord", "1000"));
            this.fontSize = Integer.parseInt(prop.getProperty("fontSize", "16"));
        }
        catch (IOException e) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void storeProperties() throws DbException {
        Properties prop = new Properties();
        FileOutputStream out = null;
        try {
            prop.setProperty("Database.size", "" + this.databaseList.size());
            for (int i = 0; i < this.databaseList.size(); ++i) {
                VvDatabase db = (VvDatabase)this.databaseList.get(i);
                String path = "Database." + i;
                prop.setProperty(path + ".name", db.name);
                prop.setProperty(path + ".driverName", db.driverName);
                prop.setProperty(path + ".url", db.url);
                prop.setProperty(path + ".user", db.user);
                prop.setProperty(path + ".password", db.password);
                prop.setProperty(path + ".zipnames", "" + db.jarnames.size());
                for (int z = 0; z < db.jarnames.size(); ++z) {
                    prop.setProperty(path + ".zipnames." + z, (String)db.jarnames.get(z));
                }
                if (db.highlightFilename != null) {
                    prop.setProperty(path + ".highlight", db.highlightFilename);
                }
                prop.setProperty(path + ".isShow", "" + db.isShowLoginDialog);
            }
            prop.setProperty("maxRecord", "" + this.maxRecord);
            if (8 <= this.fontSize && this.fontSize < 100) {
                prop.setProperty("fontSize", "" + this.fontSize);
            }
            out = new FileOutputStream(new File(PROPERTIES_FILE));
            prop.store(out, "VerticalViewer");
        }
        catch (IOException e) {
            throw new DbException("\u30d7\u30ed\u30d1\u30c6\u30a3\u306e\u4fdd\u5b58\u306b\u5931\u6557\u3057\u307e\u3057\u305f./verticalviewer.properties", e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void storeXml(File file) throws DbException {
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        PrintWriter writer = null;
        try {
            int i;
            writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            String date = new SimpleDateFormat(DATE_FORMAT).format(new Date());
            writer.println("<!-- generated by AsanDatabaseBrowser " + date + " -->");
            writer.println("<AsanDatabaseBrowser>");
            for (i = 0; i < this.databaseList.size(); ++i) {
                VvDatabase db = (VvDatabase)this.databaseList.get(i);
                writer.println("\t<Database>");
                writer.println("\t\t<name>" + SxTextUtilities.encodeXml(db.name) + "</name>");
                writer.println("\t\t<driverName>" + SxTextUtilities.encodeXml(db.driverName) + "</driverName>");
                writer.println("\t\t<url>" + SxTextUtilities.encodeXml(db.url) + "</url>");
                writer.println("\t\t<user>" + SxTextUtilities.encodeXml(db.user) + "</user>");
                writer.println("\t\t<password>" + SxTextUtilities.encodeXml(db.password) + "</password>");
                writer.println("\t\t<jarnames>");
                for (int z = 0; z < db.jarnames.size(); ++z) {
                    writer.println("\t\t\t<jarname>" + SxTextUtilities.encodeXml((String)db.jarnames.get(z)) + "</jarname>");
                }
                writer.println("\t\t</jarnames>");
                writer.println("\t\t<productName>" + SxTextUtilities.encodeXml(db.productName) + "</productName>");
                if (db.highlightFilename != null) {
                    writer.println("\t\t<highlight>" + SxTextUtilities.encodeXml(db.highlightFilename) + "</highlight>");
                }
                writer.println("\t\t<isShow>" + db.isShowLoginDialog + "</isShow>");
                writer.println("\t\t<rollbackBeforeClose>" + db.rollbackBeforeClose + "</rollbackBeforeClose>");
                writer.println("\t\t<rollbackAfterQuery>" + db.rollbackAfterQuery + "</rollbackAfterQuery>");
                writer.println("\t\t<useOracleTableComments>" + db.useOracleTableComments + "</useOracleTableComments>");
                writer.println("\t\t<useOracleColumnComments>" + db.useOracleColumnComments + "</useOracleColumnComments>");
                writer.println("\t\t<hideOracleBinTable>" + db.hideOracleBinTable + "</hideOracleBinTable>");
                writer.println("\t\t<keywordCase>" + db.keywordCase + "</keywordCase>");
                writer.println("\t\t<functionNames>" + SxTextUtilities.encodeXml(db.functionNames) + "</functionNames>");
                writer.println("\t</Database>");
            }
            writer.println("\t<Favorite>");
            for (i = 0; i < this.favList.size(); ++i) {
                FavoriteGroup group = (FavoriteGroup)this.favList.get(i);
                writer.println("\t\t<FavoriteGroup>");
                writer.println("\t\t\t<name>" + group.name + "</name>");
                for (int j = 0; j < group.list.size(); ++j) {
                    if (group.get(j) instanceof FavoriteTable) {
                        FavoriteTable table = (FavoriteTable)group.get(j);
                        writer.println("\t\t\t<FavoriteTable>");
                        writer.println("\t\t\t\t<name>" + SxTextUtilities.encodeXml(table.name) + "</name>");
                        writer.println("\t\t\t\t<dbName>" + SxTextUtilities.encodeXml(table.dbName) + "</dbName>");
                        writer.println("\t\t\t\t<tableCatalog>" + (table.tableCatalog != null ? table.tableCatalog : "") + "</tableCatalog>");
                        writer.println("\t\t\t\t<tableSchema>" + (table.tableSchema != null ? table.tableSchema : "") + "</tableSchema>");
                        writer.println("\t\t\t\t<tableName>" + table.tableName + "</tableName>");
                        writer.println("\t\t\t\t<tableType>" + table.tableType + "</tableType>");
                        writer.println("\t\t\t</FavoriteTable>");
                        continue;
                    }
                    if (!(group.get(j) instanceof FavoriteSQL)) continue;
                    FavoriteSQL sql = (FavoriteSQL)group.get(j);
                    writer.println("\t\t\t<FavoriteSQL>");
                    writer.println("\t\t\t\t<name>" + SxTextUtilities.encodeXml(sql.name) + "</name>");
                    writer.println("\t\t\t\t<dbName>" + SxTextUtilities.encodeXml(sql.dbName) + "</dbName>");
                    for (int k = 0; k < sql.getCount(); ++k) {
                        writer.println("\t\t\t\t<SQL>" + SxTextUtilities.encodeXml(sql.getSql(k)) + "</SQL>");
                    }
                    writer.println("\t\t\t</FavoriteSQL>");
                }
                writer.println("\t\t</FavoriteGroup>");
            }
            writer.println("\t</Favorite>");
            writer.println("\t<option>");
            writer.println("\t\t<maxRecord>" + this.maxRecord + "</maxRecord>");
            if (8 <= this.fontSize && this.fontSize < 100) {
                writer.println("\t\t<fontSize>" + this.fontSize + "</fontSize>");
            }
            writer.println("\t</option>");
            writer.println("</AsanDatabaseBrowser>");
        }
        catch (UnsupportedEncodingException ex) {
            throw new DbException("\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002encoding=UTF8", ex);
        }
        catch (FileNotFoundException ex) {
            throw new DbException("\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002file=" + file, ex);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public void loadXml(File file) {
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !file.exists()) {
            throw new AssertionError();
        }
        try {
            System.out.println("file=" + file);
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            Document document = builder.parse(file);
            NodeList list = document.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node n = list.item(i);
                if (!n.getNodeName().equals("AsanDatabaseBrowser")) continue;
                this.loadAsanDatabaseBrowser(n);
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadVerticalViewerXml(File file) {
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !file.exists()) {
            throw new AssertionError();
        }
        try {
            System.out.println("file=" + file);
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            Document document = builder.parse(file);
            NodeList list = document.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node n = list.item(i);
                if (!n.getNodeName().equals("VerticalViewer")) continue;
                this.loadAsanDatabaseBrowser(n);
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadAsanDatabaseBrowser(Node node) {
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (n.getNodeType() != 1) continue;
            if (n.getNodeName().equals("Database")) {
                try {
                    VvDatabase db = this.loadDatabase(n);
                    this.databaseList.add(db);
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (n.getNodeName().equals("Favorite")) {
                this.favList = this.loadFavorite(n);
                continue;
            }
            if (!n.getNodeName().equals("option")) continue;
            this.loadOption(n);
        }
    }

    private VvDatabase loadDatabase(Node node) {
        String name = null;
        String driverName = null;
        String url = null;
        String user = "";
        String password = "";
        String productName = "other";
        String highlight = "";
        ArrayList jarnames = new ArrayList();
        boolean isShow = false;
        boolean rollbackBeforeClose = true;
        boolean rollbackAfterQuery = true;
        boolean useOracleTableComments = false;
        boolean useOracleColumnComments = false;
        boolean hideOracleBinTable = false;
        int keywordCase = 0;
        String functionNames = "";
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (n.getNodeType() != 1) continue;
            if (n.getNodeName().equals("name")) {
                name = n.getFirstChild().getNodeValue();
                continue;
            }
            if (n.getNodeName().equals("driverName")) {
                driverName = n.getFirstChild().getNodeValue();
                continue;
            }
            if (n.getNodeName().equals("url")) {
                url = n.getFirstChild().getNodeValue();
                continue;
            }
            if (n.getNodeName().equals("user") && n.getFirstChild() != null) {
                user = n.getFirstChild().getNodeValue();
                continue;
            }
            if (n.getNodeName().equals("password") && n.getFirstChild() != null) {
                password = n.getFirstChild().getNodeValue();
                continue;
            }
            if (n.getNodeName().equals("productName") & n.getFirstChild() != null) {
                productName = n.getFirstChild().getNodeValue();
                continue;
            }
            if (n.getNodeName().equals("highlight") && n.getFirstChild() != null) {
                highlight = n.getFirstChild().getNodeValue();
                continue;
            }
            if (n.getNodeName().equals("isShow")) {
                isShow = "true".equals(n.getFirstChild().getNodeValue());
                continue;
            }
            if (n.getNodeName().equals("rollbackBeforeClose")) {
                rollbackBeforeClose = "true".equals(n.getFirstChild().getNodeValue());
                continue;
            }
            if (n.getNodeName().equals("rollbackAfterQuery")) {
                rollbackAfterQuery = "true".equals(n.getFirstChild().getNodeValue());
                continue;
            }
            if (n.getNodeName().equals("jarnames") && n.getFirstChild() != null) {
                jarnames = this.loadJarnames(n);
                continue;
            }
            if (n.getNodeName().equals("useOracleTableComments") && n.getFirstChild() != null) {
                useOracleTableComments = "true".equals(n.getFirstChild().getNodeValue());
                continue;
            }
            if (n.getNodeName().equals("useOracleColumnComments") && n.getFirstChild() != null) {
                useOracleColumnComments = "true".equals(n.getFirstChild().getNodeValue());
                continue;
            }
            if (n.getNodeName().equals("hideOracleBinTable") && n.getFirstChild() != null) {
                hideOracleBinTable = "true".equals(n.getFirstChild().getNodeValue());
                continue;
            }
            if (n.getNodeName().equals("keywordCase") && n.getFirstChild() != null) {
                keywordCase = Integer.parseInt(n.getFirstChild().getNodeValue());
                continue;
            }
            if (!n.getNodeName().equals("functionNames") || n.getFirstChild() == null) continue;
            functionNames = n.getFirstChild().getNodeValue();
        }
        return new VvDatabase(name, driverName, url, user, password, jarnames, productName, highlight, isShow, rollbackBeforeClose, rollbackAfterQuery, useOracleTableComments, useOracleColumnComments, hideOracleBinTable, keywordCase, functionNames);
    }

    private ArrayList loadJarnames(Node node) {
        ArrayList<String> result = new ArrayList<String>();
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (n.getNodeType() != 1 || !n.getNodeName().equals("jarname")) continue;
            String jarname = n.getFirstChild().getNodeValue();
            result.add(jarname);
        }
        return result;
    }

    private ArrayList loadFavorite(Node node) {
        ArrayList<FavoriteGroup> result = new ArrayList<FavoriteGroup>();
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (n.getNodeType() != 1 || !n.getNodeName().equals("FavoriteGroup")) continue;
            FavoriteGroup group = this.loadFaroviteGroup(n);
            result.add(group);
        }
        return result;
    }

    private FavoriteGroup loadFaroviteGroup(Node node) {
        FavoriteGroup group = null;
        String name = null;
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (n.getNodeType() != 1) continue;
            if (n.getNodeName().equals("name")) {
                name = n.getFirstChild().getNodeValue();
                group = new FavoriteGroup(name);
                continue;
            }
            if (n.getNodeName().equals("FavoriteTable") && n.getFirstChild() != null) {
                FavoriteTable table = this.loadFavoriteTable(n);
                group.add(table);
                continue;
            }
            if (!n.getNodeName().equals("FavoriteSQL")) continue;
            FavoriteSQL sql = this.loadFavoriteSQL(n);
            group.add(sql);
        }
        return group;
    }

    private FavoriteTable loadFavoriteTable(Node node) {
        String name = null;
        String dbName = null;
        String tableCatalog = null;
        String tableSchema = null;
        String tableName = null;
        String tableType = null;
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (n.getNodeType() != 1) continue;
            if (n.getNodeName().equals("name")) {
                name = n.getFirstChild().getNodeValue();
                continue;
            }
            if (n.getNodeName().equals("dbName")) {
                dbName = n.getFirstChild().getNodeValue();
                continue;
            }
            if (n.getNodeName().equals("tableCatalog") && n.getFirstChild() != null) {
                tableCatalog = n.getFirstChild().getNodeValue();
                continue;
            }
            if (n.getNodeName().equals("tableSchema") && n.getFirstChild() != null) {
                tableSchema = n.getFirstChild().getNodeValue();
                continue;
            }
            if (n.getNodeName().equals("tableName") && n.getFirstChild() != null) {
                tableName = n.getFirstChild().getNodeValue();
                continue;
            }
            if (!n.getNodeName().equals("tableType") || n.getFirstChild() == null) continue;
            tableType = n.getFirstChild().getNodeValue();
        }
        return new FavoriteTable(name, dbName, tableCatalog, tableSchema, tableName, tableType);
    }

    private FavoriteSQL loadFavoriteSQL(Node node) {
        String dbName = null;
        String name = null;
        ArrayList<String> sqlList = new ArrayList<String>();
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (n.getNodeType() != 1) continue;
            if (n.getNodeName().equals("name")) {
                name = n.getFirstChild().getNodeValue();
                continue;
            }
            if (n.getNodeName().equals("dbName")) {
                dbName = n.getFirstChild().getNodeValue();
                continue;
            }
            if (!n.getNodeName().equals("SQL")) continue;
            String sql = n.getFirstChild().getNodeValue();
            sqlList.add(sql);
        }
        return new FavoriteSQL(dbName, name, sqlList);
    }

    private void loadOption(Node node) {
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (n.getNodeType() != 1) continue;
            if (n.getNodeName().equals("maxRecord")) {
                this.maxRecord = Integer.parseInt(n.getFirstChild().getNodeValue());
                continue;
            }
            if (!n.getNodeName().equals("fontSize")) continue;
            this.fontSize = Integer.parseInt(n.getFirstChild().getNodeValue());
        }
    }

    static {
        $assertionsDisabled = !VvDocument.class.desiredAssertionStatus();
    }
}

