/*
 * Decompiled with CFR 0.152.
 */
package asandatabasebrowser.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class ExcelCsvFile {
    public static final int LINE_SEPARATOR = 13;
    public static final int COLUMN_SEPARATOR = 9;
    BufferedReader reader = null;

    ExcelCsvFile(File file, String charset) throws UnsupportedEncodingException, FileNotFoundException {
        this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
    }

    void close() throws IOException {
        this.reader.close();
    }

    String[] readLine() throws IOException {
        if (this.reader == null) {
            return null;
        }
        if (!this.reader.ready()) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        int ch = this.reader.read();
        while (true) {
            String str;
            if (ch == -1) {
                this.reader.close();
                this.reader = null;
                break;
            }
            if (ch == 13 || ch == 10) {
                if (ch != 13) break;
                this.reader.mark(1);
                ch = this.reader.read();
                if (ch == 10) break;
                this.reader.reset();
                break;
            }
            if (ch == 9) {
                result.add("");
                ch = this.reader.read();
                continue;
            }
            if (ch == 34) {
                str = "";
                while (true) {
                    if ((ch = this.reader.read()) == -1) {
                        return null;
                    }
                    if (ch == 34) break;
                    str = str + (char)ch;
                }
                result.add(str);
                ch = this.reader.read();
                if (ch != 9) continue;
                ch = this.reader.read();
                continue;
            }
            str = "";
            do {
                str = str + (char)ch;
            } while ((ch = this.reader.read()) != 9 && ch != 13 && ch != 10 && ch != -1);
            result.add(str);
            if (ch != 9) continue;
            ch = this.reader.read();
        }
        String[] r = new String[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            r[i] = (String)result.get(i);
        }
        return r;
    }

    public static int insert(File file, String encoding) throws Exception {
        String[] line;
        int count = 0;
        ExcelCsvFile cvs = new ExcelCsvFile(file, "UTF-8");
        while ((line = cvs.readLine()) != null) {
            for (int i = 0; i < line.length; ++i) {
                System.out.print("[" + line[i] + "]");
            }
            System.out.println();
            ++count;
        }
        return count;
    }

    public static void main(String[] args) throws Exception {
        String[] line;
        File file = new File("data/test.txt");
        ExcelCsvFile cvs = new ExcelCsvFile(file, "UTF-8");
        while ((line = cvs.readLine()) != null) {
            for (int i = 0; i < line.length; ++i) {
                System.out.print("[" + line[i] + "]");
            }
            System.out.println();
        }
    }
}

