/*
 * Decompiled with CFR 0.152.
 */
package asandatabasebrowser.util;

import asandatabasebrowser.Global;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import net.sourceforge.swingx.SxUtilities;

public class FontChooser
extends JPanel {
    String[] FONT_NAMES = new String[]{"Serif", "SansSerif", "Monospaced", "Dialog", "DialogInput"};
    static String A_QUICK_BROWN_FOX = "A quick brown fox jumps over the lazy dog";
    static int GAP = 10;
    private JComboBox cmbFamily;
    private JTextField txtSize;
    private JToggleButton tglBold;
    private JToggleButton tglItalic;
    private JTextArea sample;

    public FontChooser(boolean showLabel, boolean showSample, boolean logicalFont) {
        String[] fontNames = null;
        if (logicalFont) {
            fontNames = this.FONT_NAMES;
        } else {
            GraphicsEnvironment genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
            fontNames = genv.getAvailableFontFamilyNames();
        }
        this.setLayout(new BorderLayout(GAP, GAP));
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(2, 2, GAP, GAP));
        if (showLabel) {
            panel.add(new JLabel(FontChooser._("FontFamily")));
        }
        this.cmbFamily = new JComboBox<String>(fontNames);
        Dimension dim = new Dimension(200, 25);
        this.cmbFamily.setMinimumSize(dim);
        this.cmbFamily.setPreferredSize(dim);
        this.cmbFamily.setMaximumSize(dim);
        panel.add(this.cmbFamily);
        if (showLabel) {
            panel.add(new JLabel(FontChooser._("FontSize")));
        }
        JPanel panel2 = new JPanel(new GridLayout(1, 3, GAP, GAP));
        this.txtSize = new JTextField("10", 3);
        this.txtSize.setHorizontalAlignment(11);
        panel2.add(this.txtSize);
        ImageIcon icon = Global.getImageIcon("/resources/FontBold.png");
        this.tglBold = icon != null ? new JToggleButton(icon) : new JToggleButton("Bold");
        this.tglBold.setPreferredSize(new Dimension(25, 25));
        panel2.add(this.tglBold);
        icon = Global.getImageIcon("/resources/FontItalic.png");
        this.tglItalic = icon != null ? new JToggleButton(icon) : new JToggleButton("Italic");
        this.tglItalic.setPreferredSize(new Dimension(25, 25));
        panel2.add(this.tglItalic);
        panel.add(panel2);
        this.add((Component)panel, "Center");
        if (showSample) {
            this.sample = new JTextArea(A_QUICK_BROWN_FOX.toUpperCase() + "\n" + A_QUICK_BROWN_FOX.toLowerCase() + "\n" + "\u3072\u3089\u304c\u306a\u30ab\u30bf\u30ab\u30ca\u6f22\u5b57" + "\n" + "12345678901234567890", 5, 40);
            SxUtilities.addPopupMenuMouseListener(this.sample);
            this.add((Component)new JScrollPane(this.sample), "South");
            FontListener listener = new FontListener();
            this.cmbFamily.addItemListener(listener);
            this.tglBold.addActionListener(listener);
            this.tglItalic.addActionListener(listener);
        }
    }

    public FontChooser() {
        this(true, true, true);
    }

    public FontChooser(Font font) {
        this();
        this.setFont(font);
    }

    public Font getChoosedFont() {
        String family = (String)this.cmbFamily.getSelectedItem();
        int style = 0;
        if (this.tglBold.isSelected()) {
            style |= 1;
        }
        if (this.tglItalic.isSelected()) {
            style |= 2;
        }
        int size = 10;
        try {
            size = Integer.parseInt(this.txtSize.getText());
        }
        catch (NumberFormatException e) {
            System.out.println("FontChooser:\u6570\u5024\u3067\u306a\u3044");
        }
        return new Font(family, style, size);
    }

    public void setChoosedFont(Font font) {
        this.cmbFamily.setSelectedItem(font.getFamily());
        this.tglBold.setSelected(font.isBold());
        this.tglItalic.setSelected(font.isItalic());
        this.txtSize.setText("" + font.getSize());
        if (this.sample != null) {
            this.sample.setFont(font);
        }
    }

    public void setEnabled(boolean sel) {
        this.cmbFamily.setEnabled(sel);
        this.txtSize.setEnabled(sel);
        this.tglBold.setEnabled(sel);
        this.tglItalic.setEnabled(sel);
    }

    public static Font showDialog(Component parent, String title, Font font) {
        FontChooser chooser = new FontChooser();
        chooser.setFont(font);
        int rc = JOptionPane.showConfirmDialog(parent, chooser, title, 2, -1);
        if (rc != 0) {
            return null;
        }
        return chooser.getFont();
    }

    private static String _(String text) {
        return text;
    }

    public static void main(String[] args) {
        GraphicsEnvironment genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] names = genv.getAvailableFontFamilyNames();
        System.out.println("genv.getAvailableFontFamilyNames() size=" + names.length);
        for (int i = 0; i < names.length; ++i) {
            System.out.println(names[i]);
        }
        Font[] fonts = genv.getAllFonts();
        System.out.println("genv.getAllFonts() size=" + fonts.length);
        for (int i = 0; i < fonts.length; ++i) {
            System.out.println(fonts[i]);
        }
        JFrame frame = new JFrame();
        JToolBar bar = new JToolBar();
        FontChooser chooser = new FontChooser(false, true, true);
        chooser.setFont(new Font("Serif", 1, 10));
        bar.add(chooser);
        Container pane = frame.getContentPane();
        pane.add((Component)bar, "North");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.setSize(800, 600);
        frame.setVisible(true);
        Font font = new Font("Serif", 1, 10);
        Font newFont = FontChooser.showDialog(frame, "FontChooser", font);
        System.out.println(newFont);
        System.exit(0);
    }

    class FontListener
    implements ActionListener,
    ItemListener {
        FontListener() {
        }

        public void actionPerformed(ActionEvent e) {
            System.out.println("actionPerformed() e=" + e);
            System.out.println("Bold=" + FontChooser.this.tglBold.isSelected() + " Italic=" + FontChooser.this.tglItalic.isSelected());
            Font font = FontChooser.this.getChoosedFont();
            FontChooser.this.sample.setFont(font);
        }

        public void itemStateChanged(ItemEvent e) {
            System.out.println("itemStateChanged() e=" + e);
            Font font = FontChooser.this.getChoosedFont();
            FontChooser.this.sample.setFont(font);
        }
    }
}

