/*
 * Decompiled with CFR 0.152.
 */
package asandatabasebrowser.util;

import asandatabasebrowser.model.ColumnInfo;
import asandatabasebrowser.model.DbException;
import asandatabasebrowser.model.TableInfo;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SqlGenerator {
    protected Document template;
    protected String timestamp;
    static SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    public SqlGenerator(String templateFilename) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        this.template = builder.parse(new File(templateFilename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generate(ArrayList tableInfoList) throws DbException {
        this.timestamp = formatter.format(Calendar.getInstance().getTime());
        Node source = this.findSourceNode(this.template, "type", "DDL");
        if (source == null) {
            return null;
        }
        PrintWriter writer = null;
        try {
            StringWriter sw = new StringWriter();
            writer = new PrintWriter(sw);
            this.generateSource(source, tableInfoList, writer);
            String string = sw.toString();
            return string;
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private Node findSourceNode(Node node, String name, String value) {
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node result;
            Node n = list.item(i);
            if (n.getNodeName().equals("source")) {
                if (name != null) {
                    Node an = n.getAttributes().getNamedItem(name);
                    System.out.println(an);
                    System.out.println(an.getNodeName());
                    return n;
                }
                return n;
            }
            if (n.getNodeType() != 1 || (result = this.findSourceNode(n, name, value)) == null) continue;
            return result;
        }
        return null;
    }

    private void generateSource(Node node, ArrayList tableInfoList, PrintWriter writer) throws DbException {
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (n.getNodeName().equals("forAllTables")) {
                this.generateForAllTables(n, tableInfoList, writer);
                continue;
            }
            if (n.getNodeType() != 3) continue;
            String str = n.getNodeValue();
            writer.print(this.replaceKeywords(str, null, null));
        }
    }

    private void generateForAllTables(Node node, ArrayList tableInfoList, PrintWriter writer) throws DbException {
        for (int i = 0; i < tableInfoList.size(); ++i) {
            TableInfo info = (TableInfo)tableInfoList.get(i);
            info.updateColumnInfoList();
            NodeList list = node.getChildNodes();
            for (int j = 0; j < list.getLength(); ++j) {
                Node n = list.item(j);
                if (n.getNodeType() == 3) {
                    String str = n.getNodeValue();
                    System.out.println("[" + str + "]");
                    writer.print(this.replaceKeywords(str, info, null));
                    continue;
                }
                if (!n.getNodeName().equals("forAllColumns")) continue;
                this.generateForAllColumns(n, info, info.getColumnInfoList(), writer);
            }
        }
    }

    private void generateForAllColumns(Node node, TableInfo table, ArrayList columnInfoList, PrintWriter writer) throws DbException {
        for (int i = 0; i < columnInfoList.size(); ++i) {
            ColumnInfo info = (ColumnInfo)columnInfoList.get(i);
            NodeList list = node.getChildNodes();
            for (int j = 0; j < list.getLength(); ++j) {
                String str;
                Node n = list.item(j);
                if (n.getNodeType() == 3) {
                    str = n.getNodeValue();
                    writer.print(this.replaceKeywords(str, table, info));
                    continue;
                }
                if (n.getNodeName().equals("excludeFirst")) {
                    if (i == 0) continue;
                    str = n.getChildNodes().item(0).getNodeValue();
                    writer.print(this.replaceKeywords(str, table, info));
                    continue;
                }
                if (!n.getNodeName().equals("excludeLast") || i == columnInfoList.size() - 1) continue;
                str = n.getChildNodes().item(0).getNodeValue();
                writer.print(this.replaceKeywords(str, table, info));
            }
        }
    }

    private String replaceKeywords(String str, TableInfo table, ColumnInfo col) {
        if (col != null) {
            str = this.replaceKeyword(str, "${COLUMN_NAME}", col.columnName.toUpperCase());
            str = this.replaceKeyword(str, "${column_name}", col.columnName.toLowerCase());
            str = this.replaceKeyword(str, "${REMARKS}", col.remarks);
            str = this.replaceKeyword(str, "${TYPE}", table.db.getTypeStr(col));
        }
        if (table != null) {
            str = this.replaceKeyword(str, "${TABLE_NAME}", table.getSqlTableName().toUpperCase());
            str = this.replaceKeyword(str, "${table_name}", table.getSqlTableName().toLowerCase());
            str = this.replaceKeyword(str, "${REMARKS}", table.getRemarks());
            if (table.pkList != null && table.pkList.size() > 0) {
                String pk = "PRIMARY KEY(";
                for (int i = 0; i < table.pkList.size(); ++i) {
                    if (i != 0) {
                        pk = pk + ", ";
                    }
                    pk = pk + table.pkList.get(i);
                }
                pk = pk + ")\n";
                str = this.replaceKeyword(str, "${PRIMARY_KEY}", pk);
            } else {
                str = this.replaceKeyword(str, "${PRIMARY_KEY}", "");
            }
        }
        str = this.replaceKeyword(str, "${TIMESTAMP}", this.timestamp);
        return str;
    }

    private String replaceKeyword(String str, String key, String val) {
        int pos;
        if (val == null) {
            val = "";
        }
        if ((pos = str.indexOf(key)) == -1) {
            return str;
        }
        str = str.substring(0, pos) + val + str.substring(pos + key.length());
        return this.replaceKeyword(str, key, val);
    }

    public static String getUpperLowerString(String arg, boolean firstUpper) {
        String result = "";
        boolean nextUpper = firstUpper;
        for (int i = 0; i < arg.length(); ++i) {
            if (arg.charAt(i) == '_') {
                nextUpper = true;
                continue;
            }
            if (nextUpper) {
                result = result + Character.toUpperCase(arg.charAt(i));
                nextUpper = false;
                continue;
            }
            result = result + Character.toLowerCase(arg.charAt(i));
        }
        return result;
    }
}

