/*
 * Decompiled with CFR 0.152.
 */
package asandatabasebrowser.view;

import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.model.VvDatabase;
import asandatabasebrowser.model.VvDocument;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.sourceforge.swingx.SxMessageBox;
import net.sourceforge.swingx.SxOptionPane;
import net.sourceforge.swingx.SxUtilities;

public class DatabaseDialog
extends JPanel {
    public JTextField name = new JTextField();
    public JComboBox driver = new JComboBox();
    public JComboBox url = new JComboBox();
    public JTextField user = new JTextField();
    public JPasswordField pass = new JPasswordField();
    public JTextArea classpaths = new JTextArea();
    public JCheckBox isShow = new JCheckBox("\u63a5\u7d9a\u6642\u306b\u30e6\u30fc\u30b6\u540d\u3068\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u554f\u3044\u5408\u308f\u305b\u308b");
    public JCheckBox rollbackBeforeClose = new JCheckBox("\u5207\u65ad\u6642\u306brollback\u3059\u308b");
    public JCheckBox rollbackAfterQuery = new JCheckBox("\u691c\u7d22\u6642\u306b\u5373\u5ea7\u306brollback\u3059\u308b");
    private JComboBox productName = new JComboBox<String>(VvDatabase.productNames);
    public JTextField highlightFile = new JTextField();
    public JCheckBox useOracleTableComments = new JCheckBox("\u30aa\u30e9\u30af\u30eb\u306e\u3068\u304d\u3001SYS.ALL_TAB_COMMENTS \u306e\u30b3\u30e1\u30f3\u30c8\u3092 remark \u306b\u3059\u308b\u304b\uff1f");
    public JCheckBox useOracleColumnComments = new JCheckBox("\u30aa\u30e9\u30af\u30eb\u306e\u3068\u304d\u3001SYS.ALL_COL_COMMENTS \u306e\u30b3\u30e1\u30f3\u30c8\u3092 remark \u306b\u3059\u308b\u304b\uff1f");
    public JCheckBox hideOracleBinTable = new JCheckBox("\u30aa\u30e9\u30af\u30eb10g\u4ee5\u964d\u306e\u3068\u304d\u3001\u30ea\u30b5\u30a4\u30af\u30eb\u30d3\u30f3\uff08\u30b4\u30df\u7bb1\u30c6\u30fc\u30d6\u30eb\uff09\u3092\u8868\u793a\u3057\u306a\u3044\u3002");
    public JRadioButton[] keywordCase = new JRadioButton[3];
    public JTextArea functionNames = new JTextArea(10, 80);
    static final /* synthetic */ boolean $assertionsDisabled;

    public DatabaseDialog() {
        JTabbedPane tab = new JTabbedPane();
        this.add(tab);
        tab.addTab("\u57fa\u672c", this.createBaseTab());
        tab.addTab("\u62e1\u5f35", this.createExtTab());
        tab.addTab("SQL\u6574\u5f62", this.createSqlFormatterTab());
    }

    private JPanel createBaseTab() {
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        GridBagLayout gridbag = new GridBagLayout();
        panel.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.insets = new Insets(4, 8, 4, 8);
        this.driver.setEditable(true);
        this.url.setEditable(true);
        SxUtilities.addPopupMenuMouseListener(this.name);
        SxUtilities.addPopupMenuMouseListener(this.user);
        SxUtilities.addPopupMenuMouseListener(this.pass);
        SxUtilities.addPopupMenuMouseListener(this.classpaths);
        VvDocument doc = AsanDatabaseBrowser.theApp.doc;
        HashSet<String> drivers = new HashSet<String>();
        HashSet<String> urls = new HashSet<String>();
        for (int i = 0; i < doc.databaseList.size(); ++i) {
            VvDatabase db = (VvDatabase)doc.databaseList.get(i);
            drivers.add(db.driverName);
            urls.add(db.url);
        }
        Dimension dim = this.url.getPreferredSize();
        dim.width = 800;
        this.url.setPreferredSize(new Dimension(400, dim.height));
        this.url.setMaximumSize(dim);
        this.driver.addItem("sun.jdbc.odbc.JdbcOdbcDriver");
        this.driver.addItem("oracle.jdbc.driver.OracleDriver");
        this.driver.addItem("com.ibm.db2.jcc.DB2Driver");
        this.driver.addItem("COM.ibm.db2.jdbc.app.DB2Driver");
        this.driver.addItem("COM.ibm.db2.jdbc.net.DB2Driver");
        this.driver.addItem("com.ibm.db2.jcc.DB2Driver");
        this.driver.addItem("com.microsoft.sqlserver.jdbc.SQLServerDriver");
        this.driver.addItem("com.microsoft.jdbc.sqlserver.SQLServerDriver");
        this.driver.addItem("com.mysql.jdbc.Driver");
        this.driver.addItem("org.gjt.mm.mysql.Driver");
        this.driver.addItem("org.postgresql.Driver");
        this.driver.addItem("com.ncr.teradata.TeraDriver");
        this.driver.addItem("org.firebirdsql.jdbc.FBDriver");
        this.driver.addItem("org.hsqldb.jdbcDriver");
        this.driver.addItem("org.apache.derby.jdbc.EmbeddedDriver");
        this.driver.addItem("com.openbase.jdbc.ObDriver");
        this.driver.addItem("org.h2.Driver");
        this.driver.addItem("com.sybase.jdbc.SybDriver");
        this.driver.addItem("com.sybase.jdbc2.jdbc.SybDriver");
        this.driver.addItem("org.sqlite.JDBC");
        this.driver.addItem("org.axiondb.jdbc.AxionDriver");
        this.url.addItem("jdbc:odbc:<DataSourceName>");
        this.url.addItem("jdbc:oracle:thin:@127.0.0.1:1521:<SID>");
        this.url.addItem("jdbc:oracle:oci:@<TNS>");
        this.url.addItem("jdbc:oracle:oci8:@<TNS>");
        this.url.addItem("jdbc:db2:<DataSourceName>");
        this.url.addItem("jdbc:db2://127.0.0.1:50000/<DataBaseName>");
        this.url.addItem("jdbc:db2://127.0.0.1:50000/<DataBaseName>");
        this.url.addItem("jdbc:sqlserver://localhost:1433;DatabaseName=<DBName>");
        this.url.addItem("jdbc:microsoft:sqlserver://127.0.0.1:1433;DatabaseName=<DBName>");
        this.url.addItem("jdbc:mysql://127.0.0.1:3306/<DBName>");
        this.url.addItem("jdbc:mysql://<host>/<database_name>?useUnicode=true&characterEncoding=SJIS");
        this.url.addItem("jdbc:postgresql://127.0.0.1:5432/<DBName>");
        this.url.addItem("jdbc:teradata://127.0.0.1:6063/<DBName>");
        this.url.addItem("jdbc:firebirdsql://127.0.0.1:3050/<DataBasePath>");
        this.url.addItem("jdbc:hsqldb:hsql://127.0.0.1:9001/<databasename>");
        this.url.addItem("jdbc:hsqldb:file:<databasename>");
        this.url.addItem("jdbc:hsqldb:mem:<databasename>");
        this.url.addItem("jdbc:derby:<databasename>;create=true");
        this.url.addItem("jdbc:openbase://localhost/<DataBaseName>");
        this.url.addItem("jdbc:h2:tcp://localhost:9092/<DataBasePath>");
        this.url.addItem("jdbc:h2:<DataBasePath>");
        this.url.addItem("jdbc:sybase:Tds:localhost:8001/<databasename>");
        this.url.addItem("jdbc:sqlite:<databasefile_path>");
        this.url.addItem("jdbc:axiondb:<database-name>[:<database-directory>]");
        this.name.setToolTipText("\u30e6\u30cb\u30fc\u30af\u306a\u4efb\u610f\u306e\u540d\u524d\u3092\u3064\u3051\u3066\u304f\u3060\u3055\u3044");
        this.driver.setToolTipText("\u5fc5\u9808");
        this.url.setToolTipText("\u5fc5\u9808");
        this.user.setToolTipText("\u63a5\u7d9a\u6642\u306b\u554f\u3044\u5408\u308f\u305b\u308b\u306a\u3089\u7701\u7565\u53ef\u80fd\u3067\u3059");
        this.pass.setToolTipText("\u63a5\u7d9a\u6642\u306b\u554f\u3044\u5408\u308f\u305b\u308b\u306a\u3089\u7701\u7565\u53ef\u80fd\u3067\u3059");
        this.classpaths.setToolTipText("<html>JDBC\u30c9\u30e9\u30a4\u30d0\u306ejar\u30d5\u30a1\u30a4\u30eb\u306e\u30d1\u30b9\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002<br>\u30a8\u30af\u30b9\u30d7\u30ed\u30fc\u30e9\u304b\u3089\u30c9\u30e9\u30c3\u30b0\uff06\u30c9\u30ed\u30c3\u30d7\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u3059\u3002</html>");
        this.classpaths.setRows(5);
        this.rollbackBeforeClose.setToolTipText("<html>DB2\u306e\u5834\u5408\u3001\u5207\u65ad\u524d\u306bcommit/rollback\u3057\u306a\u3044\u3068\u30a8\u30e9\u30fc\u306b\u306a\u308b\u305d\u3046\u3067\u3059\u3002<br>ODBC Microsoft Access Driver\u3082\u305d\u3046\u3067\u3059\u3002</html>");
        this.rollbackAfterQuery.setToolTipText("<html>DB2\u306a\u3069\u540c\u671f\u30ec\u30d9\u30eb\u306b\u3088\u3063\u3066\u306f\u3001\u691c\u7d22\u3057\u305f\u3060\u3051\u3067\u3082\u305d\u306e\u30ec\u30b3\u30fc\u30c9\u3001\u307e\u305f\u306f\u30c6\u30fc\u30d6\u30eb\u304c\u30ed\u30c3\u30af\u3055\u308c\u307e\u3059\u3002<br>\u305d\u306e\u5834\u5408\u305f\u3060\u3061\u306brollback\u3092\u884c\u308f\u306a\u3044\u3068\u3001\u4ed6\u306e\u30c8\u30e9\u30f3\u30b6\u30af\u30b7\u30e7\u30f3\u304c\u51e6\u7406\u3067\u304d\u306a\u304f\u306a\u3063\u3066\u3057\u307e\u3044\u307e\u3059\u3002</html>");
        new DropTarget(this.classpaths, 3, new ClassPathDropListener(), true);
        JLabel label = new JLabel("\u540d\u524d(N)");
        label.setDisplayedMnemonic('N');
        label.setLabelFor(this.name);
        gridbag.setConstraints(label, c);
        panel.add(label);
        c.gridwidth = 0;
        gridbag.setConstraints(this.name, c);
        panel.add(this.name);
        c.gridwidth = 1;
        label = new JLabel("\u30c9\u30e9\u30a4\u30d0\u540d(D)");
        label.setDisplayedMnemonic('D');
        label.setLabelFor(this.driver);
        gridbag.setConstraints(label, c);
        panel.add(label);
        c.gridwidth = 0;
        gridbag.setConstraints(this.driver, c);
        panel.add(this.driver);
        c.gridwidth = 1;
        label = new JLabel("URL");
        label.setDisplayedMnemonic('L');
        label.setLabelFor(this.url);
        gridbag.setConstraints(label, c);
        panel.add(label);
        c.gridwidth = 0;
        gridbag.setConstraints(this.url, c);
        panel.add(this.url);
        c.gridwidth = 1;
        label = new JLabel("\u30e6\u30fc\u30b6\u540d(U)");
        label.setDisplayedMnemonic('U');
        label.setLabelFor(this.user);
        gridbag.setConstraints(label, c);
        panel.add(label);
        c.gridwidth = 0;
        gridbag.setConstraints(this.user, c);
        panel.add(this.user);
        c.gridwidth = 1;
        label = new JLabel("\u30d1\u30b9\u30ef\u30fc\u30c9(P)");
        label.setDisplayedMnemonic('P');
        label.setLabelFor(this.pass);
        gridbag.setConstraints(label, c);
        panel.add(label);
        c.gridwidth = 0;
        gridbag.setConstraints(this.pass, c);
        panel.add(this.pass);
        c.gridwidth = 1;
        label = new JLabel("\u30af\u30e9\u30b9\u30d1\u30b9(C)");
        label.setDisplayedMnemonic('C');
        label.setLabelFor(this.classpaths);
        gridbag.setConstraints(label, c);
        panel.add(label);
        c.gridwidth = 0;
        JScrollPane s = new JScrollPane(this.classpaths);
        gridbag.setConstraints(s, c);
        panel.add(s);
        c.gridwidth = 0;
        JTextArea jdbctip = new JTextArea("\u30c9\u30e9\u30a4\u30d0\u540d\u3084URL\u306e\u8a2d\u5b9a\u65b9\u6cd5\u306f\u30b3\u30b3\u304c\u53c2\u8003\u306b\u306a\u308a\u307e\u3059\u3002http://wiki.paulownia.jp/java/jdbc");
        jdbctip.setForeground(Color.BLUE);
        jdbctip.setEditable(false);
        jdbctip.setOpaque(false);
        SxUtilities.addPopupMenuMouseListener(jdbctip);
        gridbag.setConstraints(jdbctip, c);
        panel.add(jdbctip);
        gridbag.setConstraints(this.isShow, c);
        panel.add(this.isShow);
        gridbag.setConstraints(this.rollbackBeforeClose, c);
        panel.add(this.rollbackBeforeClose);
        gridbag.setConstraints(this.rollbackAfterQuery, c);
        panel.add(this.rollbackAfterQuery);
        c.gridwidth = 1;
        label = new JLabel("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u88fd\u54c1(P)");
        label.setDisplayedMnemonic('P');
        label.setLabelFor(this.productName);
        gridbag.setConstraints(label, c);
        panel.add(label);
        c.gridwidth = 0;
        gridbag.setConstraints(this.productName, c);
        panel.add(this.productName);
        return panel;
    }

    private JPanel createExtTab() {
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        GridBagLayout gridbag = new GridBagLayout();
        panel.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.insets = new Insets(4, 8, 4, 8);
        SxUtilities.addPopupMenuMouseListener(this.highlightFile);
        this.highlightFile.setColumns(40);
        this.highlightFile.setToolTipText("\u5f37\u8abf\u8868\u793a\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002\n\u8a73\u3057\u304f\u306f SampleHighlight.xml \u3092\u53c2\u7167\u3002");
        this.hideOracleBinTable.setToolTipText("<html>\u30aa\u30e9\u30af\u30eb10g\u4ee5\u964d\u3001Drop\u3055\u308c\u305f\u30c6\u30fc\u30d6\u30eb\u306f\u3059\u3050\u306b\u306f\u524a\u9664\u3055\u308c\u305a\u306b\u3001\u30ea\u30b5\u30a4\u30af\u30eb\u30d3\u30f3\u3068\u3044\u3046 <font color=\"BLUE\">BIN$KGWUZUW7RLaF/azn7fs5Nw==$0</font>\u307f\u305f\u3044\u306a\u540d\u524d\u306b\u5909\u308f\u3063\u3066\u3001\u5fa9\u6d3b\u3055\u305b\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u3059\u3002<br>Windows\u306a\u3069\u306e\u30b4\u30df\u7bb1\u307f\u305f\u3044\u306a\u611f\u3058\u3067\u3059\u3002<br>\u3061\u306a\u307f\u306b\u3001\u4e00\u89a7\u3092\u898b\u308b\u306b\u306f\u3001<font color=\"BLUE\">show recyclebin</font><br>\u5fa9\u6d3b\u3055\u305b\u308b\u306b\u306f\u3001 <font color=\"BLUE\">flashback table \"BIN$KGWUZUW7RLaF/azn7fs5Nw==$0\" to before drop;</font><br>\u5b8c\u5168\u306b\u6d88\u3059\u306b\u306f\u3001 <font color=\"BLUE\">purge user_recyclebin;</font> \u3067\u3059\u3002</html>");
        new DropTarget(this.highlightFile, 3, new HighlightDropListener(), true);
        c.gridwidth = 0;
        JLabel label = new JLabel("<html><font color=\"blue\">\u4ee5\u4e0b\u306e\u8a2d\u5b9a\u306f\u5fc5\u9808\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002\u30c7\u30d5\u30a9\u30eb\u30c8\u306e\u307e\u307e\u3067\u3082\u4f7f\u7528\u3067\u304d\u307e\u3059\u3002</font></html>");
        gridbag.setConstraints(label, c);
        panel.add(label);
        c.gridwidth = 1;
        label = new JLabel("\u5f37\u8abf\u8868\u793a(H)");
        label.setDisplayedMnemonic('H');
        label.setLabelFor(this.highlightFile);
        gridbag.setConstraints(label, c);
        panel.add(label);
        c.gridwidth = 0;
        gridbag.setConstraints(this.highlightFile, c);
        panel.add(this.highlightFile);
        c.gridwidth = 0;
        gridbag.setConstraints(this.useOracleTableComments, c);
        panel.add(this.useOracleTableComments);
        gridbag.setConstraints(this.useOracleColumnComments, c);
        panel.add(this.useOracleColumnComments);
        gridbag.setConstraints(this.hideOracleBinTable, c);
        panel.add(this.hideOracleBinTable);
        return panel;
    }

    private JPanel createSqlFormatterTab() {
        JPanel panel = new JPanel(new BorderLayout());
        GridBagLayout gridbag = new GridBagLayout();
        panel.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.insets = new Insets(4, 8, 4, 8);
        c.gridwidth = 0;
        this.keywordCase[0] = new JRadioButton("\u4f55\u3082\u3057\u306a\u3044");
        this.keywordCase[1] = new JRadioButton("\u5927\u6587\u5b57\u306b\u3059\u308b");
        this.keywordCase[2] = new JRadioButton("\u5c0f\u6587\u5b57\u306b\u3059\u308b");
        Box box = Box.createHorizontalBox();
        box.add(this.keywordCase[0]);
        box.add(this.keywordCase[1]);
        box.add(this.keywordCase[2]);
        box.setBorder(new TitledBorder("\u30ad\u30fc\u30ef\u30fc\u30c9\u306e\u5909\u63db\u898f\u5247"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.keywordCase[0]);
        group.add(this.keywordCase[1]);
        group.add(this.keywordCase[2]);
        gridbag.setConstraints(box, c);
        panel.add(box);
        SxUtilities.addPopupMenuMouseListener(this.functionNames);
        this.functionNames.setFont(AsanDatabaseBrowser.theApp.doc.getFont());
        this.functionNames.setToolTipText("<html>\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u304c\u4f7f\u3046\u95a2\u6570\u540d\u3002<br>\u30ab\u30f3\u30de\u533a\u5207\u308a\u3001TAB\u533a\u5207\u308a\u3001\u307e\u305f\u306f\u30b9\u30da\u30fc\u30b9\u3067\u533a\u5207\u3063\u3066\u304f\u3060\u3055\u3044\u3002<br>\u5148\u982d\u304c\u30bb\u30df\u30b3\u30ed\u30f3\u306e\u884c\u306f\u7121\u8996\u3055\u308c\u307e\u3059\u3002</html>");
        JScrollPane pane = new JScrollPane(this.functionNames);
        String title = "\u95a2\u6570\u540d(SUBSTR\u306a\u3069)";
        pane.setBorder(new CompoundBorder(new TitledBorder(title), pane.getBorder()));
        panel.add(pane);
        gridbag.setConstraints(pane, c);
        return panel;
    }

    public int getSelectedKeywordCase() {
        for (int i = 0; i < this.keywordCase.length; ++i) {
            if (!this.keywordCase[i].isSelected()) continue;
            return i;
        }
        return 0;
    }

    public void setDatabase(VvDatabase db) {
        if (!$assertionsDisabled && db == null) {
            throw new AssertionError();
        }
        this.name.setText(db.name);
        this.name.selectAll();
        this.driver.getEditor().setItem(db.driverName);
        this.url.getEditor().setItem(db.url);
        this.user.setText(db.user);
        this.user.selectAll();
        this.pass.setText(db.password);
        this.pass.selectAll();
        this.isShow.setSelected(db.isShowLoginDialog);
        this.rollbackBeforeClose.setSelected(db.rollbackBeforeClose);
        this.rollbackAfterQuery.setSelected(db.rollbackAfterQuery);
        String text = "";
        for (int i = 0; i < db.jarnames.size(); ++i) {
            String name = (String)db.jarnames.get(i);
            text = text + name + "\n";
        }
        this.classpaths.setText(text);
        this.productName.setSelectedItem(db.productName);
        System.out.println(this.productName);
        this.highlightFile.setText(db.highlightFilename);
        this.useOracleTableComments.setSelected(db.useOracleTableComments);
        this.useOracleColumnComments.setSelected(db.useOracleColumnComments);
        this.hideOracleBinTable.setSelected(db.hideOracleBinTable);
        if (0 <= db.keywordCase && db.keywordCase < this.keywordCase.length) {
            this.keywordCase[db.keywordCase].setSelected(true);
        }
        this.functionNames.setText(db.functionNames);
    }

    public VvDatabase getDatabase() {
        ArrayList<String> zipnames = new ArrayList<String>();
        String paths = this.classpaths.getText();
        StringTokenizer st = new StringTokenizer(paths, "\n");
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            zipnames.add(name);
        }
        String fname = this.highlightFile.getText();
        System.out.println("fname=" + fname);
        System.out.println("driver=" + this.driver.getSelectedItem());
        System.out.println("url=" + this.url.getSelectedItem());
        ComboBoxEditor editor = this.driver.getEditor();
        System.out.println("eidtor=" + editor.getItem() + " class=" + editor.getEditorComponent().getClass());
        return new VvDatabase(this.name.getText(), (String)this.driver.getEditor().getItem(), (String)this.url.getEditor().getItem(), this.user.getText(), new String(this.pass.getPassword()), zipnames, (String)this.productName.getSelectedItem(), fname, this.isShow.isSelected(), this.rollbackBeforeClose.isSelected(), this.rollbackAfterQuery.isSelected(), this.useOracleTableComments.isSelected(), this.useOracleColumnComments.isSelected(), this.hideOracleBinTable.isSelected(), this.getSelectedKeywordCase(), this.functionNames.getText());
    }

    public static int show(final JFrame frame, VvDatabase db) {
        final DatabaseDialog chooser = new DatabaseDialog();
        chooser.setDatabase(db);
        SxOptionPane pane = new SxOptionPane(frame, "\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306e\u30d7\u30ed\u30d1\u30c6\u30a3", -1, 3);
        pane.getContentPane().add((Component)chooser, "Center");
        JButton button = pane.getButton("OK");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (chooser.name.getText().length() == 0) {
                    chooser.name.requestFocus();
                    SxMessageBox.show(frame, "\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306e\u30d7\u30ed\u30d1\u30c6\u30a3", "\u540d\u524d\u306f\u5fc5\u9808\u3067\u3059\u3002");
                    return;
                }
                String driver = (String)chooser.driver.getEditor().getItem();
                if (driver.length() == 0) {
                    chooser.driver.requestFocus();
                    SxMessageBox.show(frame, "\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306e\u30d7\u30ed\u30d1\u30c6\u30a3", "\u30c9\u30e9\u30a4\u30d0\u540d\u306f\u5fc5\u9808\u3067\u3059\u3002");
                    return;
                }
                String url = (String)chooser.url.getEditor().getItem();
                if (url.length() == 0) {
                    chooser.url.requestFocus();
                    SxMessageBox.show(frame, "\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306e\u30d7\u30ed\u30d1\u30c6\u30a3", "URL\u306f\u5fc5\u9808\u3067\u3059\u3002");
                    return;
                }
            }
        });
        pane.pack();
        pane.setLocationRelativeTo(frame);
        pane.setVisible(true);
        int rc = pane.getReturnValue();
        if (rc == 1) {
            db.copyFrom(chooser.getDatabase());
        }
        return rc;
    }

    static {
        $assertionsDisabled = !DatabaseDialog.class.desiredAssertionStatus();
    }

    private class HighlightDropListener
    implements DropTargetListener {
        private HighlightDropListener() {
        }

        public void dragEnter(DropTargetDragEvent e) {
            e.acceptDrag(3);
        }

        public void dragExit(DropTargetEvent e) {
        }

        public void dragOver(DropTargetDragEvent e) {
        }

        public void dropActionChanged(DropTargetDragEvent e) {
        }

        public void drop(DropTargetDropEvent e) {
            block4: {
                if (!e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    return;
                }
                List files = null;
                e.acceptDrop(3);
                Transferable t = e.getTransferable();
                try {
                    files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                    Iterator ite = files.iterator();
                    while (ite.hasNext()) {
                        Object obj = ite.next();
                        System.out.println(" \u30af\u30e9\u30b9=" + obj.getClass() + " " + obj);
                    }
                    e.dropComplete(true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    e.dropComplete(false);
                    return;
                }
                int i = 0;
                if (i >= files.size()) break block4;
                File file = (File)files.get(i);
                DatabaseDialog.this.highlightFile.setText(file.getAbsolutePath());
            }
        }
    }

    private class ClassPathDropListener
    implements DropTargetListener {
        private ClassPathDropListener() {
        }

        public void dragEnter(DropTargetDragEvent e) {
            e.acceptDrag(3);
        }

        public void dragExit(DropTargetEvent e) {
        }

        public void dragOver(DropTargetDragEvent e) {
        }

        public void dropActionChanged(DropTargetDragEvent e) {
        }

        public void drop(DropTargetDropEvent e) {
            if (!e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                return;
            }
            List files = null;
            e.acceptDrop(3);
            Transferable t = e.getTransferable();
            try {
                files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                Iterator ite = files.iterator();
                while (ite.hasNext()) {
                    Object obj = ite.next();
                    System.out.println(" \u30af\u30e9\u30b9=" + obj.getClass() + " " + obj);
                }
                e.dropComplete(true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                e.dropComplete(false);
                return;
            }
            for (int i = 0; i < files.size(); ++i) {
                File file = (File)files.get(i);
                DatabaseDialog.this.classpaths.append(file.getAbsolutePath() + "\n");
            }
        }
    }
}

