/*
 * Decompiled with CFR 0.152.
 */
package asandatabasebrowser.view;

import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.model.DbException;
import asandatabasebrowser.model.TableInfo;
import asandatabasebrowser.view.RitchTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;

public class DbCountDialog
extends JDialog {
    Object[][] tableCount;
    JTable table;
    JButton closeButton;
    Thread thread = null;

    public DbCountDialog(Frame parent, ArrayList tableList) {
        super(parent, "count(*)");
        this.tableCount = new Object[tableList.size()][2];
        for (int i = 0; i < tableList.size(); ++i) {
            TableInfo t = (TableInfo)tableList.get(i);
            this.tableCount[i][0] = t;
            this.tableCount[i][1] = "?";
        }
        this.table = new RitchTable(this.tableCount, new Object[]{"\u30c6\u30fc\u30d6\u30eb\u540d", "\u30ec\u30b3\u30fc\u30c9\u6570"}){

            public TableCellEditor getCellEditor(int row, int column) {
                return null;
            }
        };
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getColumnModel().getColumn(1).setCellRenderer(new CountRenderer());
        this.table.getTableHeader().addMouseListener(new DbTableHeaderMouseListener());
        this.closeButton = new JButton("\u9589\u3058\u308b");
        this.closeButton.setToolTipText("\u4ef6\u6570\u3092\u53d6\u5f97\u4e2d\u306b\u9589\u3058\u3066\u3082\u3044\u3044\u3088");
        JPanel panel = (JPanel)this.getContentPane();
        panel.setBorder(new EmptyBorder(20, 20, 20, 20));
        panel.setLayout(new BorderLayout());
        panel.add((Component)new JScrollPane(this.table), "Center");
        JPanel button_panel = new JPanel();
        button_panel.add(this.closeButton);
        panel.add((Component)button_panel, "South");
        this.getRootPane().setDefaultButton(this.closeButton);
        this.thread = new Thread(new CountThread());
        this.thread.start();
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DbCountDialog.this.setVisible(false);
                DbCountDialog.this.thread = null;
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                DbCountDialog.this.setVisible(false);
                DbCountDialog.this.thread = null;
            }
        });
    }

    class DbTableHeaderMouseListener
    extends MouseAdapter
    implements Comparator {
        int lastCol = -1;
        boolean asc = false;

        DbTableHeaderMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (DbCountDialog.this.thread != null) {
                AsanDatabaseBrowser.theApp.showMessage(DbCountDialog.this, "\u4ef6\u6570\u53d6\u5f97\u4e2d\u306f\u30bd\u30fc\u30c8\u3067\u304d\u307e\u305b\u3093", null, 1);
                return;
            }
            if (e.getClickCount() == 1 && (e.getModifiers() & 0x10) != 0) {
                int col = DbCountDialog.this.table.getTableHeader().columnAtPoint(e.getPoint());
                if (col == -1) {
                    return;
                }
                if (col == this.lastCol) {
                    this.asc = !this.asc;
                } else {
                    this.lastCol = col;
                    this.asc = true;
                }
                Arrays.sort(DbCountDialog.this.tableCount, this);
                DbCountDialog.this.repaint();
            }
        }

        public int compare(Object o1, Object o2) {
            return this.asc ? this.compare0(o1, o2) : -this.compare0(o1, o2);
        }

        private int compare0(Object o1, Object o2) {
            Object[] rec1 = (Object[])o1;
            Object fld1 = rec1[this.lastCol];
            Object[] rec2 = (Object[])o2;
            Object fld2 = rec2[this.lastCol];
            if (fld1 == fld2) {
                return 0;
            }
            if (fld1 == null) {
                return -1;
            }
            if (fld2 == null) {
                return 1;
            }
            if (fld1 instanceof Comparable) {
                Comparable c1 = (Comparable)fld1;
                Comparable c2 = (Comparable)fld2;
                if (c1.getClass().equals(c2.getClass())) {
                    return c1.compareTo(c2);
                }
                return c1.getClass().getName().compareTo(c2.getClass().getName());
            }
            if (this.lastCol == 0) {
                return fld1.toString().compareTo(fld2.toString());
            }
            System.out.println("\u6bd4\u8f03\u3067\u304d\u306a\u3044\u578b\u3067\u3059 " + fld1.getClass());
            return 0;
        }

        public boolean equals(Object obj) {
            return this == obj;
        }
    }

    class CountRenderer
    extends DefaultTableCellRenderer {
        CountRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            JLabel label = (JLabel)c;
            label.setHorizontalAlignment(4);
            return c;
        }
    }

    class CountThread
    implements Runnable {
        CountThread() {
        }

        public void run() {
            for (int i = 0; i < DbCountDialog.this.tableCount.length; ++i) {
                TableInfo t = (TableInfo)DbCountDialog.this.tableCount[i][0];
                try {
                    int count = t.db.getRecordCount(t);
                    DbCountDialog.this.table.setValueAt(new Integer(count), i, 1);
                }
                catch (DbException e) {
                    DbCountDialog.this.table.setValueAt("\u53d6\u5f97\u5931\u6557", i, 1);
                    e.printStackTrace();
                }
                if (DbCountDialog.this.thread == null) break;
            }
            DbCountDialog.this.thread = null;
        }
    }
}

