/*
 * Decompiled with CFR 0.152.
 */
package asandatabasebrowser.view;

import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.Global;
import asandatabasebrowser.action.ExecuteCommitAction;
import asandatabasebrowser.action.ExecuteUpdateAction;
import asandatabasebrowser.action.TabAddAction;
import asandatabasebrowser.action.TabRemoveAction;
import asandatabasebrowser.model.VvDatabase;
import asandatabasebrowser.view.JTabbedTextArea;
import blanco.commons.sql.format.BlancoSqlParser;
import blanco.commons.sql.format.valueobject.BlancoSqlToken;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JToolBar;

public class DbExecuteFrame
extends JFrame {
    public VvDatabase db;
    JTabbedTextArea textarea;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DbExecuteFrame(VvDatabase db) {
        this.db = db;
        this.setTitle(db.name + "(autoCommit=false)");
        this.setIconImage(Global.getImage("/resources/UpdateView.png"));
        String text = "-- UPDATE \u30c6\u30fc\u30d6\u30eb\u540d SET \u30ab\u30e9\u30e0\u540d1 = \u50241 {, \u30ab\u30e9\u30e0\u540d2 = \u50242 } [ WHERE \u6761\u4ef6 ]\n-- INSERT INTO \u30c6\u30fc\u30d6\u30eb\u540d [ ( \u30ab\u30e9\u30e0\u540d1, ... ) ] VALUES ( \u50241, ...)\n-- DELETE FROM \u30c6\u30fc\u30d6\u30eb\u540d [ WHERE \u6761\u4ef6 ]";
        text = text.toLowerCase();
        this.textarea = new JTabbedTextArea(db, new SqlKeyListener());
        this.textarea.addTextArea(text);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.textarea, "Center");
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setRollover(true);
        toolbar.add(new ExecuteUpdateAction(this));
        toolbar.addSeparator();
        toolbar.add(new ExecuteCommitAction(this, db, "commit", null));
        toolbar.add(new ExecuteCommitAction(this, db, "rollback", null));
        toolbar.addSeparator();
        toolbar.add(new TabAddAction(this.textarea));
        toolbar.add(new TabRemoveAction(this.textarea));
        this.getContentPane().add((Component)toolbar, "North");
        this.setSize(640, 360);
        this.setVisible(true);
    }

    public void executeUpdate() {
        String text = this.textarea.getSelectedText();
        if (text != null) {
            text = text.trim();
        }
        if ((text == null || text.length() == 0) && (text = this.textarea.getCurrentText()) != null) {
            text = text.trim();
        }
        if (text == null) {
            return;
        }
        ArrayList tokens = null;
        try {
            tokens = new BlancoSqlParser().parse(text);
        }
        catch (RuntimeException e) {
            AsanDatabaseBrowser.theApp.showMessage(this.textarea, "SQL\u304c\u4e0d\u6b63\u3068\u601d\u308f\u308c\u307e\u3059", e, 0);
            return;
        }
        ArrayList<String> sqlList = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        block11: for (int i = 0; i < tokens.size(); ++i) {
            BlancoSqlToken t = (BlancoSqlToken)tokens.get(i);
            switch (t.getType()) {
                case 0: {
                    sb.append(" ");
                    continue block11;
                }
                case 1: {
                    if (t.getString().equals(";")) {
                        sqlList.add(sb.toString());
                        sb = new StringBuffer();
                        continue block11;
                    }
                    sb.append(t.getString().trim());
                    continue block11;
                }
                case 2: 
                case 3: 
                case 4: {
                    sb.append(t.getString());
                    continue block11;
                }
                case 5: {
                    continue block11;
                }
                case 6: {
                    sqlList.add(sb.toString());
                    sb = new StringBuffer();
                    continue block11;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError(t.getType());
                    }
                    continue block11;
                }
            }
        }
        if (sb.toString().trim().length() > 0) {
            sqlList.add(sb.toString().trim());
        }
        this.setCursor(new Cursor(3));
        try {
            int records = 0;
            for (int i = 0; i < sqlList.size(); ++i) {
                String sql = (String)sqlList.get(i);
                records += this.db.executeUpdate(sql);
            }
            AsanDatabaseBrowser.theApp.showMessage(this.textarea, "\u66f4\u65b0\u3057\u307e\u3057\u305f " + records + " \u4ef6", null, 1);
        }
        catch (Exception e) {
            AsanDatabaseBrowser.theApp.showMessage(this.textarea, "\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e, 0);
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    static {
        $assertionsDisabled = !DbExecuteFrame.class.desiredAssertionStatus();
    }

    class SqlKeyListener
    extends KeyAdapter {
        SqlKeyListener() {
        }

        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 10 && e.isShiftDown()) {
                DbExecuteFrame.this.executeUpdate();
            }
        }
    }
}

